/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.date.DateUtils;

public class HistoryBrowserModel
extends Observable
implements DataSetListener,
MapView.LayerChangeListener {
    private History history;
    private HistoryOsmPrimitive reference;
    private HistoryOsmPrimitive current;
    private HistoryOsmPrimitive latest;
    private VersionTableModel versionTableModel = new VersionTableModel();
    private TagTableModel currentTagTableModel = new TagTableModel(PointInTimeType.CURRENT_POINT_IN_TIME);
    private TagTableModel referenceTagTableModel = new TagTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME);
    private DiffTableModel currentRelationMemberTableModel;
    private DiffTableModel referenceRelationMemberTableModel;
    private DiffTableModel referenceNodeListTableModel = new DiffTableModel();
    private DiffTableModel currentNodeListTableModel = new DiffTableModel();

    public HistoryBrowserModel() {
        this.currentRelationMemberTableModel = new DiffTableModel();
        this.referenceRelationMemberTableModel = new DiffTableModel();
        OsmDataLayer editLayer = Main.main.getEditLayer();
        if (editLayer != null) {
            editLayer.data.addDataSetListener(this);
        }
        MapView.addLayerChangeListener(this);
    }

    public HistoryBrowserModel(History history) {
        this();
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        this.setHistory(history);
    }

    public History getHistory() {
        return this.history;
    }

    protected boolean hasNewNodes(Way way) {
        for (Node n : way.getNodes()) {
            if (!n.isNew()) continue;
            return true;
        }
        return false;
    }

    protected boolean canShowAsLatest(OsmPrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        if (primitive.isNew() || !primitive.isUsable()) {
            return false;
        }
        try {
            HistoryOsmPrimitive.forOsmPrimitive(primitive);
        }
        catch (Exception ign) {
            return false;
        }
        if (this.history == null) {
            return false;
        }
        if (this.history.getByVersion(primitive.getVersion()) != null) {
            return primitive.isModified();
        }
        return this.history.getLatest().getVersion() <= (long)primitive.getVersion();
    }

    public void setHistory(History history) {
        this.history = history;
        if (history.getNumVersions() > 0) {
            OsmPrimitive p;
            HistoryOsmPrimitive newLatest = null;
            OsmDataLayer editLayer = Main.main.getEditLayer();
            if (editLayer != null && this.canShowAsLatest(p = editLayer.data.getPrimitiveById(history.getId(), history.getType()))) {
                newLatest = new HistoryPrimitiveBuilder().build(p);
            }
            if (newLatest == null) {
                this.current = history.getLatest();
                int prevIndex = history.getNumVersions() - 2;
                this.reference = prevIndex < 0 ? history.getEarliest() : history.get(prevIndex);
            } else {
                this.reference = history.getLatest();
                this.current = newLatest;
            }
            this.setLatest(newLatest);
        }
        this.initTagTableModels();
        this.fireModelChange();
    }

    protected void fireModelChange() {
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
        this.versionTableModel.fireTableDataChanged();
    }

    public VersionTableModel getVersionTableModel() {
        return this.versionTableModel;
    }

    protected void initTagTableModels() {
        this.currentTagTableModel.initKeyList();
        this.referenceTagTableModel.initKeyList();
    }

    protected void initNodeListTableModels() {
        if (this.current.getType() != OsmPrimitiveType.WAY || this.reference.getType() != OsmPrimitiveType.WAY) {
            return;
        }
        TwoColumnDiff diff = new TwoColumnDiff(((HistoryWay)this.reference).getNodes().toArray(), ((HistoryWay)this.current).getNodes().toArray());
        this.referenceNodeListTableModel.setRows(diff.referenceDiff);
        this.currentNodeListTableModel.setRows(diff.currentDiff);
        this.referenceNodeListTableModel.fireTableDataChanged();
        this.currentNodeListTableModel.fireTableDataChanged();
    }

    protected void initMemberListTableModels() {
        if (this.current.getType() != OsmPrimitiveType.RELATION || this.reference.getType() != OsmPrimitiveType.RELATION) {
            return;
        }
        TwoColumnDiff diff = new TwoColumnDiff(((HistoryRelation)this.reference).getMembers().toArray(), ((HistoryRelation)this.current).getMembers().toArray());
        this.referenceRelationMemberTableModel.setRows(diff.referenceDiff);
        this.currentRelationMemberTableModel.setRows(diff.currentDiff);
        this.currentRelationMemberTableModel.fireTableDataChanged();
        this.referenceRelationMemberTableModel.fireTableDataChanged();
    }

    public TagTableModel getTagTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentTagTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceTagTableModel;
        }
        return null;
    }

    public DiffTableModel getNodeListTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentNodeListTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceNodeListTableModel;
        }
        return null;
    }

    public DiffTableModel getRelationMemberTableModel(PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        if (pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.currentRelationMemberTableModel;
        }
        if (pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.referenceRelationMemberTableModel;
        }
        return null;
    }

    public void setReferencePointInTime(HistoryOsmPrimitive reference) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(reference, "reference");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set reference primitive.", new Object[0]));
        }
        if (reference.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", reference.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive primitive = this.history.getByVersion(reference.getVersion());
        if (primitive == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference version {0} not available in history.", reference.getVersion()));
        }
        this.reference = reference;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentPointInTime(HistoryOsmPrimitive current) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(current, "current");
        if (this.history == null) {
            throw new IllegalStateException(I18n.tr("History not initialized yet. Failed to set current primitive.", new Object[0]));
        }
        if (current.getId() != this.history.getId()) {
            throw new IllegalArgumentException(I18n.tr("Failed to set reference. Reference ID {0} does not match history ID {1}.", current.getId(), this.history.getId()));
        }
        HistoryOsmPrimitive primitive = this.history.getByVersion(current.getVersion());
        if (primitive == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to set current primitive. Current version {0} not available in history.", current.getVersion()));
        }
        this.current = current;
        this.initTagTableModels();
        this.initNodeListTableModels();
        this.initMemberListTableModels();
        this.setChanged();
        this.notifyObservers();
    }

    public HistoryOsmPrimitive getCurrentPointInTime() {
        return this.getPointInTime(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getReferencePointInTime() {
        return this.getPointInTime(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    public HistoryOsmPrimitive getPointInTime(PointInTimeType type) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        if (type.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME)) {
            return this.current;
        }
        if (type.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME)) {
            return this.reference;
        }
        return null;
    }

    public boolean isLatest(HistoryOsmPrimitive primitive) {
        if (primitive == null) {
            return false;
        }
        return primitive == this.latest;
    }

    protected void setLatest(HistoryOsmPrimitive latest) {
        if (latest == null) {
            if (this.current == this.latest) {
                this.current = this.history.getLatest();
            }
            if (this.reference == this.latest) {
                this.current = this.history.getLatest();
            }
            this.latest = null;
        } else {
            if (this.current == this.latest) {
                this.current = latest;
            }
            if (this.reference == this.latest) {
                this.reference = latest;
            }
            this.latest = latest;
        }
        this.fireModelChange();
    }

    public void unlinkAsListener() {
        OsmDataLayer editLayer = Main.main.getEditLayer();
        if (editLayer != null) {
            editLayer.data.removeDataSetListener(this);
        }
        MapView.removeLayerChangeListener(this);
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
        Node node = event.getNode();
        if (!node.isNew() && node.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(node));
        }
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        for (OsmPrimitive p : event.getPrimitives()) {
            if (!this.canShowAsLatest(p)) continue;
            this.setLatest(new HistoryPrimitiveBuilder().build(p));
        }
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        for (OsmPrimitive p : event.getPrimitives()) {
            if (p.isNew() || p.getId() != this.history.getId()) continue;
            this.setLatest(null);
        }
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        Relation r = event.getRelation();
        if (!r.isNew() && r.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(r));
        }
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        OsmPrimitive prim = event.getPrimitive();
        if (!prim.isNew() && prim.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(prim));
        }
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
        Way way = event.getChangedWay();
        if (!way.isNew() && way.getId() == this.history.getId()) {
            this.setLatest(new HistoryPrimitiveBuilder().build(way));
        }
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        OsmPrimitive primitive = event.getDataset().getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive latest = this.canShowAsLatest(primitive) ? new HistoryPrimitiveBuilder().build(primitive) : null;
        this.setLatest(latest);
        this.fireModelChange();
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        OsmDataLayer l;
        if (oldLayer instanceof OsmDataLayer) {
            l = (OsmDataLayer)oldLayer;
            l.data.removeDataSetListener(this);
        }
        if (!(newLayer instanceof OsmDataLayer)) {
            this.latest = null;
            this.fireModelChange();
            return;
        }
        l = (OsmDataLayer)newLayer;
        l.data.addDataSetListener(this);
        OsmPrimitive primitive = l.data.getPrimitiveById(this.history.getId(), this.history.getType());
        HistoryOsmPrimitive latest = this.canShowAsLatest(primitive) ? new HistoryPrimitiveBuilder().build(primitive) : null;
        this.setLatest(latest);
        this.fireModelChange();
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
    }

    static class HistoryPrimitiveBuilder
    extends AbstractVisitor {
        private HistoryOsmPrimitive clone;

        HistoryPrimitiveBuilder() {
        }

        @Override
        public void visit(Node n) {
            this.clone = new HistoryNode(n.getId(), n.getVersion(), n.isVisible(), this.getCurrentUser(), 0L, null, n.getCoor(), false);
            this.clone.setTags(n.getKeys());
        }

        @Override
        public void visit(Relation r) {
            this.clone = new HistoryRelation(r.getId(), (long)r.getVersion(), r.isVisible(), this.getCurrentUser(), 0L, null, false);
            this.clone.setTags(r.getKeys());
            HistoryRelation hr = (HistoryRelation)this.clone;
            for (RelationMember rm : r.getMembers()) {
                hr.addMember(new RelationMemberData(rm.getRole(), rm.getType(), rm.getUniqueId()));
            }
        }

        @Override
        public void visit(Way w) {
            this.clone = new HistoryWay(w.getId(), (long)w.getVersion(), w.isVisible(), this.getCurrentUser(), 0L, null, false);
            this.clone.setTags(w.getKeys());
            for (Node n : w.getNodes()) {
                ((HistoryWay)this.clone).addNode(n.getUniqueId());
            }
        }

        private User getCurrentUser() {
            UserInfo info = JosmUserIdentityManager.getInstance().getUserInfo();
            return info == null ? User.getAnonymous() : User.createOsmUser(info.getId(), info.getDisplayName());
        }

        public HistoryOsmPrimitive build(OsmPrimitive primitive) {
            primitive.accept(this);
            return this.clone;
        }
    }

    public class TagTableModel
    extends AbstractTableModel {
        private List<String> keys;
        private PointInTimeType pointInTimeType;

        protected void initKeyList() {
            HashSet<String> keySet = new HashSet<String>();
            if (HistoryBrowserModel.this.current != null) {
                keySet.addAll(HistoryBrowserModel.this.current.getTags().keySet());
            }
            if (HistoryBrowserModel.this.reference != null) {
                keySet.addAll(HistoryBrowserModel.this.reference.getTags().keySet());
            }
            this.keys = new ArrayList<String>(keySet);
            Collections.sort(this.keys);
            this.fireTableDataChanged();
        }

        protected TagTableModel(PointInTimeType type) {
            this.pointInTimeType = type;
            this.initKeyList();
        }

        @Override
        public int getRowCount() {
            if (this.keys == null) {
                return 0;
            }
            return this.keys.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.keys.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean hasTag(String key) {
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (primitive == null) {
                return false;
            }
            return primitive.hasTag(key);
        }

        public String getValue(String key) {
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(this.pointInTimeType);
            if (primitive == null) {
                return null;
            }
            return primitive.get(key);
        }

        public boolean oppositeHasTag(String key) {
            PointInTimeType opposite = this.pointInTimeType.opposite();
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(opposite);
            if (primitive == null) {
                return false;
            }
            return primitive.hasTag(key);
        }

        public String getOppositeValue(String key) {
            PointInTimeType opposite = this.pointInTimeType.opposite();
            HistoryOsmPrimitive primitive = HistoryBrowserModel.this.getPointInTime(opposite);
            if (primitive == null) {
                return null;
            }
            return primitive.get(key);
        }

        public boolean hasSameValueAsOpposite(String key) {
            String value = this.getValue(key);
            String oppositeValue = this.getOppositeValue(key);
            if (value == null || oppositeValue == null) {
                return false;
            }
            return value.equals(oppositeValue);
        }

        public PointInTimeType getPointInTimeType() {
            return this.pointInTimeType;
        }

        public boolean isCurrentPointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME);
        }

        public boolean isReferencePointInTime() {
            return this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }
    }

    public final class VersionTableModel
    extends AbstractTableModel {
        private VersionTableModel() {
        }

        @Override
        public int getRowCount() {
            if (HistoryBrowserModel.this.history == null) {
                return 0;
            }
            int ret = HistoryBrowserModel.this.history.getNumVersions();
            if (HistoryBrowserModel.this.latest != null) {
                ++ret;
            }
            return ret;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return Long.toString(this.getPrimitive(row).getVersion());
                }
                case 1: {
                    return this.isReferencePointInTime(row);
                }
                case 2: {
                    return this.isCurrentPointInTime(row);
                }
                case 3: {
                    HistoryOsmPrimitive p3 = this.getPrimitive(row);
                    if (p3 != null && p3.getTimestamp() != null) {
                        return DateUtils.formatDateTime(p3.getTimestamp(), 3, 3);
                    }
                    return null;
                }
                case 4: {
                    User user;
                    HistoryOsmPrimitive p4 = this.getPrimitive(row);
                    if (p4 != null && (user = p4.getUser()) != null) {
                        return user.getName();
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (!((Boolean)aValue).booleanValue()) {
                return;
            }
            switch (column) {
                case 1: {
                    this.setReferencePointInTime(row);
                    break;
                }
                case 2: {
                    this.setCurrentPointInTime(row);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column >= 1 && column <= 2;
        }

        public void setReferencePointInTime(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (row == HistoryBrowserModel.this.history.getNumVersions()) {
                if (HistoryBrowserModel.this.latest != null) {
                    HistoryBrowserModel.this.setReferencePointInTime(HistoryBrowserModel.this.latest);
                }
                return;
            }
            if (row < 0 || row > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive reference = HistoryBrowserModel.this.history.get(row);
            HistoryBrowserModel.this.setReferencePointInTime(reference);
        }

        public void setCurrentPointInTime(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return;
            }
            if (row == HistoryBrowserModel.this.history.getNumVersions()) {
                if (HistoryBrowserModel.this.latest != null) {
                    HistoryBrowserModel.this.setCurrentPointInTime(HistoryBrowserModel.this.latest);
                }
                return;
            }
            if (row < 0 || row > HistoryBrowserModel.this.history.getNumVersions()) {
                return;
            }
            HistoryOsmPrimitive current = HistoryBrowserModel.this.history.get(row);
            HistoryBrowserModel.this.setCurrentPointInTime(current);
        }

        public boolean isReferencePointInTime(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (row == HistoryBrowserModel.this.history.getNumVersions()) {
                return HistoryBrowserModel.this.latest == HistoryBrowserModel.this.reference;
            }
            if (row < 0 || row > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive p = HistoryBrowserModel.this.history.get(row);
            return p == HistoryBrowserModel.this.reference;
        }

        public boolean isCurrentPointInTime(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return false;
            }
            if (row == HistoryBrowserModel.this.history.getNumVersions()) {
                return HistoryBrowserModel.this.latest == HistoryBrowserModel.this.current;
            }
            if (row < 0 || row > HistoryBrowserModel.this.history.getNumVersions()) {
                return false;
            }
            HistoryOsmPrimitive p = HistoryBrowserModel.this.history.get(row);
            return p == HistoryBrowserModel.this.current;
        }

        public HistoryOsmPrimitive getPrimitive(int row) {
            if (HistoryBrowserModel.this.history == null) {
                return null;
            }
            return this.isLatest(row) ? HistoryBrowserModel.this.latest : HistoryBrowserModel.this.history.get(row);
        }

        public boolean isLatest(int row) {
            return row >= HistoryBrowserModel.this.history.getNumVersions();
        }

        public OsmPrimitive getLatest() {
            if (HistoryBrowserModel.this.latest == null) {
                return null;
            }
            OsmDataLayer editLayer = Main.main.getEditLayer();
            if (editLayer == null) {
                return null;
            }
            return editLayer.data.getPrimitiveById(HistoryBrowserModel.this.latest.getId(), HistoryBrowserModel.this.latest.getType());
        }

        @Override
        public int getColumnCount() {
            return 6;
        }
    }
}

