/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HistoryBrowserDialogManager
implements MapView.LayerChangeListener {
    private static HistoryBrowserDialogManager instance;
    private Map<Long, HistoryBrowserDialog> dialogs;
    final String WINDOW_GEOMETRY_PREF = this.getClass().getName() + ".geometry";
    private final Predicate<PrimitiveId> unloadedHistoryPredicate = new Predicate<PrimitiveId>(){
        HistoryDataSet hds = HistoryDataSet.getInstance();

        @Override
        public boolean evaluate(PrimitiveId p) {
            History h = this.hds.getHistory(p);
            if (h == null) {
                return true;
            }
            return !p.isNew() && h.getByVersion(p.getUniqueId()) == null;
        }
    };
    private final Predicate<PrimitiveId> notNewPredicate = new Predicate<PrimitiveId>(){

        @Override
        public boolean evaluate(PrimitiveId p) {
            return !p.isNew();
        }
    };

    public static synchronized HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    protected HistoryBrowserDialogManager() {
        this.dialogs = new HashMap<Long, HistoryBrowserDialog>();
        MapView.addLayerChangeListener(this);
    }

    public boolean existsDialog(long id) {
        return this.dialogs.containsKey(id);
    }

    protected void show(long id, HistoryBrowserDialog dialog) {
        if (this.dialogs.values().contains(dialog)) {
            this.show(id);
        } else {
            this.placeOnScreen(dialog);
            dialog.setVisible(true);
            this.dialogs.put(id, dialog);
        }
    }

    protected void show(long id) {
        if (this.dialogs.keySet().contains(id)) {
            this.dialogs.get(id).toFront();
        }
    }

    protected boolean hasDialogWithCloseUpperLeftCorner(Point p) {
        for (HistoryBrowserDialog dialog : this.dialogs.values()) {
            Point corner = dialog.getLocation();
            if (p.x < corner.x - 5 || corner.x + 5 < p.x || p.y < corner.y - 5 || corner.y + 5 < p.y) continue;
            return true;
        }
        return false;
    }

    protected void placeOnScreen(HistoryBrowserDialog dialog) {
        WindowGeometry geometry = new WindowGeometry(this.WINDOW_GEOMETRY_PREF, WindowGeometry.centerOnScreen(new Dimension(850, 500)));
        geometry.applySafe(dialog);
        Point p = dialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(p)) {
            p.x += 20;
            p.y += 20;
        }
        dialog.setLocation(p);
    }

    public void hide(HistoryBrowserDialog dialog) {
        long id = 0L;
        for (long i : this.dialogs.keySet()) {
            if (this.dialogs.get(i) != dialog) continue;
            id = i;
            break;
        }
        if (id > 0L) {
            this.dialogs.remove(id);
            if (this.dialogs.isEmpty()) {
                new WindowGeometry(dialog).remember(this.WINDOW_GEOMETRY_PREF);
            }
        }
        dialog.setVisible(false);
        dialog.dispose();
    }

    public void hideAll() {
        ArrayList<HistoryBrowserDialog> dialogs = new ArrayList<HistoryBrowserDialog>();
        dialogs.addAll(this.dialogs.values());
        for (HistoryBrowserDialog dialog : dialogs) {
            dialog.unlinkAsListener();
            this.hide(dialog);
        }
    }

    public void show(History h) {
        if (h == null) {
            return;
        }
        if (this.existsDialog(h.getId())) {
            this.show(h.getId());
        } else {
            HistoryBrowserDialog dialog = new HistoryBrowserDialog(h);
            this.show(h.getId(), dialog);
        }
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (Main.isDisplayingMapView() && Main.map.mapView.getNumLayers() == 0) {
            this.hideAll();
        }
    }

    public void showHistory(Collection<? extends PrimitiveId> primitives) {
        final Collection<PrimitiveId> notNewPrimitives = Utils.filter(primitives, this.notNewPredicate);
        if (notNewPrimitives.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        Collection<PrimitiveId> toLoad = Utils.filter(primitives, this.unloadedHistoryPredicate);
        if (!toLoad.isEmpty()) {
            HistoryLoadTask task = new HistoryLoadTask();
            for (PrimitiveId p : notNewPrimitives) {
                task.add(p);
            }
            Main.worker.submit(task);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    for (PrimitiveId p : notNewPrimitives) {
                        final History h = HistoryDataSet.getInstance().getHistory(p);
                        if (h == null) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HistoryBrowserDialogManager.this.show(h);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    BugReportExceptionHandler.handleException(e);
                }
            }
        };
        Main.worker.submit(r);
    }
}

