/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowser;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class HistoryBrowserDialog
extends JDialog
implements HistoryDataSetListener {
    private HistoryBrowser browser;
    private CloseAction closeAction;
    private JLabel titleLabel;

    protected void renderTitle(History h) {
        String title = "";
        switch (h.getEarliest().getType()) {
            case NODE: {
                title = I18n.marktr("History for node {0}");
                break;
            }
            case WAY: {
                title = I18n.marktr("History for way {0}");
                break;
            }
            case RELATION: {
                title = I18n.marktr("History for relation {0}");
            }
        }
        this.setTitle(I18n.tr(title, Long.toString(h.getId())));
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.titleLabel != null) {
            this.titleLabel.setText(title);
        }
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(0);
        this.add((Component)this.titleLabel, "North");
        this.browser = new HistoryBrowser();
        this.add((Component)this.browser, "Center");
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        SideButton btn = new SideButton(new ReloadAction());
        btn.setName("btn.reload");
        pnl.add(btn);
        this.closeAction = new CloseAction();
        btn = new SideButton(this.closeAction);
        String closeHistoryBrowserDialogKey = "CloseHistoryBrowserDialog";
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(1).put(escapeKey, "CloseHistoryBrowserDialog");
        this.getRootPane().getActionMap().put("CloseHistoryBrowserDialog", this.closeAction);
        btn.setName("btn.close");
        pnl.add(btn);
        btn = new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/HistoryBrowser")));
        btn.setName("btn.help");
        pnl.add(btn);
        this.add((Component)pnl, "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/HistoryBrowser"));
    }

    public HistoryBrowserDialog(History history) {
        super(JOptionPane.getFrameForComponent(Main.parent), false);
        this.build();
        this.setHistory(history);
        this.renderTitle(history);
        this.pack();
        if (this.getInsets().top > 0) {
            this.titleLabel.setVisible(false);
        }
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        this.addWindowListener(new WindowClosingAdapter());
    }

    protected void setHistory(History history) {
        this.browser.populate(history);
    }

    public void unlinkAsListener() {
        this.getHistoryBrowser().getModel().unlinkAsListener();
    }

    @Override
    public void historyUpdated(HistoryDataSet source, PrimitiveId primitiveId) {
        if (primitiveId == null || primitiveId.equals(this.browser.getHistory().getPrimitiveId())) {
            this.browser.populate(source.getHistory(this.browser.getHistory().getPrimitiveId()));
        }
    }

    @Override
    public void historyDataSetCleared(HistoryDataSet source) {
        this.closeAction.run();
    }

    public HistoryBrowser getHistoryBrowser() {
        return this.browser;
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            HistoryBrowserDialog.this.closeAction.run();
        }
    }

    class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reload the history from the server", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryLoadTask task = new HistoryLoadTask();
            task.add(HistoryBrowserDialog.this.browser.getHistory());
            Main.worker.submit(task);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Close the dialog", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void run() {
            HistoryBrowserDialog.this.getHistoryBrowser().getModel().unlinkAsListener();
            HistoryDataSet.getInstance().removeHistoryDataSetListener(HistoryBrowserDialog.this);
            HistoryBrowserDialogManager.getInstance().hide(HistoryBrowserDialog.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }
}

