/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.VersionInfoPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class CoordinateInfoViewer
extends JPanel {
    public static final Color BGCOLOR_DIFFERENCE = new Color(255, 197, 197);
    private HistoryBrowserModel model;
    private VersionInfoPanel referenceInfoPanel;
    private VersionInfoPanel currentInfoPanel;
    private LatLonViewer referenceLatLonViewer;
    private LatLonViewer currentLatLonViewer;
    private DistanceViewer distanceViewer;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.insets = new Insets(5, 5, 5, 0);
        gc.fill = 2;
        gc.anchor = 23;
        this.referenceInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceInfoPanel, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.fill = 2;
        gc.weightx = 0.5;
        gc.weighty = 0.0;
        gc.anchor = 23;
        this.currentInfoPanel = new VersionInfoPanel(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentInfoPanel, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.referenceLatLonViewer = new LatLonViewer(this.model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        this.add((Component)this.referenceLatLonViewer, gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weightx = 0.5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.anchor = 18;
        this.currentLatLonViewer = new LatLonViewer(this.model, PointInTimeType.CURRENT_POINT_IN_TIME);
        this.add((Component)this.currentLatLonViewer, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.distanceViewer = new DistanceViewer(this.model);
        this.add((Component)this.distanceViewer, gc);
    }

    public CoordinateInfoViewer(HistoryBrowserModel model) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(model, "model");
        this.setModel(model);
        this.build();
        this.registerAsObserver(model);
    }

    protected void unregisterAsObserver(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.deleteObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.deleteObserver(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            model.deleteObserver(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            model.deleteObserver(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            model.deleteObserver(this.distanceViewer);
        }
    }

    protected void registerAsObserver(HistoryBrowserModel model) {
        if (this.currentInfoPanel != null) {
            model.addObserver(this.currentInfoPanel);
        }
        if (this.referenceInfoPanel != null) {
            model.addObserver(this.referenceInfoPanel);
        }
        if (this.currentLatLonViewer != null) {
            model.addObserver(this.currentLatLonViewer);
        }
        if (this.referenceLatLonViewer != null) {
            model.addObserver(this.referenceLatLonViewer);
        }
        if (this.distanceViewer != null) {
            model.addObserver(this.distanceViewer);
        }
    }

    public void setModel(HistoryBrowserModel model) {
        if (this.model != null) {
            this.unregisterAsObserver(model);
        }
        this.model = model;
        if (this.model != null) {
            this.registerAsObserver(model);
        }
    }

    private static class DistanceViewer
    extends LatLonViewer {
        private JLabel lblDistance;

        public DistanceViewer(HistoryBrowserModel model) {
            super(model, PointInTimeType.REFERENCE_POINT_IN_TIME);
        }

        @Override
        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.insets = new Insets(5, 5, 5, 5);
            gc.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Distance: ", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.lblDistance = new JLabel();
            this.add((Component)this.lblDistance, gc);
            this.lblDistance.setBackground(Color.WHITE);
            this.lblDistance.setOpaque(true);
            this.lblDistance.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        @Override
        protected void refresh() {
            HistoryOsmPrimitive p = this.getPrimitive();
            HistoryOsmPrimitive opposite = this.getOppositePrimitive();
            if (!(p instanceof HistoryNode)) {
                return;
            }
            if (!(opposite instanceof HistoryNode)) {
                return;
            }
            HistoryNode node = (HistoryNode)p;
            HistoryNode oppositeNode = (HistoryNode)opposite;
            LatLon coord = node.getCoords();
            LatLon oppositeCoord = oppositeNode.getCoords();
            if (coord != null && oppositeCoord != null) {
                double distance = coord.greatCircleDistance(oppositeCoord);
                if (distance > 0.0) {
                    this.lblDistance.setBackground(BGCOLOR_DIFFERENCE);
                } else {
                    this.lblDistance.setBackground(Color.WHITE);
                }
                this.lblDistance.setText(NavigatableComponent.getDistText(distance));
            } else {
                this.lblDistance.setBackground(coord != oppositeCoord ? BGCOLOR_DIFFERENCE : Color.WHITE);
                this.lblDistance.setText(I18n.tr("(none)", new Object[0]));
            }
        }
    }

    private static class LatLonViewer
    extends JPanel
    implements Observer {
        private JLabel lblLat;
        private JLabel lblLon;
        private HistoryBrowserModel model;
        private PointInTimeType role;

        protected HistoryOsmPrimitive getPrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role);
        }

        protected HistoryOsmPrimitive getOppositePrimitive() {
            if (this.model == null || this.role == null) {
                return null;
            }
            return this.model.getPointInTime(this.role.opposite());
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.insets = new Insets(5, 5, 5, 5);
            gc.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Latitude: ", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.lblLat = new JLabel();
            this.add((Component)this.lblLat, gc);
            this.lblLat.setBackground(Color.WHITE);
            this.lblLat.setOpaque(true);
            this.lblLat.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.anchor = 18;
            this.add((Component)new JLabel(I18n.tr("Longitude: ", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.lblLon = new JLabel();
            this.add((Component)this.lblLon, gc);
            this.lblLon.setBackground(Color.WHITE);
            this.lblLon.setOpaque(true);
            this.lblLon.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridwidth = 2;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        public LatLonViewer(HistoryBrowserModel model, PointInTimeType role) {
            this.build();
            this.model = model;
            this.role = role;
        }

        protected void refresh() {
            HistoryOsmPrimitive p = this.getPrimitive();
            HistoryOsmPrimitive opposite = this.getOppositePrimitive();
            if (!(p instanceof HistoryNode)) {
                return;
            }
            if (!(opposite instanceof HistoryNode)) {
                return;
            }
            HistoryNode node = (HistoryNode)p;
            HistoryNode oppositeNode = (HistoryNode)opposite;
            LatLon coord = node.getCoords();
            LatLon oppositeCoord = oppositeNode.getCoords();
            this.lblLat.setText(coord != null ? coord.latToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            this.lblLon.setText(coord != null ? coord.lonToString(CoordinateFormat.DECIMAL_DEGREES) : I18n.tr("(none)", new Object[0]));
            if (coord == oppositeCoord || coord != null && oppositeCoord != null && coord.lat() == oppositeCoord.lat()) {
                this.lblLat.setBackground(Color.WHITE);
            } else {
                this.lblLat.setBackground(BGCOLOR_DIFFERENCE);
            }
            if (coord == oppositeCoord || coord != null && oppositeCoord != null && coord.lon() == oppositeCoord.lon()) {
                this.lblLon.setBackground(Color.WHITE);
            } else {
                this.lblLon.setBackground(BGCOLOR_DIFFERENCE);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.refresh();
        }
    }
}

