/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.HelpAction;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.LanguageInfo;

public final class HelpUtil {
    public static String getWikiBaseUrl() {
        return Main.pref.get("help.baseurl", Main.getJOSMWebsite());
    }

    public static String getWikiBaseHelpUrl() {
        return HelpUtil.getWikiBaseUrl() + "/wiki";
    }

    public static String getHelpTopicUrl(String absoluteHelpTopic) {
        if (absoluteHelpTopic == null) {
            return null;
        }
        String ret = HelpUtil.getWikiBaseHelpUrl();
        ret = ret.replaceAll("\\/+$", "");
        absoluteHelpTopic = absoluteHelpTopic.replace(" ", "%20");
        absoluteHelpTopic = absoluteHelpTopic.replaceAll("^\\/+", "/");
        return ret + absoluteHelpTopic;
    }

    public static String getHelpTopicEditUrl(String absoluteHelpTopic) {
        String topicUrl = HelpUtil.getHelpTopicUrl(absoluteHelpTopic);
        topicUrl = topicUrl.replaceAll("#[^#]*$", "");
        return topicUrl + "?action=edit";
    }

    public static String extractRelativeHelpTopic(String url) {
        String topic = HelpUtil.extractAbsoluteHelpTopic(url);
        if (topic == null) {
            return null;
        }
        String pattern = "/[A-Z][a-z]{1,2}(_[A-Z]{2})?:" + HelpUtil.getHelpTopicPrefix(LanguageInfo.LocaleType.ENGLISH).replaceAll("^\\/+", "");
        if (url.matches(pattern)) {
            return topic.substring(pattern.length());
        }
        return null;
    }

    public static String extractAbsoluteHelpTopic(String url) {
        String prefix;
        if (!url.startsWith(HelpUtil.getWikiBaseHelpUrl())) {
            return null;
        }
        if ((url = url.substring(HelpUtil.getWikiBaseHelpUrl().length())).startsWith(prefix = HelpUtil.getHelpTopicPrefix(LanguageInfo.LocaleType.ENGLISH))) {
            return url;
        }
        String pattern = "/[A-Z][a-z]{1,2}(_[A-Z]{2})?:" + prefix.replaceAll("^\\/+", "");
        if (url.matches(pattern)) {
            return url;
        }
        return null;
    }

    private static String getHelpTopicPrefix(LanguageInfo.LocaleType type) {
        String ret = LanguageInfo.getWikiLanguagePrefix(type);
        if (ret == null) {
            return ret;
        }
        ret = "/" + ret + Main.pref.get("help.pathhelp", "/Help").replaceAll("^\\/+", "");
        return ret.replaceAll("\\/+", "\\/");
    }

    public static String buildAbsoluteHelpTopic(String topic, LanguageInfo.LocaleType type) {
        String prefix = HelpUtil.getHelpTopicPrefix(type);
        if (prefix == null || topic == null || topic.trim().length() == 0 || "/".equals(topic.trim())) {
            return prefix;
        }
        prefix = prefix + "/" + topic;
        return prefix.replaceAll("\\/+", "\\/");
    }

    public static String getContextSpecificHelpTopic(Object context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Helpful) {
            return ((Helpful)context).helpTopic();
        }
        if (context instanceof JMenu) {
            JMenu b = (JMenu)context;
            if (b.getClientProperty("help") != null) {
                return (String)b.getClientProperty("help");
            }
            return null;
        }
        if (context instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)context;
            if (b.getClientProperty("help") != null) {
                return (String)b.getClientProperty("help");
            }
            return HelpUtil.getContextSpecificHelpTopic(b.getAction());
        }
        if (context instanceof Action) {
            return (String)((Action)context).getValue("help");
        }
        if (context instanceof JComponent && ((JComponent)context).getClientProperty("help") != null) {
            return (String)((JComponent)context).getClientProperty("help");
        }
        if (context instanceof Component) {
            return HelpUtil.getContextSpecificHelpTopic(((Component)context).getParent());
        }
        return null;
    }

    private static Action getHelpAction() {
        if (Main.main != null && Main.main.menu != null) {
            return Main.main.menu.help;
        }
        return new HelpAction();
    }

    public static void setHelpContext(JComponent component, String relativeHelpTopic) {
        component.getInputMap(2).put(KeyStroke.getKeyStroke("F1"), "help");
        component.getActionMap().put("help", HelpUtil.getHelpAction());
        component.putClientProperty("help", relativeHelpTopic == null ? "/" : relativeHelpTopic);
    }

    public static String ht(String helpTopic) {
        return helpTopic;
    }
}

