/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WikiReader;

public class HelpContentReader
extends WikiReader {
    public HelpContentReader(String baseUrl) {
        super(baseUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchHelpTopicContent(String helpTopicUrl, boolean dotest) throws HelpContentReaderException {
        if (helpTopicUrl == null) {
            throw new MissingHelpContentException(helpTopicUrl);
        }
        HttpURLConnection con = null;
        try {
            URL u = new URL(helpTopicUrl);
            con = Utils.openHttpConnection(u);
            con.connect();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                String string = this.prepareHelpContent(in, dotest, u);
                return string;
            }
        }
        catch (MalformedURLException e) {
            throw new HelpContentReaderException(e);
        }
        catch (IOException e) {
            HelpContentReaderException ex = new HelpContentReaderException(e);
            if (con == null) throw ex;
            try {
                ex.setResponseCode(con.getResponseCode());
                throw ex;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected String prepareHelpContent(BufferedReader in, boolean dotest, URL url) throws HelpContentReaderException {
        String s = "";
        try {
            s = this.readFromTrac(in, url);
        }
        catch (IOException e) {
            throw new HelpContentReaderException(e);
        }
        if (dotest && s.isEmpty()) {
            throw new MissingHelpContentException(s);
        }
        return s;
    }
}

