/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.help.HelpBrowserHistory;
import org.openstreetmap.josm.gui.help.HelpContentReader;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.gui.widgets.JosmHTMLEditorKit;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HelpBrowser
extends JDialog {
    private static HelpBrowser instance;
    private JMenuItem windowMenuItem;
    private JosmEditorPane help;
    private HelpBrowserHistory history;
    private String url;
    private HelpContentReader reader = new HelpContentReader(HelpUtil.getWikiBaseUrl());
    private static final JosmAction focusAction;

    public static synchronized HelpBrowser getInstance() {
        if (instance == null) {
            instance = new HelpBrowser();
        }
        return instance;
    }

    public static void setUrlForHelpTopic(final String helpTopic) {
        final HelpBrowser browser = HelpBrowser.getInstance();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                browser.openHelpTopic(helpTopic);
                browser.setVisible(true);
                browser.toFront();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public static void launchBrowser(String helpTopic) {
        HelpBrowser browser = HelpBrowser.getInstance();
        browser.openHelpTopic(helpTopic);
        browser.setVisible(true);
        browser.toFront();
    }

    protected StyleSheet buildStyleSheet() {
        StyleSheet ss = new StyleSheet();
        StringBuilder css = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/data/help-browser.css"), StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                css.append(line);
                css.append("\n");
            }
        }
        catch (Exception e) {
            Main.error(I18n.tr("Failed to read CSS file ''help-browser.css''. Exception is: {0}", e.toString()));
            Main.error(e);
            return ss;
        }
        ss.addRule(css.toString());
        return ss;
    }

    protected JToolBar buildToolBar() {
        JToolBar tb = new JToolBar();
        tb.add(new JButton(new HomeAction()));
        tb.add(new JButton(new BackAction(this.history)));
        tb.add(new JButton(new ForwardAction(this.history)));
        tb.add(new JButton(new ReloadAction()));
        tb.add(new JSeparator());
        tb.add(new JButton(new OpenInBrowserAction()));
        tb.add(new JButton(new EditAction()));
        return tb;
    }

    protected final void build() {
        this.help = new JosmEditorPane();
        JosmHTMLEditorKit kit = new JosmHTMLEditorKit();
        kit.setStyleSheet(this.buildStyleSheet());
        this.help.setEditorKit(kit);
        this.help.setEditable(false);
        this.help.addHyperlinkListener(new HyperlinkHandler());
        this.help.setContentType("text/html");
        this.history = new HelpBrowserHistory(this);
        JPanel p = new JPanel(new BorderLayout());
        this.setContentPane(p);
        p.add((Component)new JScrollPane(this.help), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HelpBrowser.this.setVisible(false);
            }
        });
        p.add((Component)this.buildToolBar(), "North");
        this.help.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Close");
        this.help.getActionMap().put("Close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpBrowser.this.setVisible(false);
            }
        });
        this.setMinimumSize(new Dimension(400, 200));
        this.setTitle(I18n.tr("JOSM Help Browser", new Object[0]));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(600, 400))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        if (Main.main != null && Main.main.menu != null && Main.main.menu.windowMenu != null) {
            if (this.windowMenuItem != null && !visible) {
                Main.main.menu.windowMenu.remove(this.windowMenuItem);
                this.windowMenuItem = null;
            }
            if (this.windowMenuItem == null && visible) {
                this.windowMenuItem = MainMenu.add(Main.main.menu.windowMenu, focusAction, MainMenu.WINDOW_MENU_GROUP.VOLATILE);
            }
        }
        super.setVisible(visible);
    }

    public HelpBrowser() {
        this.build();
    }

    protected void loadTopic(String content) {
        Document document = this.help.getEditorKit().createDefaultDocument();
        try {
            this.help.getEditorKit().read(new StringReader(content), document, 0);
        }
        catch (Exception e) {
            Main.error(e);
        }
        this.help.setDocument(document);
    }

    public String getUrl() {
        return this.url;
    }

    protected void handleMissingHelpContent(String relativeHelpTopic) {
        String message = I18n.tr("<html><p class=\"warning-header\">Help content for help topic missing</p><p class=\"warning-body\">Help content for the help topic <strong>{0}</strong> is not available yet. It is missing both in your local language ({1}) and in English.<br><br>Please help to improve the JOSM help system and fill in the missing information. You can both edit the <a href=\"{2}\">help topic in your local language ({1})</a> and the <a href=\"{3}\">help topic in English</a>.</p></html>", relativeHelpTopic, Locale.getDefault().getDisplayName(), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.DEFAULT)), HelpUtil.getHelpTopicEditUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.ENGLISH)));
        this.loadTopic(message);
    }

    protected void handleHelpContentReaderException(String relativeHelpTopic, HelpContentReaderException e) {
        String message = I18n.tr("<html><p class=\"error-header\">Error when retrieving help information</p><p class=\"error-body\">The content for the help topic <strong>{0}</strong> could not be loaded. The error message is (untranslated):<br><tt>{1}</tt></p></html>", relativeHelpTopic, e.toString());
        this.loadTopic(message);
    }

    protected void loadRelativeHelpTopic(String relativeHelpTopic) {
        String url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.DEFAULTNOTENGLISH));
        String content = null;
        try {
            content = this.reader.fetchHelpTopicContent(url, true);
        }
        catch (MissingHelpContentException e) {
            url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.BASELANGUAGE));
            try {
                content = this.reader.fetchHelpTopicContent(url, true);
            }
            catch (MissingHelpContentException e1) {
                url = HelpUtil.getHelpTopicUrl(HelpUtil.buildAbsoluteHelpTopic(relativeHelpTopic, LanguageInfo.LocaleType.ENGLISH));
                try {
                    content = this.reader.fetchHelpTopicContent(url, true);
                }
                catch (MissingHelpContentException e2) {
                    this.url = url;
                    this.handleMissingHelpContent(relativeHelpTopic);
                    return;
                }
                catch (HelpContentReaderException e2) {
                    Main.error(e2);
                    this.handleHelpContentReaderException(relativeHelpTopic, e2);
                    return;
                }
            }
            catch (HelpContentReaderException e1) {
                Main.error(e1);
                this.handleHelpContentReaderException(relativeHelpTopic, e1);
                return;
            }
        }
        catch (HelpContentReaderException e) {
            Main.error(e);
            this.handleHelpContentReaderException(relativeHelpTopic, e);
            return;
        }
        this.loadTopic(content);
        this.history.setCurrentUrl(url);
        this.url = url;
    }

    protected void loadAbsoluteHelpTopic(String absoluteHelpTopic) {
        String url = HelpUtil.getHelpTopicUrl(absoluteHelpTopic);
        String content = null;
        try {
            content = this.reader.fetchHelpTopicContent(url, true);
        }
        catch (MissingHelpContentException e) {
            this.url = url;
            this.handleMissingHelpContent(absoluteHelpTopic);
            return;
        }
        catch (HelpContentReaderException e) {
            Main.error(e);
            this.handleHelpContentReaderException(absoluteHelpTopic, e);
            return;
        }
        this.loadTopic(content);
        this.history.setCurrentUrl(url);
        this.url = url;
    }

    public void openUrl(String url) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        String helpTopic = HelpUtil.extractAbsoluteHelpTopic(url);
        if (helpTopic == null) {
            try {
                this.url = url;
                String content = this.reader.fetchHelpTopicContent(url, false);
                this.loadTopic(content);
                this.history.setCurrentUrl(url);
                this.url = url;
            }
            catch (Exception e) {
                Main.warn(e);
                HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>Failed to open help page for url {0}.<br>This is most likely due to a network problem, please check<br>your internet connection</html>", url), I18n.tr("Failed to open URL", new Object[0]), 0, null, null, null, null);
            }
            this.history.setCurrentUrl(url);
        } else {
            this.loadAbsoluteHelpTopic(helpTopic);
        }
    }

    public void openHelpTopic(String relativeHelpTopic) {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.toFront();
        } else {
            this.toFront();
        }
        this.loadRelativeHelpTopic(relativeHelpTopic);
    }

    static {
        focusAction = new JosmAction(I18n.tr("JOSM Help Browser", new Object[0]), "help", "", null, false, false){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpBrowser.getInstance().setVisible(true);
            }
        };
    }

    class HyperlinkHandler
    implements HyperlinkListener {
        HyperlinkHandler() {
        }

        protected boolean scrollToElementWithId(String id) {
            Document d = HelpBrowser.this.help.getDocument();
            if (d instanceof HTMLDocument) {
                HTMLDocument doc = (HTMLDocument)d;
                Element element = doc.getElement(id);
                try {
                    Rectangle r = HelpBrowser.this.help.modelToView(element.getStartOffset());
                    if (r != null) {
                        Rectangle vis = HelpBrowser.this.help.getVisibleRect();
                        r.height = vis.height;
                        HelpBrowser.this.help.scrollRectToVisible(r);
                        return true;
                    }
                }
                catch (BadLocationException e) {
                    Main.warn(I18n.tr("Bad location in HTML document. Exception was: {0}", e.toString()));
                    Main.error(e);
                }
            }
            return false;
        }

        protected String getUrlFragment(HyperlinkEvent e) {
            AttributeSet set = e.getSourceElement().getAttributes();
            Object value = set.getAttribute(HTML.Tag.A);
            if (!(value instanceof SimpleAttributeSet)) {
                return null;
            }
            SimpleAttributeSet atts = (SimpleAttributeSet)value;
            if ((value = atts.getAttribute(HTML.Attribute.HREF)) == null) {
                return null;
            }
            String s = (String)value;
            if (s.matches("#.*")) {
                return s.substring(1);
            }
            return null;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (e.getURL() == null || e.getURL().toString().startsWith(HelpBrowser.this.url + "#")) {
                String fragment = this.getUrlFragment(e);
                if (fragment != null) {
                    if (!this.scrollToElementWithId(fragment)) {
                        HelpBrowser.this.help.scrollToReference(fragment);
                    }
                } else {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Failed to open help page. The target URL is empty.", new Object[0]), I18n.tr("Failed to open help page", new Object[0]), 0, null, null, null, null);
                }
            } else if (e.getURL().toString().endsWith("action=edit")) {
                OpenBrowser.displayUrl(e.getURL().toString());
            } else {
                HelpBrowser.this.url = e.getURL().toString();
                HelpBrowser.this.openUrl(e.getURL().toString());
            }
        }
    }

    class HomeAction
    extends AbstractAction {
        public HomeAction() {
            this.putValue("ShortDescription", I18n.tr("Go to the JOSM help home page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "home"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpBrowser.this.openHelpTopic("/");
        }
    }

    static class ForwardAction
    extends AbstractAction
    implements Observer {
        private HelpBrowserHistory history;

        public ForwardAction(HelpBrowserHistory history) {
            this.history = history;
            history.addObserver(this);
            this.putValue("ShortDescription", I18n.tr("Go to the next page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "next"));
            this.setEnabled(history.canGoForward());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.history.forward();
        }

        @Override
        public void update(Observable o, Object arg) {
            this.setEnabled(this.history.canGoForward());
        }
    }

    static class BackAction
    extends AbstractAction
    implements Observer {
        private HelpBrowserHistory history;

        public BackAction(HelpBrowserHistory history) {
            this.history = history;
            history.addObserver(this);
            this.putValue("ShortDescription", I18n.tr("Go to the previous page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "previous"));
            this.setEnabled(history.canGoBack());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.history.back();
        }

        @Override
        public void update(Observable o, Object arg) {
            this.setEnabled(this.history.canGoBack());
        }
    }

    class ReloadAction
    extends AbstractAction {
        public ReloadAction() {
            this.putValue("ShortDescription", I18n.tr("Reload the current help page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpBrowser.this.openUrl(HelpBrowser.this.getUrl());
        }
    }

    class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the current help page", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url = HelpBrowser.this.getUrl();
            if (url == null) {
                return;
            }
            if (!url.startsWith(HelpUtil.getWikiBaseHelpUrl())) {
                String message = I18n.tr("<html>The current URL <tt>{0}</tt><br>is an external URL. Editing is only possible for help topics<br>on the help server <tt>{1}</tt>.</html>", HelpBrowser.this.getUrl(), HelpUtil.getWikiBaseUrl());
                JOptionPane.showMessageDialog(Main.parent, message, I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            url = url.replaceAll("#[^#]*$", "");
            OpenBrowser.displayUrl(url + "?action=edit");
        }
    }

    class OpenInBrowserAction
    extends AbstractAction {
        public OpenInBrowserAction() {
            this.putValue("ShortDescription", I18n.tr("Open the current help page in an external browser", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help", "internet"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OpenBrowser.displayUrl(HelpBrowser.this.getUrl());
        }
    }
}

