/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapChooser
extends JPanel
implements PropertyChangeListener,
DownloadSelection {
    private DownloadDialog iGui;
    private SlippyMapBBoxChooser pnlSlippyMapBBoxChooser = new SlippyMapBBoxChooser();
    private Dimension iDownloadDialogDimension;

    public SlippyMapChooser() {
        this.pnlSlippyMapBBoxChooser.addPropertyChangeListener(this);
    }

    @Override
    public void addGui(DownloadDialog gui) {
        this.iGui = gui;
        this.iGui.addDownloadAreaSelector(this.pnlSlippyMapBBoxChooser, I18n.tr("Slippy map", new Object[0]));
    }

    @Override
    public void setDownloadArea(Bounds area) {
        this.pnlSlippyMapBBoxChooser.setBoundingBox(area);
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(BBoxChooser.BBOX_PROP)) {
            if (this.iGui != null) {
                this.iGui.boundingBoxChanged((Bounds)evt.getNewValue(), this);
            }
        } else if (evt.getPropertyName().equals(SlippyMapBBoxChooser.RESIZE_PROP)) {
            int h;
            int w;
            Dimension iScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.iDownloadDialogDimension == null) {
                w = iScreenSize.width * 90 / 100;
                h = iScreenSize.height * 90 / 100;
                this.iDownloadDialogDimension = this.iGui.getSize();
            } else {
                w = this.iDownloadDialogDimension.width;
                h = this.iDownloadDialogDimension.height;
                this.iDownloadDialogDimension = null;
            }
            this.iGui.setBounds((iScreenSize.width - w) / 2, (iScreenSize.height - h) / 2, w, h);
            this.repaint();
        }
    }

    public final void refreshTileSources() {
        if (this.pnlSlippyMapBBoxChooser != null) {
            this.pnlSlippyMapBBoxChooser.refreshTileSources();
        }
    }
}

