/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PlaceSelection
implements DownloadSelection {
    private HistoryComboBox cbSearchExpression;
    private JButton btnSearch;
    private NamedResultTableModel model;
    private NamedResultTableColumnModel columnmodel;
    private JTable tblSearchResults;
    private DownloadDialog parent;
    private static final Server[] SERVERS = new Server[]{new Server("Nominatim", "https://nominatim.openstreetmap.org/search?format=xml&q=", I18n.tr("Class Type", new Object[0]), I18n.tr("Bounds", new Object[0]))};
    private final JosmComboBox<Server> server = new JosmComboBox<Server>(SERVERS);

    protected JPanel buildSearchPanel() {
        JPanel lpanel = new JPanel();
        lpanel.setLayout(new GridLayout(2, 2));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        lpanel.add(new JLabel(I18n.tr("Choose the server for searching:", new Object[0])));
        lpanel.add(this.server);
        String s = Main.pref.get("namefinder.server", PlaceSelection.SERVERS[0].name);
        for (int i = 0; i < SERVERS.length; ++i) {
            if (!PlaceSelection.SERVERS[i].name.equals(s)) continue;
            this.server.setSelectedIndex(i);
        }
        lpanel.add(new JLabel(I18n.tr("Enter a place name to search for:", new Object[0])));
        this.cbSearchExpression = new HistoryComboBox();
        this.cbSearchExpression.setToolTipText(I18n.tr("Enter a place name to search for", new Object[0]));
        LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection("download.places.history", new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        this.cbSearchExpression.setPossibleItems(cmtHistory);
        lpanel.add(this.cbSearchExpression);
        panel.add((Component)lpanel, GBC.std().fill(2).insets(5, 5, 0, 5));
        SearchAction searchAction = new SearchAction();
        this.btnSearch = new JButton(searchAction);
        ((JTextField)this.cbSearchExpression.getEditor().getEditorComponent()).getDocument().addDocumentListener(searchAction);
        ((JTextField)this.cbSearchExpression.getEditor().getEditorComponent()).addActionListener(searchAction);
        panel.add((Component)this.btnSearch, GBC.eol().insets(5, 5, 0, 5));
        return panel;
    }

    @Override
    public void addGui(DownloadDialog gui) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildSearchPanel(), "North");
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new NamedResultTableModel(selectionModel);
        this.columnmodel = new NamedResultTableColumnModel();
        this.tblSearchResults = new JTable(this.model, this.columnmodel);
        this.tblSearchResults.setSelectionModel(selectionModel);
        JScrollPane scrollPane = new JScrollPane(this.tblSearchResults);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        panel.add((Component)scrollPane, "Center");
        gui.addDownloadAreaSelector(panel, I18n.tr("Areas around places", new Object[0]));
        scrollPane.setPreferredSize(scrollPane.getPreferredSize());
        this.tblSearchResults.getSelectionModel().setSelectionMode(0);
        this.tblSearchResults.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        this.tblSearchResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    SearchResult sr = PlaceSelection.this.model.getSelectedSearchResult();
                    if (sr == null) {
                        return;
                    }
                    PlaceSelection.this.parent.startDownload(sr.getDownloadArea());
                }
            }
        });
        this.parent = gui;
    }

    @Override
    public void setDownloadArea(Bounds area) {
        this.tblSearchResults.clearSelection();
    }

    static class NamedResultCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public NamedResultCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        protected void reset() {
            this.setText("");
            this.setIcon(null);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            }
        }

        protected String lineWrapDescription(String description) {
            StringBuilder ret = new StringBuilder();
            StringBuilder line = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(description, " ");
            while (tok.hasMoreElements()) {
                String t = tok.nextToken();
                if (line.length() == 0) {
                    line.append(t);
                    continue;
                }
                if (line.length() < 80) {
                    line.append(" ").append(t);
                    continue;
                }
                line.append(" ").append(t).append("<br>");
                ret.append((CharSequence)line);
                line = new StringBuilder();
            }
            ret.insert(0, "<html>");
            ret.append("</html>");
            return ret.toString();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.reset();
            this.renderColor(isSelected);
            if (value == null) {
                return this;
            }
            SearchResult sr = (SearchResult)value;
            switch (column) {
                case 0: {
                    this.setText(sr.name);
                    break;
                }
                case 1: {
                    this.setText(sr.info);
                    break;
                }
                case 2: {
                    this.setText(sr.nearestPlace);
                    break;
                }
                case 3: {
                    if (sr.bounds != null) {
                        this.setText(sr.bounds.toShortString(new DecimalFormat("0.000")));
                        break;
                    }
                    this.setText(sr.zoom != 0 ? Integer.toString(sr.zoom) : I18n.tr("unknown", new Object[0]));
                }
            }
            this.setToolTipText(this.lineWrapDescription(sr.description));
            return this;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            SearchResult r = PlaceSelection.this.model.getSelectedSearchResult();
            if (r != null) {
                PlaceSelection.this.parent.boundingBoxChanged(r.getDownloadArea(), PlaceSelection.this);
            }
        }
    }

    static class NamedResultTableColumnModel
    extends DefaultTableColumnModel {
        TableColumn col3 = null;
        TableColumn col4 = null;

        protected final void createColumns() {
            TableColumn col = null;
            NamedResultCellRenderer renderer = new NamedResultCellRenderer();
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("Name", new Object[0]));
            col.setResizable(true);
            col.setPreferredWidth(200);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("Type", new Object[0]));
            col.setResizable(true);
            col.setPreferredWidth(100);
            col.setCellRenderer(renderer);
            this.addColumn(col);
            this.col3 = new TableColumn(2);
            this.col3.setHeaderValue(SERVERS[0].thirdcol);
            this.col3.setResizable(true);
            this.col3.setPreferredWidth(100);
            this.col3.setCellRenderer(renderer);
            this.addColumn(this.col3);
            this.col4 = new TableColumn(3);
            this.col4.setHeaderValue(SERVERS[0].fourthcol);
            this.col4.setResizable(true);
            this.col4.setPreferredWidth(50);
            this.col4.setCellRenderer(renderer);
            this.addColumn(this.col4);
        }

        public void setHeadlines(String third, String fourth) {
            this.col3.setHeaderValue(third);
            this.col4.setHeaderValue(fourth);
            this.fireColumnMarginChanged();
        }

        public NamedResultTableColumnModel() {
            this.createColumns();
        }
    }

    static class NamedResultTableModel
    extends DefaultTableModel {
        private List<SearchResult> data = new ArrayList<SearchResult>();
        private ListSelectionModel selectionModel;

        public NamedResultTableModel(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(row);
        }

        public void setData(List<SearchResult> data) {
            if (data == null) {
                this.data.clear();
            } else {
                this.data = new ArrayList<SearchResult>(data);
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public SearchResult getSelectedSearchResult() {
            if (this.selectionModel.getMinSelectionIndex() < 0) {
                return null;
            }
            return this.data.get(this.selectionModel.getMinSelectionIndex());
        }
    }

    class NameQueryTask
    extends PleaseWaitRunnable {
        private String searchExpression;
        private HttpURLConnection connection;
        private List<SearchResult> data;
        private boolean canceled;
        private Server useserver;
        private Exception lastException;

        public NameQueryTask(String searchExpression) {
            super(I18n.tr("Querying name server", new Object[0]), false);
            this.canceled = false;
            this.searchExpression = searchExpression;
            this.useserver = (Server)PlaceSelection.this.server.getSelectedItem();
            Main.pref.put("namefinder.server", this.useserver.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.canceled = true;
            NameQueryTask nameQueryTask = this;
            synchronized (nameQueryTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            PlaceSelection.this.columnmodel.setHeadlines(this.useserver.thirdcol, this.useserver.fourthcol);
            PlaceSelection.this.model.setData(this.data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            block31: {
                String urlString = this.useserver.url + URLEncoder.encode(this.searchExpression, "UTF-8");
                try {
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Querying name server ...", new Object[0]));
                    URL url = new URL(urlString);
                    NameQueryTask nameQueryTask = this;
                    synchronized (nameQueryTask) {
                        this.connection = Utils.openHttpConnection(url);
                    }
                    this.connection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                    try (InputStream inputStream = this.connection.getInputStream();
                         InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                        InputSource inputSource = new InputSource(reader);
                        NameFinderResultParser parser = new NameFinderResultParser();
                        SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)parser);
                        this.data = parser.getResult();
                    }
                }
                catch (SAXParseException e) {
                    if (!this.canceled) {
                        Main.warn(I18n.tr("Error occured with query ''{0}'': ''{1}''", urlString, e.getMessage()));
                        GuiHelper.runInEDTAndWait(new Runnable(){

                            @Override
                            public void run() {
                                HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Name server returned invalid data. Please try again.", new Object[0]), I18n.tr("Bad response", new Object[0]), 2, null);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    if (this.canceled) break block31;
                    OsmTransferException ex = new OsmTransferException(e);
                    ex.setUrl(urlString);
                    this.lastException = ex;
                }
            }
        }
    }

    class SearchAction
    extends AbstractAction
    implements DocumentListener {
        public SearchAction() {
            this.putValue("Name", I18n.tr("Search ...", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.putValue("ShortDescription", I18n.tr("Click to start searching for places", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled() || PlaceSelection.this.cbSearchExpression.getText().trim().length() == 0) {
                return;
            }
            PlaceSelection.this.cbSearchExpression.addCurrentItemToHistory();
            Main.pref.putCollection("download.places.history", PlaceSelection.this.cbSearchExpression.getHistory());
            NameQueryTask task = new NameQueryTask(PlaceSelection.this.cbSearchExpression.getText());
            Main.worker.submit(task);
        }

        protected final void updateEnabledState() {
            this.setEnabled(PlaceSelection.this.cbSearchExpression.getText().trim().length() > 0);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateEnabledState();
        }
    }

    private static class NameFinderResultParser
    extends DefaultHandler {
        private SearchResult currentResult = null;
        private StringBuffer description = null;
        private int depth = 0;
        private List<SearchResult> data = new LinkedList<SearchResult>();

        private NameFinderResultParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            ++this.depth;
            try {
                if (!"searchresults".equals(qName)) {
                    if ("named".equals(qName) && this.depth == 2) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = atts.getValue("name");
                        this.currentResult.info = atts.getValue("info");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.lat = Double.parseDouble(atts.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(atts.getValue("lon"));
                        this.currentResult.zoom = Integer.parseInt(atts.getValue("zoom"));
                        this.data.add(this.currentResult);
                    } else if ("description".equals(qName) && this.depth == 3) {
                        this.description = new StringBuffer();
                    } else if ("named".equals(qName) && this.depth == 4) {
                        String info = atts.getValue("info");
                        if ("city".equals(info) || "town".equals(info) || "village".equals(info)) {
                            this.currentResult.nearestPlace = atts.getValue("name");
                        }
                    } else if ("place".equals(qName) && atts.getValue("lat") != null) {
                        this.currentResult = new SearchResult();
                        this.currentResult.description = this.currentResult.name = atts.getValue("display_name");
                        this.currentResult.info = atts.getValue("class");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.nearestPlace = I18n.tr(atts.getValue("type"), new Object[0]);
                        this.currentResult.lat = Double.parseDouble(atts.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(atts.getValue("lon"));
                        String[] bbox = atts.getValue("boundingbox").split(",");
                        this.currentResult.bounds = new Bounds(Double.parseDouble(bbox[0]), Double.parseDouble(bbox[2]), Double.parseDouble(bbox[1]), Double.parseDouble(bbox[3]));
                        this.data.add(this.currentResult);
                    }
                }
            }
            catch (NumberFormatException x) {
                Main.error(x);
                throw new SAXException(x.getMessage(), x);
            }
            catch (NullPointerException x) {
                Main.error(x);
                throw new SAXException(I18n.tr("Null pointer exception, possibly some missing tags.", new Object[0]), x);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if ("description".equals(qName) && this.description != null) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        @Override
        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.description != null) {
                this.description.append(data, start, length);
            }
        }

        public List<SearchResult> getResult() {
            return this.data;
        }
    }

    private static class SearchResult {
        public String name;
        public String info;
        public String nearestPlace;
        public String description;
        public double lat;
        public double lon;
        public int zoom = 0;
        public Bounds bounds = null;

        private SearchResult() {
        }

        public Bounds getDownloadArea() {
            return this.bounds != null ? this.bounds : OsmUrlToBounds.positionToBounds(this.lat, this.lon, this.zoom);
        }
    }

    private static class Server {
        public String name;
        public String url;
        public String thirdcol;
        public String fourthcol;

        public String toString() {
            return this.name;
        }

        public Server(String n, String u, String t, String f) {
            this.name = n;
            this.url = u;
            this.thirdcol = t;
            this.fourthcol = f;
        }
    }
}

