/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class BookmarkList
extends JList<Bookmark> {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    public final void load() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.removeAllElements();
        Collection<Collection<String>> args = Main.pref.getArray("bookmarks", null);
        if (args != null) {
            LinkedList<Bookmark> bookmarks = new LinkedList<Bookmark>();
            for (Collection<String> entry : args) {
                try {
                    bookmarks.add(new Bookmark(entry));
                }
                catch (Exception e) {
                    Main.error(I18n.tr("Error reading bookmark entry: %s", e.getMessage()));
                }
            }
            Collections.sort(bookmarks);
            for (Bookmark b : bookmarks) {
                model.addElement(b);
            }
        }
    }

    public final void save() {
        LinkedList<Collection<String>> coll = new LinkedList<Collection<String>>();
        for (Object o : ((DefaultListModel)this.getModel()).toArray()) {
            String[] array = new String[5];
            Bookmark b = (Bookmark)o;
            array[0] = b.getName();
            Bounds area = b.getArea();
            array[1] = String.valueOf(area.getMinLat());
            array[2] = String.valueOf(area.getMinLon());
            array[3] = String.valueOf(area.getMaxLat());
            array[4] = String.valueOf(area.getMaxLon());
            coll.add(Arrays.asList(array));
        }
        Main.pref.putArray("bookmarks", coll);
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer<Bookmark> {
        private ImageIcon icon;

        public BookmarkCellRenderer() {
            this.setOpaque(true);
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.setIcon(this.icon);
        }

        protected void renderColor(boolean selected) {
            if (selected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Bookmark b) {
            Bounds area = b.getArea();
            StringBuilder sb = new StringBuilder();
            sb.append("<html>min[latitude,longitude]=<strong>[").append(area.getMinLat()).append(",").append(area.getMinLon()).append("]</strong>").append("<br>").append("max[latitude,longitude]=<strong>[").append(area.getMaxLat()).append(",").append(area.getMaxLon()).append("]</strong>").append("</html>");
            return sb.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Bookmark> list, Bookmark value, int index, boolean isSelected, boolean cellHasFocus) {
            this.renderColor(isSelected);
            this.setText(value.getName());
            this.setToolTipText(this.buildToolTipText(value));
            return this;
        }
    }

    public static class Bookmark
    implements Comparable<Bookmark> {
        private String name;
        private Bounds area;

        public Bookmark(Collection<String> list) throws NumberFormatException, IllegalArgumentException {
            ArrayList<String> array = new ArrayList<String>(list);
            if (array.size() < 5) {
                throw new IllegalArgumentException(I18n.tr("Wrong number of arguments for bookmark", new Object[0]));
            }
            this.name = (String)array.get(0);
            this.area = new Bounds(Double.parseDouble((String)array.get(1)), Double.parseDouble((String)array.get(2)), Double.parseDouble((String)array.get(3)), Double.parseDouble((String)array.get(4)));
        }

        public Bookmark() {
            this.area = null;
            this.name = null;
        }

        public Bookmark(Bounds area) {
            this.area = area;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark b) {
            return this.name.toLowerCase().compareTo(b.name.toLowerCase());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.area == null ? 0 : this.area.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Bookmark other = (Bookmark)obj;
            if (this.area == null ? other.area != null : !this.area.equals(other.area)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public Bounds getArea() {
            return this.area;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setArea(Bounds area) {
            this.area = area;
        }
    }
}

