/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.validator;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreeRenderer;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class ValidatorTreePanel
extends JTree
implements Destroyable {
    protected DefaultTreeModel valTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private List<TestError> errors = new ArrayList<TestError>();
    private Set<OsmPrimitive> filter = null;
    private int updateCount;

    public ValidatorTreePanel(List<TestError> errors) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.valTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ValidatorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setErrorList(errors);
        for (KeyListener keyListener : this.getKeyListeners()) {
            if (!"javax.swing.plaf.basic.BasicTreeUI$Handler".equals(keyListener.getClass().getName())) continue;
            this.removeKeyListener(keyListener);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String res = null;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof TestError) {
                TestError error = (TestError)nodeInfo;
                MultipleNameVisitor v = new MultipleNameVisitor();
                v.visit(error.getPrimitives());
                res = "<html>" + v.getText() + "<br>" + error.getMessage();
                String d = error.getDescription();
                if (d != null) {
                    res = res + "<br>" + d;
                }
                res = res + "</html>";
            } else {
                res = node.toString();
            }
        }
        return res;
    }

    public ValidatorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.buildTree();
        } else {
            this.valTreeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(v);
    }

    public void buildTree() {
        ++this.updateCount;
        final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    ValidatorTreePanel.this.valTreeModel.setRoot(rootNode);
                }
            });
            return;
        }
        Collections.sort(this.errors);
        HashSet<Object> oldSelectedRows = new HashSet<Object>();
        Enumeration<TreePath> expanded = this.getExpandedDescendants(new TreePath(this.getRoot()));
        if (expanded != null) {
            while (expanded.hasMoreElements()) {
                TreePath path = expanded.nextElement();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof Severity) {
                    oldSelectedRows.add(userObject);
                    continue;
                }
                if (!(userObject instanceof String)) continue;
                String msg = (String)userObject;
                int index = msg.lastIndexOf(" (");
                if (index > 0) {
                    msg = msg.substring(0, index);
                }
                oldSelectedRows.add(msg);
            }
        }
        HashMap errorTree = new HashMap();
        HashMap errorTreeDeep = new HashMap();
        for (Severity s : Severity.values()) {
            errorTree.put(s, new MultiMap(20));
            errorTreeDeep.put(s, new HashMap());
        }
        Boolean other = ValidatorPreference.PREF_OTHER.get();
        for (TestError e : this.errors) {
            Severity s;
            if (e.getIgnored().booleanValue()) continue;
            s = e.getSeverity();
            if (!other.booleanValue() && s == Severity.OTHER) continue;
            String d = e.getDescription();
            String m = e.getMessage();
            if (this.filter != null) {
                boolean found = false;
                for (OsmPrimitive osmPrimitive : e.getPrimitives()) {
                    if (!this.filter.contains(osmPrimitive)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (d != null) {
                MultiMap<String, TestError> b = (MultiMap<String, TestError>)((HashMap)errorTreeDeep.get((Object)s)).get(m);
                if (b == null) {
                    b = new MultiMap<String, TestError>(20);
                    ((HashMap)errorTreeDeep.get((Object)s)).put(m, b);
                }
                b.put(d, e);
                continue;
            }
            ((MultiMap)errorTree.get((Object)s)).put(m, e);
        }
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        for (Severity s : Severity.values()) {
            MultiMap severityErrors = (MultiMap)errorTree.get((Object)s);
            Map severityErrorsDeep = (Map)errorTreeDeep.get((Object)s);
            if (severityErrors.isEmpty() && severityErrorsDeep.isEmpty()) continue;
            GroupTreeNode groupTreeNode = new GroupTreeNode((Object)s);
            rootNode.add(groupTreeNode);
            if (oldSelectedRows.contains((Object)s)) {
                expandedPaths.add(new TreePath(new Object[]{rootNode, groupTreeNode}));
            }
            for (Map.Entry entry : severityErrors.entrySet()) {
                Set errs = entry.getValue();
                String msg = I18n.tr("{0} ({1})", entry.getKey(), errs.size());
                DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                groupTreeNode.add(messageNode);
                if (oldSelectedRows.contains(entry.getKey())) {
                    expandedPaths.add(new TreePath(new Object[]{rootNode, groupTreeNode, messageNode}));
                }
                for (TestError error : errs) {
                    DefaultMutableTreeNode errorNode = new DefaultMutableTreeNode(error);
                    messageNode.add(errorNode);
                }
            }
            for (Map.Entry<Object, Set<Object>> entry : severityErrorsDeep.entrySet()) {
                MultiMap errorlist = (MultiMap)((Object)entry.getValue());
                GroupTreeNode groupNode = null;
                if (errorlist.size() > 1) {
                    groupNode = new GroupTreeNode(entry.getKey());
                    groupTreeNode.add(groupNode);
                    if (oldSelectedRows.contains(entry.getKey())) {
                        expandedPaths.add(new TreePath(new Object[]{rootNode, groupTreeNode, groupNode}));
                    }
                }
                for (Map.Entry msgErrors : errorlist.entrySet()) {
                    Set errs = msgErrors.getValue();
                    String msg = groupNode != null ? I18n.tr("{0} ({1})", msgErrors.getKey(), errs.size()) : I18n.tr("{0} - {1} ({2})", msgErrors.getKey(), entry.getKey(), errs.size());
                    DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(msg);
                    if (groupNode != null) {
                        groupNode.add(messageNode);
                    } else {
                        groupTreeNode.add(messageNode);
                    }
                    if (oldSelectedRows.contains(msgErrors.getKey())) {
                        if (groupNode != null) {
                            expandedPaths.add(new TreePath(new Object[]{rootNode, groupTreeNode, groupNode, messageNode}));
                        } else {
                            expandedPaths.add(new TreePath(new Object[]{rootNode, groupTreeNode, messageNode}));
                        }
                    }
                    for (TestError error : errs) {
                        DefaultMutableTreeNode errorNode = new DefaultMutableTreeNode(error);
                        messageNode.add(errorNode);
                    }
                }
            }
        }
        this.valTreeModel.setRoot(rootNode);
        for (TreePath path : expandedPaths) {
            this.expandPath(path);
        }
    }

    public final void setErrorList(List<TestError> errors) {
        this.errors = errors;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void setErrors(List<TestError> newerrors) {
        if (this.errors == null) {
            return;
        }
        this.clearErrors();
        DataSet ds = Main.main.getCurrentDataSet();
        for (TestError error : newerrors) {
            if (error.getIgnored().booleanValue()) continue;
            this.errors.add(error);
            if (ds == null) continue;
            ds.addDataSetListener(error);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public Set<OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<OsmPrimitive> filter) {
        this.filter = filter != null && filter.isEmpty() ? null : filter;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        ArrayList<TestError> e = new ArrayList<TestError>(this.errors);
        this.setErrors(e);
    }

    public void expandAll() {
        DefaultMutableTreeNode root = this.getRoot();
        int row = 0;
        Enumeration<TreeNode> children = root.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            children.nextElement();
            this.expandRow(row++);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.valTreeModel.getRoot();
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    private void clearErrors() {
        if (this.errors != null) {
            DataSet ds = Main.main.getCurrentDataSet();
            if (ds != null) {
                for (TestError e : this.errors) {
                    ds.removeDataSetListener(e);
                }
            }
            this.errors.clear();
        }
    }

    @Override
    public void destroy() {
        this.clearErrors();
    }

    private static final class GroupTreeNode
    extends DefaultMutableTreeNode {
        public GroupTreeNode(Object userObject) {
            super(userObject);
        }

        @Override
        public String toString() {
            return I18n.tr("{0} ({1})", super.toString(), this.getLeafCount());
        }
    }
}

