/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSortUtils;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

public class WayConnectionTypeCalculator {
    private List<RelationMember> members;
    int firstGroupIdx;
    int lastForwardWay;
    int lastBackwardWay;
    boolean onewayBeginning;

    public List<WayConnectionType> updateLinks(List<RelationMember> members) {
        this.members = members;
        ArrayList<WayConnectionType> con = new ArrayList<WayConnectionType>();
        for (int i = 0; i < members.size(); ++i) {
            con.add(null);
        }
        this.firstGroupIdx = 0;
        this.lastForwardWay = Integer.MIN_VALUE;
        this.lastBackwardWay = Integer.MIN_VALUE;
        this.onewayBeginning = false;
        WayConnectionType lastWct = null;
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m = members.get(i);
            if (!m.isWay() || m.getWay() == null || m.getWay().isIncomplete()) {
                if (i > 0) {
                    this.makeLoopIfNeeded(con, i - 1);
                }
                con.set(i, new WayConnectionType());
                this.firstGroupIdx = i;
                continue;
            }
            WayConnectionType wct = new WayConnectionType(false);
            wct.linkPrev = i > 0 && con.get(i - 1) != null && ((WayConnectionType)con.get(i - 1)).isValid();
            wct.direction = WayConnectionType.Direction.NONE;
            if (RelationSortUtils.isOneway(m)) {
                if (lastWct != null && lastWct.isOnewayTail) {
                    wct.isOnewayHead = true;
                }
                if (this.lastBackwardWay == Integer.MIN_VALUE && this.lastForwardWay == Integer.MIN_VALUE) {
                    wct.isOnewayHead = true;
                    this.lastForwardWay = i - 1;
                    this.lastBackwardWay = i - 1;
                    this.onewayBeginning = true;
                }
            }
            if (wct.linkPrev) {
                if (this.lastBackwardWay != Integer.MIN_VALUE && this.lastForwardWay != Integer.MIN_VALUE) {
                    wct = this.determineOnewayConnectionType(con, m, i, wct);
                    if (!wct.linkPrev) {
                        this.firstGroupIdx = i;
                    }
                }
                if (!RelationSortUtils.isOneway(m)) {
                    wct.direction = this.determineDirection(i - 1, lastWct.direction, i);
                    boolean bl = wct.linkPrev = wct.direction != WayConnectionType.Direction.NONE;
                }
            }
            if (!wct.linkPrev) {
                wct.direction = this.determineDirectionOfFirst(i, m);
                if (RelationSortUtils.isOneway(m)) {
                    wct.isOnewayLoopForwardPart = true;
                    this.lastForwardWay = i;
                }
            }
            wct.linkNext = false;
            if (lastWct != null) {
                lastWct.linkNext = wct.linkPrev;
            }
            con.set(i, wct);
            lastWct = wct;
            if (wct.linkPrev) continue;
            if (i > 0) {
                this.makeLoopIfNeeded(con, i - 1);
            }
            this.firstGroupIdx = i;
        }
        this.makeLoopIfNeeded(con, members.size() - 1);
        return con;
    }

    private void makeLoopIfNeeded(List<WayConnectionType> con, int i) {
        boolean loop;
        if (i == this.firstGroupIdx) {
            loop = this.determineDirection(i, WayConnectionType.Direction.FORWARD, i) == WayConnectionType.Direction.FORWARD;
        } else {
            boolean bl = loop = this.determineDirection(i, con.get((int)i).direction, this.firstGroupIdx) == con.get((int)this.firstGroupIdx).direction;
        }
        if (loop) {
            for (int j = this.firstGroupIdx; j <= i; ++j) {
                con.get((int)j).isLoop = true;
            }
        }
    }

    private WayConnectionType.Direction determineDirectionOfFirst(int i, RelationMember m) {
        WayConnectionType.Direction result = RelationSortUtils.roundaboutType(m);
        if (result != WayConnectionType.Direction.NONE) {
            return result;
        }
        if (RelationSortUtils.isOneway(m)) {
            if (RelationSortUtils.isBackward(m)) {
                return WayConnectionType.Direction.BACKWARD;
            }
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(i, WayConnectionType.Direction.FORWARD, i + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(i, WayConnectionType.Direction.BACKWARD, i + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private WayConnectionType determineOnewayConnectionType(List<WayConnectionType> con, RelationMember m, int i, WayConnectionType wct) {
        WayConnectionType.Direction dirFW = this.determineDirection(this.lastForwardWay, con.get((int)this.lastForwardWay).direction, i);
        WayConnectionType.Direction dirBW = WayConnectionType.Direction.NONE;
        if (this.onewayBeginning) {
            dirBW = this.lastBackwardWay < 0 ? this.determineDirection(this.firstGroupIdx, WayConnectionTypeCalculator.reverse(con.get((int)this.firstGroupIdx).direction), i, true) : this.determineDirection(this.lastBackwardWay, con.get((int)this.lastBackwardWay).direction, i, true);
            if (dirBW != WayConnectionType.Direction.NONE) {
                this.onewayBeginning = false;
            }
        } else {
            dirBW = this.determineDirection(this.lastBackwardWay, con.get((int)this.lastBackwardWay).direction, i, true);
        }
        if (RelationSortUtils.isOneway(m)) {
            if (dirBW != WayConnectionType.Direction.NONE) {
                wct.direction = dirBW;
                this.lastBackwardWay = i;
                wct.isOnewayLoopBackwardPart = true;
            }
            if (dirFW != WayConnectionType.Direction.NONE) {
                wct.direction = dirFW;
                this.lastForwardWay = i;
                wct.isOnewayLoopForwardPart = true;
            }
            if (dirFW == WayConnectionType.Direction.NONE && dirBW == WayConnectionType.Direction.NONE) {
                wct.linkPrev = false;
                if (RelationSortUtils.isOneway(m)) {
                    wct.isOnewayHead = true;
                    this.lastForwardWay = i - 1;
                    this.lastBackwardWay = i - 1;
                } else {
                    this.lastForwardWay = Integer.MIN_VALUE;
                    this.lastBackwardWay = Integer.MIN_VALUE;
                }
                this.onewayBeginning = true;
            }
            if (dirFW != WayConnectionType.Direction.NONE && dirBW != WayConnectionType.Direction.NONE) {
                if (i + 1 < this.members.size() && this.determineDirection(i, dirFW, i + 1) != WayConnectionType.Direction.NONE) {
                    wct.isOnewayLoopBackwardPart = false;
                    wct.direction = dirFW;
                } else {
                    wct.isOnewayLoopForwardPart = false;
                    wct.direction = dirBW;
                }
                wct.isOnewayTail = true;
            }
        } else {
            this.lastForwardWay = Integer.MIN_VALUE;
            this.lastBackwardWay = Integer.MIN_VALUE;
            if (dirFW == WayConnectionType.Direction.NONE || dirBW == WayConnectionType.Direction.NONE) {
                wct.linkPrev = false;
            }
        }
        return wct;
    }

    private static WayConnectionType.Direction reverse(WayConnectionType.Direction dir) {
        if (dir == WayConnectionType.Direction.FORWARD) {
            return WayConnectionType.Direction.BACKWARD;
        }
        if (dir == WayConnectionType.Direction.BACKWARD) {
            return WayConnectionType.Direction.FORWARD;
        }
        return dir;
    }

    private WayConnectionType.Direction determineDirection(int ref_i, WayConnectionType.Direction ref_direction, int k) {
        return this.determineDirection(ref_i, ref_direction, k, false);
    }

    private WayConnectionType.Direction determineDirection(int ref_i, WayConnectionType.Direction ref_direction, int k, boolean reversed) {
        if (ref_i < 0 || k < 0 || ref_i >= this.members.size() || k >= this.members.size()) {
            return WayConnectionType.Direction.NONE;
        }
        if (ref_direction == WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.NONE;
        }
        RelationMember m_ref = this.members.get(ref_i);
        RelationMember m = this.members.get(k);
        Way way_ref = null;
        Way way = null;
        if (m_ref.isWay()) {
            way_ref = m_ref.getWay();
        }
        if (m.isWay()) {
            way = m.getWay();
        }
        if (way_ref == null || way == null) {
            return WayConnectionType.Direction.NONE;
        }
        List<Node> refNodes = new ArrayList<Node>();
        switch (ref_direction) {
            case FORWARD: {
                refNodes.add(way_ref.lastNode());
                break;
            }
            case BACKWARD: {
                refNodes.add(way_ref.firstNode());
                break;
            }
            case ROUNDABOUT_LEFT: 
            case ROUNDABOUT_RIGHT: {
                refNodes = way_ref.getNodes();
            }
        }
        for (Node n : refNodes) {
            if (n == null) continue;
            if (RelationSortUtils.roundaboutType(this.members.get(k)) != WayConnectionType.Direction.NONE) {
                for (Node nn : way.getNodes()) {
                    if (n != nn) continue;
                    return RelationSortUtils.roundaboutType(this.members.get(k));
                }
                continue;
            }
            if (RelationSortUtils.isOneway(m)) {
                if (n == RelationNodeMap.firstOnewayNode(m) && !reversed) {
                    if (RelationSortUtils.isBackward(m)) {
                        return WayConnectionType.Direction.BACKWARD;
                    }
                    return WayConnectionType.Direction.FORWARD;
                }
                if (n != RelationNodeMap.lastOnewayNode(m) || !reversed) continue;
                if (RelationSortUtils.isBackward(m)) {
                    return WayConnectionType.Direction.FORWARD;
                }
                return WayConnectionType.Direction.BACKWARD;
            }
            if (n == way.firstNode()) {
                return WayConnectionType.Direction.FORWARD;
            }
            if (n != way.lastNode()) continue;
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }
}

