/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.tools.AlphanumComparator;

public class RelationSorter {
    private static final Collection<AdditionalSorter> additionalSorters = new ArrayList<AdditionalSorter>();

    public List<RelationMember> sortMembers(List<RelationMember> relationMembers) {
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        ArrayList<RelationMember> defaultMembers = new ArrayList<RelationMember>(relationMembers.size());
        LinkedHashMap<AdditionalSorter, LinkedList<RelationMember>> customMap = new LinkedHashMap<AdditionalSorter, LinkedList<RelationMember>>();
        for (RelationMember relationMember : relationMembers) {
            boolean wasAdded = false;
            for (AdditionalSorter sorter : additionalSorters) {
                if (!sorter.acceptsMember(relationMember)) continue;
                LinkedList<RelationMember> list = (LinkedList<RelationMember>)customMap.get(sorter);
                if (list == null) {
                    list = new LinkedList<RelationMember>();
                    customMap.put(sorter, list);
                }
                list.add(relationMember);
                wasAdded = true;
                break;
            }
            if (wasAdded) continue;
            defaultMembers.add(relationMember);
        }
        for (Map.Entry entry : customMap.entrySet()) {
            newMembers.addAll(((AdditionalSorter)entry.getKey()).sortMembers((List)entry.getValue()));
        }
        newMembers.addAll(RelationSorter.sortMembersByConnectivity(defaultMembers));
        return newMembers;
    }

    public static List<RelationMember> sortMembersByConnectivity(List<RelationMember> defaultMembers) {
        Integer first;
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        RelationNodeMap map = new RelationNodeMap(defaultMembers);
        ArrayList allGroups = new ArrayList();
        while ((first = map.pop()) != null) {
            LinkedList<Integer> group = new LinkedList<Integer>();
            group.add(first);
            allGroups.add(group);
            Integer next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addLast(next);
            }
            next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addFirst(next);
            }
        }
        for (LinkedList linkedList : allGroups) {
            for (Integer p : linkedList) {
                newMembers.add(defaultMembers.get(p));
            }
        }
        for (Integer n : map.getNotSortableMembers()) {
            newMembers.add(defaultMembers.get(n));
        }
        return newMembers;
    }

    static {
        additionalSorters.add(new AssociatedStreetRoleStreetSorter());
        additionalSorters.add(new AssociatedStreetRoleAddressHouseSorter());
    }

    private static class AssociatedStreetRoleAddressHouseSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleAddressHouseSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember m) {
            return "address".equals(m.getRole()) || "house".equals(m.getRole());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            Collections.sort(list, new Comparator<RelationMember>(){

                @Override
                public int compare(RelationMember a, RelationMember b) {
                    int houseNumber = AlphanumComparator.getInstance().compare(a.getMember().get("addr:housenumber"), b.getMember().get("addr:housenumber"));
                    if (houseNumber != 0) {
                        return houseNumber;
                    }
                    String aDisplayName = a.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                    String bDisplayName = b.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                    return AlphanumComparator.getInstance().compare(aDisplayName, bDisplayName);
                }
            });
            return list;
        }
    }

    private static class AssociatedStreetRoleStreetSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleStreetSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember m) {
            return "street".equals(m.getRole());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            return RelationSorter.sortMembersByConnectivity(list);
        }
    }

    private static interface AdditionalSorter {
        public boolean acceptsMember(RelationMember var1);

        public List<RelationMember> sortMembers(List<RelationMember> var1);
    }
}

