/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

final class RelationSortUtils {
    static WayConnectionType.Direction roundaboutType(RelationMember member) {
        if (member == null || !member.isWay()) {
            return WayConnectionType.Direction.NONE;
        }
        Way w = member.getWay();
        return RelationSortUtils.roundaboutType(w);
    }

    static WayConnectionType.Direction roundaboutType(Way w) {
        if (w != null && "roundabout".equals(w.get("junction")) && w.getNodesCount() < 200 && w.getNodesCount() > 2 && w.getNode(0) != null && w.getNode(1) != null && w.getNode(2) != null && w.firstNode() == w.lastNode()) {
            EastNorth en1 = w.getNode(0).getEastNorth();
            EastNorth en2 = w.getNode(1).getEastNorth();
            EastNorth en3 = w.getNode(2).getEastNorth();
            if (en1 != null && en2 != null && en3 != null) {
                en1 = en1.sub(en2);
                en2 = en2.sub(en3);
                return en1.north() * en2.east() - en2.north() * en1.east() > 0.0 ? WayConnectionType.Direction.ROUNDABOUT_LEFT : WayConnectionType.Direction.ROUNDABOUT_RIGHT;
            }
        }
        return WayConnectionType.Direction.NONE;
    }

    static boolean isBackward(RelationMember member) {
        return "backward".equals(member.getRole());
    }

    static boolean isForward(RelationMember member) {
        return "forward".equals(member.getRole());
    }

    static boolean isOneway(RelationMember member) {
        return RelationSortUtils.isForward(member) || RelationSortUtils.isBackward(member);
    }
}

