/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;

public class SelectionTable
extends JTable {
    private SelectionTableModel model;
    private MemberTableModel memberTableModel;

    protected void build() {
        this.setSelectionMode(0);
        this.addMouseListener(new DoubleClickAdapter());
    }

    public SelectionTable(SelectionTableModel model, SelectionTableColumnModel columnModel) {
        super(model, columnModel);
        this.model = model;
        this.build();
    }

    public void setMemberTableModel(MemberTableModel memberTableModel) {
        this.memberTableModel = memberTableModel;
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (!SwingUtilities.isLeftMouseButton(evt) || evt.getClickCount() <= 1) {
                return;
            }
            int row = SelectionTable.this.rowAtPoint(evt.getPoint());
            OsmPrimitive primitive = SelectionTable.this.model.getPrimitive(row);
            SelectionTable.this.memberTableModel.selectMembersReferringTo(Collections.singleton(primitive));
        }
    }
}

