/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private ImageIcon icon = ImageProvider.get("data", "relation");

    public RelationTreeCellRenderer() {
        this.setOpaque(true);
    }

    protected void renderIcon() {
        this.setIcon(this.icon);
    }

    protected void renderValue(Relation relation) {
        this.setText(relation.getDisplayName(DefaultNameFormatter.getInstance()));
    }

    protected void renderBackground(boolean selected) {
        Color bgColor = Color.WHITE;
        if (selected) {
            bgColor = BGCOLOR_SELECTED;
        }
        this.setBackground(bgColor);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!tree.isRootVisible() && tree.getModel().getRoot() == value) {
            return this;
        }
        this.renderIcon();
        this.renderValue((Relation)value);
        this.renderBackground(selected);
        return this;
    }
}

