/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class RelationDialogManager
extends WindowAdapter
implements MapView.LayerChangeListener {
    static RelationDialogManager relationDialogManager;
    private final Map<DialogContext, RelationEditor> openDialogs = new HashMap<DialogContext, RelationEditor>();

    public static RelationDialogManager getRelationDialogManager() {
        if (relationDialogManager == null) {
            relationDialogManager = new RelationDialogManager();
            MapView.addLayerChangeListener(relationDialogManager);
        }
        return relationDialogManager;
    }

    public void register(OsmDataLayer layer, Relation relation, RelationEditor editor) {
        if (relation == null) {
            relation = new Relation();
        }
        DialogContext context = new DialogContext(layer, relation);
        this.openDialogs.put(context, editor);
        editor.addWindowListener(this);
    }

    public void updateContext(OsmDataLayer layer, Relation relation, RelationEditor editor) {
        for (DialogContext context : this.openDialogs.keySet()) {
            if (this.openDialogs.get(context) != editor) continue;
            this.openDialogs.remove(context);
            break;
        }
        DialogContext context = new DialogContext(layer, relation);
        this.openDialogs.put(context, editor);
    }

    public void close(OsmDataLayer layer, Relation relation) {
        DialogContext context = new DialogContext(layer, relation);
        RelationEditor editor = this.openDialogs.get(context);
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public boolean isOpenInEditor(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return false;
        }
        DialogContext context = new DialogContext(layer, relation);
        return this.openDialogs.keySet().contains(context);
    }

    public RelationEditor getEditorForRelation(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return null;
        }
        DialogContext context = new DialogContext(layer, relation);
        return this.openDialogs.get(context);
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (!(oldLayer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer dataLayer = (OsmDataLayer)oldLayer;
        Iterator<Map.Entry<DialogContext, RelationEditor>> it = this.openDialogs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<DialogContext, RelationEditor> entry = it.next();
            if (!entry.getKey().matchesLayer(dataLayer)) continue;
            RelationEditor editor = entry.getValue();
            it.remove();
            editor.setVisible(false);
            editor.dispose();
        }
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        RelationEditor editor = (RelationEditor)e.getWindow();
        DialogContext context = null;
        for (DialogContext c : this.openDialogs.keySet()) {
            if (!editor.equals(this.openDialogs.get(c))) continue;
            context = c;
            break;
        }
        if (context != null) {
            this.openDialogs.remove(context);
        }
    }

    protected boolean hasEditorWithCloseUpperLeftCorner(Point p, RelationEditor thisEditor) {
        for (RelationEditor editor : this.openDialogs.values()) {
            if (editor == thisEditor) continue;
            Point corner = editor.getLocation();
            if (p.x < corner.x - 5 || corner.x + 5 < p.x || p.y < corner.y - 5 || corner.y + 5 < p.y) continue;
            return true;
        }
        return false;
    }

    public void positionOnScreen(RelationEditor editor) {
        if (editor == null) {
            return;
        }
        if (!this.openDialogs.isEmpty()) {
            Point corner = editor.getLocation();
            while (this.hasEditorWithCloseUpperLeftCorner(corner, editor)) {
                corner.x += 20;
                corner.y += 20;
            }
            editor.setLocation(corner);
        }
    }

    private static class DialogContext {
        public final Relation relation;
        public final OsmDataLayer layer;

        public DialogContext(OsmDataLayer layer, Relation relation) {
            this.layer = layer;
            this.relation = relation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
            result = 31 * result + (this.relation == null ? 0 : this.relation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DialogContext other = (DialogContext)obj;
            if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
                return false;
            }
            return !(this.relation == null ? other.relation != null : !this.relation.equals(other.relation));
        }

        public boolean matchesLayer(OsmDataLayer layer) {
            if (layer == null) {
                return false;
            }
            return this.layer.equals(layer);
        }

        public String toString() {
            return "[Context: layer=" + this.layer.getName() + ",relation=" + this.relation.getId() + "]";
        }
    }
}

