/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ParentRelationLoadingTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private DataSet referrers;
    private boolean full;
    private OsmDataLayer layer;
    private Relation child;
    private List<Relation> parents;
    private Runnable continuation;

    public ParentRelationLoadingTask(Relation child, OsmDataLayer layer, boolean full, PleaseWaitProgressMonitor monitor) {
        super(I18n.tr("Download referring relations", new Object[0]), monitor, false);
        CheckParameterUtil.ensureValidPrimitiveId(child, "child");
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.referrers = null;
        this.layer = layer;
        this.parents = new ArrayList<Relation>();
        this.child = child;
        this.full = full;
    }

    public void setContinuation(Runnable continuation) {
        this.continuation = continuation;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean hasError() {
        return this.lastException != null;
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public List<Relation> getParents() {
        return this.parents;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        OsmApi.getOsmApi().cancel();
    }

    protected void showLastException() {
        String msg = this.lastException.getMessage();
        if (msg == null) {
            msg = this.lastException.toString();
        }
        JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Error", new Object[0]), 0);
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            this.showLastException();
            return;
        }
        this.parents.clear();
        for (Relation parent : this.referrers.getRelations()) {
            this.parents.add((Relation)this.getLayer().data.getPrimitiveById(parent));
        }
        if (this.continuation != null) {
            this.continuation.run();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.progressMonitor.indeterminateSubTask(null);
            OsmServerBackreferenceReader reader = new OsmServerBackreferenceReader(this.child, this.full);
            this.referrers = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(1, false));
            if (this.referrers != null) {
                DataSetMerger visitor = new DataSetMerger(this.getLayer().data, this.referrers);
                visitor.merge();
                for (DataSource src : this.referrers.dataSources) {
                    this.getLayer().data.dataSources.add(src);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ParentRelationLoadingTask.this.getLayer().onPostDownloadFromServer();
                    }
                });
                if (visitor.getConflicts().isEmpty()) {
                    return;
                }
                this.getLayer().getConflicts().add(visitor.getConflicts());
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", visitor.getConflicts().size()), I18n.tr("Warning", new Object[0]), 2);
            }
        }
        catch (Exception e) {
            if (this.canceled) {
                Main.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                return;
            }
            this.lastException = e;
        }
    }
}

