/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.PresetHandler;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTableModel;

public class MemberTableModel
extends AbstractTableModel
implements TableModelListener,
SelectionChangedListener,
DataSetListener,
OsmPrimitivesTableModel {
    private List<RelationMember> members;
    private List<WayConnectionType> connectionType = null;
    private DefaultListSelectionModel listSelectionModel;
    private final CopyOnWriteArrayList<IMemberModelListener> listeners;
    private final OsmDataLayer layer;
    private final PresetHandler presetHandler;
    private final WayConnectionTypeCalculator wayConnectionTypeCalculator = new WayConnectionTypeCalculator();
    private final RelationSorter relationSorter = new RelationSorter();

    public MemberTableModel(OsmDataLayer layer, PresetHandler presetHandler) {
        this.members = new ArrayList<RelationMember>();
        this.listeners = new CopyOnWriteArrayList();
        this.layer = layer;
        this.presetHandler = presetHandler;
        this.addTableModelListener(this);
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public void register() {
        DataSet.addSelectionListener(this);
        this.getLayer().data.addDataSetListener(this);
    }

    public void unregister() {
        DataSet.removeSelectionListener(this);
        this.getLayer().data.removeDataSetListener(this);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (Main.main.getEditLayer() != this.layer) {
            return;
        }
        Collection<RelationMember> sel = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(sel);
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        Collection<RelationMember> sel = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(sel);
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        Collection<RelationMember> sel = this.getSelectedMembers();
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i).getMember() != event.getPrimitive()) continue;
            this.fireTableCellUpdated(i, 1);
        }
        this.setSelectedMembers(sel);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void addMemberModelListener(IMemberModelListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeMemberModelListener(IMemberModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMakeMemberVisible(int index) {
        for (IMemberModelListener listener : this.listeners) {
            listener.makeMemberVisible(index);
        }
    }

    public void populate(Relation relation) {
        this.members.clear();
        if (relation != null) {
            this.members.addAll(new Relation(relation).getMembers());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.members.get(rowIndex).getRole();
            }
            case 1: {
                return this.members.get(rowIndex).getMember();
            }
            case 2: {
                return this.getWayConnection(rowIndex);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.members.size()) {
            return;
        }
        RelationMember member = this.members.get(rowIndex);
        RelationMember newMember = new RelationMember(value.toString(), member.getMember());
        this.members.remove(rowIndex);
        this.members.add(rowIndex, newMember);
    }

    @Override
    public OsmPrimitive getReferredPrimitive(int idx) {
        return this.members.get(idx).getMember();
    }

    public void moveUp(int[] selectedRows) {
        if (!this.canMoveUp(selectedRows)) {
            return;
        }
        for (int row : selectedRows) {
            RelationMember member1 = this.members.get(row);
            RelationMember member2 = this.members.get(row - 1);
            this.members.set(row, member2);
            this.members.set(row - 1, member1);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedRows) {
            this.getSelectionModel().addSelectionInterval(--row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(selectedRows[0] - 1);
    }

    public void moveDown(int[] selectedRows) {
        if (!this.canMoveDown(selectedRows)) {
            return;
        }
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int row = selectedRows[i];
            RelationMember member1 = this.members.get(row);
            RelationMember member2 = this.members.get(row + 1);
            this.members.set(row, member2);
            this.members.set(row + 1, member1);
        }
        this.fireTableDataChanged();
        this.getSelectionModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedRows) {
            this.getSelectionModel().addSelectionInterval(++row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(selectedRows[0] + 1);
    }

    public void remove(int[] selectedRows) {
        if (!this.canRemove(selectedRows)) {
            return;
        }
        int offset = 0;
        for (int row : selectedRows) {
            if (this.members.size() <= (row -= offset)) continue;
            this.members.remove(row);
            ++offset;
        }
        this.fireTableDataChanged();
    }

    public boolean canMoveUp(int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        Arrays.sort(rows);
        return rows[0] > 0 && this.members.size() > 0;
    }

    public boolean canMoveDown(int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        Arrays.sort(rows);
        return this.members.size() > 0 && rows[rows.length - 1] < this.members.size() - 1;
    }

    public boolean canRemove(int[] rows) {
        return rows != null && rows.length != 0;
    }

    public DefaultListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new DefaultListSelectionModel();
            this.listSelectionModel.setSelectionMode(2);
        }
        return this.listSelectionModel;
    }

    public void removeMembersReferringTo(List<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        Iterator<RelationMember> it = this.members.iterator();
        while (it.hasNext()) {
            RelationMember member = it.next();
            if (!primitives.contains(member.getMember())) continue;
            it.remove();
        }
        this.fireTableDataChanged();
    }

    public void applyToRelation(Relation relation) {
        relation.setMembers(this.members);
    }

    public boolean hasSameMembersAs(Relation relation) {
        if (relation == null) {
            return false;
        }
        if (relation.getMembersCount() != this.members.size()) {
            return false;
        }
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (relation.getMember(i).equals(this.members.get(i))) continue;
            return false;
        }
        return true;
    }

    public Set<OsmPrimitive> getIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember member : this.members) {
            if (!member.getMember().isIncomplete()) continue;
            ret.add(member.getMember());
        }
        return ret;
    }

    public Set<OsmPrimitive> getSelectedIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember member : this.getSelectedMembers()) {
            if (!member.getMember().isIncomplete()) continue;
            ret.add(member.getMember());
        }
        return ret;
    }

    public boolean hasIncompleteMembers() {
        for (RelationMember member : this.members) {
            if (!member.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIncompleteSelectedMembers() {
        for (RelationMember member : this.getSelectedMembers()) {
            if (!member.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            selectedIndices.add(i);
        }
        return selectedIndices;
    }

    private void addMembersAtIndex(List<? extends OsmPrimitive> primitives, int index) {
        Collection<TaggingPreset> presets = TaggingPreset.getMatchingPresets(EnumSet.of(TaggingPresetType.RELATION), this.presetHandler.getSelection().iterator().next().getKeys(), false);
        if (primitives == null) {
            return;
        }
        int idx = index;
        for (OsmPrimitive osmPrimitive : primitives) {
            TreeSet<String> potentialRoles = new TreeSet<String>();
            for (TaggingPreset tp : presets) {
                String suggestedRole = tp.suggestRoleForOsmPrimitive(osmPrimitive);
                if (suggestedRole == null) continue;
                potentialRoles.add(suggestedRole);
            }
            String role = potentialRoles.isEmpty() ? null : (String)potentialRoles.iterator().next();
            RelationMember member = new RelationMember(role == null ? "" : role, osmPrimitive);
            this.members.add(idx++, member);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().addSelectionInterval(index, index + primitives.size() - 1);
        this.fireMakeMemberVisible(index);
    }

    public void addMembersAtBeginning(List<? extends OsmPrimitive> primitives) {
        this.addMembersAtIndex(primitives, 0);
    }

    public void addMembersAtEnd(List<? extends OsmPrimitive> primitives) {
        this.addMembersAtIndex(primitives, this.members.size());
    }

    public void addMembersBeforeIdx(List<? extends OsmPrimitive> primitives, int idx) {
        this.addMembersAtIndex(primitives, idx);
    }

    public void addMembersAfterIdx(List<? extends OsmPrimitive> primitives, int idx) {
        this.addMembersAtIndex(primitives, idx + 1);
    }

    public int getNumMembersWithPrimitive(OsmPrimitive primitive) {
        int count = 0;
        for (RelationMember member : this.members) {
            if (!member.getMember().equals(primitive)) continue;
            ++count;
        }
        return count;
    }

    public void updateRole(int[] idx, String role) {
        if (idx == null || idx.length == 0) {
            return;
        }
        for (int row : idx) {
            if (row >= this.members.size()) continue;
            RelationMember oldMember = this.members.get(row);
            RelationMember newMember = new RelationMember(role, oldMember.getMember());
            this.members.remove(row);
            this.members.add(row, newMember);
        }
        this.fireTableDataChanged();
        for (int row : idx) {
            this.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    public Collection<RelationMember> getSelectedMembers() {
        ArrayList<RelationMember> selectedMembers = new ArrayList<RelationMember>();
        for (int i : this.getSelectedIndices()) {
            selectedMembers.add(this.members.get(i));
        }
        return selectedMembers;
    }

    public Collection<OsmPrimitive> getSelectedChildPrimitives() {
        ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
        for (RelationMember m : this.getSelectedMembers()) {
            ret.add(m.getMember());
        }
        return ret;
    }

    public Set<OsmPrimitive> getChildPrimitives(Collection<? extends OsmPrimitive> referenceSet) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        if (referenceSet == null) {
            return null;
        }
        for (RelationMember m : this.members) {
            if (!referenceSet.contains(m.getMember())) continue;
            ret.add(m.getMember());
        }
        return ret;
    }

    public void setSelectedMembers(Collection<RelationMember> selectedMembers) {
        if (selectedMembers == null || selectedMembers.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        HashSet<Integer> selectedIndices = new HashSet<Integer>();
        for (RelationMember member : selectedMembers) {
            for (int idx = 0; idx < this.members.size(); ++idx) {
                if (!member.equals(this.members.get(idx))) continue;
                selectedIndices.add(idx);
            }
        }
        this.setSelectedMembersIdx(selectedIndices);
    }

    public void setSelectedMembersIdx(Collection<Integer> selectedIndices) {
        if (selectedIndices == null || selectedIndices.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedIndices) {
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (!selectedIndices.isEmpty()) {
            this.fireMakeMemberVisible(Collections.min(selectedIndices));
        }
    }

    public boolean isEditableRelation(int index) {
        if (index < 0 || index >= this.members.size()) {
            return false;
        }
        RelationMember member = this.members.get(index);
        if (!member.isRelation()) {
            return false;
        }
        Relation r = member.getRelation();
        return !r.isIncomplete();
    }

    public static boolean hasMembersReferringTo(Collection<RelationMember> members, Collection<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return false;
        }
        HashSet<OsmPrimitive> referrers = new HashSet<OsmPrimitive>();
        for (RelationMember member : members) {
            referrers.add(member.getMember());
        }
        for (OsmPrimitive referred : primitives) {
            if (!referrers.contains(referred)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMembersReferringTo(Collection<OsmPrimitive> primitives) {
        return MemberTableModel.hasMembersReferringTo(this.members, primitives);
    }

    public void selectMembersReferringTo(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember m = this.members.get(i);
            if (!primitives.contains(m.getMember())) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (!this.getSelectedIndices().isEmpty()) {
            this.fireMakeMemberVisible(this.getSelectedIndices().get(0));
        }
    }

    public boolean isInJosmSelection(OsmPrimitive primitive) {
        return this.layer.data.isSelected(primitive);
    }

    protected boolean isActiveLayer() {
        if (!Main.isDisplayingMapView()) {
            return false;
        }
        return Main.map.mapView.getActiveLayer() == this.layer;
    }

    void sort() {
        List<RelationMember> newMembers;
        ArrayList<RelationMember> selectedMembers = new ArrayList<RelationMember>(this.getSelectedMembers());
        List<RelationMember> sortedMembers = null;
        if (selectedMembers.size() <= 1) {
            sortedMembers = newMembers = this.relationSorter.sortMembers(this.members);
        } else {
            sortedMembers = this.relationSorter.sortMembers(selectedMembers);
            List<Integer> selectedIndices = this.getSelectedIndices();
            newMembers = new ArrayList<RelationMember>();
            boolean inserted = false;
            for (int i = 0; i < this.members.size(); ++i) {
                if (selectedIndices.contains(i)) {
                    if (inserted) continue;
                    newMembers.addAll(sortedMembers);
                    inserted = true;
                    continue;
                }
                newMembers.add(this.members.get(i));
            }
        }
        if (this.members.size() != newMembers.size()) {
            throw new AssertionError();
        }
        this.members.clear();
        this.members.addAll(newMembers);
        this.fireTableDataChanged();
        this.setSelectedMembers(sortedMembers);
    }

    WayConnectionType getWayConnection(int i) {
        if (this.connectionType == null) {
            this.connectionType = this.wayConnectionTypeCalculator.updateLinks(this.members);
        }
        return this.connectionType.get(i);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.connectionType = null;
    }

    void reverse() {
        List<Integer> selectedIndices = this.getSelectedIndices();
        List<Integer> selectedIndicesReversed = this.getSelectedIndices();
        if (selectedIndices.size() <= 1) {
            Collections.reverse(this.members);
            this.fireTableDataChanged();
            this.setSelectedMembers(this.members);
        } else {
            Collections.reverse(selectedIndicesReversed);
            ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>(this.members);
            for (int i = 0; i < selectedIndices.size(); ++i) {
                newMembers.set(selectedIndices.get(i), this.members.get(selectedIndicesReversed.get(i)));
            }
            if (this.members.size() != newMembers.size()) {
                throw new AssertionError();
            }
            this.members.clear();
            this.members.addAll(newMembers);
            this.fireTableDataChanged();
            this.setSelectedMembersIdx(selectedIndices);
        }
    }
}

