/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ZoomToAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.MemberRoleCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTable;
import org.openstreetmap.josm.tools.I18n;

public class MemberTable
extends OsmPrimitivesTable
implements IMemberModelListener {
    private ZoomToGapAction zoomToGap;
    private HighlightHelper highlightHelper = new HighlightHelper();
    private boolean highlightEnabled;
    ListSelectionListener highlighterListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (Main.isDisplayingMapView()) {
                Collection<RelationMember> sel = MemberTable.this.getMemberTableModel().getSelectedMembers();
                final ArrayList<OsmPrimitive> toHighlight = new ArrayList<OsmPrimitive>();
                for (RelationMember r : sel) {
                    if (!r.getMember().isUsable()) continue;
                    toHighlight.add(r.getMember());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MemberTable.this.highlightHelper.highlightOnly(toHighlight)) {
                            Main.map.mapView.repaint();
                        }
                    }
                });
            }
        }
    };

    public MemberTable(OsmDataLayer layer, Relation relation, MemberTableModel model) {
        super(model, (TableColumnModel)new MemberTableColumnModel(layer.data, relation), (ListSelectionModel)model.getSelectionModel());
        this.setLayer(layer);
        model.addMemberModelListener(this);
        this.init();
    }

    protected void init() {
        MemberRoleCellEditor ce = (MemberRoleCellEditor)this.getColumnModel().getColumn(0).getCellEditor();
        this.setRowHeight(ce.getEditor().getPreferredSize().height);
        this.setAutoResizeMode(4);
        this.setSelectionMode(2);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.initHighlighting();
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
    }

    @Override
    protected ZoomToAction buildZoomToAction() {
        return new ZoomToAction(this);
    }

    @Override
    protected JPopupMenu buildPopupMenu() {
        JPopupMenu menu = super.buildPopupMenu();
        this.zoomToGap = new ZoomToGapAction();
        MapView.addLayerChangeListener(this.zoomToGap);
        this.getSelectionModel().addListSelectionListener(this.zoomToGap);
        menu.add(this.zoomToGap);
        menu.addSeparator();
        menu.add(new SelectPreviousGapAction());
        menu.add(new SelectNextGapAction());
        return menu;
    }

    @Override
    public Dimension getPreferredSize() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
        }
        if (c != null) {
            Dimension d = super.getPreferredSize();
            d.width = c.getSize().width;
            return d;
        }
        return super.getPreferredSize();
    }

    @Override
    public void makeMemberVisible(int index) {
        this.scrollRectToVisible(this.getCellRect(index, 0, true));
    }

    private void initHighlighting() {
        this.highlightEnabled = Main.pref.getBoolean("draw.target-highlight", true);
        if (!this.highlightEnabled) {
            return;
        }
        this.getMemberTableModel().getSelectionModel().addListSelectionListener(this.highlighterListener);
        if (Main.isDisplayingMapView()) {
            HighlightHelper.clearAllHighlighted();
            Main.map.mapView.repaint();
        }
    }

    @Override
    public void unlinkAsListener() {
        super.unlinkAsListener();
        MapView.removeLayerChangeListener(this.zoomToGap);
    }

    public void stopHighlighting() {
        if (this.highlighterListener == null) {
            return;
        }
        if (!this.highlightEnabled) {
            return;
        }
        this.getMemberTableModel().getSelectionModel().removeListSelectionListener(this.highlighterListener);
        this.highlighterListener = null;
        if (Main.isDisplayingMapView()) {
            HighlightHelper.clearAllHighlighted();
            Main.map.mapView.repaint();
        }
    }

    protected MemberTableModel getMemberTableModel() {
        return (MemberTableModel)this.getModel();
    }

    private class ZoomToGapAction
    extends AbstractAction
    implements ListSelectionListener,
    MapView.LayerChangeListener {
        private final Collection<WayConnectionType.Direction> connectionTypesOfInterest = Arrays.asList(WayConnectionType.Direction.FORWARD, WayConnectionType.Direction.BACKWARD);

        public ZoomToGapAction() {
            this.putValue("Name", I18n.tr("Zoom to Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to the gap in the way sequence", new Object[0]));
            this.updateEnabledState();
        }

        private WayConnectionType getConnectionType() {
            return MemberTable.this.getMemberTableModel().getWayConnection(MemberTable.this.getSelectedRows()[0]);
        }

        private boolean hasGap() {
            WayConnectionType connectionType = this.getConnectionType();
            return this.connectionTypesOfInterest.contains((Object)connectionType.direction) && (!connectionType.linkNext || !connectionType.linkPrev);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WayConnectionType connectionType = this.getConnectionType();
            Way way = (Way)MemberTable.this.getMemberTableModel().getReferredPrimitive(MemberTable.this.getSelectedRows()[0]);
            if (!connectionType.linkPrev) {
                MemberTable.this.getLayer().data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)connectionType.direction) ? way.firstNode() : way.lastNode());
                AutoScaleAction.autoScale("selection");
            } else if (!connectionType.linkNext) {
                MemberTable.this.getLayer().data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)connectionType.direction) ? way.lastNode() : way.firstNode());
                AutoScaleAction.autoScale("selection");
            }
        }

        private void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() == MemberTable.this.getLayer() && MemberTable.this.getSelectedRowCount() == 1 && this.hasGap());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledState();
        }

        @Override
        public void layerAdded(Layer newLayer) {
            this.updateEnabledState();
        }

        @Override
        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledState();
        }
    }

    private class SelectNextGapAction
    extends AbstractAction {
        public SelectNextGapAction() {
            this.putValue("Name", I18n.tr("Select next Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select the next relation member which gives rise to a gap", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            for (i = MemberTable.this.getSelectedRow() + 1; i < MemberTable.this.getRowCount() && MemberTable.this.getMemberTableModel().getWayConnection((int)i).linkNext; ++i) {
            }
            if (i < MemberTable.this.getRowCount()) {
                MemberTable.this.getSelectionModel().setSelectionInterval(i, i);
            }
        }
    }

    private class SelectPreviousGapAction
    extends AbstractAction {
        public SelectPreviousGapAction() {
            this.putValue("Name", I18n.tr("Select previous Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select the previous relation member which gives rise to a gap", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            for (i = MemberTable.this.getSelectedRow() - 1; i >= 0 && MemberTable.this.getMemberTableModel().getWayConnection((int)i).linkPrev; --i) {
            }
            if (i >= 0) {
                MemberTable.this.getSelectionModel().setSelectionInterval(i, i);
            }
        }
    }

    private class SelectPreviousColumnCellAction
    extends AbstractAction {
        private SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int col = MemberTable.this.getSelectedColumn();
            int row = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if ((col > 0 || row > 0) && row > 0) {
                col = 0;
                --row;
            }
            MemberTable.this.changeSelection(row, col, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = MemberTable.this.getSelectedColumn();
            int row = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if (col == 0 && row < MemberTable.this.getRowCount() - 1) {
                ++row;
            } else if (row < MemberTable.this.getRowCount() - 1) {
                col = 0;
                ++row;
            } else {
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusNextComponent();
                return;
            }
            MemberTable.this.changeSelection(row, col, false, false);
        }
    }
}

