/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.io.IOException;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadRelationTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private Collection<Relation> relations;
    private OsmDataLayer layer;
    private OsmServerObjectReader objectReader;

    public DownloadRelationTask(Collection<Relation> relations, OsmDataLayer layer) throws IllegalArgumentException {
        super(I18n.tr("Download relations", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(relations, "relations");
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.relations = relations;
        this.layer = layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadRelationTask downloadRelationTask = this;
        synchronized (downloadRelationTask) {
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            final DataSet allDownloads = new DataSet();
            int i = 0;
            this.getProgressMonitor().setTicksCount(this.relations.size());
            for (Relation relation : this.relations) {
                this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}): Downloading relation ''{2}''...", ++i, this.relations.size(), relation.getDisplayName(DefaultNameFormatter.getInstance())));
                DownloadRelationTask downloadRelationTask = this;
                synchronized (downloadRelationTask) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = new OsmServerObjectReader(relation.getPrimitiveId(), true);
                }
                DataSet dataSet = this.objectReader.parseOsm(this.getProgressMonitor().createSubTaskMonitor(0, false));
                if (dataSet == null) {
                    return;
                }
                DownloadRelationTask downloadRelationTask2 = this;
                synchronized (downloadRelationTask2) {
                    if (this.canceled) {
                        return;
                    }
                    this.objectReader = null;
                }
                DataSetMerger merger = new DataSetMerger(allDownloads, dataSet);
                merger.merge();
                this.getProgressMonitor().worked(1);
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadRelationTask.this.layer.mergeFrom(allDownloads);
                    DownloadRelationTask.this.layer.onPostDownloadFromServer();
                    Main.map.repaint();
                }
            });
        }
        catch (Exception e) {
            if (this.canceled) {
                Main.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                return;
            }
            this.lastException = e;
        }
    }
}

