/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Dialog;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadRelationMemberTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private final Set<Relation> parents = new HashSet<Relation>();
    private Collection<OsmPrimitive> children;
    private OsmDataLayer curLayer;
    private MultiFetchServerObjectReader objectReader;

    public DownloadRelationMemberTask(Relation parent, Collection<OsmPrimitive> children, OsmDataLayer curLayer, Dialog dialog) {
        super(I18n.tr("Download relation members", new Object[0]), new PleaseWaitProgressMonitor(dialog), false);
        if (parent != null) {
            this.parents.add(parent);
        }
        this.children = children;
        this.curLayer = curLayer;
    }

    public DownloadRelationMemberTask(Relation parent, Collection<OsmPrimitive> children, OsmDataLayer curLayer) {
        super(I18n.tr("Download relation members", new Object[0]), false);
        if (parent != null) {
            this.parents.add(parent);
        }
        this.children = children;
        this.curLayer = curLayer;
    }

    public DownloadRelationMemberTask(Collection<Relation> parents, Collection<OsmPrimitive> children, OsmDataLayer curLayer) {
        super(I18n.tr("Download relation members", new Object[0]), false);
        this.parents.addAll(parents);
        this.children = children;
        this.curLayer = curLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadRelationMemberTask downloadRelationMemberTask = this;
        synchronized (downloadRelationMemberTask) {
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        Main.map.repaint();
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }

    protected String buildDownloadFeedbackMessage() {
        if (this.parents.isEmpty()) {
            return I18n.trn("Downloading {0} incomplete object", "Downloading {0} incomplete objects", this.children.size(), this.children.size());
        }
        if (this.parents.size() == 1) {
            Relation parent = this.parents.iterator().next();
            return I18n.trn("Downloading {0} incomplete child of relation ''{1}''", "Downloading {0} incomplete children of relation ''{1}''", this.children.size(), this.children.size(), parent.getDisplayName(DefaultNameFormatter.getInstance()));
        }
        return I18n.trn("Downloading {0} incomplete child of {1} parent relations", "Downloading {0} incomplete children of {1} parent relations", this.children.size(), this.children.size(), this.parents.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            DownloadRelationMemberTask downloadRelationMemberTask = this;
            synchronized (downloadRelationMemberTask) {
                if (this.canceled) {
                    return;
                }
                this.objectReader = new MultiFetchServerObjectReader();
            }
            this.objectReader.append(this.children);
            this.progressMonitor.indeterminateSubTask(this.buildDownloadFeedbackMessage());
            final DataSet dataSet = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            if (dataSet == null) {
                return;
            }
            dataSet.deleteInvisible();
            DownloadRelationMemberTask downloadRelationMemberTask2 = this;
            synchronized (downloadRelationMemberTask2) {
                if (this.canceled) {
                    return;
                }
                this.objectReader = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadRelationMemberTask.this.curLayer.mergeFrom(dataSet);
                    DownloadRelationMemberTask.this.curLayer.onPostDownloadFromServer();
                }
            });
        }
        catch (Exception e) {
            if (this.canceled) {
                Main.warn(I18n.tr("Ignoring exception because task was canceled. Exception: {0}", e.toString()));
                return;
            }
            this.lastException = e;
        }
    }
}

