/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

class TagEditHelper {
    private final DefaultTableModel tagData;
    private final Map<String, Map<String, Integer>> valueCount;
    Collection<OsmPrimitive> sel;
    private String changedKey;
    private String objKey;
    Comparator<AutoCompletionListItem> defaultACItemComparator = new Comparator<AutoCompletionListItem>(){

        @Override
        public int compare(AutoCompletionListItem o1, AutoCompletionListItem o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
        }
    };
    private String lastAddKey = null;
    private String lastAddValue = null;
    public static final int DEFAULT_LRU_TAGS_NUMBER = 5;
    public static final int MAX_LRU_TAGS_NUMBER = 30;
    private final Map<Tag, Void> recentTags = new LinkedHashMap<Tag, Void>(31, 1.1f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Tag, Void> eldest) {
            return this.size() > 30;
        }
    };
    public static final BooleanProperty PROPERTY_FIX_TAG_LOCALE = new BooleanProperty("properties.fix-tag-combobox-locale", false);
    public static final BooleanProperty PROPERTY_REMEMBER_TAGS = new BooleanProperty("properties.remember-recently-added-tags", true);
    public static final IntegerProperty PROPERTY_RECENT_TAGS_NUMBER = new IntegerProperty("properties.recently-added-tags", 5);

    TagEditHelper(DefaultTableModel propertyData, Map<String, Map<String, Integer>> valueCount) {
        this.tagData = propertyData;
        this.valueCount = valueCount;
    }

    public void addTag() {
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        AddTagsDialog addDialog = new AddTagsDialog();
        addDialog.showDialog();
        addDialog.destroyActions();
        if (addDialog.getValue() == 1) {
            addDialog.performTagAdding();
        } else {
            addDialog.undoAllTagsAdding();
        }
    }

    public void editTag(int row, boolean focusOnKey) {
        String key;
        this.changedKey = null;
        this.sel = Main.main.getInProgressSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        this.objKey = key = this.tagData.getValueAt(row, 0).toString();
        EditTagDialog editDialog = new EditTagDialog(key, row, (Map)this.tagData.getValueAt(row, 1), focusOnKey);
        editDialog.showDialog();
        if (editDialog.getValue() != 1) {
            return;
        }
        editDialog.performTagEdit();
    }

    public String getChangedKey() {
        return this.changedKey;
    }

    public void resetChangedKey() {
        this.changedKey = null;
    }

    private static List<String> getAutocompletionKeys(String key) {
        if ("name".equals(key) || "addr:street".equals(key)) {
            return Arrays.asList("addr:street", "name");
        }
        return Arrays.asList(key);
    }

    public void loadTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && this.recentTags.isEmpty()) {
            this.recentTags.clear();
            Collection<String> c = Main.pref.getCollection("properties.recent-tags");
            Iterator<String> it = c.iterator();
            while (it.hasNext()) {
                String key = it.next();
                String value = it.next();
                this.recentTags.put(new Tag(key, value), null);
            }
        }
    }

    public void saveTagsIfNeeded() {
        if (PROPERTY_REMEMBER_TAGS.get().booleanValue() && !this.recentTags.isEmpty()) {
            ArrayList<String> c = new ArrayList<String>(this.recentTags.size() * 2);
            for (Tag t : this.recentTags.keySet()) {
                c.add(t.getKey());
                c.add(t.getValue());
            }
            Main.pref.putCollection("properties.recent-tags", c);
        }
    }

    private boolean warnOverwriteKey(String action, String togglePref) {
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Overwrite key", new Object[0]), new String[]{I18n.tr("Replace", new Object[0]), I18n.tr("Cancel", new Object[0])});
        ed.setButtonIcons(new String[]{"purge", "cancel"});
        ed.setContent(action + "\n" + I18n.tr("The new key is already used, overwrite values?", new Object[0]));
        ed.setCancelButton(2);
        ed.toggleEnable(togglePref);
        ed.showDialog();
        return ed.getValue() == 1;
    }

    class AddTagsDialog
    extends AbstractTagsDialog {
        List<JosmAction> recentTagsActions;
        private int commandCount;

        public AddTagsDialog() {
            super(Main.parent, I18n.tr("Add value?", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.recentTagsActions = new ArrayList<JosmAction>();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/AddValue", true);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            this.keys = new AutoCompletingComboBox();
            this.values = new AutoCompletingComboBox();
            mainPanel.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>" + I18n.tr("Please select a key", new Object[0])), GBC.eol().fill(2));
            AutoCompletionManager autocomplete = Main.main.getEditLayer().data.getAutoCompletionManager();
            List<AutoCompletionListItem> keyList = autocomplete.getKeys();
            AutoCompletionListItem itemToSelect = null;
            Iterator<AutoCompletionListItem> iter = keyList.iterator();
            block0: while (iter.hasNext()) {
                AutoCompletionListItem item = iter.next();
                if (item.getValue().equals(TagEditHelper.this.lastAddKey)) {
                    itemToSelect = item;
                }
                for (int i = 0; i < TagEditHelper.this.tagData.getRowCount(); ++i) {
                    if (!item.getValue().equals(TagEditHelper.this.tagData.getValueAt(i, 0))) continue;
                    if (itemToSelect == item) {
                        itemToSelect = null;
                    }
                    iter.remove();
                    continue block0;
                }
            }
            Collections.sort(keyList, TagEditHelper.this.defaultACItemComparator);
            this.keys.setPossibleACItems(keyList);
            this.keys.setEditable(true);
            mainPanel.add((Component)this.keys, GBC.eop().fill());
            mainPanel.add((Component)new JLabel(I18n.tr("Please select a value", new Object[0])), GBC.eol());
            this.values.setEditable(true);
            mainPanel.add((Component)this.values, GBC.eop().fill());
            if (itemToSelect != null) {
                this.keys.setSelectedItem(itemToSelect);
                if (TagEditHelper.this.lastAddValue != null) {
                    this.values.setSelectedItem(TagEditHelper.this.lastAddValue);
                }
            }
            FocusAdapter focus = this.addFocusAdapter(autocomplete, TagEditHelper.this.defaultACItemComparator);
            focus.focusGained(null);
            int recentTagsToShow = PROPERTY_RECENT_TAGS_NUMBER.get();
            if (recentTagsToShow > 30) {
                recentTagsToShow = 30;
            }
            mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 1), "addAndContinue");
            mainPanel.getActionMap().put("addAndContinue", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTagsDialog.this.performTagAdding();
                    AddTagsDialog.this.selectKeysComboBox();
                }
            });
            this.suggestRecentlyAddedTags(mainPanel, recentTagsToShow, focus);
            this.setContent(mainPanel, false);
            this.selectKeysComboBox();
            this.popupMenu.add(new AbstractAction(I18n.tr("Set number of recently added tags", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddTagsDialog.this.selectNumberOfTags();
                }
            });
            JCheckBoxMenuItem rememberLastTags = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Remember last used tags after a restart", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                    PROPERTY_REMEMBER_TAGS.put(sel);
                    if (sel) {
                        TagEditHelper.this.saveTagsIfNeeded();
                    }
                }
            });
            rememberLastTags.setState(PROPERTY_REMEMBER_TAGS.get());
            this.popupMenu.add(rememberLastTags);
        }

        private void selectNumberOfTags() {
            String s = JOptionPane.showInputDialog(this, (Object)I18n.tr("Please enter the number of recently added tags to display", new Object[0]));
            if (s != null) {
                try {
                    int v = Integer.parseInt(s);
                    if (v >= 0 && v <= 30) {
                        PROPERTY_RECENT_TAGS_NUMBER.put(v);
                        return;
                    }
                }
                catch (NumberFormatException ex) {
                    Main.warn(ex);
                }
            }
            JOptionPane.showMessageDialog(this, I18n.tr("Please enter integer number between 0 and {0}", 30));
        }

        private void suggestRecentlyAddedTags(JPanel mainPanel, int tagsToShow, final FocusAdapter focus) {
            if (tagsToShow <= 0 || TagEditHelper.this.recentTags.isEmpty()) {
                return;
            }
            mainPanel.add((Component)new JLabel(I18n.tr("Recently added tags", new Object[0])), GBC.eol());
            int count = 1;
            LinkedList tags = new LinkedList(TagEditHelper.this.recentTags.keySet());
            for (int i = tags.size() - 1; i >= 0 && count <= tagsToShow; --i, ++count) {
                final Tag t = (Tag)tags.get(i);
                String actionShortcutKey = "properties:recent:" + count;
                String actionShortcutShiftKey = "properties:recent:shift:" + count;
                Shortcut sc = Shortcut.registerShortcut(actionShortcutKey, I18n.tr("Choose recent tag {0}", count), 48 + count, 5006);
                final JosmAction action = new JosmAction(actionShortcutKey, null, I18n.tr("Use this tag again", new Object[0]), sc, false){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddTagsDialog.this.keys.setSelectedItem(t.getKey());
                        focus.focusGained(null);
                        AddTagsDialog.this.values.setSelectedItem(t.getValue());
                        AddTagsDialog.this.selectValuesCombobox();
                    }
                };
                Shortcut scShift = Shortcut.registerShortcut(actionShortcutShiftKey, I18n.tr("Apply recent tag {0}", count), 48 + count, 5009);
                JosmAction actionShift = new JosmAction(actionShortcutShiftKey, null, I18n.tr("Use this tag again", new Object[0]), scShift, false){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        action.actionPerformed(null);
                        AddTagsDialog.this.performTagAdding();
                        AddTagsDialog.this.selectKeysComboBox();
                    }
                };
                this.recentTagsActions.add(action);
                this.recentTagsActions.add(actionShift);
                this.disableTagIfNeeded(t, action);
                ImageIcon icon = MapPaintStyles.getNodeIcon(t, false);
                if (icon == null) {
                    TaggingPreset tp;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(t.getKey(), t.getValue());
                    Iterator<TaggingPreset> i$ = TaggingPreset.getMatchingPresets(null, map, false).iterator();
                    while (i$.hasNext() && (icon = (tp = i$.next()).getIcon()) == null) {
                    }
                    if (icon == null) {
                        icon = new ImageIcon(new BufferedImage(16, 16, 2));
                    }
                }
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.ipadx = 5;
                mainPanel.add((Component)new JLabel(action.isEnabled() ? icon : GuiHelper.getDisabledIcon(icon)), gbc);
                String color = action.isEnabled() ? "" : "; color:gray";
                JLabel tagLabel = new JLabel("<html><style>td{border:1px solid gray; font-weight:normal" + color + "}</style>" + "<table><tr><td>" + XmlWriter.encode(t.toString(), true) + "</td></tr></table></html>");
                if (action.isEnabled()) {
                    mainPanel.getInputMap(2).put(sc.getKeyStroke(), actionShortcutKey);
                    mainPanel.getActionMap().put(actionShortcutKey, action);
                    mainPanel.getInputMap(2).put(scShift.getKeyStroke(), actionShortcutShiftKey);
                    mainPanel.getActionMap().put(actionShortcutShiftKey, actionShift);
                    tagLabel.setToolTipText((String)action.getValue("ShortDescription"));
                    tagLabel.setCursor(Cursor.getPredefinedCursor(12));
                    tagLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            action.actionPerformed(null);
                            if (e.getClickCount() > 1) {
                                AddTagsDialog.this.buttonAction(0, null);
                            }
                            if (e.isShiftDown()) {
                                AddTagsDialog.this.performTagAdding();
                                AddTagsDialog.this.selectKeysComboBox();
                            }
                        }
                    });
                } else {
                    tagLabel.setEnabled(false);
                    tagLabel.setToolTipText(I18n.tr("The key ''{0}'' is already used", t.getKey()));
                }
                JPanel tagPanel = new JPanel(new FlowLayout(0, 0, 0));
                tagPanel.add(tagLabel);
                mainPanel.add((Component)tagPanel, GBC.eol().fill(2));
            }
        }

        public void destroyActions() {
            for (JosmAction action : this.recentTagsActions) {
                action.destroy();
            }
        }

        public final void performTagAdding() {
            String key = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            String value = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if (key.isEmpty() || value.isEmpty()) {
                return;
            }
            for (OsmPrimitive osm : TagEditHelper.this.sel) {
                String val = osm.get(key);
                if (val == null || val.equals(value)) continue;
                if (TagEditHelper.this.warnOverwriteKey(I18n.tr("You changed the value of ''{0}'' from ''{1}'' to ''{2}''.", key, val, value), "overwriteAddKey")) break;
                return;
            }
            TagEditHelper.this.lastAddKey = key;
            TagEditHelper.this.lastAddValue = value;
            TagEditHelper.this.recentTags.put(new Tag(key, value), null);
            AutoCompletionManager.rememberUserInput(key, value, false);
            ++this.commandCount;
            Main.main.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, key, value));
            TagEditHelper.this.changedKey = key;
        }

        public void undoAllTagsAdding() {
            Main.main.undoRedo.undo(this.commandCount);
        }

        private void disableTagIfNeeded(Tag t, JosmAction action) {
            for (int j = 0; j < TagEditHelper.this.tagData.getRowCount(); ++j) {
                if (!t.getKey().equals(TagEditHelper.this.tagData.getValueAt(j, 0))) continue;
                action.setEnabled(false);
                break;
            }
        }
    }

    abstract class AbstractTagsDialog
    extends ExtendedDialog {
        AutoCompletingComboBox keys;
        AutoCompletingComboBox values;
        protected JPopupMenu popupMenu;

        public AbstractTagsDialog(Component parent, String title, String[] buttonTexts) {
            super(parent, title, buttonTexts);
            this.popupMenu = new JPopupMenu(){
                JCheckBoxMenuItem fixTagLanguageCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Use English language for tag by default", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                        PROPERTY_FIX_TAG_LOCALE.put(sel);
                    }
                });
                {
                    this.add(this.fixTagLanguageCb);
                    this.fixTagLanguageCb.setState(PROPERTY_FIX_TAG_LOCALE.get());
                }
            };
            this.addMouseListener(new PopupMenuLauncher(this.popupMenu));
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            Dimension size = this.getSize();
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, size));
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                Dimension size;
                WindowGeometry geometry = this.initWindowGeometry();
                Dimension storedSize = geometry.getSize();
                if (!storedSize.equals(size = this.getSize())) {
                    if (storedSize.width < size.width) {
                        storedSize.width = size.width;
                    }
                    if (storedSize.height != size.height) {
                        storedSize.height = size.height;
                    }
                    this.rememberWindowGeometry(geometry);
                }
                this.keys.setFixedLocale(PROPERTY_FIX_TAG_LOCALE.get());
            }
            super.setVisible(visible);
        }

        private void selectACComboBoxSavingUnixBuffer(AutoCompletingComboBox cb) {
            Clipboard sysSel = Toolkit.getDefaultToolkit().getSystemSelection();
            if (sysSel != null) {
                Transferable old = sysSel.getContents(null);
                cb.requestFocusInWindow();
                cb.getEditor().selectAll();
                sysSel.setContents(old, null);
            } else {
                cb.requestFocusInWindow();
                cb.getEditor().selectAll();
            }
        }

        public void selectKeysComboBox() {
            this.selectACComboBoxSavingUnixBuffer(this.keys);
        }

        public void selectValuesCombobox() {
            this.selectACComboBoxSavingUnixBuffer(this.values);
        }

        protected FocusAdapter addFocusAdapter(final AutoCompletionManager autocomplete, final Comparator<AutoCompletionListItem> comparator) {
            JTextComponent editor = (JTextComponent)this.values.getEditor().getEditorComponent();
            FocusAdapter focus = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    String key = AbstractTagsDialog.this.keys.getEditor().getItem().toString();
                    List<AutoCompletionListItem> valueList = autocomplete.getValues(TagEditHelper.getAutocompletionKeys(key));
                    Collections.sort(valueList, comparator);
                    AbstractTagsDialog.this.values.setPossibleACItems(valueList);
                    AbstractTagsDialog.this.values.getEditor().selectAll();
                    TagEditHelper.this.objKey = key;
                }
            };
            editor.addFocusListener(focus);
            return focus;
        }
    }

    public final class EditTagDialog
    extends AbstractTagsDialog {
        final String key;
        final Map<String, Integer> m;
        final int row;
        Comparator<AutoCompletionListItem> usedValuesAwareComparator;
        ListCellRenderer<AutoCompletionListItem> cellRenderer;

        private EditTagDialog(String key, int row, Map<String, Integer> map, final boolean initialFocusOnKey) {
            super(Main.parent, I18n.trn("Change value?", "Change values?", map.size(), new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.usedValuesAwareComparator = new Comparator<AutoCompletionListItem>(){

                @Override
                public int compare(AutoCompletionListItem o1, AutoCompletionListItem o2) {
                    boolean c2;
                    boolean c1 = EditTagDialog.this.m.containsKey(o1.getValue());
                    if (c1 == (c2 = EditTagDialog.this.m.containsKey(o2.getValue()))) {
                        return String.CASE_INSENSITIVE_ORDER.compare(o1.getValue(), o2.getValue());
                    }
                    if (c1) {
                        return -1;
                    }
                    return 1;
                }
            };
            this.cellRenderer = new ListCellRenderer<AutoCompletionListItem>(){
                final DefaultListCellRenderer def = new DefaultListCellRenderer();

                @Override
                public Component getListCellRendererComponent(JList<? extends AutoCompletionListItem> list, AutoCompletionListItem value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = this.def.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (c instanceof JLabel) {
                        Map m;
                        String str = value.getValue();
                        if (TagEditHelper.this.valueCount.containsKey(TagEditHelper.this.objKey) && (m = (Map)TagEditHelper.this.valueCount.get(TagEditHelper.this.objKey)).containsKey(str)) {
                            str = I18n.tr("{0} ({1})", str, m.get(str));
                            c.setFont(c.getFont().deriveFont(3));
                        }
                        ((JLabel)c).setText(str);
                    }
                    return c;
                }
            };
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setCancelButton(2);
            this.configureContextsensitiveHelp("/Dialog/EditValue", true);
            this.key = key;
            this.row = row;
            this.m = map;
            JPanel mainPanel = new JPanel(new BorderLayout());
            String msg = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", key) + ")</html>";
            mainPanel.add((Component)new JLabel(msg), "North");
            JPanel p = new JPanel(new GridBagLayout());
            mainPanel.add((Component)p, "Center");
            AutoCompletionManager autocomplete = Main.main.getEditLayer().data.getAutoCompletionManager();
            List<AutoCompletionListItem> keyList = autocomplete.getKeys();
            Collections.sort(keyList, TagEditHelper.this.defaultACItemComparator);
            this.keys = new AutoCompletingComboBox(key);
            this.keys.setPossibleACItems(keyList);
            this.keys.setEditable(true);
            this.keys.setSelectedItem(key);
            p.add(Box.createVerticalStrut(5), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std());
            p.add(Box.createHorizontalStrut(10), GBC.std());
            p.add((Component)this.keys, GBC.eol().fill(2));
            List<AutoCompletionListItem> valueList = autocomplete.getValues(TagEditHelper.getAutocompletionKeys(key));
            Collections.sort(valueList, this.usedValuesAwareComparator);
            String selection = this.m.size() != 1 ? I18n.tr("<different>", new Object[0]) : this.m.entrySet().iterator().next().getKey();
            this.values = new AutoCompletingComboBox(selection);
            this.values.setRenderer(this.cellRenderer);
            this.values.setEditable(true);
            this.values.setPossibleACItems(valueList);
            this.values.setSelectedItem(selection);
            this.values.getEditor().setItem(selection);
            p.add(Box.createVerticalStrut(5), GBC.eol());
            p.add((Component)new JLabel(I18n.tr("Value", new Object[0])), GBC.std());
            p.add(Box.createHorizontalStrut(10), GBC.std());
            p.add((Component)this.values, GBC.eol().fill(2));
            this.values.getEditor().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditTagDialog.this.buttonAction(0, null);
                }
            });
            this.addFocusAdapter(autocomplete, this.usedValuesAwareComparator);
            this.setContent(mainPanel, false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (initialFocusOnKey) {
                        EditTagDialog.this.selectKeysComboBox();
                    } else {
                        EditTagDialog.this.selectValuesCombobox();
                    }
                }
            });
        }

        private void performTagEdit() {
            String value = Tag.removeWhiteSpaces(this.values.getEditor().getItem().toString());
            if ((value = Normalizer.normalize(value, Normalizer.Form.NFC)).isEmpty()) {
                value = null;
            }
            String newkey = Tag.removeWhiteSpaces(this.keys.getEditor().getItem().toString());
            if ((newkey = Normalizer.normalize(newkey, Normalizer.Form.NFC)).isEmpty()) {
                newkey = this.key;
                value = null;
            }
            if (this.key.equals(newkey) && I18n.tr("<different>", new Object[0]).equals(value)) {
                return;
            }
            if (this.key.equals(newkey) || value == null) {
                Main.main.undoRedo.add(new ChangePropertyCommand(TagEditHelper.this.sel, newkey, value));
                AutoCompletionManager.rememberUserInput(newkey, value, true);
            } else {
                for (OsmPrimitive osm : TagEditHelper.this.sel) {
                    if (osm.get(newkey) == null) continue;
                    if (TagEditHelper.this.warnOverwriteKey(I18n.tr("You changed the key from ''{0}'' to ''{1}''.", this.key, newkey), "overwriteEditKey")) break;
                    return;
                }
                ArrayList<Command> commands = new ArrayList<Command>();
                commands.add(new ChangePropertyCommand(TagEditHelper.this.sel, this.key, null));
                if (value.equals(I18n.tr("<different>", new Object[0]))) {
                    HashMap map = new HashMap();
                    for (OsmPrimitive osmPrimitive : TagEditHelper.this.sel) {
                        String val = osmPrimitive.get(this.key);
                        if (val == null) continue;
                        if (map.containsKey(val)) {
                            ((List)map.get(val)).add(osmPrimitive);
                            continue;
                        }
                        ArrayList<OsmPrimitive> v = new ArrayList<OsmPrimitive>();
                        v.add(osmPrimitive);
                        map.put(val, v);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        commands.add(new ChangePropertyCommand((Collection)entry.getValue(), newkey, (String)entry.getKey()));
                    }
                } else {
                    commands.add(new ChangePropertyCommand(TagEditHelper.this.sel, newkey, value));
                    AutoCompletionManager.rememberUserInput(newkey, value, false);
                }
                Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", TagEditHelper.this.sel.size(), TagEditHelper.this.sel.size()), commands));
            }
            TagEditHelper.this.changedKey = newkey;
        }
    }
}

