/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadMembersAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.relation.SelectMembersAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesCellRenderer;
import org.openstreetmap.josm.gui.dialogs.properties.TagEditHelper;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.PresetHandler;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
DataSetListenerAdapter.Listener,
MapView.EditLayerChangeListener {
    public static final JPanel pluginHook = new JPanel();
    private final DefaultTableModel tagData = new ReadOnlyTableModel();
    private final DefaultTableModel membershipData = new ReadOnlyTableModel();
    private final JTable tagTable = new JTable(this.tagData);
    private final JTable membershipTable = new JTable(this.membershipData);
    private final JPanel bothTables = new JPanel();
    private final JPopupMenu tagMenu = new JPopupMenu();
    private final JPopupMenu membershipMenu = new JPopupMenu();
    private final JPopupMenu blankSpaceMenu = new JPopupMenu();
    private final PopupMenuHandler tagMenuHandler = new PopupMenuHandler(this.tagMenu);
    private final PopupMenuHandler membershipMenuHandler = new PopupMenuHandler(this.membershipMenu);
    private final PopupMenuHandler blankSpaceMenuHandler = new PopupMenuHandler(this.blankSpaceMenu);
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private final TagEditHelper editHelper = new TagEditHelper(this.tagData, this.valueCount);
    private final DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private final HelpAction helpAction = new HelpAction();
    private final PasteValueAction pasteValueAction = new PasteValueAction();
    private final CopyValueAction copyValueAction = new CopyValueAction();
    private final CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction();
    private final CopyAllKeyValueAction copyAllKeyValueAction = new CopyAllKeyValueAction();
    private final SearchAction searchActionSame = new SearchAction(true);
    private final SearchAction searchActionAny = new SearchAction(false);
    private final AddAction addAction = new AddAction();
    private final EditAction editAction = new EditAction();
    private final DeleteAction deleteAction = new DeleteAction();
    private final JosmAction[] josmActions = new JosmAction[]{this.addAction, this.editAction, this.deleteAction};
    private final SelectInRelationListAction setRelationSelectionAction = new SelectInRelationListAction();
    private final SelectRelationAction selectRelationAction = new SelectRelationAction(false);
    private final SelectRelationAction addRelationToSelectionAction = new SelectRelationAction(true);
    private final DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
    private final DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
    private final SelectMembersAction selectMembersAction = new SelectMembersAction(false);
    private final SelectMembersAction addMembersToSelectionAction = new SelectMembersAction(true);
    private final HighlightHelper highlightHelper = new HighlightHelper();
    private final SideButton btnAdd = new SideButton(this.addAction);
    private final SideButton btnEdit = new SideButton(this.editAction);
    private final SideButton btnDel = new SideButton(this.deleteAction);
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Select objects for which to change tags.", new Object[0]) + "</p></html>");
    private final PresetHandler presetHandler = new PresetHandler(){

        @Override
        public void updateTags(List<Tag> tags) {
            Command command = TaggingPreset.createCommand(this.getSelection(), tags);
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }

        @Override
        public Collection<OsmPrimitive> getSelection() {
            if (Main.main == null) {
                return null;
            }
            return Main.main.getInProgressSelection();
        }
    };

    public PropertiesDialog() {
        super(I18n.tr("Tags/Memberships", new Object[0]), "propertiesdialog", I18n.tr("Tags for selected objects.", new Object[0]), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Tags/Memberships", new Object[0])), 80, 5007), 150, true);
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Dialog/TagsMembership"));
        this.setupTagsMenu();
        this.buildTagsTable();
        this.setupMembershipMenu();
        this.buildMembershipTable();
        boolean top = Main.pref.getBoolean("properties.presets.top", true);
        this.bothTables.setLayout(new GridBagLayout());
        if (top) {
            this.bothTables.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double epsilon = Double.MIN_VALUE;
            this.bothTables.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(epsilon, epsilon));
        }
        this.bothTables.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        this.bothTables.add((Component)this.tagTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.tagTable, GBC.eol().fill(1));
        this.bothTables.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        this.bothTables.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!top) {
            this.bothTables.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        this.setupBlankSpaceMenu();
        this.setupKeyboardShortcuts();
        this.tagTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.tagTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        JScrollPane scrollPane = (JScrollPane)this.createLayout(this.bothTables, true, Arrays.asList(this.btnAdd, this.btnEdit, this.btnDel));
        MouseClickWatch mouseClickWatch = new MouseClickWatch();
        this.tagTable.addMouseListener(mouseClickWatch);
        this.membershipTable.addMouseListener(mouseClickWatch);
        scrollPane.addMouseListener(mouseClickWatch);
        this.selectSth.setPreferredSize(scrollPane.getSize());
        this.presets.setSize(scrollPane.getSize());
        this.editHelper.loadTagsIfNeeded();
        Main.pref.addPreferenceChangeListener(this);
    }

    private void buildTagsTable() {
        this.tagData.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        this.tagTable.setSelectionMode(2);
        this.tagTable.getTableHeader().setReorderingAllowed(false);
        PropertiesCellRenderer cellRenderer = new PropertiesCellRenderer();
        this.tagTable.getColumnModel().getColumn(0).setCellRenderer(cellRenderer);
        this.tagTable.getColumnModel().getColumn(1).setCellRenderer(cellRenderer);
    }

    private void buildMembershipTable() {
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of", new Object[0]), I18n.tr("Role", new Object[0]), I18n.tr("Position", new Object[0])});
        this.membershipTable.setSelectionMode(2);
        TableColumnModel mod = this.membershipTable.getColumnModel();
        this.membershipTable.getTableHeader().setReorderingAllowed(false);
        mod.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (value == null) {
                    return this;
                }
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    Relation r = (Relation)value;
                    label.setText(r.getDisplayName(DefaultNameFormatter.getInstance()));
                    if (r.isDisabledAndHidden()) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    return this;
                }
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    label.setText(((MemberInfo)value).getRoleString());
                    if (isDisabledAndHidden) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                boolean isDisabledAndHidden = ((Relation)table.getValueAt(row, 0)).isDisabledAndHidden();
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    label.setText(((MemberInfo)table.getValueAt(row, 1)).getPositionString());
                    if (isDisabledAndHidden) {
                        label.setFont(label.getFont().deriveFont(2));
                    }
                }
                return c;
            }
        });
        mod.getColumn(2).setPreferredWidth(20);
        mod.getColumn(1).setPreferredWidth(40);
        mod.getColumn(0).setPreferredWidth(200);
    }

    private void setupBlankSpaceMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.blankSpaceMenuHandler.addAction(this.addAction);
            PopupMenuLauncher launcher = new PopupMenuLauncher(this.blankSpaceMenu){

                @Override
                protected boolean checkSelection(Component component, Point p) {
                    if (component instanceof JTable) {
                        return ((JTable)component).rowAtPoint(p) == -1;
                    }
                    return true;
                }
            };
            this.bothTables.addMouseListener(launcher);
            this.tagTable.addMouseListener(launcher);
        }
    }

    private void setupMembershipMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.membershipMenuHandler.addAction(this.editAction);
            this.membershipMenuHandler.addAction(this.deleteAction);
            this.membershipMenu.addSeparator();
        }
        this.membershipMenuHandler.addAction(this.setRelationSelectionAction);
        this.membershipMenuHandler.addAction(this.selectRelationAction);
        this.membershipMenuHandler.addAction(this.addRelationToSelectionAction);
        this.membershipMenuHandler.addAction(this.selectMembersAction);
        this.membershipMenuHandler.addAction(this.addMembersToSelectionAction);
        this.membershipMenu.addSeparator();
        this.membershipMenuHandler.addAction(this.downloadMembersAction);
        this.membershipMenuHandler.addAction(this.downloadSelectedIncompleteMembersAction);
        this.membershipMenu.addSeparator();
        this.membershipMenu.add(this.helpAction);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(this.membershipMenu){

            @Override
            protected int checkTableSelection(JTable table, Point p) {
                int row = super.checkTableSelection(table, p);
                ArrayList<Relation> rels = new ArrayList<Relation>();
                for (int i : table.getSelectedRows()) {
                    rels.add((Relation)table.getValueAt(i, 0));
                }
                PropertiesDialog.this.membershipMenuHandler.setPrimitives(rels);
                return row;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (Main.isDisplayingMapView() && (row = PropertiesDialog.this.membershipTable.rowAtPoint(e.getPoint())) >= 0 && PropertiesDialog.this.highlightHelper.highlightOnly((Relation)PropertiesDialog.this.membershipTable.getValueAt(row, 0))) {
                    Main.map.mapView.repaint();
                }
                super.mouseClicked(e);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                PropertiesDialog.this.highlightHelper.clear();
            }
        });
    }

    private void setupTagsMenu() {
        if (Main.pref.getBoolean("properties.menu.add_edit_delete", true)) {
            this.tagMenu.add(this.addAction);
            this.tagMenu.add(this.editAction);
            this.tagMenu.add(this.deleteAction);
            this.tagMenu.addSeparator();
        }
        this.tagMenu.add(this.pasteValueAction);
        this.tagMenu.add(this.copyValueAction);
        this.tagMenu.add(this.copyKeyValueAction);
        this.tagMenu.add(this.copyAllKeyValueAction);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.searchActionAny);
        this.tagMenu.add(this.searchActionSame);
        this.tagMenu.addSeparator();
        this.tagMenu.add(this.helpAction);
        this.tagTable.addMouseListener(new PopupMenuLauncher(this.tagMenu));
    }

    private void setupKeyboardShortcuts() {
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.tagTable.getActionMap().put("onTableEnter", this.editAction);
        this.membershipTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.membershipTable.getActionMap().put("onTableEnter", this.editAction);
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(155, 0), "onTableInsert");
        this.tagTable.getActionMap().put("onTableInsert", this.addAction);
        InputMapUtils.unassignCtrlShiftUpDown(this.tagTable, 1);
        InputMapUtils.unassignPageUpDown(this.tagTable, 1);
        this.tagTable.setTransferHandler(null);
        this.tagTable.getInputMap(1).put(KeyStroke.getKeyStroke(67, 2), "onCopy");
        this.tagTable.getActionMap().put("onCopy", this.copyKeyValueAction);
        InputMapUtils.enableEnter(this.btnAdd);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", this.deleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    private void editMembership(int row) {
        Relation relation = (Relation)this.membershipData.getValueAt(row, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.main.getEditLayer(), relation, ((MemberInfo)this.membershipData.getValueAt(row, 1)).role).setVisible(true);
    }

    private int findRow(TableModel model, Object value) {
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getValueAt(i, 0).equals(value)) continue;
            return i;
        }
        return -1;
    }

    private void updateSelection() {
        this.selectionChanged(null);
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener(this);
        for (JosmAction action : this.josmActions) {
            Main.registerActionShortcut(action);
        }
        this.updateSelection();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MapView.removeEditLayerChangeListener(this);
        for (JosmAction action : this.josmActions) {
            Main.unregisterActionShortcut(action);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && Main.main.getCurrentDataSet() != null) {
            this.updateSelection();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        Main.pref.removePreferenceChangeListener(this);
        for (JosmAction action : this.josmActions) {
            action.destroy();
        }
        Container parent = pluginHook.getParent();
        if (parent != null) {
            parent.remove(pluginHook);
        }
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        int selectedIndex;
        Collection<OsmPrimitive> newSel;
        if (!this.isVisible()) {
            return;
        }
        if (this.tagTable == null) {
            return;
        }
        if (this.tagTable.getCellEditor() != null) {
            this.tagTable.getCellEditor().cancelCellEditing();
        }
        if ((newSel = Main.main.getInProgressSelection()) == null) {
            newSel = Collections.emptyList();
        }
        Relation selectedRelation = null;
        String selectedTag = this.editHelper.getChangedKey();
        if (selectedTag == null && this.tagTable.getSelectedRowCount() == 1) {
            selectedTag = (String)this.tagData.getValueAt(this.tagTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            selectedRelation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.tagData.setRowCount(0);
        boolean displayDiscardableKeys = Main.pref.getBoolean("display.discardable-keys", false);
        HashMap<String, Integer> keyCount = new HashMap<String, Integer>();
        HashMap<String, String> tags = new HashMap<String, String>();
        this.valueCount.clear();
        EnumSet<TaggingPresetType> types = EnumSet.noneOf(TaggingPresetType.class);
        for (OsmPrimitive osmPrimitive : newSel) {
            types.add(TaggingPresetType.forPrimitive(osmPrimitive));
            for (String key : osmPrimitive.keySet()) {
                Map<Object, Object> v;
                if (!displayDiscardableKeys && OsmPrimitive.getDiscardableKeys().contains(key)) continue;
                String value = osmPrimitive.get(key);
                keyCount.put(key, keyCount.containsKey(key) ? (Integer)keyCount.get(key) + 1 : 1);
                if (this.valueCount.containsKey(key)) {
                    v.put(value, (v = this.valueCount.get(key)).containsKey(value) ? (Integer)v.get(value) + 1 : 1);
                    continue;
                }
                v = new TreeMap<String, Integer>();
                ((TreeMap)v).put(value, 1);
                this.valueCount.put(key, v);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            int count = 0;
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                count += ((Integer)e1.getValue()).intValue();
            }
            if (count < newSel.size()) {
                ((Map)entry.getValue()).put("", newSel.size() - count);
            }
            this.tagData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            tags.put((String)entry.getKey(), ((Map)entry.getValue()).size() == 1 ? (String)((Map)entry.getValue()).keySet().iterator().next() : I18n.tr("<different>", new Object[0]));
        }
        this.membershipData.setRowCount(0);
        HashMap<Relation, MemberInfo> roles = new HashMap<Relation, MemberInfo>();
        for (OsmPrimitive primitive : newSel) {
            for (OsmPrimitive ref : primitive.getReferrers(true)) {
                if (!(ref instanceof Relation) || ref.isIncomplete() || ref.isDeleted()) continue;
                Relation r = (Relation)ref;
                MemberInfo mi = (MemberInfo)roles.get(r);
                if (mi == null) {
                    mi = new MemberInfo(newSel);
                }
                roles.put(r, mi);
                int i = 1;
                for (RelationMember m : r.getMembers()) {
                    if (m.getMember() == primitive) {
                        mi.add(m, i);
                    }
                    ++i;
                }
            }
        }
        ArrayList arrayList = new ArrayList(roles.keySet());
        Collections.sort(arrayList, new Comparator<Relation>(){

            @Override
            public int compare(Relation o1, Relation o2) {
                int comp = Boolean.valueOf(o1.isDisabledAndHidden()).compareTo(o2.isDisabledAndHidden());
                return comp != 0 ? comp : DefaultNameFormatter.getInstance().getRelationComparator().compare(o1, o2);
            }
        });
        for (Relation r : arrayList) {
            this.membershipData.addRow(new Object[]{r, roles.get(r)});
        }
        this.presets.updatePresets(types, tags, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean hasSelection = !newSel.isEmpty();
        boolean hasTags = hasSelection && this.tagData.getRowCount() > 0;
        boolean hasMemberships = hasSelection && this.membershipData.getRowCount() > 0;
        this.addAction.setEnabled(hasSelection);
        this.editAction.setEnabled(hasTags || hasMemberships);
        this.deleteAction.setEnabled(hasTags || hasMemberships);
        this.tagTable.setVisible(hasTags);
        this.tagTable.getTableHeader().setVisible(hasTags);
        this.selectSth.setVisible(!hasSelection);
        pluginHook.setVisible(hasSelection);
        if (selectedTag != null && (selectedIndex = this.findRow(this.tagData, selectedTag)) != -1) {
            this.tagTable.changeSelection(selectedIndex, 0, false, false);
        } else if (selectedRelation != null && (selectedIndex = this.findRow(this.membershipData, selectedRelation)) != -1) {
            this.membershipTable.changeSelection(selectedIndex, 0, false, false);
        } else if (hasTags) {
            this.tagTable.changeSelection(0, 0, false, false);
        } else if (hasMemberships) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.tagData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Tags: {0} / Memberships: {1}", this.tagData.getRowCount(), this.membershipData.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Tags / Memberships", new Object[0]));
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (newLayer == null) {
            this.editHelper.saveTagsIfNeeded();
        }
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                PropertiesDialog.this.updateSelection();
            }
        });
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.updateSelection();
    }

    public PopupMenuHandler getPropertyPopupMenuHandler() {
        return this.tagMenuHandler;
    }

    public Tag getSelectedProperty() {
        int row = this.tagTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        TreeMap map = (TreeMap)this.tagData.getValueAt(row, 1);
        return new Tag(this.tagData.getValueAt(row, 0).toString(), map.size() > 1 ? "" : (String)map.keySet().iterator().next());
    }

    public PopupMenuHandler getMembershipPopupMenuHandler() {
        return this.membershipMenuHandler;
    }

    public IRelation getSelectedMembershipRelation() {
        int row = this.membershipTable.getSelectedRow();
        return row > -1 ? (IRelation)this.membershipData.getValueAt(row, 0) : null;
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        super.preferenceChanged(e);
        if ("display.discardable-keys".equals(e.getKey()) && Main.main.getCurrentDataSet() != null) {
            this.updateSelection();
        }
    }

    class SearchAction
    extends AbstractAction {
        final boolean sameType;

        public SearchAction(boolean sameType) {
            this.sameType = sameType;
            if (sameType) {
                this.putValue("Name", I18n.tr("Search Key/Value/Type", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag, restrict to type (i.e., node/way/relation)", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Search Key/Value", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag", new Object[0]));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String key = PropertiesDialog.this.tagData.getValueAt(PropertiesDialog.this.tagTable.getSelectedRow(), 0).toString();
            Collection<OsmPrimitive> sel = Main.main.getInProgressSelection();
            if (sel.isEmpty()) {
                return;
            }
            String sep = "";
            StringBuilder s = new StringBuilder();
            for (OsmPrimitive p : sel) {
                String val = p.get(key);
                if (val == null) continue;
                String t = "";
                if (!this.sameType) {
                    t = "";
                } else if (p instanceof Node) {
                    t = "type:node ";
                } else if (p instanceof Way) {
                    t = "type:way ";
                } else if (p instanceof Relation) {
                    t = "type:relation ";
                }
                s.append(sep).append("(").append(t).append("\"").append(org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch(key)).append("\"=\"").append(org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch(val)).append("\")");
                sep = " OR ";
            }
            SearchAction.SearchSetting ss = new SearchAction.SearchSetting(s.toString(), SearchAction.SearchMode.replace, true, false, false);
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(ss);
        }
    }

    class CopyAllKeyValueAction
    extends AbstractCopyAction {
        public CopyAllKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy all Keys/Values", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of all the tags to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive p, String key) {
            LinkedList<String> r = new LinkedList<String>();
            for (Map.Entry<String, String> kv : p.getKeys().entrySet()) {
                r.add(new Tag(kv.getKey(), kv.getValue()).toString());
            }
            return r;
        }
    }

    class CopyKeyValueAction
    extends AbstractCopyAction {
        public CopyKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy selected Key(s)/Value(s)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of the selected tag(s) to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive p, String key) {
            String v = p.get(key);
            return v == null ? null : Collections.singleton(new Tag(key, v).toString());
        }
    }

    class CopyValueAction
    extends AbstractCopyAction {
        public CopyValueAction() {
            this.putValue("Name", I18n.tr("Copy Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the value of the selected tag to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive p, String key) {
            String v = p.get(key);
            return v == null ? null : Collections.singleton(v);
        }
    }

    abstract class AbstractCopyAction
    extends AbstractAction {
        AbstractCopyAction() {
        }

        protected abstract Collection<String> getString(OsmPrimitive var1, String var2);

        @Override
        public void actionPerformed(ActionEvent ae) {
            int[] rows = PropertiesDialog.this.tagTable.getSelectedRows();
            TreeSet<String> values = new TreeSet<String>();
            Collection<OsmPrimitive> sel = Main.main.getInProgressSelection();
            if (rows.length == 0 || sel.isEmpty()) {
                return;
            }
            for (int row : rows) {
                String key = PropertiesDialog.this.tagData.getValueAt(row, 0).toString();
                if (sel.isEmpty()) {
                    return;
                }
                for (OsmPrimitive p : sel) {
                    Collection<String> s = this.getString(p, key);
                    if (s == null) continue;
                    values.addAll(s);
                }
            }
            if (!values.isEmpty()) {
                Utils.copyToClipboard(Utils.join("\n", values));
            }
        }
    }

    class PasteValueAction
    extends AbstractAction {
        public PasteValueAction() {
            this.putValue("Name", I18n.tr("Paste Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Paste the value of the selected tag from clipboard", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() != 1) {
                return;
            }
            String key = PropertiesDialog.this.tagData.getValueAt(PropertiesDialog.this.tagTable.getSelectedRow(), 0).toString();
            Collection<OsmPrimitive> sel = Main.main.getInProgressSelection();
            String clipboard = Utils.getClipboardContent();
            if (sel.isEmpty() || clipboard == null) {
                return;
            }
            Main.main.undoRedo.add(new ChangePropertyCommand(sel, key, Utils.strip(clipboard)));
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", I18n.tr("Go to OSM wiki for tag help (F1)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String base = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
                String lang = LanguageInfo.getWikiLanguagePrefix();
                final ArrayList<URI> uris = new ArrayList<URI>();
                if (PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) {
                    int row = PropertiesDialog.this.tagTable.getSelectedRow();
                    String key = URLEncoder.encode(PropertiesDialog.this.tagData.getValueAt(row, 0).toString(), "UTF-8");
                    Map m = (Map)PropertiesDialog.this.tagData.getValueAt(row, 1);
                    String val = URLEncoder.encode((String)m.entrySet().iterator().next().getKey(), "UTF-8");
                    uris.add(new URI(String.format("%s%sTag:%s=%s", base, lang, key, val)));
                    uris.add(new URI(String.format("%sTag:%s=%s", base, key, val)));
                    uris.add(new URI(String.format("%s%sKey:%s", base, lang, key)));
                    uris.add(new URI(String.format("%sKey:%s", base, key)));
                    uris.add(new URI(String.format("%s%sMap_Features", base, lang)));
                    uris.add(new URI(String.format("%sMap_Features", base)));
                } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                    String type = ((Relation)PropertiesDialog.this.membershipData.getValueAt(row, 0)).get("type");
                    if (type != null) {
                        type = URLEncoder.encode(type, "UTF-8");
                    }
                    if (type != null && !type.isEmpty()) {
                        uris.add(new URI(String.format("%s%sRelation:%s", base, lang, type)));
                        uris.add(new URI(String.format("%sRelation:%s", base, type)));
                    }
                    uris.add(new URI(String.format("%s%sRelations", base, lang)));
                    uris.add(new URI(String.format("%sRelations", base)));
                } else {
                    uris.add(new URI(String.format("%s%sMap_Features", base, lang)));
                    uris.add(new URI(String.format("%sMap_Features", base)));
                }
                Main.worker.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (URI u : uris) {
                                HttpURLConnection conn = Utils.openHttpConnection(u.toURL());
                                conn.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (conn.getResponseCode() != 200) {
                                    Main.info("{0} does not exist", u);
                                    conn.disconnect();
                                    continue;
                                }
                                int osize = conn.getContentLength();
                                if (osize > -1) {
                                    conn.disconnect();
                                    conn = Utils.openHttpConnection(new URI(u.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title=")).toURL());
                                    conn.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                }
                                if (conn.getContentLength() != -1 && osize > -1 && Math.abs(conn.getContentLength() - osize) > 200) {
                                    Main.info("{0} is a mediawiki redirect", u);
                                    conn.disconnect();
                                    continue;
                                }
                                Main.info("browsing to {0}", u);
                                conn.disconnect();
                                OpenBrowser.displayUrl(u.toString());
                                break;
                            }
                        }
                        catch (Exception e) {
                            Main.error(e);
                        }
                    }
                });
            }
            catch (UnsupportedEncodingException | URISyntaxException e1) {
                Main.error(e1);
            }
        }
    }

    class EditAction
    extends JosmAction
    implements ListSelectionListener {
        public EditAction() {
            super(I18n.tr("Edit", new Object[0]), "dialogs/edit", I18n.tr("Edit the value of the selected key for all objects", new Object[0]), Shortcut.registerShortcut("properties:edit", I18n.tr("Edit Tags", new Object[0]), 83, 5004), false);
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) {
                int row = PropertiesDialog.this.tagTable.getSelectedRow();
                PropertiesDialog.this.editHelper.editTag(row, false);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                PropertiesDialog.this.editMembership(row);
            }
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled((PropertiesDialog.this.tagTable != null && PropertiesDialog.this.tagTable.getSelectedRowCount() == 1) ^ (PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends JosmAction {
        public AddAction() {
            super(I18n.tr("Add", new Object[0]), "dialogs/add", I18n.tr("Add a new key/value pair to all objects", new Object[0]), Shortcut.registerShortcut("properties:add", I18n.tr("Add Tag", new Object[0]), 65, 5004), false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertiesDialog.this.editHelper.addTag();
            PropertiesDialog.this.btnAdd.requestFocusInWindow();
        }
    }

    class DeleteAction
    extends JosmAction
    implements ListSelectionListener {
        public DeleteAction() {
            super(I18n.tr("Delete", new Object[0]), "dialogs/delete", I18n.tr("Delete the selected key in all objects", new Object[0]), Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Tags", new Object[0]), 68, 5010), false);
            this.updateEnabledState();
        }

        protected void deleteTags(int[] rows) {
            HashMap<String, String> tags = new HashMap<String, String>(rows.length);
            int nextKeyIndex = rows[0];
            for (int row : rows) {
                String key = PropertiesDialog.this.tagData.getValueAt(row, 0).toString();
                if (row == nextKeyIndex + 1) {
                    nextKeyIndex = row;
                }
                tags.put(key, null);
            }
            String nextKey = null;
            int rowCount = PropertiesDialog.this.tagData.getRowCount();
            if (rowCount > rows.length) {
                nextKeyIndex = nextKeyIndex == rows[rows.length - 1] ? (nextKeyIndex + 1 < rowCount ? nextKeyIndex + 1 : rows[0] - 1) : ++nextKeyIndex;
                nextKey = (String)PropertiesDialog.this.tagData.getValueAt(nextKeyIndex, 0);
            }
            Collection<OsmPrimitive> sel = Main.main.getInProgressSelection();
            Main.main.undoRedo.add(new ChangePropertyCommand(sel, tags));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (nextKey != null) {
                PropertiesDialog.this.tagTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.tagData, nextKey), 0, false, false);
            }
        }

        protected void deleteFromRelation(int row) {
            Relation cur = (Relation)PropertiesDialog.this.membershipData.getValueAt(row, 0);
            Relation nextRelation = null;
            int rowCount = PropertiesDialog.this.membershipTable.getRowCount();
            if (rowCount > 1) {
                nextRelation = (Relation)PropertiesDialog.this.membershipData.getValueAt(row + 1 < rowCount ? row + 1 : row - 1, 0);
            }
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Change relation", new Object[0]), new String[]{I18n.tr("Delete from relation", new Object[0]), I18n.tr("Cancel", new Object[0])});
            ed.setButtonIcons(new String[]{"dialogs/delete", "cancel"});
            ed.setContent(I18n.tr("Really delete selection from relation {0}?", cur.getDisplayName(DefaultNameFormatter.getInstance())));
            ed.toggleEnable("delete_from_relation");
            ed.showDialog();
            if (ed.getValue() != 1) {
                return;
            }
            Relation rel = new Relation(cur);
            for (OsmPrimitive primitive : Main.main.getInProgressSelection()) {
                rel.removeMembersFor(primitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(cur, rel));
            PropertiesDialog.this.tagTable.clearSelection();
            if (nextRelation != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.membershipData, nextRelation), 0, false, false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PropertiesDialog.this.tagTable.getSelectedRowCount() > 0) {
                int[] rows = PropertiesDialog.this.tagTable.getSelectedRows();
                this.deleteTags(rows);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                ConditionalOptionPaneUtil.startBulkOperation("delete_from_relation");
                int[] rows = PropertiesDialog.this.membershipTable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.deleteFromRelation(rows[i]);
                }
                ConditionalOptionPaneUtil.endBulkOperation("delete_from_relation");
            }
        }

        @Override
        protected final void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.tagTable != null && PropertiesDialog.this.tagTable.getSelectedRowCount() >= 1 || PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    public static class ReadOnlyTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    }

    static class MemberInfo {
        private List<RelationMember> role = new ArrayList<RelationMember>();
        private Set<OsmPrimitive> members = new HashSet<OsmPrimitive>();
        private List<Integer> position = new ArrayList<Integer>();
        private Iterable<OsmPrimitive> selection;
        private String positionString = null;
        private String roleString = null;

        MemberInfo(Iterable<OsmPrimitive> selection) {
            this.selection = selection;
        }

        void add(RelationMember r, Integer p) {
            this.role.add(r);
            this.members.add(r.getMember());
            this.position.add(p);
        }

        String getPositionString() {
            if (this.positionString == null) {
                this.positionString = Utils.getPositionListString(this.position);
                if (Utils.exists(this.selection, Predicates.not(Predicates.inCollection(this.members)))) {
                    this.positionString = this.positionString + ",\u2717";
                }
                this.members = null;
                this.position = null;
                this.selection = null;
            }
            return Utils.shortenString(this.positionString, 20);
        }

        String getRoleString() {
            if (this.roleString == null) {
                for (RelationMember r : this.role) {
                    if (this.roleString == null) {
                        this.roleString = r.getRole();
                        continue;
                    }
                    if (this.roleString.equals(r.getRole())) continue;
                    this.roleString = I18n.tr("<different>", new Object[0]);
                    break;
                }
            }
            return this.roleString;
        }

        public String toString() {
            return "MemberInfo{roles='" + this.roleString + '\'' + ", positions='" + this.positionString + '\'' + '}';
        }
    }

    public class MouseClickWatch
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                if (e.getSource() == PropertiesDialog.this.tagTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.tagTable.clearSelection();
                }
            } else if (e.getSource() == PropertiesDialog.this.tagTable) {
                int row = PropertiesDialog.this.tagTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    boolean focusOnKey = PropertiesDialog.this.tagTable.columnAtPoint(e.getPoint()) == 0;
                    PropertiesDialog.this.editHelper.editTag(row, focusOnKey);
                } else {
                    PropertiesDialog.this.editHelper.addTag();
                    PropertiesDialog.this.btnAdd.requestFocusInWindow();
                }
            } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                int row = PropertiesDialog.this.membershipTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    PropertiesDialog.this.editMembership(row);
                }
            } else {
                PropertiesDialog.this.editHelper.addTag();
                PropertiesDialog.this.btnAdd.requestFocusInWindow();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == PropertiesDialog.this.tagTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.tagTable.clearSelection();
            }
        }
    }
}

