/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Map;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.tagging.PresetHandler;
import org.openstreetmap.josm.gui.tagging.PresetLabel;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.tools.GBC;

public class PresetListPanel
extends JPanel {
    public PresetListPanel() {
        super(new GridBagLayout());
    }

    public void updatePresets(Collection<TaggingPresetType> types, Map<String, String> tags, final PresetHandler presetHandler) {
        this.removeAll();
        if (types.isEmpty()) {
            this.setVisible(false);
            return;
        }
        for (final TaggingPreset t : TaggingPreset.getMatchingPresets(types, tags, true)) {
            PresetLabel lbl = new PresetLabel(t);
            lbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Collection<OsmPrimitive> selection = t.createSelection(presetHandler.getSelection());
                    if (selection == null || selection.isEmpty()) {
                        return;
                    }
                    int answer = t.showDialog(selection, false);
                    if (answer == 1) {
                        presetHandler.updateTags(t.getChangedTags());
                    }
                }
            });
            this.add((Component)lbl, GBC.eol().fill(2));
        }
        if (this.getComponentCount() > 0) {
            this.setVisible(true);
            int height = this.getComponentCount() * this.getComponent(0).getHeight();
            Dimension size = new Dimension(this.getWidth(), height);
            this.setMaximumSize(size);
            this.setMinimumSize(size);
        } else {
            this.setVisible(false);
        }
    }
}

