/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetQueryTask
extends PleaseWaitRunnable
implements ChangesetDownloadTask {
    private ChangesetQuery query;
    private boolean canceled;
    private Set<Changeset> downloadedChangesets;
    private Exception lastException;
    private OsmServerUserInfoReader userInfoReader;
    private OsmServerChangesetReader changesetReader;

    public ChangesetQueryTask(ChangesetQuery query) throws IllegalArgumentException {
        super(I18n.tr("Querying and downloading changesets", false));
        CheckParameterUtil.ensureParameterNotNull(query, "query");
        this.query = query;
    }

    public ChangesetQueryTask(Component parent, ChangesetQuery query) throws IllegalArgumentException {
        super(parent, I18n.tr("Querying and downloading changesets", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(query, "query");
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ChangesetQueryTask changesetQueryTask = this;
        synchronized (changesetQueryTask) {
            if (this.userInfoReader != null) {
                this.userInfoReader.cancel();
            }
        }
        changesetQueryTask = this;
        synchronized (changesetQueryTask) {
            if (this.changesetReader != null) {
                this.changesetReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            GuiHelper.runInEDTAndWait(new Runnable(){
                private final Component parent;
                {
                    this.parent = ChangesetQueryTask.this.progressMonitor != null ? ChangesetQueryTask.this.progressMonitor.getWindowParent() : null;
                }

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(this.parent != null ? this.parent : Main.parent, ExceptionUtil.explainException(ChangesetQueryTask.this.lastException), I18n.tr("Errors during download", new Object[0]), 0);
                }
            });
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ChangesetCache.getInstance().update(ChangesetQueryTask.this.downloadedChangesets);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException e) {
                Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while updating changeset cache");
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    BugReportExceptionHandler.handleException(t);
                }
                if (t instanceof Exception) {
                    ExceptionUtil.explainException(e);
                }
                BugReportExceptionHandler.handleException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullyIdentifyCurrentUser() throws OsmTransferException {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Determine user id for current user...", new Object[0]));
        ChangesetQueryTask changesetQueryTask = this;
        synchronized (changesetQueryTask) {
            this.userInfoReader = new OsmServerUserInfoReader();
        }
        UserInfo info = this.userInfoReader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
        ChangesetQueryTask changesetQueryTask2 = this;
        synchronized (changesetQueryTask2) {
            this.userInfoReader = null;
        }
        JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
        im.setFullyIdentified(im.getUserName(), info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
            if (this.query.isRestrictedToPartiallyIdentifiedUser() && im.isCurrentUser(this.query.getUserName())) {
                if (im.isPartiallyIdentified()) {
                    this.fullyIdentifyCurrentUser();
                }
                this.query = this.query.forUser(JosmUserIdentityManager.getInstance().getUserId());
            }
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().indeterminateSubTask(I18n.tr("Query and download changesets ...", new Object[0]));
            ChangesetQueryTask changesetQueryTask = this;
            synchronized (changesetQueryTask) {
                this.changesetReader = new OsmServerChangesetReader();
            }
            this.downloadedChangesets = new HashSet<Changeset>();
            this.downloadedChangesets.addAll(this.changesetReader.queryChangesets(this.query, this.getProgressMonitor().createSubTaskMonitor(0, false)));
            changesetQueryTask = this;
            synchronized (changesetQueryTask) {
                this.changesetReader = null;
            }
        }
        catch (OsmTransferCanceledException e) {
            this.canceled = true;
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }

    @Override
    public Set<Changeset> getDownloadedChangesets() {
        return this.downloadedChangesets;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isFailed() {
        return this.lastException != null;
    }
}

