/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.BoundingBoxSelectionPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedChangesetQueryPanel
extends JPanel {
    private JCheckBox cbUserRestriction;
    private JCheckBox cbOpenAndCloseRestrictions;
    private JCheckBox cbTimeRestrictions;
    private JCheckBox cbBoundingBoxRestriction;
    private UserRestrictionPanel pnlUserRestriction;
    private OpenAndCloseStateRestrictionPanel pnlOpenAndCloseRestriction;
    private TimeRestrictionPanel pnlTimeRestriction;
    private BBoxRestrictionPanel pnlBoundingBoxRestriction;

    protected JPanel buildQueryPanel() {
        RestrictionGroupStateChangeHandler stateChangeHandler = new RestrictionGroupStateChangeHandler();
        VerticallyScrollablePanel pnl = new VerticallyScrollablePanel();
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.fill = 2;
        this.cbUserRestriction = new JCheckBox();
        pnl.add((Component)this.cbUserRestriction, gc);
        this.cbUserRestriction.addItemListener(stateChangeHandler);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Select changesets owned by specific users", new Object[0])), gc);
        gc.gridy = 1;
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.pnlUserRestriction = new UserRestrictionPanel();
        pnl.add((Component)this.pnlUserRestriction, gc);
        gc.gridy = 2;
        gc.gridx = 0;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.fill = 2;
        this.cbOpenAndCloseRestrictions = new JCheckBox();
        pnl.add((Component)this.cbOpenAndCloseRestrictions, gc);
        this.cbOpenAndCloseRestrictions.addItemListener(stateChangeHandler);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Select changesets depending on whether they are open or closed", new Object[0])), gc);
        gc.gridy = 3;
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.pnlOpenAndCloseRestriction = new OpenAndCloseStateRestrictionPanel();
        pnl.add((Component)this.pnlOpenAndCloseRestriction, gc);
        gc.gridy = 4;
        gc.gridx = 0;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.fill = 2;
        this.cbTimeRestrictions = new JCheckBox();
        pnl.add((Component)this.cbTimeRestrictions, gc);
        this.cbTimeRestrictions.addItemListener(stateChangeHandler);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Select changesets based on the date/time they have been created or closed", new Object[0])), gc);
        gc.gridy = 5;
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.pnlTimeRestriction = new TimeRestrictionPanel();
        pnl.add((Component)this.pnlTimeRestriction, gc);
        gc.gridy = 6;
        gc.gridx = 0;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.fill = 2;
        this.cbBoundingBoxRestriction = new JCheckBox();
        pnl.add((Component)this.cbBoundingBoxRestriction, gc);
        this.cbBoundingBoxRestriction.addItemListener(stateChangeHandler);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)new JMultilineLabel(I18n.tr("Select only changesets related to a specific bounding box", new Object[0])), gc);
        gc.gridy = 7;
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.pnlBoundingBoxRestriction = new BBoxRestrictionPanel();
        pnl.add((Component)this.pnlBoundingBoxRestriction, gc);
        gc.gridy = 8;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        JScrollPane spQueryPanel = GuiHelper.embedInVerticalScrollPane(this.buildQueryPanel());
        this.add((Component)spQueryPanel, "Center");
    }

    public AdvancedChangesetQueryPanel() {
        this.build();
    }

    public void startUserInput() {
        this.restoreFromSettings();
        this.pnlBoundingBoxRestriction.setVisible(this.cbBoundingBoxRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.setVisible(this.cbOpenAndCloseRestrictions.isSelected());
        this.pnlTimeRestriction.setVisible(this.cbTimeRestrictions.isSelected());
        this.pnlUserRestriction.setVisible(this.cbUserRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.startUserInput();
        this.pnlUserRestriction.startUserInput();
        this.pnlTimeRestriction.startUserInput();
    }

    public void displayMessageIfInvalid() {
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                this.pnlUserRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                this.pnlTimeRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbBoundingBoxRestriction.isSelected() && !this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
            this.pnlBoundingBoxRestriction.displayMessageIfInvalid();
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        ChangesetQuery query = new ChangesetQuery();
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlUserRestriction.fillInQuery(query);
        }
        if (this.cbOpenAndCloseRestrictions.isSelected()) {
            this.pnlOpenAndCloseRestriction.fillInQuery(query);
        }
        if (this.cbBoundingBoxRestriction.isSelected()) {
            if (!this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlBoundingBoxRestriction.fillInQuery(query);
        }
        if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlTimeRestriction.fillInQuery(query);
        }
        return query;
    }

    public void rememberSettings() {
        Main.pref.put("changeset-query.advanced.user-restrictions", this.cbUserRestriction.isSelected());
        Main.pref.put("changeset-query.advanced.open-restrictions", this.cbOpenAndCloseRestrictions.isSelected());
        Main.pref.put("changeset-query.advanced.time-restrictions", this.cbTimeRestrictions.isSelected());
        Main.pref.put("changeset-query.advanced.bbox-restrictions", this.cbBoundingBoxRestriction.isSelected());
        this.pnlUserRestriction.rememberSettings();
        this.pnlOpenAndCloseRestriction.rememberSettings();
        this.pnlTimeRestriction.rememberSettings();
    }

    public void restoreFromSettings() {
        this.cbUserRestriction.setSelected(Main.pref.getBoolean("changeset-query.advanced.user-restrictions", false));
        this.cbOpenAndCloseRestrictions.setSelected(Main.pref.getBoolean("changeset-query.advanced.open-restrictions", false));
        this.cbTimeRestrictions.setSelected(Main.pref.getBoolean("changeset-query.advanced.time-restrictions", false));
        this.cbBoundingBoxRestriction.setSelected(Main.pref.getBoolean("changeset-query.advanced.bbox-restrictions", false));
    }

    private static class TimeValidator
    extends AbstractTextComponentValidator {
        public static TimeValidator decorate(JTextComponent tc) {
            return new TimeValidator(tc);
        }

        public TimeValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public boolean isValid() {
            if (this.getComponent().getText().trim().length() == 0) {
                return true;
            }
            return this.getDate() != null;
        }

        public String getStandardTooltipTextAsHtml() {
            return "<html>" + this.getStandardTooltipText() + "</html>";
        }

        public String getStandardTooltipText() {
            Date date = new Date();
            return I18n.tr("Please enter a valid time in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateFormat.getTimeInstance(3, Locale.getDefault()).format(date), DateFormat.getTimeInstance(2, Locale.getDefault()).format(date), DateFormat.getTimeInstance(1, Locale.getDefault()).format(date), DateFormat.getTimeInstance(0, Locale.getDefault()).format(date));
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                String msg = "<html>The current value isn't a valid time.<br>" + this.getStandardTooltipText() + "</html>";
                this.feedbackInvalid(msg);
                return;
            }
            String msg = "<html>" + this.getStandardTooltipText() + "</html>";
            this.feedbackValid(msg);
        }

        public Date getDate() {
            if (this.getComponent().getText().trim().length() == 0) {
                return null;
            }
            for (int style : new int[]{3, 2, 1, 0}) {
                try {
                    return DateFormat.getTimeInstance(style, Locale.getDefault()).parse(this.getComponent().getText());
                }
                catch (ParseException e) {
                }
            }
            return null;
        }
    }

    private static class DateValidator
    extends AbstractTextComponentValidator {
        public static DateValidator decorate(JTextComponent tc) {
            return new DateValidator(tc);
        }

        public DateValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public boolean isValid() {
            return this.getDate() != null;
        }

        public String getStandardTooltipTextAsHtml() {
            return "<html>" + this.getStandardTooltipText() + "</html>";
        }

        public String getStandardTooltipText() {
            Date date = new Date();
            return I18n.tr("Please enter a date in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateFormat.getDateInstance(3, Locale.getDefault()).format(date), DateFormat.getDateInstance(2, Locale.getDefault()).format(date), DateFormat.getDateInstance(1, Locale.getDefault()).format(date), DateFormat.getDateInstance(0, Locale.getDefault()).format(date));
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                String msg = "<html>The current value isn't a valid date.<br>" + this.getStandardTooltipText() + "</html>";
                this.feedbackInvalid(msg);
                return;
            }
            String msg = "<html>" + this.getStandardTooltipText() + "</html>";
            this.feedbackValid(msg);
        }

        public Date getDate() {
            for (int format : new int[]{3, 2, 1, 0}) {
                DateFormat df = DateFormat.getDateInstance(format);
                try {
                    return df.parse(this.getComponent().getText());
                }
                catch (ParseException parseException) {
                }
            }
            return null;
        }
    }

    private static class UserNameInputValidator
    extends AbstractTextComponentValidator {
        public static UserNameInputValidator decorate(JTextComponent tc) {
            return new UserNameInputValidator(tc);
        }

        public UserNameInputValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public boolean isValid() {
            return this.getComponent().getText().trim().length() > 0;
        }

        @Override
        public void validate() {
            String value = this.getComponent().getText();
            if (value.trim().length() == 0) {
                this.feedbackInvalid(I18n.tr("<html>The  current value is not a valid user name.<br>Please enter an non-empty user name.</html>", new Object[0]));
                return;
            }
            this.feedbackValid(I18n.tr("Please enter an non-empty user name", new Object[0]));
        }
    }

    private static class UidInputFieldValidator
    extends AbstractTextComponentValidator {
        public static UidInputFieldValidator decorate(JTextComponent tc) {
            return new UidInputFieldValidator(tc);
        }

        public UidInputFieldValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public boolean isValid() {
            return this.getUid() > 0;
        }

        @Override
        public void validate() {
            String value = this.getComponent().getText();
            if (value == null || value.trim().length() == 0) {
                this.feedbackInvalid("");
                return;
            }
            try {
                int uid = Integer.parseInt(value);
                if (uid <= 0) {
                    this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
                return;
            }
            this.feedbackValid(I18n.tr("Please enter an integer value > 0", new Object[0]));
        }

        public int getUid() {
            String value = this.getComponent().getText();
            if (value == null || value.trim().length() == 0) {
                return 0;
            }
            try {
                int uid = Integer.parseInt(value.trim());
                if (uid > 0) {
                    return uid;
                }
                return 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }

    private static class BBoxRestrictionPanel
    extends BoundingBoxSelectionPanel {
        public BBoxRestrictionPanel() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        }

        public boolean isValidChangesetQuery() {
            return this.getBoundingBox() != null;
        }

        public void fillInQuery(ChangesetQuery query) {
            if (!this.isValidChangesetQuery()) {
                throw new IllegalStateException(I18n.tr("Cannot restrict the changeset query to a specific bounding box. The input is invalid.", new Object[0]));
            }
            query.inBbox(this.getBoundingBox());
        }

        public void displayMessageIfInvalid() {
            if (this.isValidChangesetQuery()) {
                return;
            }
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>Please enter valid longitude/latitude values to restrict<br>the changeset query to a specific bounding box.</html>", new Object[0]), I18n.tr("Invalid bounding box", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidBoundingBox"));
        }
    }

    private static class TimeRestrictionPanel
    extends JPanel {
        private JRadioButton rbClosedAfter;
        private JRadioButton rbClosedAfterAndCreatedBefore;
        private JosmTextField tfClosedAfterDate1;
        private DateValidator valClosedAfterDate1;
        private JosmTextField tfClosedAfterTime1;
        private TimeValidator valClosedAfterTime1;
        private JosmTextField tfClosedAfterDate2;
        private DateValidator valClosedAfterDate2;
        private JosmTextField tfClosedAfterTime2;
        private TimeValidator valClosedAfterTime2;
        private JosmTextField tfCreatedBeforeDate;
        private DateValidator valCreatedBeforeDate;
        private JosmTextField tfCreatedBeforeTime;
        private TimeValidator valCreatedBeforeTime;

        protected JPanel buildClosedAfterInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            pnl.add((Component)new JLabel(I18n.tr("Date: ", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 0.7;
            this.tfClosedAfterDate1 = new JosmTextField();
            pnl.add((Component)this.tfClosedAfterDate1, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate1);
            this.valClosedAfterDate1 = DateValidator.decorate(this.tfClosedAfterDate1);
            this.tfClosedAfterDate1.setToolTipText(this.valClosedAfterDate1.getStandardTooltipTextAsHtml());
            gc.gridx = 2;
            gc.weightx = 0.0;
            pnl.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gc);
            gc.gridx = 3;
            gc.weightx = 0.3;
            this.tfClosedAfterTime1 = new JosmTextField();
            pnl.add((Component)this.tfClosedAfterTime1, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime1);
            this.valClosedAfterTime1 = TimeValidator.decorate(this.tfClosedAfterTime1);
            this.tfClosedAfterTime1.setToolTipText(this.valClosedAfterTime1.getStandardTooltipTextAsHtml());
            return pnl;
        }

        protected JPanel buildClosedAfterAndCreatedBeforeInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            pnl.add((Component)new JLabel(I18n.tr("Closed after - ", new Object[0])), gc);
            gc.gridx = 1;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            pnl.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gc);
            gc.gridx = 2;
            gc.weightx = 0.7;
            this.tfClosedAfterDate2 = new JosmTextField();
            pnl.add((Component)this.tfClosedAfterDate2, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate2);
            this.valClosedAfterDate2 = DateValidator.decorate(this.tfClosedAfterDate2);
            this.tfClosedAfterDate2.setToolTipText(this.valClosedAfterDate2.getStandardTooltipTextAsHtml());
            gc.gridx = 3;
            gc.weightx = 0.0;
            pnl.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gc);
            gc.gridx = 4;
            gc.weightx = 0.3;
            this.tfClosedAfterTime2 = new JosmTextField();
            pnl.add((Component)this.tfClosedAfterTime2, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime2);
            this.valClosedAfterTime2 = TimeValidator.decorate(this.tfClosedAfterTime2);
            this.tfClosedAfterTime2.setToolTipText(this.valClosedAfterTime2.getStandardTooltipTextAsHtml());
            gc.gridy = 1;
            gc.gridx = 0;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            pnl.add((Component)new JLabel(I18n.tr("Created before - ", new Object[0])), gc);
            gc.gridx = 1;
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            pnl.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gc);
            gc.gridx = 2;
            gc.weightx = 0.7;
            this.tfCreatedBeforeDate = new JosmTextField();
            pnl.add((Component)this.tfCreatedBeforeDate, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeDate);
            this.valCreatedBeforeDate = DateValidator.decorate(this.tfCreatedBeforeDate);
            this.tfCreatedBeforeDate.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
            gc.gridx = 3;
            gc.weightx = 0.0;
            pnl.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gc);
            gc.gridx = 4;
            gc.weightx = 0.3;
            this.tfCreatedBeforeTime = new JosmTextField();
            pnl.add((Component)this.tfCreatedBeforeTime, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeTime);
            this.valCreatedBeforeTime = TimeValidator.decorate(this.tfCreatedBeforeTime);
            this.tfCreatedBeforeTime.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
            return pnl;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.gridx = 0;
            gc.fill = 2;
            gc.weightx = 0.0;
            this.rbClosedAfter = new JRadioButton();
            this.add((Component)this.rbClosedAfter, gc);
            gc.gridx = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after the following date/time", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)this.buildClosedAfterInputPanel(), gc);
            gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.gridy = 2;
            gc.gridx = 0;
            gc.fill = 2;
            gc.weightx = 0.0;
            this.rbClosedAfterAndCreatedBefore = new JRadioButton();
            this.add((Component)this.rbClosedAfterAndCreatedBefore, gc);
            gc.gridx = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after and created before a specific date/time", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 3;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)this.buildClosedAfterAndCreatedBeforeInputPanel(), gc);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbClosedAfter);
            bg.add(this.rbClosedAfterAndCreatedBefore);
            TimeRestrictionChangedHandler restrictionChangeHandler = new TimeRestrictionChangedHandler();
            this.rbClosedAfter.addItemListener(restrictionChangeHandler);
            this.rbClosedAfterAndCreatedBefore.addItemListener(restrictionChangeHandler);
            this.rbClosedAfter.setSelected(true);
        }

        public TimeRestrictionPanel() {
            this.build();
        }

        public boolean isValidChangesetQuery() {
            if (this.rbClosedAfter.isSelected()) {
                return this.valClosedAfterDate1.isValid() && this.valClosedAfterTime1.isValid();
            }
            if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
                return this.valClosedAfterDate2.isValid() && this.valClosedAfterTime2.isValid() && this.valCreatedBeforeDate.isValid() && this.valCreatedBeforeTime.isValid();
            }
            return true;
        }

        public void startUserInput() {
            this.restoreFromSettings();
        }

        public void fillInQuery(ChangesetQuery query) throws IllegalStateException {
            if (!this.isValidChangesetQuery()) {
                throw new IllegalStateException(I18n.tr("Cannot build changeset query with time based restrictions. Input is not valid.", new Object[0]));
            }
            if (this.rbClosedAfter.isSelected()) {
                GregorianCalendar cal = new GregorianCalendar();
                Date d1 = this.valClosedAfterDate1.getDate();
                Date d2 = this.valClosedAfterTime1.getDate();
                cal.setTimeInMillis(d1.getTime() + (d2 == null ? 0L : d2.getTime()));
                query.closedAfter(cal.getTime());
            } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
                GregorianCalendar cal = new GregorianCalendar();
                Date d1 = this.valClosedAfterDate2.getDate();
                Date d2 = this.valClosedAfterTime2.getDate();
                cal.setTimeInMillis(d1.getTime() + (d2 == null ? 0L : d2.getTime()));
                Date d3 = cal.getTime();
                d1 = this.valCreatedBeforeDate.getDate();
                d2 = this.valCreatedBeforeTime.getDate();
                cal.setTimeInMillis(d1.getTime() + (d2 == null ? 0L : d2.getTime()));
                Date d4 = cal.getTime();
                query.closedAfterAndCreatedBefore(d3, d4);
            }
        }

        public void displayMessageIfInvalid() {
            if (this.isValidChangesetQuery()) {
                return;
            }
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>Please enter valid date/time values to restrict<br>the query to a specific time range.</html>", new Object[0]), I18n.tr("Invalid date/time values", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidDateTimeValues"));
        }

        public void rememberSettings() {
            String prefRoot = "changeset-query.advanced.time-restrictions";
            if (this.rbClosedAfter.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "closed-after");
            } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "closed-after-created-before");
            }
            Main.pref.put(prefRoot + ".closed-after.date", this.tfClosedAfterDate1.getText());
            Main.pref.put(prefRoot + ".closed-after.time", this.tfClosedAfterTime1.getText());
            Main.pref.put(prefRoot + ".closed-created.closed.date", this.tfClosedAfterDate2.getText());
            Main.pref.put(prefRoot + ".closed-created.closed.time", this.tfClosedAfterTime2.getText());
            Main.pref.put(prefRoot + ".closed-created.created.date", this.tfCreatedBeforeDate.getText());
            Main.pref.put(prefRoot + ".closed-created.created.time", this.tfCreatedBeforeTime.getText());
        }

        public void restoreFromSettings() {
            String prefRoot = "changeset-query.advanced.open-restrictions";
            String v = Main.pref.get(prefRoot + ".query-type", "closed-after");
            this.rbClosedAfter.setSelected("closed-after".equals(v));
            this.rbClosedAfterAndCreatedBefore.setSelected("closed-after-created-before".equals(v));
            if (!this.rbClosedAfter.isSelected() && !this.rbClosedAfterAndCreatedBefore.isSelected()) {
                this.rbClosedAfter.setSelected(true);
            }
            this.tfClosedAfterDate1.setText(Main.pref.get(prefRoot + ".closed-after.date", ""));
            this.tfClosedAfterTime1.setText(Main.pref.get(prefRoot + ".closed-after.time", ""));
            this.tfClosedAfterDate2.setText(Main.pref.get(prefRoot + ".closed-created.closed.date", ""));
            this.tfClosedAfterTime2.setText(Main.pref.get(prefRoot + ".closed-created.closed.time", ""));
            this.tfCreatedBeforeDate.setText(Main.pref.get(prefRoot + ".closed-created.created.date", ""));
            this.tfCreatedBeforeTime.setText(Main.pref.get(prefRoot + ".closed-created.created.time", ""));
            if (!this.valClosedAfterDate1.isValid()) {
                this.tfClosedAfterDate1.setText("");
            }
            if (!this.valClosedAfterTime1.isValid()) {
                this.tfClosedAfterTime1.setText("");
            }
            if (!this.valClosedAfterDate2.isValid()) {
                this.tfClosedAfterDate2.setText("");
            }
            if (!this.valClosedAfterTime2.isValid()) {
                this.tfClosedAfterTime2.setText("");
            }
            if (!this.valCreatedBeforeDate.isValid()) {
                this.tfCreatedBeforeDate.setText("");
            }
            if (!this.valCreatedBeforeTime.isValid()) {
                this.tfCreatedBeforeTime.setText("");
            }
        }

        class TimeRestrictionChangedHandler
        implements ItemListener {
            TimeRestrictionChangedHandler() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                TimeRestrictionPanel.this.tfClosedAfterDate1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
                TimeRestrictionPanel.this.tfClosedAfterTime1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
                TimeRestrictionPanel.this.tfClosedAfterDate2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
                TimeRestrictionPanel.this.tfClosedAfterTime2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
                TimeRestrictionPanel.this.tfCreatedBeforeDate.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
                TimeRestrictionPanel.this.tfCreatedBeforeTime.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            }
        }
    }

    private static class UserRestrictionPanel
    extends JPanel {
        private ButtonGroup bgUserRestrictions;
        private JRadioButton rbRestrictToMyself;
        private JRadioButton rbRestrictToUid;
        private JRadioButton rbRestrictToUserName;
        private JosmTextField tfUid;
        private UidInputFieldValidator valUid;
        private JosmTextField tfUserName;
        private UserNameInputValidator valUserName;
        private JMultilineLabel lblRestrictedToMyself;

        protected JPanel buildUidInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            pnl.add((Component)new JLabel(I18n.tr("User ID:", new Object[0])), gc);
            gc.gridx = 1;
            this.tfUid = new JosmTextField(10);
            pnl.add((Component)this.tfUid, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfUid);
            this.valUid = UidInputFieldValidator.decorate(this.tfUid);
            gc.gridx = 2;
            gc.weightx = 1.0;
            pnl.add((Component)new JPanel(), gc);
            return pnl;
        }

        protected JPanel buildUserNameInputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 0.0;
            gc.insets = new Insets(0, 0, 0, 3);
            pnl.add((Component)new JLabel(I18n.tr("User name:", new Object[0])), gc);
            gc.gridx = 1;
            this.tfUserName = new JosmTextField(10);
            pnl.add((Component)this.tfUserName, gc);
            SelectAllOnFocusGainedDecorator.decorate(this.tfUserName);
            this.valUserName = UserNameInputValidator.decorate(this.tfUserName);
            gc.gridx = 2;
            gc.weightx = 1.0;
            pnl.add((Component)new JPanel(), gc);
            return pnl;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            UserRestrictionChangedHandler userRestrictionChangeHandler = new UserRestrictionChangedHandler();
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.gridx = 0;
            gc.fill = 2;
            gc.weightx = 0.0;
            this.rbRestrictToMyself = new JRadioButton();
            this.add((Component)this.rbRestrictToMyself, gc);
            this.rbRestrictToMyself.addItemListener(userRestrictionChangeHandler);
            gc.gridx = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.lblRestrictedToMyself = new JMultilineLabel(I18n.tr("Only changesets owned by myself", new Object[0]));
            this.add((Component)this.lblRestrictedToMyself, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 0.0;
            this.rbRestrictToUid = new JRadioButton();
            this.add((Component)this.rbRestrictToUid, gc);
            this.rbRestrictToUid.addItemListener(userRestrictionChangeHandler);
            gc.gridx = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets owned by the user with the following user ID", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 2;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)this.buildUidInputPanel(), gc);
            gc.gridx = 0;
            gc.gridy = 3;
            gc.fill = 2;
            gc.weightx = 0.0;
            this.rbRestrictToUserName = new JRadioButton();
            this.add((Component)this.rbRestrictToUserName, gc);
            this.rbRestrictToUserName.addItemListener(userRestrictionChangeHandler);
            gc.gridx = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets owned by the user with the following user name", new Object[0])), gc);
            gc.gridx = 1;
            gc.gridy = 4;
            gc.fill = 2;
            gc.weightx = 1.0;
            this.add((Component)this.buildUserNameInputPanel(), gc);
            this.bgUserRestrictions = new ButtonGroup();
            this.bgUserRestrictions.add(this.rbRestrictToMyself);
            this.bgUserRestrictions.add(this.rbRestrictToUid);
            this.bgUserRestrictions.add(this.rbRestrictToUserName);
        }

        public UserRestrictionPanel() {
            this.build();
        }

        public void startUserInput() {
            if (JosmUserIdentityManager.getInstance().isAnonymous()) {
                this.lblRestrictedToMyself.setText(I18n.tr("Only changesets owned by myself (disabled. JOSM is currently run by an anonymous user)", new Object[0]));
                this.rbRestrictToMyself.setEnabled(false);
                if (this.rbRestrictToMyself.isSelected()) {
                    this.rbRestrictToUid.setSelected(true);
                }
            } else {
                this.lblRestrictedToMyself.setText(I18n.tr("Only changesets owned by myself", new Object[0]));
                this.rbRestrictToMyself.setEnabled(true);
                this.rbRestrictToMyself.setSelected(true);
            }
            this.restoreFromSettings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fillInQuery(ChangesetQuery query) throws IllegalStateException, IllegalArgumentException {
            CheckParameterUtil.ensureParameterNotNull(query, "query");
            if (this.rbRestrictToMyself.isSelected()) {
                JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
                if (im.isPartiallyIdentified()) {
                    query.forUser(im.getUserName());
                    return;
                } else {
                    if (!im.isFullyIdentified()) throw new IllegalStateException(I18n.tr("Cannot restrict changeset query to the current user because the current user is anonymous", new Object[0]));
                    query.forUser(im.getUserId());
                }
                return;
            } else if (this.rbRestrictToUid.isSelected()) {
                int uid = this.valUid.getUid();
                if (uid <= 0) throw new IllegalStateException(I18n.tr("Current value ''{0}'' for user ID is not valid", this.tfUid.getText()));
                query.forUser(uid);
                return;
            } else {
                if (!this.rbRestrictToUserName.isSelected()) return;
                if (!this.valUserName.isValid()) {
                    throw new IllegalStateException(I18n.tr("Cannot restrict the changeset query to the user name ''{0}''", this.tfUserName.getText()));
                }
                query.forUser(this.tfUserName.getText());
            }
        }

        public boolean isValidChangesetQuery() {
            if (this.rbRestrictToUid.isSelected()) {
                return this.valUid.isValid();
            }
            if (this.rbRestrictToUserName.isSelected()) {
                return this.valUserName.isValid();
            }
            return true;
        }

        protected void alertInvalidUid() {
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("Please enter a valid user ID", new Object[0]), I18n.tr("Invalid user ID", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidUserId"));
        }

        protected void alertInvalidUserName() {
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("Please enter a non-empty user name", new Object[0]), I18n.tr("Invalid user name", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidUserName"));
        }

        public void displayMessageIfInvalid() {
            if (this.rbRestrictToUid.isSelected()) {
                if (!this.valUid.isValid()) {
                    this.alertInvalidUid();
                }
            } else if (this.rbRestrictToUserName.isSelected() && !this.valUserName.isValid()) {
                this.alertInvalidUserName();
            }
        }

        public void rememberSettings() {
            String prefRoot = "changeset-query.advanced.user-restrictions";
            if (this.rbRestrictToMyself.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "mine");
            } else if (this.rbRestrictToUid.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "uid");
            } else if (this.rbRestrictToUserName.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "username");
            }
            Main.pref.put(prefRoot + ".uid", this.tfUid.getText());
            Main.pref.put(prefRoot + ".username", this.tfUserName.getText());
        }

        public void restoreFromSettings() {
            String prefRoot = "changeset-query.advanced.user-restrictions";
            String v = Main.pref.get(prefRoot + ".query-type", "mine");
            if ("mine".equals(v)) {
                JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
                if (im.isAnonymous()) {
                    this.rbRestrictToUid.setSelected(true);
                } else {
                    this.rbRestrictToMyself.setSelected(true);
                }
            } else if ("uid".equals(v)) {
                this.rbRestrictToUid.setSelected(true);
            } else if ("username".equals(v)) {
                this.rbRestrictToUserName.setSelected(true);
            }
            this.tfUid.setText(Main.pref.get(prefRoot + ".uid", ""));
            if (!this.valUid.isValid()) {
                this.tfUid.setText("");
            }
            this.tfUserName.setText(Main.pref.get(prefRoot + ".username", ""));
        }

        class UserRestrictionChangedHandler
        implements ItemListener {
            UserRestrictionChangedHandler() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                UserRestrictionPanel.this.tfUid.setEnabled(UserRestrictionPanel.this.rbRestrictToUid.isSelected());
                UserRestrictionPanel.this.tfUserName.setEnabled(UserRestrictionPanel.this.rbRestrictToUserName.isSelected());
                if (UserRestrictionPanel.this.rbRestrictToUid.isSelected()) {
                    UserRestrictionPanel.this.tfUid.requestFocusInWindow();
                } else if (UserRestrictionPanel.this.rbRestrictToUserName.isSelected()) {
                    UserRestrictionPanel.this.tfUserName.requestFocusInWindow();
                }
            }
        }
    }

    private static class OpenAndCloseStateRestrictionPanel
    extends JPanel {
        private JRadioButton rbOpenOnly;
        private JRadioButton rbClosedOnly;
        private JRadioButton rbBoth;

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 2;
            gc.weightx = 0.0;
            this.rbOpenOnly = new JRadioButton();
            this.add((Component)this.rbOpenOnly, gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Query open changesets only", new Object[0])), gc);
            gc.gridy = 1;
            gc.gridx = 0;
            gc.weightx = 0.0;
            this.rbClosedOnly = new JRadioButton();
            this.add((Component)this.rbClosedOnly, gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Query closed changesets only", new Object[0])), gc);
            gc.gridy = 2;
            gc.gridx = 0;
            gc.weightx = 0.0;
            this.rbBoth = new JRadioButton();
            this.add((Component)this.rbBoth, gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Query both open and closed changesets", new Object[0])), gc);
            ButtonGroup bgRestrictions = new ButtonGroup();
            bgRestrictions.add(this.rbBoth);
            bgRestrictions.add(this.rbClosedOnly);
            bgRestrictions.add(this.rbOpenOnly);
        }

        public OpenAndCloseStateRestrictionPanel() {
            this.build();
        }

        public void startUserInput() {
            this.restoreFromSettings();
        }

        public void fillInQuery(ChangesetQuery query) {
            if (this.rbBoth.isSelected()) {
                query.beingClosed(true);
                query.beingOpen(true);
            } else if (this.rbOpenOnly.isSelected()) {
                query.beingOpen(true);
            } else if (this.rbClosedOnly.isSelected()) {
                query.beingClosed(true);
            }
        }

        public void rememberSettings() {
            String prefRoot = "changeset-query.advanced.open-restrictions";
            if (this.rbBoth.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "both");
            } else if (this.rbOpenOnly.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "open");
            } else if (this.rbClosedOnly.isSelected()) {
                Main.pref.put(prefRoot + ".query-type", "closed");
            }
        }

        public void restoreFromSettings() {
            String prefRoot = "changeset-query.advanced.open-restrictions";
            String v = Main.pref.get(prefRoot + ".query-type", "open");
            this.rbBoth.setSelected("both".equals(v));
            this.rbOpenOnly.setSelected("open".equals(v));
            this.rbClosedOnly.setSelected("closed".equals(v));
        }
    }

    class RestrictionGroupStateChangeHandler
    implements ItemListener {
        RestrictionGroupStateChangeHandler() {
        }

        protected void userRestrictionStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlUserRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlUserRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbUserRestriction.isSelected());
        }

        protected void openCloseRestrictionStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlOpenAndCloseRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlOpenAndCloseRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions.isSelected());
        }

        protected void timeRestrictionsStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlTimeRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlTimeRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbTimeRestrictions.isSelected());
        }

        protected void boundingBoxRestrictionChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlBoundingBoxRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlBoundingBoxRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction.isSelected());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == AdvancedChangesetQueryPanel.this.cbUserRestriction) {
                this.userRestrictionStateChanged();
            } else if (e.getSource() == AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions) {
                this.openCloseRestrictionStateChanged();
            } else if (e.getSource() == AdvancedChangesetQueryPanel.this.cbTimeRestrictions) {
                this.timeRestrictionsStateChanged();
            } else if (e.getSource() == AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction) {
                this.boundingBoxRestrictionChanged();
            }
            AdvancedChangesetQueryPanel.this.validate();
            AdvancedChangesetQueryPanel.this.repaint();
        }
    }
}

