/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.widgets.ChangesetIdTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;

public class SingleChangesetDownloadPanel
extends JPanel {
    private ChangesetIdTextField tfChangesetId;
    private DownloadAction actDownload;

    protected void build() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        this.add(new JLabel(I18n.tr("Changeset ID: ", new Object[0])));
        this.tfChangesetId = new ChangesetIdTextField();
        this.add(this.tfChangesetId);
        this.tfChangesetId.setToolTipText(I18n.tr("Enter a changeset id", new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate(this.tfChangesetId);
        this.actDownload = new DownloadAction();
        SideButton btn = new SideButton(this.actDownload);
        this.tfChangesetId.addActionListener(this.actDownload);
        this.tfChangesetId.getDocument().addDocumentListener(this.actDownload);
        this.add(btn);
        if (Main.pref.getBoolean("downloadchangeset.autopaste", true)) {
            this.tfChangesetId.tryToPasteFromClipboard();
        }
    }

    public SingleChangesetDownloadPanel() {
        this.build();
    }

    public int getChangesetId() {
        return this.tfChangesetId.getChangesetId();
    }

    class DownloadAction
    extends AbstractAction
    implements DocumentListener {
        public DownloadAction() {
            this.putValue("SmallIcon", ChangesetCacheManager.DOWNLOAD_CONTENT_ICON);
            this.putValue("ShortDescription", I18n.tr("Download the changeset with the specified id, including the changeset content", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.isEnabled()) {
                return;
            }
            int id = SingleChangesetDownloadPanel.this.getChangesetId();
            if (id == 0) {
                return;
            }
            ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)SingleChangesetDownloadPanel.this, Collections.singleton(id));
            ChangesetCacheManager.getInstance().runDownloadTask(task);
        }

        protected void updateEnabledState() {
            this.setEnabled(SingleChangesetDownloadPanel.this.tfChangesetId.readIds() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }
    }
}

