/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetListCellRenderer
extends JLabel
implements ListCellRenderer<Changeset> {
    public ChangesetListCellRenderer() {
        this.setOpaque(true);
        this.setIcon(ImageProvider.get("data", "changeset"));
    }

    protected void renderColors(boolean selected) {
        if (selected) {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
        }
    }

    protected void renderLabel(Changeset cs) {
        StringBuilder sb = new StringBuilder();
        if (cs.isIncomplete()) {
            sb.append(I18n.tr("{0} [incomplete]", cs.getId()));
        } else {
            String comment = cs.get("comment");
            sb.append(cs.getId());
            sb.append(" - ");
            sb.append(cs.isOpen() ? I18n.tr("open", new Object[0]) : I18n.tr("closed", new Object[0]));
            if (comment != null) {
                sb.append(" - ").append("'").append(comment).append("'");
            }
        }
        this.setText(sb.toString());
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Changeset> list, Changeset cs, int index, boolean isSelected, boolean cellHasFocus) {
        this.renderColors(isSelected);
        this.renderLabel(cs);
        return this;
    }
}

