/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetDetailPanel
extends JPanel
implements PropertyChangeListener {
    private final JosmTextField tfID = new JosmTextField(10);
    private final JosmTextArea taComment = new JosmTextArea(5, 40);
    private final JosmTextField tfOpen = new JosmTextField(10);
    private final JosmTextField tfUser = new JosmTextField("");
    private final JosmTextField tfCreatedOn = new JosmTextField(20);
    private final JosmTextField tfClosedOn = new JosmTextField(20);
    private final DownloadChangesetContentAction actDownloadChangesetContent = new DownloadChangesetContentAction();
    private final UpdateChangesetAction actUpdateChangesets = new UpdateChangesetAction();
    private final RemoveFromCacheAction actRemoveFromCache = new RemoveFromCacheAction();
    private final SelectInCurrentLayerAction actSelectInCurrentLayer = new SelectInCurrentLayerAction();
    private final ZoomInCurrentLayerAction actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
    private Changeset current = null;

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        tb.add(this.actRemoveFromCache);
        this.actRemoveFromCache.initProperties(this.current);
        tb.add(this.actUpdateChangesets);
        this.actUpdateChangesets.initProperties(this.current);
        tb.add(this.actDownloadChangesetContent);
        this.actDownloadChangesetContent.initProperties(this.current);
        tb.add(this.actSelectInCurrentLayer);
        MapView.addEditLayerChangeListener(this.actSelectInCurrentLayer);
        tb.add(this.actZoomInCurrentLayerAction);
        MapView.addEditLayerChangeListener(this.actZoomInCurrentLayerAction);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                MapView.removeEditLayerChangeListener(ChangesetDetailPanel.this.actSelectInCurrentLayer);
                MapView.removeEditLayerChangeListener(ChangesetDetailPanel.this.actZoomInCurrentLayerAction);
            }
        });
        pnl.add(tb);
        return pnl;
    }

    protected JPanel buildDetailViewPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 23;
        gc.insets = new Insets(0, 0, 2, 3);
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("ID:", new Object[0])), gc);
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.gridx = 1;
        pnl.add((Component)this.tfID, gc);
        this.tfID.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Comment:", new Object[0])), gc);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridx = 1;
        pnl.add((Component)this.taComment, gc);
        this.taComment.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Open/Closed:", new Object[0])), gc);
        gc.fill = 2;
        gc.gridx = 1;
        pnl.add((Component)this.tfOpen, gc);
        this.tfOpen.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 3;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Created by:", new Object[0])), gc);
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridx = 1;
        pnl.add((Component)this.tfUser, gc);
        this.tfUser.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Created on:", new Object[0])), gc);
        gc.fill = 2;
        gc.gridx = 1;
        pnl.add((Component)this.tfCreatedOn, gc);
        this.tfCreatedOn.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 5;
        gc.fill = 2;
        gc.weightx = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Closed on:", new Object[0])), gc);
        gc.fill = 2;
        gc.gridx = 1;
        pnl.add((Component)this.tfClosedOn, gc);
        this.tfClosedOn.setEditable(false);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildDetailViewPanel(), "Center");
        this.add((Component)this.buildActionButtonPanel(), "West");
    }

    protected void clearView() {
        this.tfID.setText("");
        this.taComment.setText("");
        this.tfOpen.setText("");
        this.tfUser.setText("");
        this.tfCreatedOn.setText("");
        this.tfClosedOn.setText("");
    }

    protected void updateView(Changeset cs) {
        if (cs == null) {
            return;
        }
        this.tfID.setText(Integer.toString(cs.getId()));
        String comment = cs.get("comment");
        this.taComment.setText(comment == null ? "" : comment);
        String msg = cs.isOpen() ? I18n.trc("changeset.state", "Open") : I18n.trc("changeset.state", "Closed");
        this.tfOpen.setText(msg);
        msg = cs.getUser() == null ? I18n.tr("anonymous", new Object[0]) : cs.getUser().getName();
        this.tfUser.setText(msg);
        DateFormat sdf = DateUtils.getDateTimeFormat(3, 3);
        this.tfCreatedOn.setText(cs.getCreatedAt() == null ? "" : sdf.format(cs.getCreatedAt()));
        this.tfClosedOn.setText(cs.getClosedAt() == null ? "" : sdf.format(cs.getClosedAt()));
    }

    public ChangesetDetailPanel() {
        this.build();
    }

    protected void setCurrentChangeset(Changeset cs) {
        this.current = cs;
        if (cs == null) {
            this.clearView();
        } else {
            this.updateView(cs);
        }
        this.actDownloadChangesetContent.initProperties(this.current);
        this.actUpdateChangesets.initProperties(this.current);
        this.actRemoveFromCache.initProperties(this.current);
        this.actSelectInCurrentLayer.updateEnabledState();
        this.actZoomInCurrentLayerAction.updateEnabledState();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        this.setCurrentChangeset((Changeset)evt.getNewValue());
    }

    class ZoomInCurrentLayerAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        public ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.putValue("ShortDescription", I18n.tr("Zoom to the objects in the content of this changeset in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToZoomTo() {
            HelpAwareOptionPane.showOptionDialog(ChangesetDetailPanel.this, I18n.tr("<html>None of the objects in the content of changeset {0} is available in the current<br>edit layer ''{1}''.</html>", ChangesetDetailPanel.this.current.getId(), Main.main.getEditLayer().getName()), I18n.tr("Nothing to zoom to", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || !Main.main.hasEditLayer()) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            HashSet<OsmPrimitive> target = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : layer.data.allPrimitives()) {
                if (!p.isUsable() || p.getChangesetId() != ChangesetDetailPanel.this.current.getId()) continue;
                target.add(p);
            }
            if (target.isEmpty()) {
                this.alertNoPrimitivesToZoomTo();
                return;
            }
            layer.data.setSelected(target);
            AutoScaleAction.zoomToSelection();
        }

        public void updateEnabledState() {
            if (Main.main == null || !Main.main.hasEditLayer()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetDetailPanel.this.current != null);
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    class SelectInCurrentLayerAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        public SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.putValue("ShortDescription", I18n.tr("Select the primitives in the content of this changeset in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        protected void alertNoPrimitivesToSelect(Collection<OsmPrimitive> primitives) {
            HelpAwareOptionPane.showOptionDialog(ChangesetDetailPanel.this, I18n.tr("<html>None of the objects in the content of changeset {0} is available in the current<br>edit layer ''{1}''.</html>", ChangesetDetailPanel.this.current.getId(), Main.main.getEditLayer().getName()), I18n.tr("Nothing to select", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || !Main.main.hasEditLayer()) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            HashSet<OsmPrimitive> target = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : layer.data.allPrimitives()) {
                if (!p.isUsable() || p.getChangesetId() != ChangesetDetailPanel.this.current.getId()) continue;
                target.add(p);
            }
            if (target.isEmpty()) {
                this.alertNoPrimitivesToSelect(target);
                return;
            }
            layer.data.setSelected(target);
        }

        public void updateEnabledState() {
            if (Main.main == null || !Main.main.hasEditLayer()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetDetailPanel.this.current != null);
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    class UpdateChangesetAction
    extends AbstractAction {
        public UpdateChangesetAction() {
            this.putValue("Name", I18n.tr("Update changeset", new Object[0]));
            this.putValue("SmallIcon", ChangesetCacheManager.UPDATE_CONTENT_ICON);
            this.putValue("ShortDescription", I18n.tr("Update the changeset from the OSM server", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDetailPanel.this.current == null) {
                return;
            }
            Main.worker.submit(new ChangesetHeaderDownloadTask(ChangesetDetailPanel.this, Collections.singleton(ChangesetDetailPanel.this.current.getId())));
        }

        public void initProperties(Changeset cs) {
            this.setEnabled(cs != null && !Main.isOffline(OnlineResource.OSM_API));
        }
    }

    class DownloadChangesetContentAction
    extends AbstractAction {
        public DownloadChangesetContentAction() {
            this.putValue("Name", I18n.tr("Download content", new Object[0]));
            this.putValue("SmallIcon", ChangesetCacheManager.DOWNLOAD_CONTENT_ICON);
            this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDetailPanel.this.current == null) {
                return;
            }
            ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)ChangesetDetailPanel.this, ChangesetDetailPanel.this.current.getId());
            ChangesetCacheManager.getInstance().runDownloadTask(task);
        }

        public void initProperties(Changeset cs) {
            if (cs == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            if (cs.getContent() == null) {
                this.putValue("Name", I18n.tr("Download content", new Object[0]));
                this.putValue("SmallIcon", ChangesetCacheManager.DOWNLOAD_CONTENT_ICON);
                this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Update content", new Object[0]));
                this.putValue("SmallIcon", ChangesetCacheManager.UPDATE_CONTENT_ICON);
                this.putValue("ShortDescription", I18n.tr("Update the changeset content from the OSM server", new Object[0]));
            }
        }
    }

    class RemoveFromCacheAction
    extends AbstractAction {
        public RemoveFromCacheAction() {
            this.putValue("Name", I18n.tr("Remove from cache", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Remove the changeset in the detail view panel from the local cache", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetDetailPanel.this.current == null) {
                return;
            }
            ChangesetCache.getInstance().remove(ChangesetDetailPanel.this.current);
        }

        public void initProperties(Changeset cs) {
            this.setEnabled(cs != null);
        }
    }
}

