/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;

public class ChangesetContentTableModel
extends AbstractTableModel {
    private final List<ChangesetContentEntry> data = new ArrayList<ChangesetContentEntry>();
    private DefaultListSelectionModel selectionModel;

    public ChangesetContentTableModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public boolean hasSelectedPrimitives() {
        return this.selectionModel.getMinSelectionIndex() >= 0;
    }

    public void setSelectedByIdx(int row) {
        this.selectionModel.setSelectionInterval(row, row);
    }

    public DefaultListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Set<HistoryOsmPrimitive> getSelectedPrimitives() {
        HashSet<HistoryOsmPrimitive> ret = new HashSet<HistoryOsmPrimitive>();
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ret.add(this.data.get(i).getPrimitive());
        }
        return ret;
    }

    public void populate(ChangesetDataSet ds) {
        this.data.clear();
        if (ds == null) {
            this.fireTableDataChanged();
            return;
        }
        Iterator<ChangesetDataSet.ChangesetDataSetEntry> it = ds.iterator();
        while (it.hasNext()) {
            this.data.add(new ChangesetContentEntry(it.next()));
        }
        this.sort();
        this.fireTableDataChanged();
    }

    protected void sort() {
        Collections.sort(this.data, new Comparator<ChangesetDataSet.ChangesetDataSetEntry>(){

            @Override
            public int compare(ChangesetDataSet.ChangesetDataSetEntry c1, ChangesetDataSet.ChangesetDataSetEntry c2) {
                if (c1.getModificationType().equals((Object)c2.getModificationType())) {
                    long id2;
                    long id1 = c1.getPrimitive().getId();
                    if (id1 == (id2 = c2.getPrimitive().getId())) {
                        return 0;
                    }
                    if (id1 < id2) {
                        return -1;
                    }
                    return 1;
                }
                switch (c1.getModificationType()) {
                    case CREATED: {
                        return -1;
                    }
                    case UPDATED: {
                        switch (c2.getModificationType()) {
                            case CREATED: {
                                return 1;
                            }
                        }
                        return -1;
                    }
                    case DELETED: {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.data.get(row).getModificationType();
            }
        }
        return this.data.get(row).getPrimitive();
    }

    private static class ChangesetContentEntry
    implements ChangesetDataSet.ChangesetDataSetEntry {
        private final ChangesetDataSet.ChangesetModificationType modificationType;
        private final HistoryOsmPrimitive primitive;

        public ChangesetContentEntry(ChangesetDataSet.ChangesetModificationType modificationType, HistoryOsmPrimitive primitive) {
            this.modificationType = modificationType;
            this.primitive = primitive;
        }

        public ChangesetContentEntry(ChangesetDataSet.ChangesetDataSetEntry entry) {
            this(entry.getModificationType(), entry.getPrimitive());
        }

        @Override
        public ChangesetDataSet.ChangesetModificationType getModificationType() {
            return this.modificationType;
        }

        @Override
        public HistoryOsmPrimitive getPrimitive() {
            return this.primitive;
        }
    }
}

