/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableModel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetContentPanel
extends JPanel
implements PropertyChangeListener {
    private ChangesetContentTableModel model;
    private Changeset currentChangeset;
    private DownloadChangesetContentAction actDownloadContentAction;
    private ShowHistoryAction actShowHistory;
    private SelectInCurrentLayerAction actSelectInCurrentLayerAction;
    private ZoomInCurrentLayerAction actZoomInCurrentLayerAction;
    private final HeaderPanel pnlHeader = new HeaderPanel();

    protected void buildModels() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new ChangesetContentTableModel(selectionModel);
        this.actDownloadContentAction = new DownloadChangesetContentAction();
        this.actDownloadContentAction.initProperties(this.currentChangeset);
        this.actShowHistory = new ShowHistoryAction();
        this.model.getSelectionModel().addListSelectionListener(this.actShowHistory);
        this.actSelectInCurrentLayerAction = new SelectInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actSelectInCurrentLayerAction);
        MapView.addEditLayerChangeListener(this.actSelectInCurrentLayerAction);
        this.actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actZoomInCurrentLayerAction);
        MapView.addEditLayerChangeListener(this.actZoomInCurrentLayerAction);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                MapView.removeEditLayerChangeListener(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
                MapView.removeEditLayerChangeListener(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
            }
        });
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JTable tblContent = new JTable(this.model, new ChangesetContentTableColumnModel(), this.model.getSelectionModel());
        tblContent.addMouseListener(new PopupMenuLauncher(new ChangesetContentTablePopupMenu()));
        pnl.add((Component)new JScrollPane(tblContent), "Center");
        return pnl;
    }

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        tb.add(this.actDownloadContentAction);
        tb.add(this.actShowHistory);
        tb.add(this.actSelectInCurrentLayerAction);
        tb.add(this.actZoomInCurrentLayerAction);
        pnl.add(tb);
        return pnl;
    }

    protected final void build() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.buildModels();
        this.add((Component)this.pnlHeader, "North");
        this.add((Component)this.buildActionButtonPanel(), "West");
        this.add((Component)this.buildContentPanel(), "Center");
    }

    public ChangesetContentPanel() {
        this.build();
    }

    public ChangesetContentTableModel getModel() {
        return this.model;
    }

    protected void setCurrentChangeset(Changeset cs) {
        this.currentChangeset = cs;
        if (cs == null) {
            this.model.populate(null);
        } else {
            this.model.populate(cs.getContent());
        }
        this.actDownloadContentAction.initProperties(cs);
        this.pnlHeader.setChangeset(cs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        Changeset cs = (Changeset)evt.getNewValue();
        this.setCurrentChangeset(cs);
    }

    private final void alertNoPrimitivesTo(Collection<HistoryOsmPrimitive> primitives, String title, String helpTopic) {
        HelpAwareOptionPane.showOptionDialog(this, I18n.trn("<html>The selected object is not available in the current<br>edit layer ''{0}''.</html>", "<html>None of the selected objects is available in the current<br>edit layer ''{0}''.</html>", primitives.size(), Main.main.getEditLayer().getName()), title, 2, helpTopic);
    }

    private static class HeaderPanel
    extends JPanel {
        private JMultilineLabel lblMessage;
        private Changeset current;

        protected final void build() {
            this.setLayout(new FlowLayout(0));
            this.lblMessage = new JMultilineLabel(I18n.tr("The content of this changeset is not downloaded yet.", new Object[0]));
            this.add(this.lblMessage);
            this.add(new JButton(new DownloadAction()));
        }

        public HeaderPanel() {
            this.build();
        }

        public void setChangeset(Changeset cs) {
            this.setVisible(cs != null && cs.getContent() == null);
            this.current = cs;
        }

        private class DownloadAction
        extends AbstractAction {
            public DownloadAction() {
                this.putValue("Name", I18n.tr("Download now", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Download the changeset content", new Object[0]));
                this.putValue("SmallIcon", ChangesetCacheManager.DOWNLOAD_CONTENT_ICON);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (HeaderPanel.this.current == null) {
                    return;
                }
                ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)HeaderPanel.this, HeaderPanel.this.current.getId());
                ChangesetCacheManager.getInstance().runDownloadTask(task);
            }
        }
    }

    class ZoomInCurrentLayerAction
    extends AbstractAction
    implements ListSelectionListener,
    MapView.EditLayerChangeListener {
        public ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.putValue("ShortDescription", I18n.tr("Zoom to the corresponding objects in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || !Main.main.hasEditLayer()) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            Set<HistoryOsmPrimitive> selected = ChangesetContentPanel.this.model.getSelectedPrimitives();
            HashSet<OsmPrimitive> target = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive p : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive op = layer.data.getPrimitiveById(p.getPrimitiveId());
                if (op == null) continue;
                target.add(op);
            }
            if (target.isEmpty()) {
                ChangesetContentPanel.this.alertNoPrimitivesTo(selected, I18n.tr("Nothing to zoom to", new Object[0]), HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
                return;
            }
            layer.data.setSelected(target);
            AutoScaleAction.zoomToSelection();
        }

        public final void updateEnabledState() {
            if (Main.main == null || !Main.main.hasEditLayer()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    class SelectInCurrentLayerAction
    extends AbstractAction
    implements ListSelectionListener,
    MapView.EditLayerChangeListener {
        public SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.putValue("ShortDescription", I18n.tr("Select the corresponding primitives in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!this.isEnabled()) {
                return;
            }
            if (Main.main == null || !Main.main.hasEditLayer()) {
                return;
            }
            OsmDataLayer layer = Main.main.getEditLayer();
            Set<HistoryOsmPrimitive> selected = ChangesetContentPanel.this.model.getSelectedPrimitives();
            HashSet<OsmPrimitive> target = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive p : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive op = layer.data.getPrimitiveById(p.getPrimitiveId());
                if (op == null) continue;
                target.add(op);
            }
            if (target.isEmpty()) {
                ChangesetContentPanel.this.alertNoPrimitivesTo(selected, I18n.tr("Nothing to select", new Object[0]), HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
                return;
            }
            layer.data.setSelected(target);
        }

        public final void updateEnabledState() {
            if (Main.main == null || !Main.main.hasEditLayer()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        public ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.putValue("ShortDescription", I18n.tr("Download and show the history of the selected objects", new Object[0]));
            this.updateEnabledState();
        }

        protected List<HistoryOsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<HistoryOsmPrimitive> primitives) {
            ArrayList<HistoryOsmPrimitive> ret = new ArrayList<HistoryOsmPrimitive>(primitives.size());
            for (HistoryOsmPrimitive p : primitives) {
                if (HistoryDataSet.getInstance().getHistory(p.getPrimitiveId()) != null) continue;
                ret.add(p);
            }
            return ret;
        }

        public void showHistory(Collection<HistoryOsmPrimitive> primitives) {
            List<HistoryOsmPrimitive> toLoad = this.filterPrimitivesWithUnloadedHistory(primitives);
            if (!toLoad.isEmpty()) {
                HistoryLoadTask task = new HistoryLoadTask(ChangesetContentPanel.this);
                for (HistoryOsmPrimitive p : toLoad) {
                    task.add(p);
                }
                Main.worker.submit(task);
            }
            Main.worker.submit(new ShowHistoryTask(primitives));
        }

        protected final void updateEnabledState() {
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Set<HistoryOsmPrimitive> selected = ChangesetContentPanel.this.model.getSelectedPrimitives();
            if (selected.isEmpty()) {
                return;
            }
            this.showHistory(selected);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        private final class ShowHistoryTask
        implements Runnable {
            private final Collection<HistoryOsmPrimitive> primitives;

            private ShowHistoryTask(Collection<HistoryOsmPrimitive> primitives) {
                this.primitives = primitives;
            }

            @Override
            public void run() {
                try {
                    for (HistoryOsmPrimitive p : this.primitives) {
                        final History h = HistoryDataSet.getInstance().getHistory(p.getPrimitiveId());
                        if (h == null) continue;
                        GuiHelper.runInEDT(new Runnable(){

                            @Override
                            public void run() {
                                HistoryBrowserDialogManager.getInstance().show(h);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            BugReportExceptionHandler.handleException(e);
                        }
                    });
                }
            }
        }
    }

    class ChangesetContentTablePopupMenu
    extends JPopupMenu {
        public ChangesetContentTablePopupMenu() {
            this.add(ChangesetContentPanel.this.actDownloadContentAction);
            this.add(ChangesetContentPanel.this.actShowHistory);
            this.add(new JSeparator());
            this.add(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
            this.add(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
        }
    }

    class DownloadChangesetContentAction
    extends AbstractAction {
        public DownloadChangesetContentAction() {
            this.putValue("Name", I18n.tr("Download content", new Object[0]));
            this.putValue("SmallIcon", ChangesetCacheManager.DOWNLOAD_CONTENT_ICON);
            this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (ChangesetContentPanel.this.currentChangeset == null) {
                return;
            }
            ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)ChangesetContentPanel.this, ChangesetContentPanel.this.currentChangeset.getId());
            ChangesetCacheManager.getInstance().runDownloadTask(task);
        }

        public void initProperties(Changeset cs) {
            if (cs == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            if (cs.getContent() == null) {
                this.putValue("Name", I18n.tr("Download content", new Object[0]));
                this.putValue("SmallIcon", ChangesetCacheManager.DOWNLOAD_CONTENT_ICON);
                this.putValue("ShortDescription", I18n.tr("Download the changeset content from the OSM server", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Update content", new Object[0]));
                this.putValue("SmallIcon", ChangesetCacheManager.UPDATE_CONTENT_ICON);
                this.putValue("ShortDescription", I18n.tr("Update the changeset content from the OSM server", new Object[0]));
            }
        }
    }
}

