/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetContentDownloadTask
extends PleaseWaitRunnable
implements ChangesetDownloadTask {
    private final List<Integer> toDownload = new ArrayList<Integer>();
    private boolean canceled;
    private Exception lastException;
    private OsmServerChangesetReader reader;
    private Set<Changeset> downloadedChangesets;

    protected void init(Collection<Integer> ids) {
        if (ids == null) {
            ids = Collections.emptyList();
        }
        for (Integer id : ids) {
            if (id == null || id <= 0) continue;
            this.toDownload.add(id);
        }
        this.downloadedChangesets = new HashSet<Changeset>();
    }

    public ChangesetContentDownloadTask(int changesetId) throws IllegalArgumentException {
        super(I18n.tr("Downloading changeset content", new Object[0]), false);
        if (changesetId <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected integer value > 0 for parameter ''{0}'', got ''{1}''", "changesetId", changesetId));
        }
        this.init(Collections.singleton(changesetId));
    }

    public ChangesetContentDownloadTask(Collection<Integer> changesetIds) {
        super(I18n.tr("Downloading changeset content", new Object[0]), false);
        this.init(changesetIds);
    }

    public ChangesetContentDownloadTask(Component parent, int changesetId) throws IllegalArgumentException {
        super(parent, I18n.tr("Downloading changeset content", new Object[0]), false);
        if (changesetId <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected integer value > 0 for parameter ''{0}'', got ''{1}''", "changesetId", changesetId));
        }
        this.init(Collections.singleton(changesetId));
    }

    public ChangesetContentDownloadTask(Component parent, Collection<Integer> changesetIds) throws IllegalArgumentException {
        super(parent, I18n.tr("Downloading changeset content", new Object[0]), false);
        this.init(changesetIds);
    }

    protected boolean isAvailableLocally(int changesetId) {
        return ChangesetCache.getInstance().get(changesetId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadChangeset(int changesetId) throws OsmTransferException {
        ChangesetContentDownloadTask changesetContentDownloadTask = this;
        synchronized (changesetContentDownloadTask) {
            this.reader = new OsmServerChangesetReader();
        }
        Changeset cs = this.reader.readChangeset(changesetId, false, this.getProgressMonitor().createSubTaskMonitor(0, false));
        ChangesetContentDownloadTask changesetContentDownloadTask2 = this;
        synchronized (changesetContentDownloadTask2) {
            this.reader = null;
        }
        ChangesetCache.getInstance().update(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ChangesetContentDownloadTask changesetContentDownloadTask = this;
        synchronized (changesetContentDownloadTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.getProgressMonitor().setTicksCount(this.toDownload.size());
            int i = 0;
            for (int id : this.toDownload) {
                ++i;
                if (!this.isAvailableLocally(id)) {
                    this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading changeset {2}...", i, this.toDownload.size(), id));
                    this.downloadChangeset(id);
                }
                if (this.canceled) {
                    return;
                }
                ChangesetContentDownloadTask changesetContentDownloadTask = this;
                synchronized (changesetContentDownloadTask) {
                    this.reader = new OsmServerChangesetReader();
                }
                this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading content for changeset {2}...", i, this.toDownload.size(), id));
                ChangesetDataSet ds = this.reader.downloadChangeset(id, this.getProgressMonitor().createSubTaskMonitor(0, false));
                ChangesetContentDownloadTask changesetContentDownloadTask2 = this;
                synchronized (changesetContentDownloadTask2) {
                    this.reader = null;
                }
                Changeset cs = ChangesetCache.getInstance().get(id);
                cs.setContent(ds);
                ChangesetCache.getInstance().update(cs);
                this.downloadedChangesets.add(cs);
                this.getProgressMonitor().worked(1);
            }
        }
        catch (OsmTransferCanceledException e) {
            this.canceled = true;
            return;
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }

    @Override
    public Set<Changeset> getDownloadedChangesets() {
        return this.downloadedChangesets;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isFailed() {
        return this.lastException != null;
    }
}

