/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDetailPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetTagsPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.SingleChangesetDownloadPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.ChangesetQueryDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.query.ChangesetQueryTask;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ChangesetCacheManager
extends JFrame {
    public static final ImageIcon DOWNLOAD_CONTENT_ICON = ImageProvider.get("dialogs/changeset", "downloadchangesetcontent");
    public static final ImageIcon UPDATE_CONTENT_ICON = ImageProvider.get("dialogs/changeset", "updatechangesetcontent");
    private static volatile ChangesetCacheManager instance;
    private ChangesetCacheManagerModel model;
    private JSplitPane spContent;
    private boolean needsSplitPaneAdjustment;
    private RemoveFromCacheAction actRemoveFromCacheAction;
    private CloseSelectedChangesetsAction actCloseSelectedChangesetsAction;
    private DownloadSelectedChangesetsAction actDownloadSelectedChangesets;
    private DownloadSelectedChangesetContentAction actDownloadSelectedContent;
    private JTable tblChangesets;

    public static ChangesetCacheManager getInstance() {
        if (instance == null) {
            instance = new ChangesetCacheManager();
        }
        return instance;
    }

    public static void destroyInstance() {
        if (instance != null) {
            instance.setVisible(true);
            instance.dispose();
            instance = null;
        }
    }

    protected void buildModel() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(2);
        this.model = new ChangesetCacheManagerModel(selectionModel);
        this.actRemoveFromCacheAction = new RemoveFromCacheAction();
        this.actCloseSelectedChangesetsAction = new CloseSelectedChangesetsAction();
        this.actDownloadSelectedChangesets = new DownloadSelectedChangesetsAction();
        this.actDownloadSelectedContent = new DownloadSelectedChangesetContentAction();
    }

    protected JPanel buildToolbarPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        SideButton btn = new SideButton(new QueryAction());
        pnl.add(btn);
        pnl.add(new SingleChangesetDownloadPanel());
        pnl.add(new SideButton(new DownloadMyChangesets()));
        return pnl;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        pnl.add(new SideButton(new CancelAction()));
        pnl.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/ChangesetManager"))));
        return pnl;
    }

    protected JPanel buildChangesetDetailPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        ChangesetDetailPanel pnlChangesetDetail = new ChangesetDetailPanel();
        tp.add(pnlChangesetDetail);
        this.model.addPropertyChangeListener(pnlChangesetDetail);
        ChangesetTagsPanel pnlChangesetTags = new ChangesetTagsPanel();
        tp.add(pnlChangesetTags);
        this.model.addPropertyChangeListener(pnlChangesetTags);
        ChangesetContentPanel pnlChangesetContent = new ChangesetContentPanel();
        tp.add(pnlChangesetContent);
        this.model.addPropertyChangeListener(pnlChangesetContent);
        ChangesetDiscussionPanel pnlChangesetDiscussion = new ChangesetDiscussionPanel();
        tp.add(pnlChangesetDiscussion);
        this.model.addPropertyChangeListener(pnlChangesetDiscussion);
        tp.setTitleAt(0, I18n.tr("Properties", new Object[0]));
        tp.setToolTipTextAt(0, I18n.tr("Display the basic properties of the changeset", new Object[0]));
        tp.setTitleAt(1, I18n.tr("Tags", new Object[0]));
        tp.setToolTipTextAt(1, I18n.tr("Display the tags of the changeset", new Object[0]));
        tp.setTitleAt(2, I18n.tr("Content", new Object[0]));
        tp.setToolTipTextAt(2, I18n.tr("Display the objects created, updated, and deleted by the changeset", new Object[0]));
        tp.setTitleAt(3, I18n.tr("Discussion", new Object[0]));
        tp.setToolTipTextAt(3, I18n.tr("Display the public discussion around this changeset", new Object[0]));
        pnl.add((Component)tp, "Center");
        return pnl;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.spContent = new JSplitPane(0);
        this.spContent.setLeftComponent(this.buildChangesetTablePanel());
        this.spContent.setRightComponent(this.buildChangesetDetailPanel());
        this.spContent.setOneTouchExpandable(true);
        this.spContent.setDividerLocation(0.5);
        pnl.add((Component)this.spContent, "Center");
        return pnl;
    }

    protected JPanel buildChangesetTableActionPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        this.model.getSelectionModel().addListSelectionListener(this.actRemoveFromCacheAction);
        tb.add(this.actRemoveFromCacheAction);
        this.model.getSelectionModel().addListSelectionListener(this.actCloseSelectedChangesetsAction);
        tb.add(this.actCloseSelectedChangesetsAction);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedChangesets);
        tb.add(this.actDownloadSelectedChangesets);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedContent);
        tb.add(this.actDownloadSelectedContent);
        pnl.add((Component)tb, "Center");
        return pnl;
    }

    protected JPanel buildChangesetTablePanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this.tblChangesets = new JTable(this.model, new ChangesetCacheTableColumnModel(), this.model.getSelectionModel());
        this.tblChangesets.addMouseListener(new MouseEventHandler());
        this.tblChangesets.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "showDetails");
        this.tblChangesets.getActionMap().put("showDetails", new ShowDetailAction());
        this.model.getSelectionModel().addListSelectionListener(new ChangesetDetailViewSynchronizer());
        this.tblChangesets.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "removeFromCache");
        this.tblChangesets.getActionMap().put("removeFromCache", this.actRemoveFromCacheAction);
        pnl.add((Component)new JScrollPane(this.tblChangesets), "Center");
        pnl.add((Component)this.buildChangesetTableActionPanel(), "West");
        return pnl;
    }

    protected void build() {
        this.setTitle(I18n.tr("Changeset Management Dialog", new Object[0]));
        this.setIconImage(ImageProvider.get("dialogs/changeset", "changesetmanager").getImage());
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.buildModel();
        cp.add((Component)this.buildToolbarPanel(), "North");
        cp.add((Component)this.buildContentPanel(), "Center");
        cp.add((Component)this.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/ChangesetManager"));
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelAndClose");
        this.getRootPane().getActionMap().put("cancelAndClose", new CancelAction());
        this.addWindowListener(new WindowEventHandler());
    }

    public ChangesetCacheManager() {
        this.build();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
            this.needsSplitPaneAdjustment = true;
            this.model.init();
        } else if (this.isShowing()) {
            this.model.tearDown();
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void setSelectedChangesets(Collection<Changeset> changesets) {
        this.model.setSelectedChangesets(changesets);
        int idx = this.model.getSelectionModel().getMinSelectionIndex();
        if (idx < 0) {
            return;
        }
        this.tblChangesets.scrollRectToVisible(this.tblChangesets.getCellRect(idx, 0, true));
        this.repaint();
    }

    public void setSelectedChangesetsById(Collection<Integer> ids) {
        if (ids == null) {
            this.setSelectedChangesets(null);
            return;
        }
        HashSet<Changeset> toSelect = new HashSet<Changeset>();
        ChangesetCache cc = ChangesetCache.getInstance();
        for (int id : ids) {
            if (!cc.contains(id)) continue;
            toSelect.add(cc.get(id));
        }
        this.setSelectedChangesets(toSelect);
    }

    public void runDownloadTask(final ChangesetDownloadTask task) {
        Main.worker.submit(task);
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                if (task.isCanceled() || task.isFailed()) {
                    return;
                }
                ChangesetCacheManager.this.setSelectedChangesets(task.getDownloadedChangesets());
            }
        });
    }

    class ChangesetDetailViewSynchronizer
    implements ListSelectionListener {
        ChangesetDetailViewSynchronizer() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            List<Changeset> selected = ChangesetCacheManager.this.model.getSelectedChangesets();
            if (selected.size() == 1) {
                ChangesetCacheManager.this.model.setChangesetInDetailView(selected.get(0));
            } else {
                ChangesetCacheManager.this.model.setChangesetInDetailView(null);
            }
        }
    }

    class ChangesetTablePopupMenu
    extends JPopupMenu {
        public ChangesetTablePopupMenu() {
            this.add(ChangesetCacheManager.this.actRemoveFromCacheAction);
            this.add(ChangesetCacheManager.this.actCloseSelectedChangesetsAction);
            this.add(ChangesetCacheManager.this.actDownloadSelectedChangesets);
            this.add(ChangesetCacheManager.this.actDownloadSelectedContent);
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(new ChangesetTablePopupMenu());
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (MouseEventHandler.isDoubleClick(evt)) {
                new ShowDetailAction().showDetails();
            }
        }
    }

    class DownloadMyChangesets
    extends AbstractAction {
        public DownloadMyChangesets() {
            this.putValue("Name", I18n.tr("My changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangeset"));
            this.putValue("ShortDescription", I18n.tr("Download my changesets from the OSM server (max. 100 changesets)", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        protected void alertAnonymousUser() {
            HelpAwareOptionPane.showOptionDialog(ChangesetCacheManager.this, I18n.tr("<html>JOSM is currently running with an anonymous user. It cannot download<br>your changesets from the OSM server unless you enter your OSM user name<br>in the JOSM preferences.</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetManager#CanDownloadMyChangesets"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
            if (im.isAnonymous()) {
                this.alertAnonymousUser();
                return;
            }
            ChangesetQuery query = new ChangesetQuery();
            query = im.isFullyIdentified() ? query.forUser(im.getUserId()) : query.forUser(im.getUserName());
            ChangesetQueryTask task = new ChangesetQueryTask(ChangesetCacheManager.this, query);
            ChangesetCacheManager.getInstance().runDownloadTask(task);
        }
    }

    class ShowDetailAction
    extends AbstractAction {
        ShowDetailAction() {
        }

        public void showDetails() {
            List<Changeset> selected = ChangesetCacheManager.this.model.getSelectedChangesets();
            if (selected.size() != 1) {
                return;
            }
            ChangesetCacheManager.this.model.setChangesetInDetailView(selected.get(0));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.showDetails();
        }
    }

    class DownloadSelectedChangesetContentAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedChangesetContentAction() {
            this.putValue("Name", I18n.tr("Download changeset content", new Object[0]));
            this.putValue("SmallIcon", DOWNLOAD_CONTENT_ICON);
            this.putValue("ShortDescription", I18n.tr("Download the content of the selected changesets from the server", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)ChangesetCacheManager.this, ChangesetCacheManager.this.model.getSelectedChangesetIds());
            ChangesetCacheManager.getInstance().runDownloadTask(task);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetCacheManager.this.model.hasSelectedChangesets() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class DownloadSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedChangesetsAction() {
            this.putValue("Name", I18n.tr("Update changeset", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "updatechangeset"));
            this.putValue("ShortDescription", I18n.tr("Updates the selected changesets with current data from the OSM server", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            List<Changeset> selected = ChangesetCacheManager.this.model.getSelectedChangesets();
            ChangesetHeaderDownloadTask task = ChangesetHeaderDownloadTask.buildTaskForChangesets(ChangesetCacheManager.this, selected);
            ChangesetCacheManager.getInstance().runDownloadTask(task);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetCacheManager.this.model.hasSelectedChangesets() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class CloseSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        public CloseSelectedChangesetsAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
            this.putValue("ShortDescription", I18n.tr("Close the selected changesets", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            List<Changeset> selected = ChangesetCacheManager.this.model.getSelectedChangesets();
            Main.worker.submit(new CloseChangesetTask(selected));
        }

        protected void updateEnabledState() {
            List<Changeset> selected = ChangesetCacheManager.this.model.getSelectedChangesets();
            JosmUserIdentityManager im = JosmUserIdentityManager.getInstance();
            for (Changeset cs : selected) {
                if (!cs.isOpen()) continue;
                if (im.isPartiallyIdentified() && cs.getUser() != null && cs.getUser().getName().equals(im.getUserName())) {
                    this.setEnabled(true);
                    return;
                }
                if (!im.isFullyIdentified() || cs.getUser() == null || cs.getUser().getId() != (long)im.getUserId()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class RemoveFromCacheAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveFromCacheAction() {
            this.putValue("Name", I18n.tr("Remove from cache", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Remove the selected changesets from the local cache", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            List<Changeset> selected = ChangesetCacheManager.this.model.getSelectedChangesets();
            ChangesetCache.getInstance().remove(selected);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetCacheManager.this.model.hasSelectedChangesets());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class QueryAction
    extends AbstractAction {
        public QueryAction() {
            this.putValue("Name", I18n.tr("Query", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.putValue("ShortDescription", I18n.tr("Launch the dialog for querying changesets", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ChangesetQueryDialog dialog = new ChangesetQueryDialog(ChangesetCacheManager.this);
            dialog.initForUserInput();
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return;
            }
            try {
                ChangesetQuery query = dialog.getChangesetQuery();
                if (query == null) {
                    return;
                }
                ChangesetQueryTask task = new ChangesetQueryTask(ChangesetCacheManager.this, query);
                ChangesetCacheManager.getInstance().runDownloadTask(task);
            }
            catch (IllegalStateException e) {
                JOptionPane.showMessageDialog(ChangesetCacheManager.this, e.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog", new Object[0]));
        }

        public void cancelAndClose() {
            ChangesetCacheManager.destroyInstance();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.cancelAndClose();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().cancelAndClose();
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
            if (ChangesetCacheManager.this.needsSplitPaneAdjustment) {
                ChangesetCacheManager.this.spContent.setDividerLocation(0.5);
                ChangesetCacheManager.this.needsSplitPaneAdjustment = false;
            }
        }
    }
}

