/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidatorDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.LayerChangeListener {
    public ValidatorTreePanel tree;
    private SideButton fixButton;
    private SideButton ignoreButton;
    private SideButton selectButton;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private DefaultMutableTreeNode lastSelectedNode = null;
    private OsmDataLayer linkedLayer;

    public ValidatorDialog() {
        super(I18n.tr("Validation Results", new Object[0]), "validator", I18n.tr("Open the validation window.", new Object[0]), Shortcut.registerShortcut("subwindow:validator", I18n.tr("Toggle: {0}", I18n.tr("Validation results", new Object[0])), 86, 5007), 150, false, ValidatorPreference.class);
        this.popupMenuHandler.addAction(Main.main.menu.autoScaleActions.get("problem"));
        this.popupMenuHandler.addAction(new EditRelationAction());
        this.tree = new ValidatorTreePanel();
        this.tree.addMouseListener(new MouseEventHandler());
        this.addTreeSelectionListener(new SelectionWatch());
        InputMapUtils.unassignCtrlShiftUpDown(this.tree, 0);
        LinkedList<SideButton> buttons = new LinkedList<SideButton>();
        this.selectButton = new SideButton(new AbstractSelectAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.setSelectedItems();
            }
        });
        InputMapUtils.addEnterAction(this.tree, this.selectButton.getAction());
        this.selectButton.setEnabled(false);
        buttons.add(this.selectButton);
        buttons.add(new SideButton(Main.main.validator.validateAction));
        this.fixButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Fix", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Fix the selected issue.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "fix"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidatorDialog.this.fixErrors();
            }
        });
        this.fixButton.setEnabled(false);
        buttons.add(this.fixButton);
        if (Main.pref.getBoolean("validator.ignore", true)) {
            this.ignoreButton = new SideButton(new AbstractAction(){
                {
                    this.putValue("Name", I18n.tr("Ignore", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Ignore the selected issue next time.", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "fix"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValidatorDialog.this.ignoreErrors();
                }
            });
            this.ignoreButton.setEnabled(false);
            buttons.add(this.ignoreButton);
        } else {
            this.ignoreButton = null;
        }
        this.createLayout(this.tree, true, buttons);
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds != null) {
            this.updateSelection(ds.getAllSelected());
        }
        MapView.addLayerChangeListener(this);
        Layer activeLayer = Main.map.mapView.getActiveLayer();
        if (activeLayer != null) {
            this.activeLayerChange(null, activeLayer);
        }
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    @Override
    public void setVisible(boolean v) {
        if (this.tree != null) {
            this.tree.setVisible(v);
        }
        super.setVisible(v);
        Main.map.repaint();
    }

    private void fixErrors() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        LinkedList<TestError> errorsToFix = new LinkedList<TestError>();
        for (TreePath path : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) continue;
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                if (processedNodes.contains(childNode)) continue;
                processedNodes.add(childNode);
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                errorsToFix.add((TestError)nodeInfo);
            }
        }
        FixTask fixTask = new FixTask(errorsToFix);
        Main.worker.submit(fixTask);
    }

    private void ignoreErrors() {
        int asked = -1;
        boolean changed = false;
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> processedNodes = new HashSet<DefaultMutableTreeNode>();
        for (TreePath path : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) continue;
            Object mainNodeInfo = node.getUserObject();
            if (!(mainNodeInfo instanceof TestError)) {
                HashSet<String> state = new HashSet<String>();
                if (asked == -1) {
                    Object[] a = new String[]{I18n.tr("Whole group", new Object[0]), I18n.tr("Single elements", new Object[0]), I18n.tr("Nothing", new Object[0])};
                    asked = JOptionPane.showOptionDialog(Main.parent, I18n.tr("Ignore whole group or individual elements?", new Object[0]), I18n.tr("Ignoring elements", new Object[0]), 1, 2, null, a, a[1]);
                }
                if (asked == 0) {
                    Enumeration<TreeNode> children = node.breadthFirstEnumeration();
                    while (children.hasMoreElements()) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                        if (processedNodes.contains(childNode)) continue;
                        processedNodes.add(childNode);
                        Object nodeInfo = childNode.getUserObject();
                        if (!(nodeInfo instanceof TestError)) continue;
                        TestError err = (TestError)nodeInfo;
                        err.setIgnored(true);
                        changed = true;
                        state.add(node.getDepth() == 1 ? err.getIgnoreSubGroup() : err.getIgnoreGroup());
                    }
                    for (String s : state) {
                        OsmValidator.addIgnoredError(s);
                    }
                    continue;
                }
                if (asked == 2 || asked == -1) continue;
            }
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                if (processedNodes.contains(childNode)) continue;
                processedNodes.add(childNode);
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                TestError error = (TestError)nodeInfo;
                String state = error.getIgnoreState();
                if (state != null) {
                    OsmValidator.addIgnoredError(state);
                }
                changed = true;
                error.setIgnored(true);
            }
        }
        if (changed) {
            this.tree.resetErrors();
            OsmValidator.saveIgnoredErrors();
            Main.map.repaint();
        }
    }

    private void setSelectedItems() {
        if (this.tree == null) {
            return;
        }
        HashSet<? extends OsmPrimitive> sel = new HashSet<OsmPrimitive>(40);
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (selectedPaths == null) {
            return;
        }
        for (TreePath path : selectedPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> children = node.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                Object nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                TestError error = (TestError)nodeInfo;
                sel.addAll(error.getSelectablePrimitives());
            }
        }
        DataSet ds = Main.main.getCurrentDataSet();
        if (ds != null) {
            ds.setSelected(sel);
        }
    }

    private boolean setSelection(Collection<OsmPrimitive> sel, boolean addSelected) {
        TestError error;
        Object nodeInfo;
        DefaultMutableTreeNode childNode;
        Enumeration<TreeNode> children;
        boolean hasFixes = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(node)) {
            children = this.lastSelectedNode.breadthFirstEnumeration();
            while (children.hasMoreElements()) {
                childNode = (DefaultMutableTreeNode)children.nextElement();
                nodeInfo = childNode.getUserObject();
                if (!(nodeInfo instanceof TestError)) continue;
                error = (TestError)nodeInfo;
                error.setSelected(false);
            }
        }
        this.lastSelectedNode = node;
        if (node == null) {
            return hasFixes;
        }
        children = node.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            childNode = (DefaultMutableTreeNode)children.nextElement();
            nodeInfo = childNode.getUserObject();
            if (!(nodeInfo instanceof TestError)) continue;
            error = (TestError)nodeInfo;
            error.setSelected(true);
            boolean bl = hasFixes = hasFixes || error.isFixable();
            if (!addSelected) continue;
            sel.addAll(error.getSelectablePrimitives());
        }
        this.selectButton.setEnabled(true);
        if (this.ignoreButton != null) {
            this.ignoreButton.setEnabled(true);
        }
        return hasFixes;
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            this.linkedLayer = (OsmDataLayer)newLayer;
            this.tree.setErrorList(this.linkedLayer.validationErrors);
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this.linkedLayer) {
            this.tree.setErrorList(new ArrayList<TestError>());
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.removeTreeSelectionListener(listener);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public TestError getSelectedError() {
        Object object;
        Object comp = this.tree.getLastSelectedPathComponent();
        if (comp instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)comp).getUserObject()) instanceof TestError) {
            return (TestError)object;
        }
        return null;
    }

    public void updateSelection(Collection<? extends OsmPrimitive> newSelection) {
        if (!Main.pref.getBoolean("validator.selectionFilter", false)) {
            return;
        }
        if (newSelection.isEmpty()) {
            this.tree.setFilter(null);
        }
        HashSet<OsmPrimitive> filter = new HashSet<OsmPrimitive>(newSelection);
        this.tree.setFilter(filter);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.updateSelection(newSelection);
    }

    class FixTask
    extends PleaseWaitRunnable {
        private Collection<TestError> testErrors;
        private boolean canceled;

        public FixTask(Collection<TestError> testErrors) {
            super(I18n.tr("Fixing errors ...", new Object[0]), false);
            this.testErrors = testErrors == null ? new ArrayList() : testErrors;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        protected void fixError(TestError error) throws InterruptedException, InvocationTargetException {
            if (error.isFixable()) {
                final Command fixCommand = error.getFix();
                if (fixCommand != null) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Main.main.undoRedo.addNoRedraw(fixCommand);
                        }
                    });
                }
                error.setIgnored(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor monitor = this.getProgressMonitor();
            try {
                monitor.setTicksCount(this.testErrors.size());
                int i = 0;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.getCurrentDataSet().beginUpdate();
                    }
                });
                try {
                    for (TestError error : this.testErrors) {
                        monitor.subTask(I18n.tr("Fixing ({0}/{1}): ''{2}''", ++i, this.testErrors.size(), error.getMessage()));
                        if (!this.canceled) break block10;
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Main.main.getCurrentDataSet().endUpdate();
                        }
                    });
                    throw throwable;
                }
                {
                    TestError error;
                    block10: {
                        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    this.fixError(error);
                    monitor.worked(1);
                    continue;
                }
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                monitor.subTask(I18n.tr("Updating map ...", new Object[0]));
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.undoRedo.afterAdd();
                        Main.map.repaint();
                        ValidatorDialog.this.tree.resetErrors();
                        Main.main.getCurrentDataSet().fireSelectionChanged();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            finally {
                monitor.finishTask();
            }
        }
    }

    public static class ValidatorBoundingXYVisitor
    extends BoundingXYVisitor
    implements ValidatorVisitor {
        @Override
        public void visit(OsmPrimitive p) {
            if (p.isUsable()) {
                p.accept(this);
            }
        }

        @Override
        public void visit(WaySegment ws) {
            if (ws.lowerIndex < 0 || ws.lowerIndex + 1 >= ws.way.getNodesCount()) {
                return;
            }
            this.visit(ws.way.getNodes().get(ws.lowerIndex));
            this.visit(ws.way.getNodes().get(ws.lowerIndex + 1));
        }

        @Override
        public void visit(List<Node> nodes) {
            for (Node n : nodes) {
                this.visit(n);
            }
        }

        @Override
        public void visit(TestError error) {
            if (error != null) {
                error.visitHighlighted(this);
            }
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            HashSet sel = new HashSet();
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, true);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            ValidatorDialog.this.popupMenuHandler.setPrimitives(sel);
            if (Main.map != null) {
                Main.map.repaint();
            }
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(ValidatorDialog.this.popupMenu);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean isDblClick = MouseEventHandler.isDoubleClick(e);
            HashSet<OsmPrimitive> sel = isDblClick ? new HashSet<OsmPrimitive>(40) : null;
            boolean hasFixes = ValidatorDialog.this.setSelection(sel, isDblClick);
            ValidatorDialog.this.fixButton.setEnabled(hasFixes);
            if (isDblClick) {
                Main.main.getCurrentDataSet().setSelected(sel);
                if (Main.pref.getBoolean("validator.autozoom", false)) {
                    AutoScaleAction.zoomTo(sel);
                }
            }
        }

        @Override
        public void launch(MouseEvent e) {
            TreePath selPath = ValidatorDialog.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getPathComponent(selPath.getPathCount() - 1);
            if (!(node.getUserObject() instanceof TestError)) {
                return;
            }
            super.launch(e);
        }
    }
}

