/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.actions.relation.SelectInRelationListAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.ListPopupMenu;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class SelectionListDialog
extends ToggleDialog {
    private JList<OsmPrimitive> lstPrimitives;
    private final DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private final SelectionListModel model = new SelectionListModel(this.selectionModel);
    private final SelectAction actSelect = new SelectAction();
    private final SearchAction actSearch = new SearchAction();
    private final ShowHistoryAction actShowHistory = new ShowHistoryAction();
    private final ZoomToJOSMSelectionAction actZoomToJOSMSelection = new ZoomToJOSMSelectionAction();
    private final ZoomToListSelection actZoomToListSelection = new ZoomToListSelection();
    private final SelectInRelationListAction actSetRelationSelection = new SelectInRelationListAction();
    private final EditRelationAction actEditRelationSelection = new EditRelationAction();
    private final DownloadSelectedIncompleteMembersAction actDownloadSelIncompleteMembers = new DownloadSelectedIncompleteMembersAction();
    private final ListPopupMenu popupMenu;
    private final PopupMenuHandler popupMenuHandler;

    protected void buildContentPanel() {
        this.lstPrimitives = new JList<OsmPrimitive>(this.model);
        this.lstPrimitives.setSelectionMode(2);
        this.lstPrimitives.setSelectionModel(this.selectionModel);
        this.lstPrimitives.setCellRenderer(new OsmPrimitivRenderer());
        this.lstPrimitives.setTransferHandler(null);
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actSelect);
        this.lstPrimitives.getSelectionModel().addListSelectionListener(this.actShowHistory);
        final SideButton selectButton = new SideButton(this.actSelect);
        selectButton.createArrow(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionHistoryPopup.launch(selectButton, SelectionListDialog.this.model.getSelectionHistory());
            }
        });
        final SideButton searchButton = new SideButton(this.actSearch);
        searchButton.createArrow(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPopupMenu.launch(searchButton);
            }
        });
        this.createLayout(this.lstPrimitives, true, Arrays.asList(selectButton, searchButton, new SideButton(this.actShowHistory)));
    }

    public SelectionListDialog() {
        super(I18n.tr("Selection", new Object[0]), "selectionlist", I18n.tr("Open a selection list window.", new Object[0]), Shortcut.registerShortcut("subwindow:selection", I18n.tr("Toggle: {0}", I18n.tr("Current Selection", new Object[0])), 84, 5007), 150, true);
        this.buildContentPanel();
        this.model.addListDataListener(new TitleUpdater());
        this.model.addListDataListener(this.actZoomToJOSMSelection);
        this.popupMenu = new ListPopupMenu(this.lstPrimitives);
        this.popupMenuHandler = this.setupPopupMenuHandler();
        this.lstPrimitives.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectionListDialog.this.actZoomToListSelection.valueChanged(e);
                SelectionListDialog.this.popupMenuHandler.setPrimitives(SelectionListDialog.this.model.getSelected());
            }
        });
        this.lstPrimitives.addMouseListener(new MouseEventHandler());
        InputMapUtils.addEnterAction(this.lstPrimitives, this.actZoomToListSelection);
    }

    @Override
    public void showNotify() {
        MapView.addEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().addSelectionListener(this.actShowHistory, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this.model, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        DatasetEventManager.getInstance().addDatasetListener(this.model, DatasetEventManager.FireMode.IN_EDT);
        MapView.addEditLayerChangeListener(this.actSearch);
        OsmDataLayer editLayer = Main.main.getEditLayer();
        this.model.editLayerChanged(null, editLayer);
        if (editLayer != null) {
            this.model.setJOSMSelection(editLayer.data.getAllSelected());
        }
        this.actSearch.updateEnabledState();
    }

    @Override
    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this.actSearch);
        MapView.removeEditLayerChangeListener(this.model);
        SelectionEventManager.getInstance().removeSelectionListener(this.actShowHistory);
        SelectionEventManager.getInstance().removeSelectionListener(this.model);
        DatasetEventManager.getInstance().removeDatasetListener(this.model);
    }

    private PopupMenuHandler setupPopupMenuHandler() {
        PopupMenuHandler handler = new PopupMenuHandler(this.popupMenu);
        handler.addAction(this.actZoomToJOSMSelection);
        handler.addAction(this.actZoomToListSelection);
        handler.addSeparator();
        handler.addAction(this.actSetRelationSelection);
        handler.addAction(this.actEditRelationSelection);
        handler.addSeparator();
        handler.addAction(this.actDownloadSelIncompleteMembers);
        return handler;
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public Collection<OsmPrimitive> getSelectedPrimitives() {
        return this.model.getSelected();
    }

    protected static class SelectionHistoryPopup
    extends JPopupMenu {
        public static void launch(Component parent, Collection<Collection<? extends OsmPrimitive>> history) {
            if (history == null || history.isEmpty()) {
                return;
            }
            SelectionHistoryPopup menu = new SelectionHistoryPopup(history);
            Rectangle r = parent.getBounds();
            menu.show(parent, r.x, r.y + r.height);
        }

        public SelectionHistoryPopup(Collection<Collection<? extends OsmPrimitive>> history) {
            for (Collection<? extends OsmPrimitive> sel : history) {
                this.add(new SelectionMenuItem(sel));
            }
        }
    }

    protected static class SelectionMenuItem
    extends JMenuItem
    implements ActionListener {
        private final DefaultNameFormatter df = DefaultNameFormatter.getInstance();
        protected Collection<? extends OsmPrimitive> sel;

        public SelectionMenuItem(Collection<? extends OsmPrimitive> sel) {
            this.sel = sel;
            int ways = 0;
            int nodes = 0;
            int relations = 0;
            for (OsmPrimitive osmPrimitive : sel) {
                if (!osmPrimitive.isSelectable()) continue;
                if (osmPrimitive instanceof Way) {
                    ++ways;
                    continue;
                }
                if (osmPrimitive instanceof Node) {
                    ++nodes;
                    continue;
                }
                if (!(osmPrimitive instanceof Relation)) continue;
                ++relations;
            }
            StringBuilder text = new StringBuilder();
            if (ways != 0) {
                text.append(text.length() > 0 ? ", " : "").append(I18n.trn("{0} way", "{0} ways", ways, ways));
            }
            if (nodes != 0) {
                text.append(text.length() > 0 ? ", " : "").append(I18n.trn("{0} node", "{0} nodes", nodes, nodes));
            }
            if (relations != 0) {
                text.append(text.length() > 0 ? ", " : "").append(I18n.trn("{0} relation", "{0} relations", relations, relations));
            }
            if (ways + nodes + relations == 0) {
                text.append(I18n.tr("Unselectable now", new Object[0]));
                this.sel = new ArrayList<OsmPrimitive>();
            }
            if (ways + nodes + relations == 1) {
                text.append(": ");
                for (OsmPrimitive osmPrimitive : sel) {
                    text.append(osmPrimitive.getDisplayName(this.df));
                }
                this.setText(text.toString());
            } else {
                this.setText(I18n.tr("Selection: {0}", text));
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.main.getCurrentDataSet().setSelected(this.sel);
        }
    }

    protected static class SearchPopupMenu
    extends JPopupMenu {
        public static void launch(Component parent) {
            if (org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory().isEmpty()) {
                return;
            }
            SearchPopupMenu menu = new SearchPopupMenu();
            Rectangle r = parent.getBounds();
            menu.show(parent, r.x, r.y + r.height);
        }

        public SearchPopupMenu() {
            for (SearchAction.SearchSetting ss : org.openstreetmap.josm.actions.search.SearchAction.getSearchHistory()) {
                this.add(new SearchMenuItem(ss));
            }
        }
    }

    protected static class SearchMenuItem
    extends JMenuItem
    implements ActionListener {
        protected final SearchAction.SearchSetting s;

        public SearchMenuItem(SearchAction.SearchSetting s) {
            super(Utils.shortenString(s.toString(), 100));
            this.s = s;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(this.s);
        }
    }

    private static class SelectionListModel
    extends AbstractListModel<OsmPrimitive>
    implements SelectionChangedListener,
    DataSetListener,
    MapView.EditLayerChangeListener {
        private LinkedList<Collection<? extends OsmPrimitive>> history;
        private final List<OsmPrimitive> selection = new ArrayList<OsmPrimitive>();
        private DefaultListSelectionModel selectionModel;

        public SelectionListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public String getJOSMSelectionSummary() {
            if (this.selection.isEmpty()) {
                return I18n.tr("Selection", new Object[0]);
            }
            int numNodes = 0;
            int numWays = 0;
            int numRelations = 0;
            for (OsmPrimitive p : this.selection) {
                switch (p.getType()) {
                    case NODE: {
                        ++numNodes;
                        break;
                    }
                    case WAY: {
                        ++numWays;
                        break;
                    }
                    case RELATION: {
                        ++numRelations;
                    }
                }
            }
            return I18n.tr("Sel.: Rel.:{0} / Ways:{1} / Nodes:{2}", numRelations, numWays, numNodes);
        }

        public void remember(Collection<? extends OsmPrimitive> selection) {
            if (selection == null) {
                return;
            }
            if (selection.isEmpty()) {
                return;
            }
            if (this.history == null) {
                return;
            }
            if (this.history.isEmpty()) {
                this.history.add(selection);
                return;
            }
            if (this.history.getFirst().equals(selection)) {
                return;
            }
            this.history.addFirst(selection);
            for (int i = 1; i < this.history.size(); ++i) {
                if (!this.history.get(i).equals(selection)) continue;
                this.history.remove(i);
                break;
            }
            int maxsize = Main.pref.getInteger("select.history-size", 10);
            while (this.history.size() > maxsize) {
                this.history.removeLast();
            }
        }

        public List<Collection<? extends OsmPrimitive>> getSelectionHistory() {
            return this.history;
        }

        @Override
        public OsmPrimitive getElementAt(int index) {
            return this.selection.get(index);
        }

        @Override
        public int getSize() {
            return this.selection.size();
        }

        public Collection<OsmPrimitive> getSelected() {
            HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                sel.add(this.selection.get(i));
            }
            return sel;
        }

        public void setSelected(Collection<OsmPrimitive> sel) {
            this.selectionModel.clearSelection();
            if (sel == null) {
                return;
            }
            for (OsmPrimitive p : sel) {
                int i = this.selection.indexOf(p);
                if (i < 0) continue;
                this.selectionModel.addSelectionInterval(i, i);
            }
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            Collection<OsmPrimitive> sel = this.getSelected();
            super.fireContentsChanged(source, index0, index1);
            this.setSelected(sel);
        }

        public void setJOSMSelection(final Collection<? extends OsmPrimitive> selection) {
            this.selection.clear();
            if (selection != null) {
                this.selection.addAll(selection);
                this.sort();
            }
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    SelectionListModel.this.fireContentsChanged(this, 0, SelectionListModel.this.getSize());
                    if (selection != null) {
                        SelectionListModel.this.remember(selection);
                        if (selection.size() == 2) {
                            Iterator it = selection.iterator();
                            OsmPrimitive n1 = (OsmPrimitive)it.next();
                            OsmPrimitive n2 = (OsmPrimitive)it.next();
                            if (n1 instanceof Node && n2 instanceof Node) {
                                LatLon c1 = ((Node)n1).getCoor();
                                LatLon c2 = ((Node)n2).getCoor();
                                if (c1 != null && c2 != null) {
                                    Main.map.statusLine.setDist(c1.greatCircleDistance(c2));
                                    return;
                                }
                            }
                        }
                        Main.map.statusLine.setDist(new SubclassFilteredCollection(selection, OsmPrimitive.wayPredicate));
                    }
                }
            });
        }

        public void update(Collection<? extends OsmPrimitive> toUpdate) {
            if (toUpdate == null) {
                return;
            }
            if (toUpdate.isEmpty()) {
                return;
            }
            Collection<OsmPrimitive> sel = this.getSelected();
            for (OsmPrimitive osmPrimitive : toUpdate) {
                int i = this.selection.indexOf(osmPrimitive);
                if (i < 0) continue;
                super.fireContentsChanged(this, i, i);
            }
            this.setSelected(sel);
        }

        public void sort() {
            if (this.selection.size() <= Main.pref.getInteger("selection.no_sort_above", 100000)) {
                boolean quick = this.selection.size() > Main.pref.getInteger("selection.fast_sort_above", 10000);
                Collections.sort(this.selection, new OsmPrimitiveComparator(quick, false));
            }
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            if (newLayer == null) {
                this.setJOSMSelection(null);
                this.history = null;
            } else {
                this.history = newLayer.data.getSelectionHistory();
                this.setJOSMSelection(newLayer.data.getAllSelected());
            }
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            this.setJOSMSelection(newSelection);
        }

        @Override
        public void dataChanged(DataChangedEvent event) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void nodeMoved(NodeMovedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void otherDatasetChange(AbstractDatasetChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void relationMembersChanged(RelationMembersChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void tagsChanged(TagsChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void wayNodesChanged(WayNodesChangedEvent event) {
            this.update(event.getPrimitives());
        }

        @Override
        public void primitivesAdded(PrimitivesAddedEvent event) {
        }

        @Override
        public void primitivesRemoved(PrimitivesRemovedEvent event) {
        }
    }

    class ZoomToListSelection
    extends AbstractAction
    implements ListSelectionListener {
        public ZoomToListSelection() {
            this.putValue("Name", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selected element(s)", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BoundingXYVisitor box = new BoundingXYVisitor();
            Collection<OsmPrimitive> sel = SelectionListDialog.this.model.getSelected();
            if (sel.isEmpty()) {
                return;
            }
            box.computeBoundingBox(sel);
            if (box.getBounds() == null) {
                return;
            }
            box.enlargeBoundingBox();
            Main.map.mapView.zoomTo(box);
        }

        protected void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class ZoomToJOSMSelectionAction
    extends AbstractAction
    implements ListDataListener {
        public ZoomToJOSMSelectionAction() {
            this.putValue("Name", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to selection", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoScaleAction.autoScale("selection");
        }

        public void updateEnabledState() {
            this.setEnabled(SelectionListDialog.this.model.getSize() > 0);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener,
    SelectionChangedListener {
        public ShowHistoryAction() {
            this.putValue("Name", I18n.tr("History", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Display the history of the selected objects.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.updateEnabledState(SelectionListDialog.this.model.getSize());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<OsmPrimitive> sel = SelectionListDialog.this.model.getSelected();
            if (sel.isEmpty() && SelectionListDialog.this.model.getSize() != 1) {
                return;
            }
            if (sel.isEmpty()) {
                sel = Collections.singleton(SelectionListDialog.this.model.getElementAt(0));
            }
            HistoryBrowserDialogManager.getInstance().showHistory(sel);
        }

        protected void updateEnabledState(int osmSelectionSize) {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty() || osmSelectionSize == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState(SelectionListDialog.this.model.getSize());
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
            this.updateEnabledState(newSelection.size());
        }
    }

    class SelectAction
    extends AbstractSelectAction
    implements ListSelectionListener {
        public SelectAction() {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<OsmPrimitive> sel = SelectionListDialog.this.model.getSelected();
            if (sel.isEmpty()) {
                return;
            }
            OsmDataLayer editLayer = Main.main.getEditLayer();
            if (editLayer == null) {
                return;
            }
            editLayer.data.setSelected(sel);
            SelectionListDialog.this.model.selectionModel.setSelectionInterval(0, sel.size() - 1);
        }

        protected void updateEnabledState() {
            this.setEnabled(!SelectionListDialog.this.model.getSelected().isEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    static class SearchAction
    extends AbstractAction
    implements MapView.EditLayerChangeListener {
        public SearchAction() {
            this.putValue("Name", I18n.tr("Search", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Search for objects", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            org.openstreetmap.josm.actions.search.SearchAction.search();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.hasEditLayer());
        }

        @Override
        public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
            this.updateEnabledState();
        }
    }

    class TitleUpdater
    implements ListDataListener {
        TitleUpdater() {
        }

        protected void updateTitle() {
            SelectionListDialog.this.setTitle(SelectionListDialog.this.model.getJOSMSelectionSummary());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.updateTitle();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.updateTitle();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.updateTitle();
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        private final HighlightHelper helper;
        private boolean highlightEnabled;

        public MouseEventHandler() {
            super(SelectionListDialog.this.popupMenu);
            this.helper = new HighlightHelper();
            this.highlightEnabled = Main.pref.getBoolean("draw.target-highlight", true);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int idx = SelectionListDialog.this.lstPrimitives.locationToIndex(e.getPoint());
            if (idx < 0) {
                return;
            }
            if (MouseEventHandler.isDoubleClick(e)) {
                OsmDataLayer layer = Main.main.getEditLayer();
                if (layer == null) {
                    return;
                }
                OsmPrimitive osm = SelectionListDialog.this.model.getElementAt(idx);
                Collection<OsmPrimitive> sel = layer.data.getSelected();
                if (sel.size() != 1 || !sel.iterator().next().equals(osm)) {
                    layer.data.setSelected(Collections.singleton(osm));
                } else if (osm instanceof Relation) {
                    SelectionListDialog.this.actEditRelationSelection.actionPerformed(null);
                }
            } else if (this.highlightEnabled && Main.isDisplayingMapView() && this.helper.highlightOnly(SelectionListDialog.this.model.getElementAt(idx))) {
                Main.map.mapView.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (this.highlightEnabled) {
                this.helper.clear();
            }
            super.mouseExited(me);
        }
    }
}

