/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.FocusManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AddSelectionToRelations;
import org.openstreetmap.josm.actions.relation.DeleteRelationsAction;
import org.openstreetmap.josm.actions.relation.DownloadMembersAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.actions.relation.DuplicateRelationAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.actions.relation.SelectMembersAction;
import org.openstreetmap.josm.actions.relation.SelectRelationAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class RelationListDialog
extends ToggleDialog
implements DataSetListener {
    private final JList<Relation> displaylist;
    private final RelationListModel model;
    private final NewAction newAction;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private final JosmTextField filter;
    private final EditRelationAction editAction = new EditRelationAction();
    private final DeleteRelationsAction deleteRelationsAction = new DeleteRelationsAction();
    private final DuplicateRelationAction duplicateAction = new DuplicateRelationAction();
    private final DownloadMembersAction downloadMembersAction = new DownloadMembersAction();
    private final DownloadSelectedIncompleteMembersAction downloadSelectedIncompleteMembersAction = new DownloadSelectedIncompleteMembersAction();
    private final SelectMembersAction selectMembersAction = new SelectMembersAction(false);
    private final SelectMembersAction addMembersToSelectionAction = new SelectMembersAction(true);
    private final SelectRelationAction selectRelationAction = new SelectRelationAction(false);
    private final SelectRelationAction addRelationToSelectionAction = new SelectRelationAction(true);
    private final AddSelectionToRelations addSelectionToRelations = new AddSelectionToRelations();
    HighlightHelper highlightHelper = new HighlightHelper();
    private boolean highlightEnabled = Main.pref.getBoolean("draw.target-highlight", true);

    public RelationListDialog() {
        super(I18n.tr("Relations", new Object[0]), "relationlist", I18n.tr("Open a list of all relations.", new Object[0]), Shortcut.registerShortcut("subwindow:relations", I18n.tr("Toggle: {0}", I18n.tr("Relations", new Object[0])), 82, 5007), 150, true);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new RelationListModel(selectionModel);
        this.displaylist = new JList<Relation>(this.model);
        this.displaylist.setSelectionModel(selectionModel);
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer(){

            @Override
            protected String getComponentToolTipText(OsmPrimitive value) {
                return null;
            }
        });
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new MouseEventHandler());
        this.newAction = new NewAction();
        this.filter = this.setupFilter();
        this.displaylist.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RelationListDialog.this.updateActionsRelationLists();
            }
        });
        this.setupPopupMenuHandler();
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.filter, "North");
        pane.add((Component)new JScrollPane(this.displaylist), "Center");
        this.createLayout(pane, false, Arrays.asList(new SideButton((Action)this.newAction, false), new SideButton((Action)this.editAction, false), new SideButton((Action)this.duplicateAction, false), new SideButton((Action)this.deleteRelationsAction, false), new SideButton((Action)this.selectRelationAction, false)));
        InputMapUtils.unassignCtrlShiftUpDown(this.displaylist, 0);
        InputMapUtils.addEnterAction(this.displaylist, this.selectRelationAction);
        this.displaylist.getActionMap().put("edit", this.editAction);
        this.displaylist.getInputMap().put(KeyStroke.getKeyStroke(10, 2), "edit");
        this.displaylist.getActionMap().put("copy", Main.main.menu.copy);
        this.displaylist.getInputMap().put(KeyStroke.getKeyStroke(67, GuiHelper.getMenuShortcutKeyMaskEx()), "copy");
        this.updateActionsRelationLists();
    }

    private void updateActionsRelationLists() {
        List<Relation> sel = this.model.getSelectedRelations();
        this.popupMenuHandler.setPrimitives(sel);
        Component focused = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (this.highlightEnabled && focused == this.displaylist && Main.isDisplayingMapView() && this.highlightHelper.highlightOnly(sel)) {
            Main.map.mapView.repaint();
        }
    }

    @Override
    public void showNotify() {
        MapView.addLayerChangeListener(this.newAction);
        this.newAction.updateEnabledState();
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT);
        DataSet.addSelectionListener(this.addSelectionToRelations);
        this.dataChanged(null);
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this.newAction);
        DatasetEventManager.getInstance().removeDatasetListener(this);
        DataSet.removeSelectionListener(this.addSelectionToRelations);
    }

    private void resetFilter() {
        this.filter.setText(null);
    }

    protected void initFromLayer(Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            this.model.setRelations(null);
            return;
        }
        OsmDataLayer l = (OsmDataLayer)layer;
        this.model.setRelations(l.data.getRelations());
        this.model.updateTitle();
        this.updateActionsRelationLists();
    }

    private Relation getSelected() {
        if (this.model.getSize() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        return this.displaylist.getSelectedValue();
    }

    public void selectRelation(Relation relation) {
        this.selectRelations(Collections.singleton(relation));
    }

    public void selectRelations(Collection<Relation> relations) {
        if (relations == null || relations.isEmpty()) {
            this.model.setSelectedRelations(null);
        } else {
            this.model.setSelectedRelations(relations);
            Integer i = this.model.getVisibleRelationIndex(relations.iterator().next());
            if (i != null) {
                this.displaylist.scrollRectToVisible(this.displaylist.getCellBounds(i, i));
            }
        }
    }

    private JosmTextField setupFilter() {
        final DisableShortcutsOnFocusGainedTextField f = new DisableShortcutsOnFocusGainedTextField();
        f.setToolTipText(I18n.tr("Relation list filter", new Object[0]));
        f.getDocument().addDocumentListener(new DocumentListener(){

            private void setFilter() {
                try {
                    f.setBackground(UIManager.getColor("TextField.background"));
                    f.setToolTipText(I18n.tr("Relation list filter", new Object[0]));
                    RelationListDialog.this.model.setFilter(SearchCompiler.compile(RelationListDialog.this.filter.getText(), false, false));
                }
                catch (SearchCompiler.ParseError ex) {
                    f.setBackground(new Color(255, 224, 224));
                    f.setToolTipText(ex.getMessage());
                    RelationListDialog.this.model.setFilter(new SearchCompiler.Always());
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setFilter();
            }
        });
        return f;
    }

    private final void setupPopupMenuHandler() {
        this.popupMenuHandler.addAction(this.selectRelationAction);
        this.popupMenuHandler.addAction(this.addRelationToSelectionAction);
        this.popupMenuHandler.addAction(this.selectMembersAction);
        this.popupMenuHandler.addAction(this.addMembersToSelectionAction);
        this.popupMenuHandler.addSeparator();
        this.popupMenuHandler.addAction(this.downloadMembersAction);
        this.popupMenuHandler.addAction(this.downloadSelectedIncompleteMembersAction);
        this.popupMenuHandler.addSeparator();
        this.popupMenuHandler.addAction(this.editAction).setVisible(false);
        this.popupMenuHandler.addAction(this.duplicateAction).setVisible(false);
        this.popupMenuHandler.addAction(this.deleteRelationsAction).setVisible(false);
        this.popupMenuHandler.addAction(this.addSelectionToRelations);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    public Collection<Relation> getSelectedRelations() {
        return this.model.getSelectedRelations();
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent event) {
        this.model.addRelations(event.getPrimitives());
        this.model.updateTitle();
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.model.removeRelations(event.getPrimitives());
        this.model.updateTitle();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
        List<Relation> sel = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(sel);
        this.displaylist.repaint();
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        OsmPrimitive prim = event.getPrimitive();
        if (!(prim instanceof Relation)) {
            return;
        }
        List<Relation> sel = this.model.getSelectedRelations();
        this.model.sort();
        this.model.setSelectedRelations(sel);
        this.displaylist.repaint();
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        this.initFromLayer(Main.main.getEditLayer());
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    private class RelationListModel
    extends AbstractListModel<Relation> {
        private final List<Relation> relations = new ArrayList<Relation>();
        private List<Relation> filteredRelations;
        private DefaultListSelectionModel selectionModel;
        private SearchCompiler.Match filter;

        public RelationListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        public void sort() {
            Collections.sort(this.relations, DefaultNameFormatter.getInstance().getRelationComparator());
        }

        private boolean isValid(Relation r) {
            return !r.isDeleted() && r.isVisible() && !r.isIncomplete();
        }

        public void setRelations(Collection<Relation> relations) {
            List<Relation> sel = this.getSelectedRelations();
            this.relations.clear();
            this.filteredRelations = null;
            if (relations == null) {
                this.selectionModel.clearSelection();
                this.fireContentsChanged(this, 0, this.getSize());
                return;
            }
            for (Relation r : relations) {
                if (!this.isValid(r)) continue;
                this.relations.add(r);
            }
            this.sort();
            this.updateFilteredRelations();
            this.fireIntervalAdded(this, 0, this.getSize());
            this.setSelectedRelations(sel);
        }

        public void addRelations(Collection<? extends OsmPrimitive> addedPrimitives) {
            boolean added = false;
            for (OsmPrimitive osmPrimitive : addedPrimitives) {
                Relation r;
                if (!(osmPrimitive instanceof Relation) || this.relations.contains(r = (Relation)osmPrimitive) || !this.isValid(r)) continue;
                this.relations.add(r);
                added = true;
            }
            if (added) {
                List<Relation> sel = this.getSelectedRelations();
                this.sort();
                this.updateFilteredRelations();
                this.fireIntervalAdded(this, 0, this.getSize());
                this.setSelectedRelations(sel);
            }
        }

        public void removeRelations(Collection<? extends OsmPrimitive> removedPrimitives) {
            if (removedPrimitives == null) {
                return;
            }
            HashSet<Relation> removedRelations = new HashSet<Relation>();
            for (OsmPrimitive osmPrimitive : removedPrimitives) {
                if (!(osmPrimitive instanceof Relation)) continue;
                removedRelations.add((Relation)osmPrimitive);
            }
            if (removedRelations.isEmpty()) {
                return;
            }
            int size = this.relations.size();
            this.relations.removeAll(removedRelations);
            if (this.filteredRelations != null) {
                this.filteredRelations.removeAll(removedRelations);
            }
            if (size != this.relations.size()) {
                List<Relation> list = this.getSelectedRelations();
                this.sort();
                this.fireContentsChanged(this, 0, this.getSize());
                this.setSelectedRelations(list);
            }
        }

        private void updateFilteredRelations() {
            if (this.filter != null) {
                this.filteredRelations = new ArrayList<Relation>(Utils.filter(this.relations, new Predicate<Relation>(){

                    @Override
                    public boolean evaluate(Relation r) {
                        return RelationListModel.this.filter.match(r);
                    }
                }));
            } else if (this.filteredRelations != null) {
                this.filteredRelations = null;
            }
        }

        public void setFilter(SearchCompiler.Match filter) {
            this.filter = filter;
            this.updateFilteredRelations();
            List<Relation> sel = this.getSelectedRelations();
            this.fireContentsChanged(this, 0, this.getSize());
            this.setSelectedRelations(sel);
            this.updateTitle();
        }

        private List<Relation> getVisibleRelations() {
            return this.filteredRelations == null ? this.relations : this.filteredRelations;
        }

        private Relation getVisibleRelation(int index) {
            if (index < 0 || index >= this.getVisibleRelations().size()) {
                return null;
            }
            return this.getVisibleRelations().get(index);
        }

        @Override
        public Relation getElementAt(int index) {
            return this.getVisibleRelation(index);
        }

        @Override
        public int getSize() {
            return this.getVisibleRelations().size();
        }

        public List<Relation> getSelectedRelations() {
            ArrayList<Relation> ret = new ArrayList<Relation>();
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ret.add(this.getVisibleRelation(i));
            }
            return ret;
        }

        public void setSelectedRelations(Collection<Relation> sel) {
            this.selectionModel.clearSelection();
            if (sel == null || sel.isEmpty()) {
                return;
            }
            if (!this.getVisibleRelations().containsAll(sel)) {
                RelationListDialog.this.resetFilter();
            }
            for (Relation r : sel) {
                Integer i = this.getVisibleRelationIndex(r);
                if (i == null) continue;
                this.selectionModel.addSelectionInterval(i, i);
            }
        }

        private Integer getVisibleRelationIndex(Relation rel) {
            int i = this.getVisibleRelations().indexOf(rel);
            if (i < 0) {
                return null;
            }
            return i;
        }

        public void updateTitle() {
            if (this.relations.size() > 0 && this.relations.size() != this.getSize()) {
                RelationListDialog.this.setTitle(I18n.tr("Relations: {0}/{1}", this.getSize(), this.relations.size()));
            } else if (this.getSize() > 0) {
                RelationListDialog.this.setTitle(I18n.tr("Relations: {0}", this.getSize()));
            } else {
                RelationListDialog.this.setTitle(I18n.tr("Relations", new Object[0]));
            }
        }
    }

    static class NewAction
    extends AbstractAction
    implements MapView.LayerChangeListener {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new relation", new Object[0]));
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "addrelation"));
            this.updateEnabledState();
        }

        public void run() {
            RelationEditor.getEditor(Main.main.getEditLayer(), null, null).setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.hasEditLayer());
        }

        @Override
        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledState();
        }

        @Override
        public void layerAdded(Layer newLayer) {
            this.updateEnabledState();
        }

        @Override
        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledState();
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(RelationListDialog.this.popupMenu);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            if (RelationListDialog.this.highlightEnabled) {
                RelationListDialog.this.highlightHelper.clear();
            }
        }

        protected void setCurrentRelationAsSelection() {
            Main.main.getCurrentDataSet().setSelected((PrimitiveId)RelationListDialog.this.displaylist.getSelectedValue());
        }

        protected void editCurrentRelation() {
            EditRelationAction.launchEditor(RelationListDialog.this.getSelected());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!Main.main.hasEditLayer()) {
                return;
            }
            if (MouseEventHandler.isDoubleClick(e)) {
                if (e.isControlDown()) {
                    this.editCurrentRelation();
                } else {
                    this.setCurrentRelationAsSelection();
                }
            }
        }
    }
}

