/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmIdSelectionDialog
extends ExtendedDialog
implements WindowListener {
    protected final JPanel panel = new JPanel();
    protected final OsmPrimitiveTypesComboBox cbType = new OsmPrimitiveTypesComboBox();
    protected final OsmIdTextField tfId = new OsmIdTextField();
    protected final HistoryComboBox cbId = new HistoryComboBox();
    protected final GroupLayout layout = new GroupLayout(this.panel);

    public OsmIdSelectionDialog(Component parent, String title, String[] buttonTexts) {
        super(parent, title, buttonTexts);
    }

    public OsmIdSelectionDialog(Component parent, String title, String[] buttonTexts, boolean modal) {
        super(parent, title, buttonTexts, modal);
    }

    public OsmIdSelectionDialog(Component parent, String title, String[] buttonTexts, boolean modal, boolean disposeOnClose) {
        super(parent, title, buttonTexts, modal, disposeOnClose);
    }

    protected void init() {
        this.panel.setLayout(this.layout);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        JLabel lbl1 = new JLabel(I18n.tr("Object type:", new Object[0]));
        this.cbType.addItem(I18n.trc("osm object types", "mixed"));
        this.cbType.setToolTipText(I18n.tr("Choose the OSM object type", new Object[0]));
        JLabel lbl2 = new JLabel(I18n.tr("Object ID:", new Object[0]));
        this.cbId.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JosmTextField createEditorComponent() {
                return OsmIdSelectionDialog.this.tfId;
            }
        });
        this.cbId.setToolTipText(I18n.tr("Enter the ID of the object that should be downloaded", new Object[0]));
        this.restorePrimitivesHistory(this.cbId);
        this.tfId.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        this.tfId.setPreferredSize(new Dimension(400, this.tfId.getPreferredSize().height));
        HtmlPanel help = new HtmlPanel(I18n.tr("Object IDs can be separated by comma or space.<br/>Examples: {0}<br/>In mixed mode, specify objects like this: {1}<br/>({2} stands for <i>node</i>, {3} for <i>way</i>, and {4} for <i>relation</i>)", "<b>" + Utils.joinAsHtmlUnorderedList(Arrays.asList("1 2 5", "1,2,5")) + "</b>", "<b>w123, n110, w12, r15</b>", "<b>n</b>", "<b>w</b>", "<b>r</b>"));
        help.setBorder(BorderFactory.createEtchedBorder(1));
        this.cbType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OsmIdSelectionDialog.this.tfId.setType(OsmIdSelectionDialog.this.cbType.getType());
                OsmIdSelectionDialog.this.tfId.performValidation();
            }
        });
        GroupLayout.SequentialGroup sequentialGroup = this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(lbl1).addComponent(this.cbType, -2, -2, -2)).addGroup(this.layout.createParallelGroup().addComponent(lbl2).addComponent(this.cbId, -2, -2, -2));
        GroupLayout.ParallelGroup parallelGroup = this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(lbl1).addComponent(lbl2)).addGroup(this.layout.createParallelGroup().addComponent(this.cbType).addComponent(this.cbId)));
        for (Component i : this.getComponentsBeforeHelp()) {
            sequentialGroup.addComponent(i);
            parallelGroup.addComponent(i);
        }
        this.layout.setVerticalGroup(sequentialGroup.addComponent(help));
        this.layout.setHorizontalGroup(parallelGroup.addComponent(help));
    }

    protected Collection<Component> getComponentsBeforeHelp() {
        return Collections.emptySet();
    }

    public int getContinueButtonIndex() {
        return 1;
    }

    protected void restorePrimitivesHistory(HistoryComboBox cbHistory) {
        LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".primitivesHistory", new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        cbHistory.setPossibleItems(cmtHistory);
    }

    protected void remindPrimitivesHistory(HistoryComboBox cbHistory) {
        cbHistory.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".primitivesHistory", cbHistory.getHistory());
    }

    public final List<PrimitiveId> getOsmIds() {
        return this.tfId.getIds();
    }

    @Override
    public void setupDialog() {
        this.setContent(this.panel, false);
        this.cbType.setSelectedIndex(Main.pref.getInteger("downloadprimitive.lasttype", 0));
        this.tfId.setType(this.cbType.getType());
        if (Main.pref.getBoolean("downloadprimitive.autopaste", true)) {
            this.tryToPasteFromClipboard(this.tfId, this.cbType);
        }
        this.setDefaultButton(this.getContinueButtonIndex());
        this.addWindowListener(this);
        super.setupDialog();
    }

    protected void tryToPasteFromClipboard(OsmIdTextField tfId, OsmPrimitiveTypesComboBox cbType) {
        String buf = Utils.getClipboardContent();
        if (buf == null || buf.isEmpty()) {
            return;
        }
        if (buf.length() > Main.pref.getInteger("downloadprimitive.max-autopaste-length", 2000)) {
            return;
        }
        List<SimplePrimitiveId> ids = SimplePrimitiveId.fuzzyParse(buf);
        if (!ids.isEmpty()) {
            String parsedText = Utils.join(", ", Utils.transform(ids, new Utils.Function<SimplePrimitiveId, String>(){

                @Override
                public String apply(SimplePrimitiveId x) {
                    return x.getType().getAPIName().charAt(0) + String.valueOf(x.getUniqueId());
                }
            }));
            tfId.tryToPasteFrom(parsedText);
            HashSet<OsmPrimitiveType> types = new HashSet<OsmPrimitiveType>(Utils.transform(ids, new Utils.Function<SimplePrimitiveId, OsmPrimitiveType>(){

                @Override
                public OsmPrimitiveType apply(SimplePrimitiveId x) {
                    return x.getType();
                }
            }));
            if (types.size() == 1) {
                cbType.setSelectedItem(types.iterator().next());
            } else {
                cbType.setSelectedIndex(3);
            }
        } else if (buf.matches("[\\d,v\\s]+")) {
            tfId.tryToPasteFrom(buf);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (e != null && e.getComponent() == this && this.getValue() == this.getContinueButtonIndex()) {
            Main.pref.putInteger("downloadprimitive.lasttype", this.cbType.getSelectedIndex());
            if (!this.tfId.readIds()) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Invalid ID list specified\nCannot continue.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                return;
            }
            this.remindPrimitivesHistory(this.cbId);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

