/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadNotesAction;
import org.openstreetmap.josm.actions.mapmode.AddNoteAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.NoteSortDialog;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NotesDialog
extends ToggleDialog
implements MapView.LayerChangeListener {
    public static final int ICON_SMALL_SIZE = 16;
    public static final int ICON_LARGE_SIZE = 24;
    public static final ImageIcon ICON_OPEN = ImageProvider.get("dialogs/notes", "note_open");
    public static final ImageIcon ICON_OPEN_SMALL = new ImageIcon(ICON_OPEN.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_CLOSED = ImageProvider.get("dialogs/notes", "note_closed");
    public static final ImageIcon ICON_CLOSED_SMALL = new ImageIcon(ICON_CLOSED.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_NEW = ImageProvider.get("dialogs/notes", "note_new");
    public static final ImageIcon ICON_NEW_SMALL = new ImageIcon(ICON_NEW.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_COMMENT = ImageProvider.get("dialogs/notes", "note_comment");
    private NoteTableModel model;
    private JList<Note> displayList;
    private final AddCommentAction addCommentAction = new AddCommentAction();
    private final CloseAction closeAction = new CloseAction();
    private final NewAction newAction = new NewAction();
    private final ReopenAction reopenAction = new ReopenAction();
    private final SortAction sortAction = new SortAction();
    private final UploadNotesAction uploadAction = new UploadNotesAction();
    private NoteData noteData;

    public NotesDialog() {
        super(I18n.tr("Notes", new Object[0]), "notes/note_open", I18n.tr("List of notes", new Object[0]), null, 150);
        this.buildDialog();
        MapView.addLayerChangeListener(this);
    }

    @Override
    public void showDialog() {
        super.showDialog();
    }

    private void buildDialog() {
        this.model = new NoteTableModel();
        this.displayList = new JList<Note>(this.model);
        this.displayList.setCellRenderer(new NoteRenderer());
        this.displayList.setSelectionMode(0);
        this.displayList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (NotesDialog.this.noteData != null) {
                    NotesDialog.this.noteData.setSelectedNote((Note)NotesDialog.this.displayList.getSelectedValue());
                }
                NotesDialog.this.updateButtonStates();
            }
        });
        this.displayList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && NotesDialog.this.noteData != null && NotesDialog.this.noteData.getSelectedNote() != null) {
                    Main.map.mapView.zoomTo(NotesDialog.this.noteData.getSelectedNote().getLatLon());
                }
            }
        });
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)new JScrollPane(this.displayList), "Center");
        this.createLayout(pane, false, Arrays.asList(new SideButton((Action)this.newAction, false), new SideButton((Action)this.addCommentAction, false), new SideButton((Action)this.closeAction, false), new SideButton((Action)this.reopenAction, false), new SideButton((Action)this.sortAction, false), new SideButton((Action)this.uploadAction, false)));
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(false);
        } else if (this.noteData.getSelectedNote().getState() == Note.State.open) {
            this.closeAction.setEnabled(true);
            this.addCommentAction.setEnabled(true);
            this.reopenAction.setEnabled(false);
        } else {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(true);
        }
        if (this.noteData == null || !this.noteData.isModified()) {
            this.uploadAction.setEnabled(false);
        } else {
            this.uploadAction.setEnabled(true);
        }
        if (this.noteData == null || this.noteData.getNotes().isEmpty()) {
            this.sortAction.setEnabled(false);
        } else {
            this.sortAction.setEnabled(true);
        }
    }

    @Override
    public void showNotify() {
    }

    @Override
    public void hideNotify() {
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    @Override
    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof NoteLayer) {
            this.noteData = ((NoteLayer)newLayer).getNoteData();
            this.model.setData(this.noteData.getNotes());
            this.setNoteList(this.noteData.getNotes());
        }
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
        if (oldLayer instanceof NoteLayer) {
            if (Main.isDebugEnabled()) {
                Main.debug("note layer removed. Clearing everything");
            }
            this.noteData = null;
            this.model.clearData();
            if (Main.map.mapMode instanceof AddNoteAction) {
                Main.map.selectMapMode(Main.map.mapModeSelect);
            }
        }
    }

    public void setNoteList(List<Note> noteList) {
        this.model.setData(noteList);
        this.updateButtonStates();
        this.repaint();
    }

    public void selectionChanged() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.displayList.clearSelection();
        } else {
            this.displayList.setSelectedValue(this.noteData.getSelectedNote(), true);
        }
        this.updateButtonStates();
    }

    class SortAction
    extends AbstractAction {
        public SortAction() {
            this.putValue("ShortDescription", I18n.tr("Sort notes", new Object[0]));
            this.putValue("Name", I18n.tr("Sort", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "sort"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoteSortDialog sortDialog = new NoteSortDialog(Main.parent, I18n.tr("Sort notes", new Object[0]), I18n.tr("Apply", new Object[0]));
            sortDialog.showSortDialog(NotesDialog.this.noteData.getCurrentSortMethod());
            if (sortDialog.getValue() == 1) {
                NotesDialog.this.noteData.setSortMethod(sortDialog.getSelectedComparator());
            }
        }
    }

    class ReopenAction
    extends AbstractAction {
        public ReopenAction() {
            this.putValue("ShortDescription", I18n.tr("Reopen note", new Object[0]));
            this.putValue("Name", I18n.tr("Reopen", new Object[0]));
            this.putValue("SmallIcon", ICON_OPEN);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoteInputDialog dialog = new NoteInputDialog(Main.parent, I18n.tr("Reopen note", new Object[0]), I18n.tr("Reopen note", new Object[0]));
            dialog.showNoteDialog(I18n.tr("Reopen note with message:", new Object[0]), ICON_OPEN);
            if (dialog.getValue() != 1) {
                Main.debug("User aborted note reopening");
                return;
            }
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            int selectedIndex = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.reOpenNote(note, dialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(selectedIndex));
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new note", new Object[0]));
            this.putValue("Name", I18n.tr("Create", new Object[0]));
            this.putValue("SmallIcon", ICON_NEW);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NotesDialog.this.noteData == null) {
                Main.map.mapView.addLayer(new NoteLayer());
            }
            Main.map.selectMapMode(new AddNoteAction(Main.map, NotesDialog.this.noteData));
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("ShortDescription", I18n.tr("Close note", new Object[0]));
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("SmallIcon", ICON_CLOSED);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoteInputDialog dialog = new NoteInputDialog(Main.parent, I18n.tr("Close note", new Object[0]), I18n.tr("Close note", new Object[0]));
            dialog.showNoteDialog(I18n.tr("Close note with message:", new Object[0]), ICON_CLOSED);
            if (dialog.getValue() != 1) {
                Main.debug("User aborted note closing");
                return;
            }
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            int selectedIndex = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.closeNote(note, dialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(selectedIndex));
        }
    }

    class AddCommentAction
    extends AbstractAction {
        public AddCommentAction() {
            this.putValue("ShortDescription", I18n.tr("Add comment", new Object[0]));
            this.putValue("Name", I18n.tr("Comment", new Object[0]));
            this.putValue("SmallIcon", ICON_COMMENT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Note note = (Note)NotesDialog.this.displayList.getSelectedValue();
            if (note == null) {
                JOptionPane.showMessageDialog(Main.map, "You must select a note first", "No note selected", 0);
                return;
            }
            NoteInputDialog dialog = new NoteInputDialog(Main.parent, I18n.tr("Comment on note", new Object[0]), I18n.tr("Add comment", new Object[0]));
            dialog.showNoteDialog(I18n.tr("Add comment to note:", new Object[0]), ICON_COMMENT);
            if (dialog.getValue() != 1) {
                Main.debug("User aborted note reopening");
                return;
            }
            int selectedIndex = NotesDialog.this.displayList.getSelectedIndex();
            NotesDialog.this.noteData.addCommentToNote(note, dialog.getInputText());
            NotesDialog.this.noteData.setSelectedNote(NotesDialog.this.model.getElementAt(selectedIndex));
        }
    }

    class NoteTableModel
    extends AbstractListModel<Note> {
        private List<Note> data = new ArrayList<Note>();

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Note getElementAt(int index) {
            return this.data.get(index);
        }

        public void setData(List<Note> noteList) {
            this.data.clear();
            this.data.addAll(noteList);
            this.fireContentsChanged(this, 0, noteList.size());
        }

        public void clearData() {
            NotesDialog.this.displayList.clearSelection();
            this.data.clear();
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    private class NoteRenderer
    implements ListCellRenderer<Note> {
        private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
        private final SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy kk:mm");

        private NoteRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Note> list, Note note, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.defaultListCellRenderer.getListCellRendererComponent(list, note, index, isSelected, cellHasFocus);
            if (note != null && comp instanceof JLabel) {
                String text = note.getFirstComment().getText();
                String userName = note.getFirstComment().getUser().getName();
                if (userName == null || userName.isEmpty()) {
                    userName = "<Anonymous>";
                }
                String toolTipText = userName + " @ " + this.sdf.format(note.getCreatedAt());
                JLabel jlabel = (JLabel)comp;
                jlabel.setText(note.getId() + ": " + text);
                ImageIcon icon = note.getId() < 0L ? ICON_NEW_SMALL : (note.getState() == Note.State.closed ? ICON_CLOSED_SMALL : ICON_OPEN_SMALL);
                jlabel.setIcon(icon);
                jlabel.setToolTipText(toolTipText);
            }
            return comp;
        }
    }
}

