/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintDialog
extends ToggleDialog {
    protected StylesTable tblStyles;
    protected StylesModel model;
    protected DefaultListSelectionModel selectionModel;
    protected OnOffAction onoffAction;
    protected ReloadAction reloadAction;
    protected MoveUpDownAction upAction;
    protected MoveUpDownAction downAction;
    protected JCheckBox cbWireframe;
    public static final JosmAction PREFERENCE_ACTION = PreferencesAction.forPreferenceSubTab(I18n.tr("Map paint preferences", new Object[0]), null, MapPaintPreference.class, "dialogs/mappaintpreference");

    public MapPaintDialog() {
        super(I18n.tr("Map Paint Styles", new Object[0]), "mapstyle", I18n.tr("configure the map painting style", new Object[0]), Shortcut.registerShortcut("subwindow:mappaint", I18n.tr("Toggle: {0}", I18n.tr("MapPaint", new Object[0])), 77, 5007), 150, false, MapPaintPreference.class);
        this.build();
    }

    protected void build() {
        this.model = new StylesModel();
        this.cbWireframe = new JCheckBox();
        JLabel wfLabel = new JLabel(I18n.tr("Wireframe View", new Object[0]), ImageProvider.get("dialogs/mappaint", "wireframe_small"), 0);
        wfLabel.setFont(wfLabel.getFont().deriveFont(0));
        this.cbWireframe.setModel(new DefaultButtonModel(){

            @Override
            public void setSelected(boolean b) {
                super.setSelected(b);
                MapPaintDialog.this.tblStyles.setEnabled(!b);
                MapPaintDialog.this.onoffAction.updateEnabledState();
                MapPaintDialog.this.upAction.updateEnabledState();
                MapPaintDialog.this.downAction.updateEnabledState();
            }
        });
        this.cbWireframe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.main.menu.wireFrameToggleAction.actionPerformed(null);
            }
        });
        this.cbWireframe.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.tblStyles = new StylesTable(this.model);
        this.selectionModel = new DefaultListSelectionModel();
        this.tblStyles.setSelectionModel(this.selectionModel);
        this.tblStyles.addMouseListener(new PopupMenuHandler());
        this.tblStyles.putClientProperty("terminateEditOnFocusLost", true);
        this.tblStyles.setBackground(UIManager.getColor("Panel.background"));
        this.tblStyles.setSelectionMode(2);
        this.tblStyles.setTableHeader(null);
        this.tblStyles.getColumnModel().getColumn(0).setMaxWidth(1);
        this.tblStyles.getColumnModel().getColumn(0).setResizable(false);
        this.tblStyles.getColumnModel().getColumn(0).setCellRenderer(new MyCheckBoxRenderer());
        this.tblStyles.getColumnModel().getColumn(1).setCellRenderer(new StyleSourceRenderer());
        this.tblStyles.setShowGrid(false);
        this.tblStyles.setIntercellSpacing(new Dimension(0, 0));
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.cbWireframe, GBC.std(0, 0));
        p.add((Component)wfLabel, GBC.std(1, 0).weight(1.0, 0.0));
        p.add((Component)this.tblStyles, GBC.std(0, 1).span(2).fill());
        this.reloadAction = new ReloadAction();
        this.onoffAction = new OnOffAction();
        this.upAction = new MoveUpDownAction(false);
        this.downAction = new MoveUpDownAction(true);
        this.selectionModel.addListSelectionListener(this.onoffAction);
        this.selectionModel.addListSelectionListener(this.reloadAction);
        this.selectionModel.addListSelectionListener(this.upAction);
        this.selectionModel.addListSelectionListener(this.downAction);
        InputMapUtils.addEnterAction(this.tblStyles, this.onoffAction);
        InputMapUtils.addSpacebarAction(this.tblStyles, this.onoffAction);
        this.createLayout(p, true, Arrays.asList(new SideButton((Action)this.onoffAction, false), new SideButton((Action)this.upAction, false), new SideButton((Action)this.downAction, false), new SideButton((Action)PREFERENCE_ACTION, false)));
    }

    @Override
    public void showNotify() {
        MapPaintStyles.addMapPaintSylesUpdateListener(this.model);
        Main.main.menu.wireFrameToggleAction.addButtonModel(this.cbWireframe.getModel());
    }

    @Override
    public void hideNotify() {
        Main.main.menu.wireFrameToggleAction.removeButtonModel(this.cbWireframe.getModel());
        MapPaintStyles.removeMapPaintSylesUpdateListener(this.model);
    }

    public class MapPaintPopup
    extends JPopupMenu {
        public MapPaintPopup() {
            this.add(MapPaintDialog.this.reloadAction);
            this.add(new SaveAsAction());
            JMenu setMenu = new JMenu(I18n.tr("Style settings", new Object[0]));
            setMenu.setIcon(ImageProvider.overlay(ImageProvider.get("preference"), ImageProvider.get("dialogs/mappaint", "pencil"), ImageProvider.OverlayPosition.SOUTHEAST));
            setMenu.setToolTipText(I18n.tr("Customize the style", new Object[0]));
            this.add(setMenu);
            int sel = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            StyleSource style = null;
            if (sel >= 0 && sel < MapPaintDialog.this.model.getRowCount()) {
                style = MapPaintDialog.this.model.getRow(sel);
            }
            if (style == null || style.settings.isEmpty()) {
                setMenu.setEnabled(false);
            } else {
                for (StyleSetting s : style.settings) {
                    s.addMenuEntry(setMenu);
                }
            }
            this.addSeparator();
            this.add(new InfoAction());
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void launch(MouseEvent evt) {
            if (MapPaintDialog.this.cbWireframe.isSelected()) {
                return;
            }
            super.launch(evt);
        }

        @Override
        protected void showMenu(MouseEvent evt) {
            this.menu = new MapPaintPopup();
            super.showMenu(evt);
        }
    }

    protected class InfoAction
    extends AbstractAction {
        boolean errorsTabLoaded;
        boolean sourceTabLoaded;

        public InfoAction() {
            this.putValue("Name", I18n.tr("Info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("view meta information, error log and source definition", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("info"));
            this.setEnabled(MapPaintDialog.this.tblStyles.getSelectedRows().length == 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sel = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            if (sel < 0 || sel >= MapPaintDialog.this.model.getRowCount()) {
                return;
            }
            final StyleSource s = MapPaintDialog.this.model.getRow(sel);
            ExtendedDialog info = new ExtendedDialog(Main.parent, I18n.tr("Map Style info", new Object[0]), new String[]{I18n.tr("Close", new Object[0])});
            info.setPreferredSize(new Dimension(600, 400));
            info.setButtonIcons(new String[]{"ok.png"});
            JTabbedPane tabs = new JTabbedPane();
            tabs.add("Info", this.buildInfoPanel(s));
            JLabel lblInfo = new JLabel(I18n.tr("Info", new Object[0]));
            lblInfo.setFont(lblInfo.getFont().deriveFont(0));
            tabs.setTabComponentAt(0, lblInfo);
            final JPanel pErrors = new JPanel(new GridBagLayout());
            tabs.add("Errors", pErrors);
            if (s.getErrors().isEmpty()) {
                JLabel lblErrors = new JLabel(I18n.tr("Errors", new Object[0]));
                lblErrors.setFont(lblInfo.getFont().deriveFont(0));
                lblErrors.setEnabled(false);
                tabs.setTabComponentAt(1, lblErrors);
                tabs.setEnabledAt(1, false);
            } else {
                JLabel lblErrors = new JLabel(I18n.tr("Errors", new Object[0]), ImageProvider.get("misc", "error"), 0);
                tabs.setTabComponentAt(1, lblErrors);
            }
            final JPanel pSource = new JPanel(new GridBagLayout());
            tabs.addTab("Source", pSource);
            JLabel lblSource = new JLabel(I18n.tr("Source", new Object[0]));
            lblSource.setFont(lblSource.getFont().deriveFont(0));
            tabs.setTabComponentAt(2, lblSource);
            tabs.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!InfoAction.this.errorsTabLoaded && ((SingleSelectionModel)e.getSource()).getSelectedIndex() == 1) {
                        InfoAction.this.errorsTabLoaded = true;
                        InfoAction.this.buildErrorsPanel(s, pErrors);
                    }
                    if (!InfoAction.this.sourceTabLoaded && ((SingleSelectionModel)e.getSource()).getSelectedIndex() == 2) {
                        InfoAction.this.sourceTabLoaded = true;
                        InfoAction.this.buildSourcePanel(s, pSource);
                    }
                }
            });
            info.setContent(tabs, false);
            info.showDialog();
        }

        private JPanel buildInfoPanel(StyleSource s) {
            JPanel p = new JPanel(new GridBagLayout());
            StringBuilder text = new StringBuilder("<table cellpadding=3>");
            text.append(this.tableRow(I18n.tr("Title:", new Object[0]), s.getDisplayString()));
            if (s.url.startsWith("http://") || s.url.startsWith("https://")) {
                text.append(this.tableRow(I18n.tr("URL:", new Object[0]), s.url));
            } else if (s.url.startsWith("resource://")) {
                text.append(this.tableRow(I18n.tr("Built-in Style, internal path:", new Object[0]), s.url));
            } else {
                text.append(this.tableRow(I18n.tr("Path:", new Object[0]), s.url));
            }
            if (s.icon != null) {
                text.append(this.tableRow(I18n.tr("Icon:", new Object[0]), s.icon));
            }
            if (s.getBackgroundColorOverride() != null) {
                text.append(this.tableRow(I18n.tr("Background:", new Object[0]), Utils.toString(s.getBackgroundColorOverride())));
            }
            text.append(this.tableRow(I18n.tr("Style is currently active?", new Object[0]), s.active ? I18n.tr("Yes", new Object[0]) : I18n.tr("No", new Object[0])));
            text.append("</table>");
            p.add((Component)new JScrollPane(new HtmlPanel(text.toString())), GBC.eol().fill(1));
            return p;
        }

        private String tableRow(String firstColumn, String secondColumn) {
            return "<tr><td><b>" + firstColumn + "</b></td><td>" + secondColumn + "</td></tr>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildSourcePanel(StyleSource s, JPanel p) {
            JosmTextArea txtSource = new JosmTextArea();
            txtSource.setFont(GuiHelper.getMonospacedFont(txtSource));
            txtSource.setEditable(false);
            p.add((Component)new JScrollPane(txtSource), GBC.std().fill());
            try {
                InputStream is = s.getSourceInputStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        txtSource.append(line + "\n");
                    }
                }
                finally {
                    s.closeSourceInputStream(is);
                }
            }
            catch (IOException ex) {
                txtSource.append("<ERROR: failed to read file!>");
            }
        }

        private void buildErrorsPanel(StyleSource s, JPanel p) {
            JosmTextArea txtErrors = new JosmTextArea();
            txtErrors.setFont(GuiHelper.getMonospacedFont(txtErrors));
            txtErrors.setEditable(false);
            p.add((Component)new JScrollPane(txtErrors), GBC.std().fill());
            for (Throwable t : s.getErrors()) {
                txtErrors.append(t.toString() + "\n");
            }
        }
    }

    protected class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            this.putValue("Name", I18n.tr("Save as...", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Save a copy of this Style to file and add it to the list", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("copy"));
            this.setEnabled(MapPaintDialog.this.tblStyles.getSelectedRows().length == 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sel = MapPaintDialog.this.tblStyles.getSelectionModel().getLeadSelectionIndex();
            if (sel < 0 || sel >= MapPaintDialog.this.model.getRowCount()) {
                return;
            }
            StyleSource s = MapPaintDialog.this.model.getRow(sel);
            FileChooserManager fcm = new FileChooserManager(false, "mappaint.clone-style.lastDirectory", System.getProperty("user.home"));
            String suggestion = fcm.getInitialDirectory() + File.separator + s.getFileNamePart();
            ExtensionFileFilter ff = s instanceof MapCSSStyleSource ? new ExtensionFileFilter("mapcss,css,zip", "mapcss", I18n.tr("Map paint style file (*.mapcss, *.zip)", new Object[0])) : new ExtensionFileFilter("xml,zip", "xml", I18n.tr("Map paint style file (*.xml, *.zip)", new Object[0]));
            fcm.createFileChooser(false, null, Arrays.asList(ff, FileFilterAllFiles.getInstance()), ff, 0).getFileChooser().setSelectedFile(new File(suggestion));
            AbstractFileChooser fc = fcm.openFileChooser();
            if (fc == null) {
                return;
            }
            Main.worker.submit(new SaveToFileTask(s, fc.getSelectedFile()));
        }

        private class SaveToFileTask
        extends PleaseWaitRunnable {
            private StyleSource s;
            private File file;
            private boolean canceled;
            private boolean error;

            public SaveToFileTask(StyleSource s, File file) {
                super(I18n.tr("Reloading style sources", new Object[0]));
                this.s = s;
                this.file = file;
            }

            @Override
            protected void cancel() {
                this.canceled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void realRun() {
                this.getProgressMonitor().indeterminateSubTask(I18n.tr("Save style ''{0}'' as ''{1}''", this.s.getDisplayString(), this.file.getPath()));
                try {
                    InputStream in = this.s.getSourceInputStream();
                    try (BufferedInputStream bis = new BufferedInputStream(in);
                         BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.file));){
                        int length;
                        byte[] buffer = new byte[4096];
                        while ((length = ((InputStream)bis).read(buffer)) > -1 && !this.canceled) {
                            ((OutputStream)bos).write(buffer, 0, length);
                        }
                    }
                    finally {
                        this.s.closeSourceInputStream(in);
                    }
                }
                catch (IOException e) {
                    this.error = true;
                }
            }

            @Override
            protected void finish() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!SaveToFileTask.this.error && !SaveToFileTask.this.canceled) {
                            SourceEntry se = new SourceEntry(SaveToFileTask.this.s);
                            se.url = SaveToFileTask.this.file.getPath();
                            MapPaintStyles.addStyle(se);
                            MapPaintDialog.this.tblStyles.getSelectionModel().setSelectionInterval(MapPaintDialog.this.model.getRowCount() - 1, MapPaintDialog.this.model.getRowCount() - 1);
                            MapPaintDialog.this.model.ensureSelectedIsVisible();
                        }
                    }
                });
            }
        }
    }

    protected class ReloadAction
    extends AbstractAction
    implements ListSelectionListener {
        public ReloadAction() {
            this.putValue("Name", I18n.tr("Reload from file", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("reload selected styles from file", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.setEnabled(this.getEnabledState());
        }

        protected boolean getEnabledState() {
            if (MapPaintDialog.this.cbWireframe.isSelected()) {
                return false;
            }
            int[] pos = MapPaintDialog.this.tblStyles.getSelectedRows();
            if (pos.length == 0) {
                return false;
            }
            for (int i : pos) {
                if (MapPaintDialog.this.model.getRow(i).isLocal()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(this.getEnabledState());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final int[] rows = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.reloadStyles(rows);
            Main.worker.submit(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MapPaintDialog.this.selectionModel.clearSelection();
                            for (int r : rows) {
                                MapPaintDialog.this.selectionModel.addSelectionInterval(r, r);
                            }
                        }
                    });
                }
            });
        }
    }

    protected class MoveUpDownAction
    extends AbstractAction
    implements ListSelectionListener {
        final int increment;

        public MoveUpDownAction(boolean isDown) {
            this.increment = isDown ? 1 : -1;
            this.putValue("Name", isDown ? I18n.tr("Down", new Object[0]) : I18n.tr("Up", new Object[0]));
            this.putValue("SmallIcon", isDown ? ImageProvider.get("dialogs", "down") : ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", isDown ? I18n.tr("Move the selected entry one row down.", new Object[0]) : I18n.tr("Move the selected entry one row up.", new Object[0]));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            int[] sel = MapPaintDialog.this.tblStyles.getSelectedRows();
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected() && MapPaintStyles.canMoveStyles(sel, this.increment));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] sel = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.moveStyles(sel, this.increment);
            MapPaintDialog.this.selectionModel.clearSelection();
            for (int row : sel) {
                MapPaintDialog.this.selectionModel.addSelectionInterval(row + this.increment, row + this.increment);
            }
            MapPaintDialog.this.model.ensureSelectedIsVisible();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    protected class OnOffAction
    extends AbstractAction
    implements ListSelectionListener {
        public OnOffAction() {
            this.putValue("Name", I18n.tr("On/Off", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Turn selected styles on or off", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("apply"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected() && MapPaintDialog.this.tblStyles.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] pos = MapPaintDialog.this.tblStyles.getSelectedRows();
            MapPaintStyles.toggleStyleActive(pos);
            MapPaintDialog.this.selectionModel.clearSelection();
            for (int p : pos) {
                MapPaintDialog.this.selectionModel.addSelectionInterval(p, p);
            }
        }
    }

    private class StyleSourceRenderer
    extends DefaultTableCellRenderer {
        private StyleSourceRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            StyleSource s = (StyleSource)value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, s.getDisplayString(), isSelected, hasFocus, row, column);
            label.setIcon(s.getIcon());
            label.setToolTipText(s.getToolTipText());
            label.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected());
            return label;
        }
    }

    private class MyCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public MyCheckBoxRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            boolean b = (Boolean)value;
            this.setSelected(b);
            this.setEnabled(!MapPaintDialog.this.cbWireframe.isSelected());
            return this;
        }
    }

    protected class StylesModel
    extends AbstractTableModel
    implements MapPaintStyles.MapPaintSylesUpdateListener {
        List<StyleSource> data = new ArrayList<StyleSource>();
        Class<?>[] columnClasses = new Class[]{Boolean.class, StyleSource.class};

        public StylesModel() {
            this.data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());
        }

        private StyleSource getRow(int i) {
            return this.data.get(i);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.getRow((int)row).active;
            }
            return this.getRow(row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.columnClasses[column];
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row < 0 || row >= this.getRowCount() || aValue == null) {
                return;
            }
            if (column == 0) {
                MapPaintStyles.toggleStyleActive(row);
            }
        }

        public void ensureSelectedIsVisible() {
            int index = MapPaintDialog.this.selectionModel.getMinSelectionIndex();
            if (index < 0) {
                return;
            }
            if (index >= this.getRowCount()) {
                return;
            }
            MapPaintDialog.this.tblStyles.scrollToVisible(index, 0);
            MapPaintDialog.this.tblStyles.repaint();
        }

        @Override
        public void mapPaintStylesUpdated() {
            this.data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());
            this.fireTableDataChanged();
            MapPaintDialog.this.tblStyles.repaint();
        }

        @Override
        public void mapPaintStyleEntryUpdated(int idx) {
            this.data = new ArrayList<StyleSource>(MapPaintStyles.getStyles().getStyleSources());
            this.fireTableRowsUpdated(idx, idx);
            MapPaintDialog.this.tblStyles.repaint();
        }
    }

    protected static class StylesTable
    extends JTable {
        public StylesTable(TableModel dm) {
            super(dm);
        }

        public void scrollToVisible(int row, int col) {
            if (!(this.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this.getParent();
            Rectangle rect = this.getCellRect(row, col, true);
            Point pt = viewport.getViewPosition();
            rect.setLocation(rect.x - pt.x, rect.y - pt.y);
            viewport.scrollRectToVisible(rect);
        }
    }
}

