/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class LayerListPopup
extends JPopupMenu {
    /*
     * WARNING - void declaration
     */
    public LayerListPopup(List<Layer> selectedLayers, Layer layer) {
        List<Object> actions;
        if (selectedLayers.size() == 1) {
            actions = Arrays.asList(selectedLayers.get(0).getMenuEntries());
        } else {
            void var5_8;
            actions = new ArrayList();
            boolean separatorAdded = true;
            for (Action a : selectedLayers.get(0).getMenuEntries()) {
                if (!separatorAdded && a instanceof Layer.SeparatorLayerAction) {
                    separatorAdded = true;
                    actions.add(a);
                    continue;
                }
                if (!(a instanceof Layer.LayerAction) || !((Layer.LayerAction)((Object)a)).supportLayers(selectedLayers)) continue;
                separatorAdded = false;
                if (a instanceof Layer.MultiLayerAction) {
                    a = ((Layer.MultiLayerAction)((Object)a)).getMultiLayerAction(selectedLayers);
                }
                actions.add(a);
            }
            boolean bl = true;
            while (var5_8 < selectedLayers.size()) {
                separatorAdded = false;
                for (Action a : selectedLayers.get((int)var5_8).getMenuEntries()) {
                    if (!(a instanceof Layer.LayerAction) || a instanceof Layer.MultiLayerAction || !((Layer.LayerAction)((Object)a)).supportLayers(selectedLayers) || actions.contains(a)) continue;
                    if (!separatorAdded) {
                        separatorAdded = true;
                        actions.add(Layer.SeparatorLayerAction.INSTANCE);
                    }
                    actions.add(a);
                }
                ++var5_8;
            }
        }
        if (!actions.isEmpty() && actions.get(actions.size() - 1) instanceof Layer.SeparatorLayerAction) {
            actions.remove(actions.size() - 1);
        }
        for (Action action : actions) {
            if (action instanceof Layer.LayerAction) {
                this.add(((Layer.LayerAction)((Object)action)).createMenuComponent());
                continue;
            }
            this.add(new JMenuItem(action));
        }
    }

    public static final class InfoAction
    extends AbstractAction {
        private final Layer layer;

        public InfoAction(Layer layer) {
            super(I18n.tr("Info", new Object[0]), ImageProvider.get("info"));
            this.putValue("help", HelpUtil.ht("/Action/LayerInfo"));
            this.layer = layer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = this.layer.getInfoComponent();
            if (object instanceof Component) {
                ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Information about layer", new Object[0]), new String[]{I18n.tr("OK", new Object[0])});
                ed.setButtonIcons(new String[]{"ok"});
                ed.setIcon(1);
                ed.setContent((Component)object);
                ed.setResizable(this.layer.isInfoResizable());
                ed.setMinimumSize(new Dimension(270, 170));
                ed.showDialog();
            } else {
                JOptionPane.showMessageDialog(Main.parent, object, I18n.tr("Information about layer", new Object[0]), 1);
            }
        }
    }
}

