/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.MultikeyActionsHandler;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog {
    private static volatile LayerListDialog instance;
    private LayerListModel model;
    private LayerList layerList;
    private SideButton opacityButton;
    ActivateLayerAction activateLayerAction;
    ShowHideLayerAction showHideLayerAction;
    private final Shortcut[] visibilityToggleShortcuts = new Shortcut[10];
    private final ToggleLayerIndexVisibility[] visibilityToggleActions = new ToggleLayerIndexVisibility[10];

    public static void createInstance(MapFrame mapFrame) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(mapFrame);
    }

    public static LayerListDialog getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    private final void createVisibilityToggleShortcuts() {
        int[] k = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
        for (int i = 0; i < 10; ++i) {
            this.visibilityToggleShortcuts[i] = Shortcut.registerShortcut("subwindow:layers:toggleLayer" + (i + 1), I18n.tr("Toggle visibility of layer: {0}", i + 1), k[i], 5004);
            this.visibilityToggleActions[i] = new ToggleLayerIndexVisibility(i);
            Main.registerActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
    }

    protected LayerListDialog(MapFrame mapFrame) {
        super(I18n.tr("Layers", new Object[0]), "layerlist", I18n.tr("Open a list of all loaded layers.", new Object[0]), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers", new Object[0])), 76, 5007), 100, true);
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.setSelectionMode(2);
        this.model = new LayerListModel(selectionModel);
        this.layerList = new LayerList(this.model);
        this.layerList.setSelectionModel(selectionModel);
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.putClientProperty("terminateEditOnFocusLost", true);
        this.layerList.putClientProperty("JTable.autoStartsEdit", false);
        this.layerList.setSelectionMode(2);
        this.layerList.setTableHeader(null);
        this.layerList.setShowGrid(false);
        this.layerList.setIntercellSpacing(new Dimension(0, 0));
        this.layerList.getColumnModel().getColumn(0).setCellRenderer(new ActiveLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new ActiveLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(0).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(0).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(0).setResizable(false);
        this.layerList.getColumnModel().getColumn(1).setCellRenderer(new LayerVisibleCellRenderer());
        this.layerList.getColumnModel().getColumn(1).setCellEditor(new LayerVisibleCellEditor(new LayerVisibleCheckBox()));
        this.layerList.getColumnModel().getColumn(1).setMaxWidth(16);
        this.layerList.getColumnModel().getColumn(1).setPreferredWidth(16);
        this.layerList.getColumnModel().getColumn(1).setResizable(false);
        this.layerList.getColumnModel().getColumn(2).setCellRenderer(new LayerNameCellRenderer());
        this.layerList.getColumnModel().getColumn(2).setCellEditor(new LayerNameCellEditor(new DisableShortcutsOnFocusGainedTextField()));
        for (KeyStroke ks : new KeyStroke[]{KeyStroke.getKeyStroke(67, GuiHelper.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(86, GuiHelper.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(40, 64), KeyStroke.getKeyStroke(38, 64), KeyStroke.getKeyStroke(37, 64), KeyStroke.getKeyStroke(39, 64), KeyStroke.getKeyStroke(40, 128), KeyStroke.getKeyStroke(38, 128), KeyStroke.getKeyStroke(37, 128), KeyStroke.getKeyStroke(39, 128), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(9, 0), KeyStroke.getKeyStroke(119, 0)}) {
            this.layerList.getInputMap(1).put(ks, new Object());
        }
        MapView mapView = mapFrame.mapView;
        this.model.populate();
        this.model.setSelectedLayer(mapView.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            @Override
            public void makeVisible(int row, Layer layer) {
                LayerListDialog.this.layerList.scrollToVisible(row, 0);
                LayerListDialog.this.layerList.repaint();
            }

            @Override
            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        MoveUpAction moveUpAction = new MoveUpAction();
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, selectionModel);
        MoveDownAction moveDownAction = new MoveDownAction();
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, selectionModel);
        this.activateLayerAction = new ActivateLayerAction();
        this.activateLayerAction.updateEnabledState();
        MultikeyActionsHandler.getInstance().addAction(this.activateLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.activateLayerAction, selectionModel);
        JumpToMarkerActions.initialize();
        this.showHideLayerAction = new ShowHideLayerAction();
        MultikeyActionsHandler.getInstance().addAction(this.showHideLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.showHideLayerAction, selectionModel);
        LayerOpacityAction layerOpacityAction = new LayerOpacityAction();
        this.adaptTo((IEnabledStateUpdating)layerOpacityAction, selectionModel);
        this.opacityButton = new SideButton((Action)layerOpacityAction, false);
        MergeAction mergeLayerAction = new MergeAction();
        this.adaptTo((IEnabledStateUpdating)mergeLayerAction, this.model);
        this.adaptTo((IEnabledStateUpdating)mergeLayerAction, selectionModel);
        DuplicateAction duplicateLayerAction = new DuplicateAction();
        this.adaptTo((IEnabledStateUpdating)duplicateLayerAction, this.model);
        this.adaptTo((IEnabledStateUpdating)duplicateLayerAction, selectionModel);
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction();
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        this.adaptTo((IEnabledStateUpdating)deleteLayerAction, selectionModel);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteLayerAction);
        InputMapUtils.addEnterAction(this.layerList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerListDialog.this.activateLayerAction.actionPerformed(null);
                LayerListDialog.this.layerList.requestFocus();
            }
        });
        InputMapUtils.addSpacebarAction(this.layerList, this.showHideLayerAction);
        this.createLayout(this.layerList, true, Arrays.asList(new SideButton((Action)moveUpAction, false), new SideButton((Action)moveDownAction, false), new SideButton((Action)this.activateLayerAction, false), new SideButton((Action)this.showHideLayerAction, false), this.opacityButton, new SideButton((Action)mergeLayerAction, false), new SideButton((Action)duplicateLayerAction, false), new SideButton((Action)deleteLayerAction, false)));
        this.createVisibilityToggleShortcuts();
    }

    @Override
    public void showNotify() {
        MapView.addLayerChangeListener(this.activateLayerAction);
        MapView.addLayerChangeListener(this.model);
        this.model.populate();
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this.model);
        MapView.removeLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    protected void adaptTo(final IEnabledStateUpdating listener, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                listener.updateEnabledState();
            }
        });
    }

    protected void adaptTo(final IEnabledStateUpdating listener, LayerListModel listModel) {
        listModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listener.updateEnabledState();
            }
        });
    }

    @Override
    public void destroy() {
        for (int i = 0; i < 10; ++i) {
            Main.unregisterActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
        MultikeyActionsHandler.getInstance().removeAction(this.activateLayerAction);
        MultikeyActionsHandler.getInstance().removeAction(this.showHideLayerAction);
        JumpToMarkerActions.unregisterActions();
        super.destroy();
        instance = null;
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        return new ShowHideLayerAction();
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction();
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer);
    }

    public static Layer getLayerForIndex(int index) {
        if (!Main.isDisplayingMapView()) {
            return null;
        }
        List<Layer> layers = Main.map.mapView.getAllLayersAsList();
        if (index < layers.size() && index >= 0) {
            return layers.get(index);
        }
        return null;
    }

    public static List<MultikeyShortcutAction.MultikeyInfo> getLayerInfoByClass(Class<?> layerClass) {
        ArrayList<MultikeyShortcutAction.MultikeyInfo> result = new ArrayList<MultikeyShortcutAction.MultikeyInfo>();
        if (!Main.isDisplayingMapView()) {
            return result;
        }
        List<Layer> layers = Main.map.mapView.getAllLayersAsList();
        int index = 0;
        for (Layer l : layers) {
            if (layerClass.isAssignableFrom(l.getClass())) {
                result.add(new MultikeyShortcutAction.MultikeyInfo(index, l.getName()));
            }
            ++index;
        }
        return result;
    }

    public static boolean isLayerValid(Layer l) {
        if (l == null || !Main.isDisplayingMapView()) {
            return false;
        }
        return Main.map.mapView.getAllLayersAsList().contains(l);
    }

    public static MultikeyShortcutAction.MultikeyInfo getLayerInfo(Layer l) {
        if (l == null || !Main.isDisplayingMapView()) {
            return null;
        }
        int index = Main.map.mapView.getAllLayersAsList().indexOf(l);
        if (index < 0) {
            return null;
        }
        return new MultikeyShortcutAction.MultikeyInfo(index, l.getName());
    }

    static class LayerList
    extends JTable {
        public LayerList(TableModel dataModel) {
            super(dataModel);
        }

        public void scrollToVisible(int row, int col) {
            if (!(this.getParent() instanceof JViewport)) {
                return;
            }
            JViewport viewport = (JViewport)this.getParent();
            Rectangle rect = this.getCellRect(row, col, true);
            Point pt = viewport.getViewPosition();
            rect.setLocation(rect.x - pt.x, rect.y - pt.y);
            viewport.scrollRectToVisible(rect);
        }
    }

    public final class LayerListModel
    extends AbstractTableModel
    implements PropertyChangeListener,
    MapView.LayerChangeListener {
        private DefaultListSelectionModel selectionModel;
        private CopyOnWriteArrayList<LayerListModelListener> listeners;

        private LayerListModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        public void addLayerListModelListener(LayerListModelListener listener) {
            if (listener != null) {
                this.listeners.addIfAbsent(listener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener listener) {
            this.listeners.remove(listener);
        }

        protected void fireMakeVisible(int index, Layer layer) {
            for (LayerListModelListener listener : this.listeners) {
                listener.makeVisible(index, layer);
            }
        }

        protected void fireRefresh() {
            for (LayerListModelListener listener : this.listeners) {
                listener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int idx = this.getLayers().indexOf(layer);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            ArrayList<Layer> selected = new ArrayList<Layer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                selected.add(this.getLayers().get(i));
            }
            return selected;
        }

        public List<Integer> getSelectedRows() {
            ArrayList<Integer> selected = new ArrayList<Integer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                selected.add(i);
            }
            return selected;
        }

        protected void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            final int size = this.getRowCount();
            final List<Integer> rows = this.getSelectedRows();
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    if (rows.isEmpty() && size > 0) {
                        LayerListModel.this.selectionModel.setSelectionInterval(size - 1, size - 1);
                    }
                    LayerListModel.this.fireTableDataChanged();
                    LayerListModel.this.fireRefresh();
                    LayerListModel.this.ensureActiveSelected();
                }
            });
        }

        protected void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireTableDataChanged();
            int idx = this.getLayers().indexOf(layer);
            LayerListDialog.this.layerList.setRowHeight(idx, Math.max(16, layer.getIcon().getIconHeight()));
            this.selectionModel.setSelectionInterval(idx, idx);
            this.ensureSelectedIsVisible();
        }

        public Layer getFirstLayer() {
            if (this.getRowCount() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return this.getLayers().get(index);
        }

        public boolean canMoveUp() {
            List<Integer> sel = this.getSelectedRows();
            return !sel.isEmpty() && sel.get(0) > 0;
        }

        public void moveUp() {
            if (!this.canMoveUp()) {
                return;
            }
            List<Integer> sel = this.getSelectedRows();
            for (int row : sel) {
                Layer l1 = this.getLayers().get(row);
                Layer l2 = this.getLayers().get(row - 1);
                Main.map.mapView.moveLayer(l2, row);
                Main.map.mapView.moveLayer(l1, row - 1);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int row : sel) {
                this.selectionModel.addSelectionInterval(row - 1, row - 1);
            }
            this.ensureSelectedIsVisible();
        }

        public boolean canMoveDown() {
            List<Integer> sel = this.getSelectedRows();
            return !sel.isEmpty() && sel.get(sel.size() - 1) < this.getLayers().size() - 1;
        }

        public void moveDown() {
            if (!this.canMoveDown()) {
                return;
            }
            List<Integer> sel = this.getSelectedRows();
            Collections.reverse(sel);
            for (int row : sel) {
                Layer l1 = this.getLayers().get(row);
                Layer l2 = this.getLayers().get(row + 1);
                Main.map.mapView.moveLayer(l1, row + 1);
                Main.map.mapView.moveLayer(l2, row);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int row : sel) {
                this.selectionModel.addSelectionInterval(row + 1, row + 1);
            }
            this.ensureSelectedIsVisible();
        }

        protected void ensureSelectedIsVisible() {
            int index = this.selectionModel.getMinSelectionIndex();
            if (index < 0) {
                return;
            }
            if (index >= this.getLayers().size()) {
                return;
            }
            Layer layer = this.getLayers().get(index);
            this.fireMakeVisible(index, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer source) {
            ArrayList<Layer> targets = new ArrayList<Layer>();
            if (source == null) {
                return targets;
            }
            for (Layer target : this.getLayers()) {
                if (source == target || !target.isMergable(source) || !source.isMergable(target)) continue;
                targets.add(target);
            }
            return targets;
        }

        public List<Layer> getLayers() {
            if (!Main.isDisplayingMapView()) {
                return Collections.emptyList();
            }
            return Main.map.mapView.getAllLayersAsList();
        }

        protected void ensureActiveSelected() {
            if (this.getLayers().isEmpty()) {
                return;
            }
            Layer activeLayer = this.getActiveLayer();
            if (activeLayer != null) {
                int idx = this.getLayers().indexOf(activeLayer);
                this.selectionModel.setSelectionInterval(idx, idx);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        protected Layer getActiveLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.map.mapView.getActiveLayer();
        }

        @Override
        public int getRowCount() {
            List<Layer> layers = this.getLayers();
            if (layers == null) {
                return 0;
            }
            return layers.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= 0 && row < this.getLayers().size()) {
                switch (col) {
                    case 0: {
                        return this.getLayers().get(row) == this.getActiveLayer();
                    }
                    case 1: {
                        return this.getLayers().get(row);
                    }
                    case 2: {
                        return this.getLayers().get(row);
                    }
                }
                throw new RuntimeException();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0 || this.getActiveLayer() != this.getLayers().get(row);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Layer l = this.getLayers().get(row);
            switch (col) {
                case 0: {
                    Main.map.mapView.setActiveLayer(l);
                    l.setVisible(true);
                    break;
                }
                case 1: {
                    l.setVisible((Boolean)value);
                    break;
                }
                case 2: {
                    l.setName((String)value);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public void activeLayerChange(final Layer oldLayer, final Layer newLayer) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    int idx;
                    if (oldLayer != null && (idx = LayerListModel.this.getLayers().indexOf(oldLayer)) >= 0) {
                        LayerListModel.this.fireTableRowsUpdated(idx, idx);
                    }
                    if (newLayer != null && (idx = LayerListModel.this.getLayers().indexOf(newLayer)) >= 0) {
                        LayerListModel.this.fireTableRowsUpdated(idx, idx);
                    }
                    LayerListModel.this.ensureActiveSelected();
                }
            });
        }

        @Override
        public void layerAdded(Layer newLayer) {
            this.onAddLayer(newLayer);
        }

        @Override
        public void layerRemoved(Layer oldLayer) {
            this.onRemoveLayer(oldLayer);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof Layer) {
                Layer layer = (Layer)evt.getSource();
                int idx = this.getLayers().indexOf(layer);
                if (idx < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class MoveDownAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveDownAction() {
            this.putValue("Name", I18n.tr("Move down", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "down"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row down.", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveDown());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayerListDialog.this.model.moveDown();
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveUpAction() {
            this.putValue("Name", I18n.tr("Move up", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row up.", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveUp());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayerListDialog.this.model.moveUp();
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void showMenu(MouseEvent evt) {
            Layer layer = LayerListDialog.this.getModel().getLayer(LayerListDialog.this.layerList.getSelectedRow());
            this.menu = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers(), layer);
            super.showMenu(evt);
        }
    }

    private static class LayerNameCellEditor
    extends DefaultCellEditor {
        public LayerNameCellEditor(DisableShortcutsOnFocusGainedTextField tf) {
            super(tf);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JosmTextField tf = (JosmTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            tf.setText(value == null ? "" : ((Layer)value).getName());
            return tf;
        }
    }

    private class LayerNameCellRenderer
    extends DefaultTableCellRenderer {
        private LayerNameCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            Layer layer = (Layer)value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, layer.getName(), isSelected, hasFocus, row, column);
            if (this.isActiveLayer(layer)) {
                label.setFont(label.getFont().deriveFont(1));
            }
            if (Main.pref.getBoolean("dialog.layer.colorname", true)) {
                Color c = layer.getColor(false);
                if (c != null) {
                    Color oc = null;
                    for (Layer l : LayerListDialog.this.model.getLayers()) {
                        oc = l.getColor(false);
                        if (oc == null) continue;
                        if (!oc.equals(c)) break;
                        oc = null;
                    }
                    if (oc == null) {
                        c = null;
                    }
                }
                if (c == null) {
                    c = Main.pref.getUIColor(isSelected ? "Table.selectionForeground" : "Table.foreground");
                }
                label.setForeground(c);
            }
            label.setIcon(layer.getIcon());
            label.setToolTipText(layer.getToolTipText());
            return label;
        }
    }

    private static class LayerVisibleCellEditor
    extends DefaultCellEditor {
        final LayerVisibleCheckBox cb;

        public LayerVisibleCellEditor(LayerVisibleCheckBox cb) {
            super(cb);
            this.cb = cb;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cb.updateStatus((Layer)value);
            return this.cb;
        }
    }

    private static class LayerVisibleCellRenderer
    implements TableCellRenderer {
        final LayerVisibleCheckBox cb = new LayerVisibleCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.cb.updateStatus((Layer)value);
            }
            return this.cb;
        }
    }

    private static class ActiveLayerCellRenderer
    implements TableCellRenderer {
        final JCheckBox cb = new ActiveLayerCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean active = value != null && (Boolean)value != false;
            this.cb.setSelected(active);
            this.cb.setToolTipText(active ? I18n.tr("this layer is the active layer", new Object[0]) : I18n.tr("this layer is not currently active (click to activate)", new Object[0]));
            return this.cb;
        }
    }

    private static class LayerVisibleCheckBox
    extends JCheckBox {
        private final ImageIcon iconEye;
        private final ImageIcon iconEyeTranslucent;
        private boolean isTranslucent;

        public LayerVisibleCheckBox() {
            this.setHorizontalAlignment(4);
            this.iconEye = ImageProvider.get("dialogs/layerlist", "eye");
            this.iconEyeTranslucent = ImageProvider.get("dialogs/layerlist", "eye-translucent");
            this.setIcon(ImageProvider.get("dialogs/layerlist", "eye-off"));
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "eye-pressed"));
            this.setSelectedIcon(this.iconEye);
            this.isTranslucent = false;
        }

        public void setTranslucent(boolean isTranslucent) {
            if (this.isTranslucent == isTranslucent) {
                return;
            }
            if (isTranslucent) {
                this.setSelectedIcon(this.iconEyeTranslucent);
            } else {
                this.setSelectedIcon(this.iconEye);
            }
            this.isTranslucent = isTranslucent;
        }

        public void updateStatus(Layer layer) {
            boolean visible = layer.isVisible();
            this.setSelected(visible);
            this.setTranslucent(layer.getOpacity() < 1.0);
            this.setToolTipText(visible ? I18n.tr("layer is currently visible (click to hide layer)", new Object[0]) : I18n.tr("layer is currently hidden (click to show layer)", new Object[0]));
        }
    }

    private static class ActiveLayerCheckBox
    extends JCheckBox {
        public ActiveLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon blank = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon active = ImageProvider.get("dialogs/layerlist", "active");
            this.setIcon(blank);
            this.setSelectedIcon(active);
            this.setRolloverIcon(blank);
            this.setRolloverSelectedIcon(active);
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "active-pressed"));
        }
    }

    public final class DuplicateAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public DuplicateAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public DuplicateAction() {
            this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
            this.putValue("ShortDescription", I18n.tr("Duplicate this layer", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DuplicateLayer"));
            this.updateEnabledState();
        }

        private void duplicate(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return;
            }
            ArrayList<String> layerNames = new ArrayList<String>();
            for (Layer l : Main.map.mapView.getAllLayers()) {
                layerNames.add(l.getName());
            }
            if (layer instanceof OsmDataLayer) {
                OsmDataLayer oldLayer = (OsmDataLayer)layer;
                String newName = I18n.tr("Copy of {0}", oldLayer.getName());
                int i = 2;
                while (layerNames.contains(newName)) {
                    newName = I18n.tr("Copy {1} of {0}", oldLayer.getName(), i);
                    ++i;
                }
                Main.main.addLayer(new OsmDataLayer(oldLayer.data.clone(), newName, null));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.layer != null) {
                this.duplicate(this.layer);
            } else {
                this.duplicate(LayerListDialog.this.getModel().getSelectedLayers().get(0));
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() == 1) {
                    this.setEnabled(LayerListDialog.this.getModel().getSelectedLayers().get(0) instanceof OsmDataLayer);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(this.layer instanceof OsmDataLayer);
            }
        }
    }

    public final class MergeAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public MergeAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Merge", new Object[0]));
            this.updateEnabledState();
        }

        public MergeAction() {
            this.putValue("Name", I18n.tr("Merge", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "mergedown"));
            this.putValue("ShortDescription", I18n.tr("Merge this layer into another layer", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#MergeLayer"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.layer != null) {
                Main.main.menu.merge.merge(this.layer);
            } else if (LayerListDialog.this.getModel().getSelectedLayers().size() == 1) {
                Layer selectedLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                Main.main.menu.merge.merge(selectedLayer);
            } else {
                Main.main.menu.merge.merge(LayerListDialog.this.getModel().getSelectedLayers());
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().isEmpty()) {
                    this.setEnabled(false);
                } else if (LayerListDialog.this.getModel().getSelectedLayers().size() > 1) {
                    Layer firstLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                    for (Layer l : LayerListDialog.this.getModel().getSelectedLayers()) {
                        if (l == firstLayer || l.isMergable(firstLayer) && firstLayer.isMergable(l)) continue;
                        this.setEnabled(false);
                        return;
                    }
                    this.setEnabled(true);
                } else {
                    Layer selectedLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                    List<Layer> targets = LayerListDialog.this.getModel().getPossibleMergeTargets(selectedLayer);
                    this.setEnabled(!targets.isEmpty());
                }
            } else {
                List<Layer> targets = LayerListDialog.this.getModel().getPossibleMergeTargets(this.layer);
                this.setEnabled(!targets.isEmpty());
            }
        }
    }

    public final class ActivateLayerAction
    extends AbstractAction
    implements MapView.LayerChangeListener,
    IEnabledStateUpdating,
    MultikeyShortcutAction {
        private Layer layer;
        private Shortcut multikeyShortcut;

        public ActivateLayerAction(Layer layer) {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Activate", new Object[0]));
            this.updateEnabledState();
        }

        public ActivateLayerAction() {
            this.putValue("Name", I18n.tr("Activate", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "activate"));
            this.putValue("ShortDescription", I18n.tr("Activate the selected layer", new Object[0]));
            this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:activateLayer", I18n.tr("Multikey: {0}", I18n.tr("Activate layer", new Object[0])), 65, 5005);
            this.multikeyShortcut.setAccelerator(this);
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ActivateLayer"));
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return this.multikeyShortcut;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer toActivate = this.layer != null ? this.layer : LayerListDialog.this.model.getSelectedLayers().get(0);
            this.execute(toActivate);
        }

        private void execute(Layer layer) {
            Main.map.mapView.setActiveLayer(layer);
            layer.setVisible(true);
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public void updateEnabledState() {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    if (ActivateLayerAction.this.layer == null) {
                        if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                            ActivateLayerAction.this.setEnabled(false);
                            return;
                        }
                        Layer selectedLayer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                        ActivateLayerAction.this.setEnabled(!ActivateLayerAction.this.isActiveLayer(selectedLayer));
                    } else {
                        ActivateLayerAction.this.setEnabled(!ActivateLayerAction.this.isActiveLayer(ActivateLayerAction.this.layer));
                    }
                }
            });
        }

        @Override
        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledState();
        }

        @Override
        public void layerAdded(Layer newLayer) {
            this.updateEnabledState();
        }

        @Override
        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledState();
        }

        @Override
        public void executeMultikeyAction(int index, boolean repeat) {
            Layer l = LayerListDialog.getLayerForIndex(index);
            if (l != null) {
                this.execute(l);
            }
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            return LayerListDialog.getLayerInfoByClass(Layer.class);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            return null;
        }
    }

    public final class LayerOpacityAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        private Layer layer;
        private JPopupMenu popup;
        private JSlider slider = new JSlider(1);

        public LayerOpacityAction(Layer layer) throws IllegalArgumentException {
            this();
            this.putValue("Name", I18n.tr("Opacity", new Object[0]));
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public LayerOpacityAction() {
            this.putValue("Name", I18n.tr("Opacity", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Adjust opacity of the layer.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/layerlist", "transparency"));
            this.updateEnabledState();
            this.popup = new JPopupMenu();
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    LayerOpacityAction.this.setOpacity((double)LayerOpacityAction.this.slider.getValue() / 100.0);
                }
            });
            this.popup.add(this.slider);
        }

        private void setOpacity(double value) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.layer != null) {
                this.layer.setOpacity(value);
            } else {
                for (Layer layer : LayerListDialog.this.model.getSelectedLayers()) {
                    layer.setOpacity(value);
                }
            }
        }

        private double getOpacity() {
            if (this.layer != null) {
                return this.layer.getOpacity();
            }
            double opacity = 0.0;
            List<Layer> layers = LayerListDialog.this.model.getSelectedLayers();
            for (Layer layer : layers) {
                opacity += layer.getOpacity();
            }
            return opacity / (double)layers.size();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.slider.setValue((int)Math.round(this.getOpacity() * 100.0));
            if (e.getSource() == LayerListDialog.this.opacityButton) {
                this.popup.show(LayerListDialog.this.opacityButton, 0, LayerListDialog.this.opacityButton.getHeight());
            } else {
                this.popup.show(Main.parent, Main.parent.getWidth() / 2, (Main.parent.getHeight() - this.popup.getHeight()) / 2);
            }
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof LayerOpacityAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public final class ShowHideLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction,
    MultikeyShortcutAction {
        private WeakReference<Layer> lastLayer;
        private Shortcut multikeyShortcut;

        public ShowHideLayerAction() {
            this.putValue("Name", I18n.tr("Show/hide", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the selected layer.", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ShowHideLayer"));
            this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:showHideLayer", I18n.tr("Multikey: {0}", I18n.tr("Show/hide layer", new Object[0])), 83, 5005);
            this.multikeyShortcut.setAccelerator(this);
            this.updateEnabledState();
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return this.multikeyShortcut;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Layer l : LayerListDialog.this.model.getSelectedLayers()) {
                l.toggleVisible();
            }
        }

        @Override
        public void executeMultikeyAction(int index, boolean repeat) {
            Layer l = LayerListDialog.getLayerForIndex(index);
            if (l != null) {
                l.toggleVisible();
                this.lastLayer = new WeakReference<Layer>(l);
            } else if (repeat && this.lastLayer != null && LayerListDialog.isLayerValid(l = (Layer)this.lastLayer.get())) {
                l.toggleVisible();
            }
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!LayerListDialog.this.model.getSelectedLayers().isEmpty());
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof ShowHideLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            return LayerListDialog.getLayerInfoByClass(Layer.class);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            if (this.lastLayer != null) {
                return LayerListDialog.getLayerInfo((Layer)this.lastLayer.get());
            }
            return null;
        }
    }

    public final class DeleteLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        public DeleteLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected layers.", new Object[0]));
            this.putValue("Name", I18n.tr("Delete", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DeleteLayer"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Layer> selectedLayers = LayerListDialog.this.getModel().getSelectedLayers();
            if (selectedLayers.isEmpty()) {
                return;
            }
            if (!Main.saveUnsavedModifications(selectedLayers, false)) {
                return;
            }
            for (Layer l : selectedLayers) {
                Main.main.removeLayer(l);
            }
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> layers) {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof DeleteLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    protected static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }

    private final class ToggleLayerIndexVisibility
    extends AbstractAction {
        int layerIndex = -1;

        public ToggleLayerIndexVisibility(int layerIndex) {
            this.layerIndex = layerIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer l = LayerListDialog.this.model.getLayer(LayerListDialog.this.model.getRowCount() - this.layerIndex - 1);
            if (l != null) {
                l.toggleVisible();
            }
        }
    }
}

