/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

public class LatLonDialog
extends ExtendedDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    public JTabbedPane tabs;
    private JosmTextField tfLatLon;
    private JosmTextField tfEastNorth;
    private LatLon latLonCoordinates;
    private EastNorth eastNorthCoordinates;
    private static final char N_TR = LatLon.NORTH.charAt(0);
    private static final char S_TR = LatLon.SOUTH.charAt(0);
    private static final char E_TR = LatLon.EAST.charAt(0);
    private static final char W_TR = LatLon.WEST.charAt(0);
    private static final Pattern p = Pattern.compile("([+|-]?\\d+[.,]\\d+)|([+|-]?\\d+)|(\u00b0|o|deg)|('|\u2032|min)|(\"|\u2033|sec)|(,|;)|([NSEW" + N_TR + S_TR + E_TR + W_TR + "])|" + "\\s+|" + "(.+)");

    protected JPanel buildLatLon() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel(I18n.tr("Coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfLatLon = new JosmTextField(24);
        pnl.add((Component)this.tfLatLon, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)new HtmlPanel(I18n.tr("Enter the coordinates for the new node.<br/>You can separate longitude and latitude with space, comma or semicolon.<br/>Use positive numbers or N, E characters to indicate North or East cardinal direction.<br/>For South and West cardinal directions you can use either negative numbers or S, W characters.<br/>Coordinate value can be in one of three formats:<ul><li><i>degrees</i><tt>&deg;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt> <i>seconds</i><tt>&quot</tt></li></ul>Symbols <tt>&deg;</tt>, <tt>&#39;</tt>, <tt>&prime;</tt>, <tt>&quot;</tt>, <tt>&Prime;</tt> are optional.<br/><br/>Some examples:<ul>{0}</ul>", "<li>49.29918&deg; 19.24788&deg;</li><li>N 49.29918 E 19.24788</li><li>W 49&deg;29.918&#39; S 19&deg;24.788&#39;</li><li>N 49&deg;29&#39;04&quot; E 19&deg;24&#39;43&quot;</li><li>49.29918 N, 19.24788 E</li><li>49&deg;29&#39;21&quot; N 19&deg;24&#39;38&quot; E</li><li>49 29 51, 19 24 18</li><li>49 29, 19 24</li><li>E 49 29, N 19 24</li><li>49&deg; 29; 19&deg; 24</li><li>N 49&deg; 29, W 19&deg; 24</li><li>49&deg; 29.5 S, 19&deg; 24.6 E</li><li>N 49 29.918 E 19 15.88</li><li>49 29.4 19 24.5</li><li>-49 29.4 N -19 24.5 W</li><li>48 deg 42&#39; 52.13\" N, 21 deg 11&#39; 47.60\" E</li>")), GBC.eol().fill().weight(1.0, 1.0));
        LatLonInputVerifier inputVerifier = new LatLonInputVerifier();
        this.tfLatLon.getDocument().addDocumentListener(inputVerifier);
        TextFieldFocusHandler focusHandler = new TextFieldFocusHandler();
        this.tfLatLon.addFocusListener(focusHandler);
        return pnl;
    }

    private JPanel buildEastNorth() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel(I18n.tr("Projected coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfEastNorth = new JosmTextField(24);
        pnl.add((Component)this.tfEastNorth, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        pnl.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        pnl.add((Component)new HtmlPanel(I18n.tr("Enter easting and northing (x and y) separated by space, comma or semicolon.", new Object[0])), GBC.eol().fill(2));
        pnl.add(GBC.glue(1, 1), GBC.eol().fill().weight(1.0, 1.0));
        EastNorthInputVerifier inputVerifier = new EastNorthInputVerifier();
        this.tfEastNorth.getDocument().addDocumentListener(inputVerifier);
        TextFieldFocusHandler focusHandler = new TextFieldFocusHandler();
        this.tfEastNorth.addFocusListener(focusHandler);
        return pnl;
    }

    protected void build() {
        this.tabs = new JTabbedPane();
        this.tabs.addTab(I18n.tr("Lat/Lon", new Object[0]), this.buildLatLon());
        this.tabs.addTab(I18n.tr("East/North", new Object[0]), this.buildEastNorth());
        this.tabs.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                switch (LatLonDialog.this.tabs.getModel().getSelectedIndex()) {
                    case 0: {
                        LatLonDialog.this.parseLatLonUserInput();
                        break;
                    }
                    case 1: {
                        LatLonDialog.this.parseEastNorthUserInput();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        });
        this.setContent(this.tabs, false);
    }

    public LatLonDialog(Component parent, String title, String help) {
        super(parent, title, new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.setButtonIcons(new String[]{"ok", "cancel"});
        this.configureContextsensitiveHelp(help, true);
        this.build();
        this.setCoordinates(null);
    }

    public boolean isLatLon() {
        return this.tabs.getModel().getSelectedIndex() == 0;
    }

    public void setCoordinates(LatLon ll) {
        if (ll == null) {
            ll = new LatLon(0.0, 0.0);
        }
        this.latLonCoordinates = ll;
        this.tfLatLon.setText(ll.latToString(CoordinateFormat.getDefaultFormat()) + " " + ll.lonToString(CoordinateFormat.getDefaultFormat()));
        EastNorth en = Main.getProjection().latlon2eastNorth(ll);
        this.tfEastNorth.setText(en.east() + " " + en.north());
        this.setOkEnabled(true);
    }

    public LatLon getCoordinates() {
        if (this.isLatLon()) {
            return this.latLonCoordinates;
        }
        if (this.eastNorthCoordinates == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(this.eastNorthCoordinates);
    }

    public LatLon getLatLonCoordinates() {
        return this.latLonCoordinates;
    }

    public EastNorth getEastNorthCoordinates() {
        return this.eastNorthCoordinates;
    }

    protected void setErrorFeedback(JosmTextField tf, String message) {
        tf.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        tf.setToolTipText(message);
        tf.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JosmTextField tf, String message) {
        tf.setBorder(UIManager.getBorder("TextField.border"));
        tf.setToolTipText(message);
        tf.setBackground(UIManager.getColor("TextField.background"));
    }

    protected Double parseDoubleFromUserInput(String input) {
        if (input == null) {
            return null;
        }
        input = input.trim();
        input = input.replaceAll("\u00b0", "");
        NumberFormat f = NumberFormat.getNumberInstance();
        Number n = null;
        ParsePosition pp = new ParsePosition(0);
        n = f.parse(input, pp);
        if (pp.getErrorIndex() >= 0 || pp.getIndex() < input.length()) {
            pp = new ParsePosition(0);
            f = NumberFormat.getNumberInstance(Locale.ENGLISH);
            n = f.parse(input, pp);
            if (pp.getErrorIndex() >= 0 || pp.getIndex() < input.length()) {
                return null;
            }
        }
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    protected void parseLatLonUserInput() {
        LatLon latLon;
        try {
            latLon = LatLonDialog.parseLatLon(this.tfLatLon.getText());
            if (!LatLon.isValidLat(latLon.lat()) || !LatLon.isValidLon(latLon.lon())) {
                latLon = null;
            }
        }
        catch (IllegalArgumentException e) {
            latLon = null;
        }
        if (latLon == null) {
            this.setErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = latLon;
            this.setOkEnabled(true);
        }
    }

    protected void parseEastNorthUserInput() {
        EastNorth en;
        try {
            en = LatLonDialog.parseEastNorth(this.tfEastNorth.getText());
        }
        catch (IllegalArgumentException e) {
            en = null;
        }
        if (en == null) {
            this.setErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.eastNorthCoordinates = en;
            this.setOkEnabled(true);
        }
    }

    private void setOkEnabled(boolean b) {
        if (this.buttons != null && !this.buttons.isEmpty()) {
            ((JButton)this.buttons.get(0)).setEnabled(b);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            WindowGeometry.centerInWindow(Main.parent, this.getSize()).applySafe(this);
        }
        super.setVisible(visible);
    }

    public static LatLon parseLatLon(String coord) {
        Matcher m = p.matcher(coord);
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        while (m.find()) {
            if (m.group(1) != null) {
                sb.append('R');
                list.add(Double.parseDouble(m.group(1).replace(',', '.')));
                continue;
            }
            if (m.group(2) != null) {
                sb.append('Z');
                list.add(Double.parseDouble(m.group(2)));
                continue;
            }
            if (m.group(3) != null) {
                sb.append('o');
                continue;
            }
            if (m.group(4) != null) {
                sb.append('\'');
                continue;
            }
            if (m.group(5) != null) {
                sb.append('\"');
                continue;
            }
            if (m.group(6) != null) {
                sb.append(',');
                continue;
            }
            if (m.group(7) != null) {
                sb.append("x");
                String c = m.group(7).toUpperCase();
                if ("N".equals(c) || "S".equals(c) || "E".equals(c) || "W".equals(c)) {
                    list.add(c);
                    continue;
                }
                list.add(c.replace(N_TR, 'N').replace(S_TR, 'S').replace(E_TR, 'E').replace(W_TR, 'W'));
                continue;
            }
            if (m.group(8) == null) continue;
            throw new IllegalArgumentException("invalid token: " + m.group(8));
        }
        String pattern = sb.toString();
        Object[] params = list.toArray();
        LatLonHolder latLon = new LatLonHolder();
        if (pattern.matches("Ro?,?Ro?")) {
            LatLonDialog.setLatLonObj(latLon, params[0], 0.0, 0.0, "N", params[1], 0.0, 0.0, "E");
        } else if (pattern.matches("xRo?,?xRo?")) {
            LatLonDialog.setLatLonObj(latLon, params[1], 0.0, 0.0, params[0], params[3], 0.0, 0.0, params[2]);
        } else if (pattern.matches("Ro?x,?Ro?x")) {
            LatLonDialog.setLatLonObj(latLon, params[0], 0.0, 0.0, params[1], params[2], 0.0, 0.0, params[3]);
        } else if (pattern.matches("Zo[RZ]'?,?Zo[RZ]'?|Z[RZ],?Z[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], 0.0, "N", params[2], params[3], 0.0, "E");
        } else if (pattern.matches("xZo[RZ]'?,?xZo[RZ]'?|xZo?[RZ],?xZo?[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[1], params[2], 0.0, params[0], params[4], params[5], 0.0, params[3]);
        } else if (pattern.matches("Zo[RZ]'?x,?Zo[RZ]'?x|Zo?[RZ]x,?Zo?[RZ]x")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], 0.0, params[2], params[3], params[4], 0.0, params[5]);
        } else if (pattern.matches("ZoZ'[RZ]\"?x,?ZoZ'[RZ]\"?x|ZZ[RZ]x,?ZZ[RZ]x")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7]);
        } else if (pattern.matches("xZoZ'[RZ]\"?,?xZoZ'[RZ]\"?|xZZ[RZ],?xZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[1], params[2], params[3], params[0], params[5], params[6], params[7], params[4]);
        } else if (pattern.matches("ZZ[RZ],?ZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLon, params[0], params[1], params[2], "N", params[3], params[4], params[5], "E");
        } else {
            throw new IllegalArgumentException("invalid format: " + pattern);
        }
        return new LatLon(latLon.lat, latLon.lon);
    }

    public static EastNorth parseEastNorth(String s) {
        String[] en = s.split("[;, ]+");
        if (en.length != 2) {
            return null;
        }
        try {
            double east = Double.parseDouble(en[0]);
            double north = Double.parseDouble(en[1]);
            return new EastNorth(east, north);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static void setLatLonObj(LatLonHolder latLon, Object coord1deg, Object coord1min, Object coord1sec, Object card1, Object coord2deg, Object coord2min, Object coord2sec, Object card2) {
        LatLonDialog.setLatLon(latLon, (Double)coord1deg, (Double)coord1min, (Double)coord1sec, (String)card1, (Double)coord2deg, (Double)coord2min, (Double)coord2sec, (String)card2);
    }

    private static void setLatLon(LatLonHolder latLon, double coord1deg, double coord1min, double coord1sec, String card1, double coord2deg, double coord2min, double coord2sec, String card2) {
        LatLonDialog.setLatLon(latLon, coord1deg, coord1min, coord1sec, card1);
        LatLonDialog.setLatLon(latLon, coord2deg, coord2min, coord2sec, card2);
    }

    private static void setLatLon(LatLonHolder latLon, double coordDeg, double coordMin, double coordSec, String card) {
        if (coordDeg < -180.0 || coordDeg > 180.0 || coordMin < 0.0 || coordMin >= 60.0 || coordSec < 0.0 || coordSec > 60.0) {
            throw new IllegalArgumentException("out of range");
        }
        double coord = (double)(coordDeg < 0.0 ? -1 : 1) * (Math.abs(coordDeg) + coordMin / 60.0 + coordSec / 3600.0);
        double d = coord = "N".equals(card) || "E".equals(card) ? coord : -coord;
        if ("N".equals(card) || "S".equals(card)) {
            latLon.lat = coord;
        } else {
            latLon.lon = coord;
        }
    }

    public String getLatLonText() {
        return this.tfLatLon.getText();
    }

    public void setLatLonText(String text) {
        this.tfLatLon.setText(text);
    }

    public String getEastNorthText() {
        return this.tfEastNorth.getText();
    }

    public void setEastNorthText(String text) {
        this.tfEastNorth.setText(text);
    }

    private static class LatLonHolder {
        double lat;
        double lon;

        private LatLonHolder() {
        }
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (c instanceof JosmTextField) {
                JosmTextField tf = (JosmTextField)c;
                tf.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class EastNorthInputVerifier
    implements DocumentListener {
        EastNorthInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LatLonDialog.this.parseEastNorthUserInput();
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LatLonDialog.this.parseLatLonUserInput();
        }
    }
}

