/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;
import org.openstreetmap.josm.tools.date.DateUtils;

public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected List<OsmPrimitive> primitives;
    protected OsmDataLayer layer;
    private JosmTextArea txtMappaint;
    boolean mappaintTabLoaded;

    public InspectPrimitiveDialog(Collection<OsmPrimitive> primitives, OsmDataLayer layer) {
        super(Main.parent, I18n.tr("Advanced object info", new Object[0]), new String[]{I18n.tr("Close", new Object[0])});
        this.primitives = new ArrayList<OsmPrimitive>(primitives);
        this.layer = layer;
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(750, 550)));
        this.setButtonIcons(new String[]{"ok.png"});
        JTabbedPane tabs = new JTabbedPane();
        JPanel pData = this.buildDataPanel();
        tabs.addTab(I18n.tr("data", new Object[0]), pData);
        final JPanel pMapPaint = new JPanel();
        tabs.addTab(I18n.tr("map style", new Object[0]), pMapPaint);
        tabs.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!InspectPrimitiveDialog.this.mappaintTabLoaded && ((SingleSelectionModel)e.getSource()).getSelectedIndex() == 1) {
                    InspectPrimitiveDialog.this.mappaintTabLoaded = true;
                    InspectPrimitiveDialog.this.buildMapPaintPanel(pMapPaint);
                    InspectPrimitiveDialog.this.createMapPaintText();
                }
            }
        });
        this.setContent(tabs, false);
    }

    protected JPanel buildDataPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        JosmTextArea txtData = new JosmTextArea();
        txtData.setFont(GuiHelper.getMonospacedFont(txtData));
        txtData.setEditable(false);
        txtData.setText(this.buildDataText());
        txtData.setSelectionStart(0);
        txtData.setSelectionEnd(0);
        JScrollPane scroll = new JScrollPane(txtData);
        p.add((Component)scroll, GBC.std().fill());
        return p;
    }

    protected String buildDataText() {
        DataText dt = new DataText();
        Collections.sort(this.primitives, new OsmPrimitiveComparator());
        for (OsmPrimitive o : this.primitives) {
            dt.addPrimitive(o);
        }
        return dt.toString();
    }

    protected void buildMapPaintPanel(JPanel p) {
        p.setLayout(new GridBagLayout());
        this.txtMappaint = new JosmTextArea();
        this.txtMappaint.setFont(GuiHelper.getMonospacedFont(this.txtMappaint));
        this.txtMappaint.setEditable(false);
        p.add((Component)new JScrollPane(this.txtMappaint), GBC.std().fill());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMapPaintText() {
        Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getAllSelected();
        ElemStyles elemstyles = MapPaintStyles.getStyles();
        MapView nc = Main.map.mapView;
        double scale = nc.getDist100Pixel();
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            for (OsmPrimitive osm : sel) {
                this.txtMappaint.append(I18n.tr("Styles Cache for \"{0}\":", osm.getDisplayName(DefaultNameFormatter.getInstance())));
                MultiCascade mc = new MultiCascade();
                for (StyleSource s : elemstyles.getStyleSources()) {
                    if (s.active) {
                        this.txtMappaint.append(I18n.tr("\n\n> applying {0} style \"{1}\"\n", this.getSort(s), s.getDisplayString()));
                        s.apply(mc, osm, scale, false);
                        this.txtMappaint.append(I18n.tr("\nRange:{0}", mc.range));
                        for (Map.Entry<String, Cascade> e : mc.getLayers()) {
                            this.txtMappaint.append("\n " + e.getKey() + ": \n" + e.getValue());
                        }
                        continue;
                    }
                    this.txtMappaint.append(I18n.tr("\n\n> skipping \"{0}\" (not active)", s.getDisplayString()));
                }
                this.txtMappaint.append(I18n.tr("\n\nList of generated Styles:\n", new Object[0]));
                StyleCache.StyleList sl = elemstyles.get(osm, scale, nc);
                for (ElemStyle s : sl) {
                    this.txtMappaint.append(" * " + s + "\n");
                }
                this.txtMappaint.append("\n\n");
            }
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
        if (sel.size() == 2) {
            ArrayList<OsmPrimitive> selList = new ArrayList<OsmPrimitive>(sel);
            StyleCache sc1 = ((OsmPrimitive)selList.get((int)0)).mappaintStyle;
            StyleCache sc2 = ((OsmPrimitive)selList.get((int)1)).mappaintStyle;
            if (sc1 == sc2) {
                this.txtMappaint.append(I18n.tr("The 2 selected objects have identical style caches.", new Object[0]));
            }
            if (!sc1.equals(sc2)) {
                this.txtMappaint.append(I18n.tr("The 2 selected objects have different style caches.", new Object[0]));
            }
            if (sc1.equals(sc2) && sc1 != sc2) {
                this.txtMappaint.append(I18n.tr("Warning: The 2 selected objects have equal, but not identical style caches.", new Object[0]));
            }
        }
    }

    private String getSort(StyleSource s) {
        if (s instanceof XmlStyleSource) {
            return I18n.tr("xml", new Object[0]);
        }
        if (s instanceof MapCSSStyleSource) {
            return I18n.tr("mapcss", new Object[0]);
        }
        return I18n.tr("unknown", new Object[0]);
    }

    class DataText {
        private StringBuilder s = new StringBuilder();

        DataText() {
        }

        private DataText add(String title, String ... values) {
            this.s.append("  ").append(title);
            for (String v : values) {
                this.s.append(v);
            }
            this.s.append("\n");
            return this;
        }

        private String getNameAndId(String name, long id) {
            if (name != null) {
                return name + I18n.tr(" ({0})", Long.toString(id));
            }
            return Long.toString(id);
        }

        public void addPrimitive(OsmPrimitive o) {
            this.addHeadline(o);
            if (o.getDataSet() == null || o.getDataSet().getPrimitiveById(o) == null) {
                this.s.append("\n").append("  ").append(I18n.tr("not in data set", new Object[0])).append("\n");
                return;
            }
            if (o.isIncomplete()) {
                this.s.append("\n").append("  ").append(I18n.tr("incomplete", new Object[0])).append("\n");
                return;
            }
            this.s.append("\n");
            this.addState(o);
            this.addCommon(o);
            this.addAttributes(o);
            this.addSpecial(o);
            this.addReferrers(this.s, o);
            this.addConflicts(o);
            this.s.append("\n");
        }

        void addHeadline(OsmPrimitive o) {
            this.addType(o);
            this.addNameAndId(o);
        }

        void addType(OsmPrimitive o) {
            if (o instanceof Node) {
                this.s.append(I18n.tr("Node: ", new Object[0]));
            } else if (o instanceof Way) {
                this.s.append(I18n.tr("Way: ", new Object[0]));
            } else if (o instanceof Relation) {
                this.s.append(I18n.tr("Relation: ", new Object[0]));
            }
        }

        void addNameAndId(OsmPrimitive o) {
            String name = o.get("name");
            if (name == null) {
                this.s.append(o.getUniqueId());
            } else {
                this.s.append(this.getNameAndId(name, o.getUniqueId()));
            }
        }

        void addState(OsmPrimitive o) {
            String state;
            StringBuilder sb = new StringBuilder("  ");
            if (o.isDeleted()) {
                sb.append(I18n.tr("deleted", new Object[0])).append("  ");
            }
            if (!o.isVisible()) {
                sb.append(I18n.tr("deleted-on-server", new Object[0])).append("  ");
            }
            if (o.isModified()) {
                sb.append(I18n.tr("modified", new Object[0])).append("  ");
            }
            if (o.isDisabledAndHidden()) {
                sb.append(I18n.tr("filtered/hidden", new Object[0])).append("  ");
            }
            if (o.isDisabled()) {
                sb.append(I18n.tr("filtered/disabled", new Object[0])).append("  ");
            }
            if (o.hasDirectionKeys()) {
                if (o.reversedDirection()) {
                    sb.append(I18n.tr("has direction keys (reversed)", new Object[0])).append("  ");
                } else {
                    sb.append(I18n.tr("has direction keys", new Object[0])).append("  ");
                }
            }
            if (!(state = sb.toString().trim()).isEmpty()) {
                this.add(I18n.tr("State: ", new Object[0]), sb.toString().trim());
            }
        }

        void addCommon(OsmPrimitive o) {
            this.add(I18n.tr("Data Set: ", new Object[0]), Integer.toHexString(o.getDataSet().hashCode()));
            this.add(I18n.tr("Edited at: ", new Object[0]), o.isTimestampEmpty() ? I18n.tr("<new object>", new Object[0]) : DateUtils.fromDate(o.getTimestamp()));
            this.add(I18n.tr("Edited by: ", new Object[0]), o.getUser() == null ? I18n.tr("<new object>", new Object[0]) : this.getNameAndId(o.getUser().getName(), o.getUser().getId()));
            this.add(I18n.tr("Version: ", new Object[0]), Integer.toString(o.getVersion()));
            this.add(I18n.tr("In changeset: ", new Object[0]), Integer.toString(o.getChangesetId()));
        }

        void addAttributes(OsmPrimitive o) {
            if (o.hasKeys()) {
                this.add(I18n.tr("Tags: ", new Object[0]), new String[0]);
                for (String key : o.keySet()) {
                    this.s.append("  ").append("  ");
                    this.s.append(String.format("\"%s\"=\"%s\"%n", key, o.get(key)));
                }
            }
        }

        void addSpecial(OsmPrimitive o) {
            if (o instanceof Node) {
                this.addCoordinates((Node)o);
            } else if (o instanceof Way) {
                this.addBbox(o);
                this.add(I18n.tr("Centroid: ", new Object[0]), Main.getProjection().eastNorth2latlon(Geometry.getCentroid(((Way)o).getNodes())).toStringCSV(", "));
                this.addWayNodes((Way)o);
            } else if (o instanceof Relation) {
                this.addBbox(o);
                this.addRelationMembers((Relation)o);
            }
        }

        void addRelationMembers(Relation r) {
            this.add(I18n.trn("{0} Member: ", "{0} Members: ", r.getMembersCount(), r.getMembersCount()), new String[0]);
            for (RelationMember m : r.getMembers()) {
                this.s.append("  ").append("  ");
                this.addHeadline(m.getMember());
                this.s.append(I18n.tr(" as \"{0}\"", m.getRole()));
                this.s.append("\n");
            }
        }

        void addWayNodes(Way w) {
            this.add(I18n.tr("{0} Nodes: ", w.getNodesCount()), new String[0]);
            for (Node n : w.getNodes()) {
                this.s.append("  ").append("  ");
                this.addNameAndId(n);
                this.s.append("\n");
            }
        }

        void addBbox(OsmPrimitive o) {
            BBox bbox = o.getBBox();
            if (bbox != null) {
                this.add(I18n.tr("Bounding box: ", new Object[0]), bbox.toStringCSV(", "));
                EastNorth bottomRigth = Main.getProjection().latlon2eastNorth(bbox.getBottomRight());
                EastNorth topLeft = Main.getProjection().latlon2eastNorth(bbox.getTopLeft());
                this.add(I18n.tr("Bounding box (projected): ", new Object[0]), Double.toString(topLeft.east()), ", ", Double.toString(bottomRigth.north()), ", ", Double.toString(bottomRigth.east()), ", ", Double.toString(topLeft.north()));
                this.add(I18n.tr("Center of bounding box: ", new Object[0]), bbox.getCenter().toStringCSV(", "));
            }
        }

        void addCoordinates(Node n) {
            if (n.getCoor() != null) {
                this.add(I18n.tr("Coordinates: ", new Object[0]), Double.toString(n.getCoor().lat()), ", ", Double.toString(n.getCoor().lon()));
                this.add(I18n.tr("Coordinates (projected): ", new Object[0]), Double.toString(n.getEastNorth().east()), ", ", Double.toString(n.getEastNorth().north()));
            }
        }

        void addReferrers(StringBuilder s, OsmPrimitive o) {
            List<OsmPrimitive> refs = o.getReferrers();
            if (!refs.isEmpty()) {
                this.add(I18n.tr("Part of: ", new Object[0]), new String[0]);
                for (OsmPrimitive p : refs) {
                    s.append("  ").append("  ");
                    this.addHeadline(p);
                    s.append("\n");
                }
            }
        }

        void addConflicts(OsmPrimitive o) {
            Conflict<?> c = InspectPrimitiveDialog.this.layer.getConflicts().getConflictForMy(o);
            if (c != null) {
                this.add(I18n.tr("In conflict with: ", new Object[0]), new String[0]);
                this.addNameAndId((OsmPrimitive)c.getTheir());
            }
        }

        public String toString() {
            return this.s.toString();
        }
    }
}

