/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.pair.ConflictResolver;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ConflictResolutionDialog
extends JDialog
implements PropertyChangeListener {
    private ConflictResolver resolver;
    private JLabel titleLabel;
    private ApplyResolutionAction applyResolutionAction;

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unregisterListeners();
    }

    @Override
    public void setVisible(boolean isVisible) {
        String geom = this.getClass().getName() + ".geometry";
        if (isVisible) {
            this.toFront();
            new WindowGeometry(geom, WindowGeometry.centerInWindow(Main.parent, new Dimension(600, 400))).applySafe(this);
        } else {
            if (this.isShowing()) {
                new WindowGeometry(this).remember(geom);
            }
            this.unregisterListeners();
        }
        super.setVisible(isVisible);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        this.applyResolutionAction = new ApplyResolutionAction();
        JButton btn = new JButton(this.applyResolutionAction);
        btn.setName("button.apply");
        pnl.add(btn);
        btn = new JButton(new CancelAction());
        btn.setName("button.cancel");
        pnl.add(btn);
        btn = new JButton(new HelpAction());
        btn.setName("button.help");
        pnl.add(btn);
        pnl.setBorder(BorderFactory.createLoweredBevelBorder());
        return pnl;
    }

    private void registerListeners() {
        this.resolver.addPropertyChangeListener(this.applyResolutionAction);
    }

    private void unregisterListeners() {
        this.resolver.removePropertyChangeListener(this.applyResolutionAction);
        this.resolver.unregisterListeners();
    }

    protected void build() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.updateTitle();
        this.resolver = new ConflictResolver();
        this.resolver.setName("panel.conflictresolver");
        this.getContentPane().add((Component)this.resolver, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.resolver.addPropertyChangeListener(this);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("Dialog/Conflict"));
        this.registerListeners();
    }

    public ConflictResolutionDialog(Component parent) {
        super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.pack();
        if (this.getInsets().top > 0) {
            this.titleLabel.setVisible(false);
        }
    }

    public ConflictResolver getConflictResolver() {
        return this.resolver;
    }

    protected void updateTitle() {
        this.updateTitle(null);
    }

    protected void updateTitle(OsmPrimitive my) {
        if (my == null) {
            this.setTitle(I18n.tr("Resolve conflicts", new Object[0]));
        } else {
            this.setTitle(I18n.tr("Resolve conflicts for ''{0}''", my.getDisplayName(DefaultNameFormatter.getInstance())));
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.titleLabel != null) {
            this.titleLabel.setText(title);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ConflictResolver.MY_PRIMITIVE_PROP)) {
            this.updateTitle((OsmPrimitive)evt.getNewValue());
        }
    }

    class ApplyResolutionAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyResolutionAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts and close the dialog", new Object[0]));
            this.putValue("Name", I18n.tr("Apply Resolution", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(ConflictResolutionDialog.this.resolver.isResolvedCompletely());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!ConflictResolutionDialog.this.resolver.isResolvedCompletely()) {
                Object[] options = new Object[]{I18n.tr("Close anyway", new Object[0]), I18n.tr("Continue resolving", new Object[0])};
                int ret = JOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>You did not finish to merge the differences in this conflict.<br>Conflict resolutions will not be applied unless all differences<br>are resolved.<br>Click <strong>{0}</strong> to close anyway.<strong> Already<br>resolved differences will not be applied.</strong><br>Click <strong>{1}</strong> to return to resolving conflicts.</html>", options[0].toString(), options[1].toString()), I18n.tr("Conflict not resolved completely", new Object[0]), 0, 2, null, options, options[1]);
                switch (ret) {
                    case 0: {
                        ConflictResolutionDialog.this.closeDialog();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            Command cmd = ConflictResolutionDialog.this.resolver.buildResolveCommand();
            Main.main.undoRedo.add(cmd);
            ConflictResolutionDialog.this.closeDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ConflictResolver.RESOLVED_COMPLETELY_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    static class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
            this.putValue("Name", I18n.tr("Help", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            HelpBrowser.setUrlForHelpTopic(HelpUtil.ht("/Dialog/Conflict"));
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution and close the dialog", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ConflictResolutionDialog.this.closeDialog();
        }
    }
}

