/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ConflictResolutionDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public final class ConflictDialog
extends ToggleDialog
implements SelectionChangedListener,
IConflictListener,
MapView.EditLayerChangeListener {
    private ConflictCollection conflicts;
    private ConflictListModel model;
    private JList<OsmPrimitive> lstConflicts;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private ResolveAction actResolve;
    private SelectAction actSelect;

    public static Color getColor() {
        return Main.pref.getColor(I18n.marktr("conflict"), Color.gray);
    }

    protected void build() {
        this.model = new ConflictListModel();
        this.lstConflicts = new JList<OsmPrimitive>(this.model);
        this.lstConflicts.setSelectionMode(2);
        this.lstConflicts.setCellRenderer(new OsmPrimitivRenderer());
        this.lstConflicts.addMouseListener(new MouseEventHandler());
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Main.map.mapView.repaint();
            }
        });
        this.actResolve = new ResolveAction();
        SideButton btnResolve = new SideButton(this.actResolve);
        this.addListSelectionListener(this.actResolve);
        this.actSelect = new SelectAction();
        SideButton btnSelect = new SideButton(this.actSelect);
        this.addListSelectionListener(this.actSelect);
        this.createLayout(this.lstConflicts, true, Arrays.asList(btnResolve, btnSelect));
        this.popupMenuHandler.addAction(Main.main.menu.autoScaleActions.get("conflict"));
    }

    public ConflictDialog() {
        super(I18n.tr("Conflict", new Object[0]), "conflict", I18n.tr("Resolve conflicts.", new Object[0]), Shortcut.registerShortcut("subwindow:conflict", I18n.tr("Toggle: {0}", I18n.tr("Conflict", new Object[0])), 67, 5007), 100);
        this.build();
        this.refreshView();
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        MapView.addEditLayerChangeListener(this, true);
        this.refreshView();
    }

    @Override
    public void hideNotify() {
        MapView.removeEditLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.lstConflicts.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.lstConflicts.getSelectionModel().removeListSelectionListener(listener);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    private final void resolve() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return;
        }
        int index = this.lstConflicts.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        Conflict<?> c = this.conflicts.get(index);
        ConflictResolutionDialog dialog = new ConflictResolutionDialog(Main.parent);
        dialog.getConflictResolver().populate(c);
        dialog.setVisible(true);
        this.lstConflicts.setSelectedIndex(index);
        Main.map.mapView.repaint();
    }

    public final void refreshView() {
        OsmDataLayer editLayer = Main.main.getEditLayer();
        this.conflicts = editLayer == null ? new ConflictCollection() : editLayer.getConflicts();
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                ConflictDialog.this.model.fireContentChanged();
                ConflictDialog.this.updateTitle();
            }
        });
    }

    private void updateTitle() {
        int conflictsCount = this.conflicts.size();
        if (conflictsCount > 0) {
            this.setTitle(I18n.trn("Conflict: {0} unresolved", "Conflicts: {0} unresolved", conflictsCount, conflictsCount) + " (" + I18n.tr("Rel.:{0} / Ways:{1} / Nodes:{2}", this.conflicts.getRelationConflicts().size(), this.conflicts.getWayConflicts().size(), this.conflicts.getNodeConflicts().size()) + ")");
        } else {
            this.setTitle(I18n.tr("Conflict", new Object[0]));
        }
    }

    public void paintConflicts(final Graphics g, final NavigatableComponent nc) {
        Color preferencesColor = ConflictDialog.getColor();
        if (preferencesColor.equals(Main.pref.getColor(I18n.marktr("background"), Color.black))) {
            return;
        }
        g.setColor(preferencesColor);
        AbstractVisitor conflictPainter = new AbstractVisitor(){
            private final Set<Relation> visited = new HashSet<Relation>();

            @Override
            public void visit(Node n) {
                Point p = nc.getPoint(n);
                g.drawRect(p.x - 1, p.y - 1, 2, 2);
            }

            public void visit(Node n1, Node n2) {
                Point p1 = nc.getPoint(n1);
                Point p2 = nc.getPoint(n2);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }

            @Override
            public void visit(Way w) {
                Node lastN = null;
                for (Node n : w.getNodes()) {
                    if (lastN == null) {
                        lastN = n;
                        continue;
                    }
                    this.visit(lastN, n);
                    lastN = n;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(Relation e) {
                if (!this.visited.contains(e)) {
                    this.visited.add(e);
                    try {
                        for (RelationMember em : e.getMembers()) {
                            em.getMember().accept(this);
                        }
                    }
                    finally {
                        this.visited.remove(e);
                    }
                }
            }
        };
        for (OsmPrimitive o : this.lstConflicts.getSelectedValuesList()) {
            if (this.conflicts == null || !this.conflicts.hasConflictForMy(o)) continue;
            ((OsmPrimitive)this.conflicts.getConflictForMy(o).getTheir()).accept(conflictPainter);
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        if (oldLayer != null) {
            oldLayer.getConflicts().removeConflictListener(this);
        }
        if (newLayer != null) {
            newLayer.getConflicts().addConflictListener(this);
        }
        this.refreshView();
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public Conflict<? extends OsmPrimitive> getSelectedConflict() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return null;
        }
        int index = this.lstConflicts.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.conflicts.get(index);
    }

    @Override
    public void onConflictsAdded(ConflictCollection conflicts) {
        this.refreshView();
    }

    @Override
    public void onConflictsRemoved(ConflictCollection conflicts) {
        Main.info("1 conflict has been resolved.");
        this.refreshView();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.lstConflicts.clearSelection();
        for (OsmPrimitive osmPrimitive : newSelection) {
            int pos;
            if (this.conflicts == null || !this.conflicts.hasConflictForMy(osmPrimitive) || (pos = this.model.indexOf(osmPrimitive)) < 0) continue;
            this.lstConflicts.addSelectionInterval(pos, pos);
        }
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/Dialog/ConflictList");
    }

    public void warnNumNewConflicts(int numNewConflicts) {
        if (numNewConflicts == 0) {
            return;
        }
        String msg1 = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", numNewConflicts, numNewConflicts);
        final StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(msg1).append("</html>");
        if (numNewConflicts > 0) {
            final HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to close this dialog and continue editing", new Object[0]), null)};
            GuiHelper.runInEDT(new Runnable(){

                @Override
                public void run() {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, sb.toString(), I18n.tr("Conflicts detected", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Concepts/Conflict#WarningAboutDetectedConflicts"));
                    ConflictDialog.this.unfurlDialog();
                    Main.map.repaint();
                }
            });
        }
    }

    class SelectAction
    extends AbstractSelectAction
    implements ListSelectionListener {
        private SelectAction() {
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#SelectAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
            for (OsmPrimitive o : ConflictDialog.this.lstConflicts.getSelectedValuesList()) {
                sel.add(o);
            }
            DataSet ds = Main.main.getCurrentDataSet();
            if (ds != null) {
                ds.setSelected(sel);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            boolean enabled = model.getMinSelectionIndex() >= 0 && model.getMaxSelectionIndex() >= model.getMinSelectionIndex();
            this.setEnabled(enabled);
        }
    }

    class ResolveAction
    extends AbstractAction
    implements ListSelectionListener {
        public ResolveAction() {
            this.putValue("Name", I18n.tr("Resolve", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a merge dialog of all selected items in the list above.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#ResolveAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictDialog.this.resolve();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel model = (ListSelectionModel)e.getSource();
            boolean enabled = model.getMinSelectionIndex() >= 0 && model.getMaxSelectionIndex() >= model.getMinSelectionIndex();
            this.setEnabled(enabled);
        }
    }

    class ConflictListModel
    implements ListModel<OsmPrimitive> {
        private CopyOnWriteArrayList<ListDataListener> listeners = new CopyOnWriteArrayList();

        @Override
        public void addListDataListener(ListDataListener l) {
            if (l != null) {
                this.listeners.addIfAbsent(l);
            }
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        protected void fireContentChanged() {
            ListDataEvent evt = new ListDataEvent(this, 0, 0, this.getSize());
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(evt);
            }
        }

        @Override
        public OsmPrimitive getElementAt(int index) {
            if (index < 0) {
                return null;
            }
            if (index >= this.getSize()) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(index).getMy();
        }

        @Override
        public int getSize() {
            if (ConflictDialog.this.conflicts == null) {
                return 0;
            }
            return ConflictDialog.this.conflicts.size();
        }

        public int indexOf(OsmPrimitive my) {
            if (ConflictDialog.this.conflicts == null) {
                return -1;
            }
            for (int i = 0; i < ConflictDialog.this.conflicts.size(); ++i) {
                if (!ConflictDialog.this.conflicts.get(i).isMatchingMy(my)) continue;
                return i;
            }
            return -1;
        }

        public OsmPrimitive get(int idx) {
            if (ConflictDialog.this.conflicts == null) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(idx).getMy();
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(ConflictDialog.this.popupMenu);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseEventHandler.isDoubleClick(e)) {
                ConflictDialog.this.resolve();
            }
        }
    }
}

