/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.CommandListMutableTreeNode;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Shortcut;

public class CommandStackDialog
extends ToggleDialog
implements OsmDataLayer.CommandQueueListener {
    private final DefaultTreeModel undoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final DefaultTreeModel redoTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private final JTree undoTree = new JTree(this.undoTreeModel);
    private final JTree redoTree = new JTree(this.redoTreeModel);
    private UndoRedoSelectionListener undoSelectionListener;
    private UndoRedoSelectionListener redoSelectionListener;
    private JScrollPane scrollPane;
    private JSeparator separator = new JSeparator();
    private Component spacer = Box.createRigidArea(new Dimension(0, 3));
    private UndoRedoType lastOperation = UndoRedoType.UNDO;
    private SelectAction selectAction = new SelectAction();
    private SelectAndZoomAction selectAndZoomAction = new SelectAndZoomAction();
    Set<IEnabledStateUpdating> showNotifyListener = new LinkedHashSet<IEnabledStateUpdating>();

    public CommandStackDialog() {
        super(I18n.tr("Command Stack", new Object[0]), "commandstack", I18n.tr("Open a list of all commands (undo buffer).", new Object[0]), Shortcut.registerShortcut("subwindow:commandstack", I18n.tr("Toggle: {0}", I18n.tr("Command Stack", new Object[0])), 79, 5007), 100);
        this.undoTree.addMouseListener(new MouseEventHandler());
        this.undoTree.setRootVisible(false);
        this.undoTree.getSelectionModel().setSelectionMode(1);
        this.undoTree.setShowsRootHandles(true);
        this.undoTree.expandRow(0);
        this.undoTree.setCellRenderer(new CommandCellRenderer());
        this.undoSelectionListener = new UndoRedoSelectionListener(this.undoTree);
        this.undoTree.getSelectionModel().addTreeSelectionListener(this.undoSelectionListener);
        InputMapUtils.unassignCtrlShiftUpDown(this.undoTree, 0);
        this.redoTree.addMouseListener(new MouseEventHandler());
        this.redoTree.setRootVisible(false);
        this.redoTree.getSelectionModel().setSelectionMode(1);
        this.redoTree.setShowsRootHandles(true);
        this.redoTree.expandRow(0);
        this.redoTree.setCellRenderer(new CommandCellRenderer());
        this.redoSelectionListener = new UndoRedoSelectionListener(this.redoTree);
        this.redoTree.getSelectionModel().addTreeSelectionListener(this.redoSelectionListener);
        InputMapUtils.unassignCtrlShiftUpDown(this.redoTree, 0);
        JPanel treesPanel = new JPanel(new GridBagLayout());
        treesPanel.add(this.spacer, GBC.eol());
        this.spacer.setVisible(false);
        treesPanel.add((Component)this.undoTree, GBC.eol().fill(2));
        this.separator.setVisible(false);
        treesPanel.add((Component)this.separator, GBC.eol().fill(2));
        treesPanel.add((Component)this.redoTree, GBC.eol().fill(2));
        treesPanel.add(Box.createRigidArea(new Dimension(0, 0)), GBC.std().weight(0.0, 1.0));
        treesPanel.setBackground(this.redoTree.getBackground());
        this.wireUpdateEnabledStateUpdater(this.selectAction, this.undoTree);
        this.wireUpdateEnabledStateUpdater(this.selectAction, this.redoTree);
        UndoRedoAction undoAction = new UndoRedoAction(UndoRedoType.UNDO);
        this.wireUpdateEnabledStateUpdater(undoAction, this.undoTree);
        UndoRedoAction redoAction = new UndoRedoAction(UndoRedoType.REDO);
        this.wireUpdateEnabledStateUpdater(redoAction, this.redoTree);
        this.scrollPane = (JScrollPane)this.createLayout(treesPanel, true, Arrays.asList(new SideButton(this.selectAction), new SideButton(undoAction), new SideButton(redoAction)));
        InputMapUtils.addEnterAction(this.undoTree, this.selectAndZoomAction);
        InputMapUtils.addEnterAction(this.redoTree, this.selectAndZoomAction);
    }

    private void updateTitle() {
        int undo = this.undoTreeModel.getChildCount(this.undoTreeModel.getRoot());
        int redo = this.redoTreeModel.getChildCount(this.redoTreeModel.getRoot());
        if (undo > 0 || redo > 0) {
            this.setTitle(I18n.tr("Command Stack: Undo: {0} / Redo: {1}", undo, redo));
        } else {
            this.setTitle(I18n.tr("Command Stack", new Object[0]));
        }
    }

    protected void wireUpdateEnabledStateUpdater(final IEnabledStateUpdating updater, JTree tree) {
        this.addShowNotifyListener(updater);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                updater.updateEnabledState();
            }
        });
        tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                updater.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                updater.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                updater.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                updater.updateEnabledState();
                CommandStackDialog.this.updateTitle();
            }
        });
    }

    @Override
    public void showNotify() {
        this.buildTrees();
        for (IEnabledStateUpdating listener : this.showNotifyListener) {
            listener.updateEnabledState();
        }
        Main.main.undoRedo.addCommandQueueListener(this);
    }

    private void addShowNotifyListener(IEnabledStateUpdating listener) {
        this.showNotifyListener.add(listener);
    }

    @Override
    public void hideNotify() {
        this.undoTreeModel.setRoot(new DefaultMutableTreeNode());
        this.redoTreeModel.setRoot(new DefaultMutableTreeNode());
        Main.main.undoRedo.removeCommandQueueListener(this);
    }

    private void buildTrees() {
        this.setTitle(I18n.tr("Command Stack", new Object[0]));
        if (!Main.main.hasEditLayer()) {
            return;
        }
        LinkedList<Command> undoCommands = Main.main.undoRedo.commands;
        DefaultMutableTreeNode undoRoot = new DefaultMutableTreeNode();
        for (int i = 0; i < undoCommands.size(); ++i) {
            undoRoot.add(this.getNodeForCommand((PseudoCommand)undoCommands.get(i), i));
        }
        this.undoTreeModel.setRoot(undoRoot);
        LinkedList<Command> redoCommands = Main.main.undoRedo.redoCommands;
        DefaultMutableTreeNode redoRoot = new DefaultMutableTreeNode();
        for (int i = 0; i < redoCommands.size(); ++i) {
            redoRoot.add(this.getNodeForCommand((PseudoCommand)redoCommands.get(i), i));
        }
        this.redoTreeModel.setRoot(redoRoot);
        if (this.redoTreeModel.getChildCount(redoRoot) > 0) {
            this.redoTree.scrollRowToVisible(0);
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
        this.separator.setVisible(!undoCommands.isEmpty() || !redoCommands.isEmpty());
        this.spacer.setVisible(undoCommands.isEmpty() && !redoCommands.isEmpty());
        switch (this.lastOperation) {
            case UNDO: {
                if (!undoCommands.isEmpty()) break;
                this.lastOperation = UndoRedoType.REDO;
                break;
            }
            case REDO: {
                if (!redoCommands.isEmpty()) break;
                this.lastOperation = UndoRedoType.UNDO;
            }
        }
        switch (this.lastOperation) {
            case UNDO: {
                this.undoTree.setSelectionRow(this.undoTree.getRowCount() - 1);
                break;
            }
            case REDO: {
                this.redoTree.setSelectionRow(0);
            }
        }
        this.undoTree.scrollRowToVisible(this.undoTreeModel.getChildCount(undoRoot) - 1);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
    }

    protected CommandListMutableTreeNode getNodeForCommand(PseudoCommand c, int idx) {
        CommandListMutableTreeNode node = new CommandListMutableTreeNode(c, idx);
        if (c.getChildren() != null) {
            ArrayList<PseudoCommand> children = new ArrayList<PseudoCommand>(c.getChildren());
            for (int i = 0; i < children.size(); ++i) {
                node.add(this.getNodeForCommand((PseudoCommand)children.get(i), i));
            }
        }
        return node;
    }

    protected static FilteredCollection<OsmPrimitive> getAffectedPrimitives(TreePath path) {
        PseudoCommand c = ((CommandListMutableTreeNode)path.getLastPathComponent()).getCommand();
        final OsmDataLayer currentLayer = Main.main.getEditLayer();
        return new FilteredCollection<OsmPrimitive>((Collection<OsmPrimitive>)c.getParticipatingPrimitives(), new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive o) {
                OsmPrimitive p = currentLayer.data.getPrimitiveById(o);
                return p != null && p.isUsable();
            }
        });
    }

    @Override
    public void commandChanged(int queueSize, int redoSize) {
        if (!this.isVisible()) {
            return;
        }
        this.buildTrees();
    }

    private class CommandStackPopup
    extends JPopupMenu {
        public CommandStackPopup() {
            this.add(CommandStackDialog.this.selectAction);
            this.add(CommandStackDialog.this.selectAndZoomAction);
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(new CommandStackPopup());
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (MouseEventHandler.isDoubleClick(evt)) {
                CommandStackDialog.this.selectAndZoomAction.actionPerformed(null);
            }
        }
    }

    protected class UndoRedoAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private UndoRedoType type;
        private JTree tree;

        public UndoRedoAction(UndoRedoType type) {
            this.type = type;
            switch (type) {
                case UNDO: {
                    this.tree = CommandStackDialog.this.undoTree;
                    this.putValue("Name", I18n.tr("Undo", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Undo the selected and all later commands", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("undo"));
                    break;
                }
                case REDO: {
                    this.tree = CommandStackDialog.this.redoTree;
                    this.putValue("Name", I18n.tr("Redo", new Object[0]));
                    this.putValue("ShortDescription", I18n.tr("Redo the selected and all earlier commands", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("redo"));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommandStackDialog.this.lastOperation = this.type;
            TreePath path = this.tree.getSelectionPath();
            if (path.getPathCount() != 2) {
                throw new IllegalStateException();
            }
            int idx = ((CommandListMutableTreeNode)path.getLastPathComponent()).getIndex();
            switch (this.type) {
                case UNDO: {
                    int numUndo = ((DefaultMutableTreeNode)CommandStackDialog.this.undoTreeModel.getRoot()).getChildCount() - idx;
                    Main.main.undoRedo.undo(numUndo);
                    break;
                }
                case REDO: {
                    int numRedo = idx + 1;
                    Main.main.undoRedo.redo(numRedo);
                }
            }
            Main.map.repaint();
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!this.tree.isSelectionEmpty() && this.tree.getSelectionPath().getPathCount() == 2);
        }
    }

    protected static enum UndoRedoType {
        UNDO,
        REDO;

    }

    public class SelectAndZoomAction
    extends SelectAction {
        public SelectAndZoomAction() {
            this.putValue("Name", I18n.tr("Select and zoom", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Selects the objects that take part in this command (unless currently deleted), then and zooms to it", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/autoscale", "selection"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (!Main.main.hasEditLayer()) {
                return;
            }
            AutoScaleAction.autoScale("selection");
        }
    }

    public class SelectAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public SelectAction() {
            this.putValue("Name", I18n.tr("Select", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Selects the objects that take part in this command (unless currently deleted)", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path;
            CommandStackDialog.this.undoTree.getSelectionPath();
            if (!CommandStackDialog.this.undoTree.isSelectionEmpty()) {
                path = CommandStackDialog.this.undoTree.getSelectionPath();
            } else if (!CommandStackDialog.this.redoTree.isSelectionEmpty()) {
                path = CommandStackDialog.this.redoTree.getSelectionPath();
            } else {
                throw new IllegalStateException();
            }
            OsmDataLayer editLayer = Main.main.getEditLayer();
            if (editLayer == null) {
                return;
            }
            editLayer.data.setSelected(CommandStackDialog.getAffectedPrimitives(path));
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!CommandStackDialog.this.undoTree.isSelectionEmpty() || !CommandStackDialog.this.redoTree.isSelectionEmpty());
        }
    }

    protected static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }

    private class UndoRedoSelectionListener
    implements TreeSelectionListener {
        private JTree source;

        public UndoRedoSelectionListener(JTree source) {
            this.source = source;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.source == CommandStackDialog.this.undoTree) {
                CommandStackDialog.this.redoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
                CommandStackDialog.this.redoTree.clearSelection();
                CommandStackDialog.this.redoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.redoSelectionListener);
            }
            if (this.source == CommandStackDialog.this.redoTree) {
                CommandStackDialog.this.undoTree.getSelectionModel().removeTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
                CommandStackDialog.this.undoTree.clearSelection();
                CommandStackDialog.this.undoTree.getSelectionModel().addTreeSelectionListener(CommandStackDialog.this.undoSelectionListener);
            }
        }
    }

    private static class CommandCellRenderer
    extends DefaultTreeCellRenderer {
        private CommandCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode v = (DefaultMutableTreeNode)value;
            if (v.getUserObject() instanceof JLabel) {
                JLabel l = (JLabel)v.getUserObject();
                this.setIcon(l.getIcon());
                this.setText(l.getText());
            }
            return this;
        }
    }
}

