/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetInSelectionListModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListCellRenderer;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetsInActiveDataLayerListModel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ListPopupMenu;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class ChangesetDialog
extends ToggleDialog {
    private ChangesetInSelectionListModel inSelectionModel;
    private ChangesetsInActiveDataLayerListModel inActiveDataLayerModel;
    private JList<Changeset> lstInSelection;
    private JList<Changeset> lstInActiveDataLayer;
    private JCheckBox cbInSelectionOnly;
    private JPanel pnlList;
    private SelectObjectsAction selectObjectsAction;
    private ReadChangesetsAction readChangesetAction;
    private ShowChangesetInfoAction showChangesetInfoAction;
    private CloseOpenChangesetsAction closeChangesetAction;
    private LaunchChangesetManagerAction launchChangesetManagerAction;
    private ChangesetDialogPopup popupMenu;

    protected void buildChangesetsLists() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.inSelectionModel = new ChangesetInSelectionListModel(selectionModel);
        this.lstInSelection = new JList<Changeset>(this.inSelectionModel);
        this.lstInSelection.setSelectionModel(selectionModel);
        this.lstInSelection.setSelectionMode(2);
        this.lstInSelection.setCellRenderer(new ChangesetListCellRenderer());
        selectionModel = new DefaultListSelectionModel();
        this.inActiveDataLayerModel = new ChangesetsInActiveDataLayerListModel(selectionModel);
        this.lstInActiveDataLayer = new JList<Changeset>(this.inActiveDataLayerModel);
        this.lstInActiveDataLayer.setSelectionModel(selectionModel);
        this.lstInActiveDataLayer.setSelectionMode(2);
        this.lstInActiveDataLayer.setCellRenderer(new ChangesetListCellRenderer());
        DblClickHandler dblClickHandler = new DblClickHandler();
        this.lstInSelection.addMouseListener(dblClickHandler);
        this.lstInActiveDataLayer.addMouseListener(dblClickHandler);
    }

    protected void registerAsListener() {
        ChangesetCache.getInstance().addChangesetCacheListener(this.inSelectionModel);
        MapView.addEditLayerChangeListener(this.inSelectionModel);
        DataSet.addSelectionListener(this.inSelectionModel);
        ChangesetCache.getInstance().addChangesetCacheListener(this.inActiveDataLayerModel);
        MapView.addEditLayerChangeListener(this.inActiveDataLayerModel);
        OsmDataLayer editLayer = Main.main.getEditLayer();
        if (editLayer != null) {
            editLayer.data.addDataSetListener(this.inActiveDataLayerModel);
            this.inActiveDataLayerModel.initFromDataSet(editLayer.data);
            this.inSelectionModel.initFromPrimitives(editLayer.data.getAllSelected());
        }
    }

    protected void unregisterAsListener() {
        ChangesetCache.getInstance().removeChangesetCacheListener(this.inActiveDataLayerModel);
        MapView.removeEditLayerChangeListener(this.inActiveDataLayerModel);
        OsmDataLayer editLayer = Main.main.getEditLayer();
        if (editLayer != null) {
            editLayer.data.removeDataSetListener(this.inActiveDataLayerModel);
        }
        MapView.removeEditLayerChangeListener(this.inSelectionModel);
        DataSet.removeSelectionListener(this.inSelectionModel);
    }

    @Override
    public void showNotify() {
        this.registerAsListener();
        DatasetEventManager.getInstance().addDatasetListener(this.inActiveDataLayerModel, DatasetEventManager.FireMode.IN_EDT);
    }

    @Override
    public void hideNotify() {
        this.unregisterAsListener();
        DatasetEventManager.getInstance().removeDatasetListener(this.inActiveDataLayerModel);
    }

    protected JPanel buildFilterPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        pnl.setBorder(null);
        this.cbInSelectionOnly = new JCheckBox(I18n.tr("For selected objects only", new Object[0]));
        pnl.add(this.cbInSelectionOnly);
        this.cbInSelectionOnly.setToolTipText(I18n.tr("<html>Select to show changesets for the currently selected objects only.<br>Unselect to show all changesets for objects in the current data layer.</html>", new Object[0]));
        this.cbInSelectionOnly.setSelected(Main.pref.getBoolean("changeset-dialog.for-selected-objects-only", false));
        return pnl;
    }

    protected JPanel buildListPanel() {
        this.buildChangesetsLists();
        JPanel pnl = new JPanel(new BorderLayout());
        if (this.cbInSelectionOnly.isSelected()) {
            pnl.add(new JScrollPane(this.lstInSelection));
        } else {
            pnl.add(new JScrollPane(this.lstInActiveDataLayer));
        }
        return pnl;
    }

    protected void build() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildFilterPanel(), "North");
        this.pnlList = this.buildListPanel();
        pnl.add((Component)this.pnlList, "Center");
        this.cbInSelectionOnly.addItemListener(new FilterChangeHandler());
        HelpUtil.setHelpContext(pnl, HelpUtil.ht("/Dialog/ChangesetList"));
        this.selectObjectsAction = new SelectObjectsAction();
        this.cbInSelectionOnly.addItemListener(this.selectObjectsAction);
        this.readChangesetAction = new ReadChangesetsAction();
        this.cbInSelectionOnly.addItemListener(this.readChangesetAction);
        this.closeChangesetAction = new CloseOpenChangesetsAction();
        this.cbInSelectionOnly.addItemListener(this.closeChangesetAction);
        this.showChangesetInfoAction = new ShowChangesetInfoAction();
        this.cbInSelectionOnly.addItemListener(this.showChangesetInfoAction);
        this.launchChangesetManagerAction = new LaunchChangesetManagerAction();
        this.cbInSelectionOnly.addItemListener(this.launchChangesetManagerAction);
        this.popupMenu = new ChangesetDialogPopup(this.lstInActiveDataLayer, this.lstInSelection);
        PopupMenuLauncher popupMenuLauncher = new PopupMenuLauncher(this.popupMenu);
        this.lstInSelection.addMouseListener(popupMenuLauncher);
        this.lstInActiveDataLayer.addMouseListener(popupMenuLauncher);
        this.createLayout(pnl, false, Arrays.asList(new SideButton((Action)this.selectObjectsAction, false), new SideButton((Action)this.readChangesetAction, false), new SideButton((Action)this.closeChangesetAction, false), new SideButton((Action)this.showChangesetInfoAction, false), new SideButton((Action)this.launchChangesetManagerAction, false)));
    }

    protected JList<Changeset> getCurrentChangesetList() {
        if (this.cbInSelectionOnly.isSelected()) {
            return this.lstInSelection;
        }
        return this.lstInActiveDataLayer;
    }

    protected ChangesetListModel getCurrentChangesetListModel() {
        if (this.cbInSelectionOnly.isSelected()) {
            return this.inSelectionModel;
        }
        return this.inActiveDataLayerModel;
    }

    protected void initWithCurrentData() {
        OsmDataLayer editLayer = Main.main.getEditLayer();
        if (editLayer != null) {
            this.inSelectionModel.initFromPrimitives(editLayer.data.getAllSelected());
            this.inActiveDataLayerModel.initFromDataSet(editLayer.data);
        }
    }

    public ChangesetDialog() {
        super(I18n.tr("Changesets", new Object[0]), "changesetdialog", I18n.tr("Open the list of changesets in the current layer.", new Object[0]), null, 200, false);
        this.build();
        this.initWithCurrentData();
    }

    public void addPopupMenuSeparator() {
        this.popupMenu.addSeparator();
    }

    public JMenuItem addPopupMenuAction(Action a) {
        return this.popupMenu.add(a);
    }

    class ChangesetDialogPopup
    extends ListPopupMenu {
        public ChangesetDialogPopup(JList<?> ... lists) {
            super(lists);
            this.add(ChangesetDialog.this.selectObjectsAction);
            this.addSeparator();
            this.add(ChangesetDialog.this.readChangesetAction);
            this.add(ChangesetDialog.this.closeChangesetAction);
            this.addSeparator();
            this.add(ChangesetDialog.this.showChangesetInfoAction);
        }
    }

    class LaunchChangesetManagerAction
    extends AbstractAction
    implements ItemListener,
    ListSelectionListener {
        public LaunchChangesetManagerAction() {
            this.putValue("Name", I18n.tr("Details", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Opens the Changeset Manager window for the selected changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "changesetmanager"));
        }

        protected void launchChangesetManager(Collection<Integer> toSelect) {
            ChangesetCacheManager cm = ChangesetCacheManager.getInstance();
            if (cm.isVisible()) {
                cm.setExtendedState(0);
                cm.toFront();
                cm.requestFocus();
            } else {
                cm.setVisible(true);
                cm.toFront();
                cm.requestFocus();
            }
            cm.setSelectedChangesetsById(toSelect);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Future<?> future;
            ChangesetHeaderDownloadTask task;
            ChangesetListModel model = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> sel = model.getSelectedChangesetIds();
            final HashSet<Integer> toDownload = new HashSet<Integer>();
            if (!Main.isOffline(OnlineResource.OSM_API)) {
                ChangesetCache cc = ChangesetCache.getInstance();
                for (int id : sel) {
                    if (cc.contains(id)) continue;
                    toDownload.add(id);
                }
            }
            if (toDownload.isEmpty()) {
                task = null;
                future = null;
            } else {
                task = new ChangesetHeaderDownloadTask(toDownload);
                future = Main.worker.submit(task);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (future != null) {
                        try {
                            future.get();
                        }
                        catch (InterruptedException e) {
                            Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while downloading changeset header");
                        }
                        catch (ExecutionException e) {
                            Main.error(e);
                            BugReportExceptionHandler.handleException(e.getCause());
                            return;
                        }
                    }
                    if (task != null) {
                        if (task.isCanceled()) {
                            return;
                        }
                        if (task.isFailed()) {
                            toDownload.clear();
                        }
                    }
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            LaunchChangesetManagerAction.this.launchChangesetManager(toDownload);
                        }
                    });
                }
            };
            Main.worker.submit(r);
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    class ShowChangesetInfoAction
    extends AbstractAction
    implements ItemListener,
    ListSelectionListener {
        public ShowChangesetInfoAction() {
            this.putValue("Name", I18n.tr("Show info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a web page for each selected changeset", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help/internet"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Set<Changeset> sel = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedChangesets();
            if (sel.isEmpty()) {
                return;
            }
            if (sel.size() > 10 && !AbstractInfoAction.confirmLaunchMultiple(sel.size())) {
                return;
            }
            String baseUrl = Main.getBaseBrowseUrl();
            for (Changeset cs : sel) {
                String url = baseUrl + "/changeset/" + cs.getId();
                OpenBrowser.displayUrl(url);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class CloseOpenChangesetsAction
    extends AbstractAction
    implements ItemListener,
    ListSelectionListener {
        public CloseOpenChangesetsAction() {
            this.putValue("Name", I18n.tr("Close open changesets", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Closes the selected open changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            List<Changeset> sel = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedOpenChangesets();
            if (sel.isEmpty()) {
                return;
            }
            Main.worker.submit(new CloseChangesetTask(sel));
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetListModel().hasSelectedOpenChangesets());
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class ReadChangesetsAction
    extends AbstractAction
    implements ItemListener,
    ListSelectionListener {
        public ReadChangesetsAction() {
            this.putValue("Name", I18n.tr("Download", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Download information about the selected changesets from the OSM server", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ChangesetListModel model = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> sel = model.getSelectedChangesetIds();
            if (sel.isEmpty()) {
                return;
            }
            ChangesetHeaderDownloadTask task = new ChangesetHeaderDownloadTask(sel);
            Main.worker.submit(task);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0 && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class SelectObjectsAction
    extends AbstractAction
    implements ItemListener,
    ListSelectionListener {
        public SelectObjectsAction() {
            this.putValue("Name", I18n.tr("Select", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select all objects assigned to the currently selected changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void selectObjectsByChangesetIds(DataSet ds, Set<Integer> ids) {
            if (ds == null || ids == null) {
                return;
            }
            HashSet<OsmPrimitive> sel = new HashSet<OsmPrimitive>();
            for (OsmPrimitive p : ds.allPrimitives()) {
                if (!ids.contains(p.getChangesetId())) continue;
                sel.add(p);
            }
            ds.setSelected(sel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Main.main.hasEditLayer()) {
                return;
            }
            ChangesetListModel model = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> sel = model.getSelectedChangesetIds();
            if (sel.isEmpty()) {
                return;
            }
            DataSet ds = Main.main.getEditLayer().data;
            this.selectObjectsByChangesetIds(ds, sel);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class FilterChangeHandler
    implements ItemListener {
        FilterChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Main.pref.put("changeset-dialog.for-selected-objects-only", ChangesetDialog.this.cbInSelectionOnly.isSelected());
            ChangesetDialog.this.pnlList.removeAll();
            if (ChangesetDialog.this.cbInSelectionOnly.isSelected()) {
                ChangesetDialog.this.pnlList.add((Component)new JScrollPane(ChangesetDialog.this.lstInSelection), "Center");
            } else {
                ChangesetDialog.this.pnlList.add((Component)new JScrollPane(ChangesetDialog.this.lstInActiveDataLayer), "Center");
            }
            ChangesetDialog.this.validate();
            ChangesetDialog.this.repaint();
        }
    }

    class DblClickHandler
    extends MouseAdapter {
        DblClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || e.getClickCount() < 2) {
                return;
            }
            Set<Integer> sel = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedChangesetIds();
            if (sel.isEmpty()) {
                return;
            }
            if (Main.main.getCurrentDataSet() == null) {
                return;
            }
            new SelectObjectsAction().selectObjectsByChangesetIds(Main.main.getCurrentDataSet(), sel);
        }
    }
}

