/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverColumnModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;

public class TagConflictResolverTable
extends JTable
implements MultiValueCellEditor.NavigationListener {
    private SelectNextColumnCellAction selectNextColumnCellAction;
    private SelectPreviousColumnCellAction selectPreviousColumnCellAction;

    public TagConflictResolverTable(TagConflictResolverModel model) {
        super(model, new TagConflictResolverColumnModel());
        this.build();
    }

    protected final void build() {
        this.setAutoResizeMode(4);
        this.setSelectionMode(0);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.selectNextColumnCellAction = new SelectNextColumnCellAction();
        this.selectPreviousColumnCellAction = new SelectPreviousColumnCellAction();
        this.getActionMap().put("selectNextColumnCell", this.selectNextColumnCellAction);
        this.getActionMap().put("selectPreviousColumnCell", this.selectPreviousColumnCellAction);
        ((MultiValueCellEditor)this.getColumnModel().getColumn(2).getCellEditor()).addNavigationListener(this);
        this.setRowHeight((int)new JosmComboBox().getPreferredSize().getHeight());
    }

    @Override
    public void gotoNextDecision() {
        this.selectNextColumnCellAction.run();
    }

    @Override
    public void gotoPreviousDecision() {
        this.selectPreviousColumnCellAction.run();
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = TagConflictResolverTable.this.getSelectedColumn();
            int row = TagConflictResolverTable.this.getSelectedRow();
            if (TagConflictResolverTable.this.getCellEditor() != null) {
                TagConflictResolverTable.this.getCellEditor().stopCellEditing();
            }
            if ((col > 0 || row > 0) && row > 0) {
                col = 2;
                --row;
            }
            TagConflictResolverTable.this.changeSelection(row, col, false, false);
            if (TagConflictResolverTable.this.editCellAt(TagConflictResolverTable.this.getSelectedRow(), TagConflictResolverTable.this.getSelectedColumn())) {
                TagConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = TagConflictResolverTable.this.getSelectedColumn();
            int row = TagConflictResolverTable.this.getSelectedRow();
            if (TagConflictResolverTable.this.getCellEditor() != null) {
                TagConflictResolverTable.this.getCellEditor().stopCellEditing();
            }
            if (col == 2 && row < TagConflictResolverTable.this.getRowCount() - 1) {
                ++row;
            } else if (row < TagConflictResolverTable.this.getRowCount() - 1) {
                col = 2;
                ++row;
            }
            TagConflictResolverTable.this.changeSelection(row, col, false, false);
            if (TagConflictResolverTable.this.editCellAt(TagConflictResolverTable.this.getSelectedRow(), TagConflictResolverTable.this.getSelectedColumn())) {
                TagConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }
}

