/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TigerUtils;

public final class TagConflictResolutionUtil {
    public static void normalizeTagCollectionBeforeEditing(TagCollection tc, Collection<? extends OsmPrimitive> merged) {
        for (String key : OsmPrimitive.getDiscardableKeys()) {
            tc.removeByKey(key);
        }
        ArrayList<OsmPrimitive> taggedPrimitives = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : merged) {
            if (!osmPrimitive.isTagged()) continue;
            taggedPrimitives.add(osmPrimitive);
        }
        if (taggedPrimitives.size() <= 1) {
            return;
        }
        for (String string : tc.getKeys()) {
            for (OsmPrimitive p : taggedPrimitives) {
                if (p.get(string) != null) continue;
                tc.add(new Tag(string, ""));
            }
        }
    }

    public static void combineTigerTags(TagCollection tc) {
        for (String key : tc.getKeys()) {
            if (!TigerUtils.isTigerTag(key)) continue;
            tc.setUniqueForKey(key, TigerUtils.combineTags(key, tc.getValues(key)));
        }
    }

    public static void completeTagCollectionForEditing(TagCollection tc) {
        for (String key : tc.getKeys()) {
            tc.add(new Tag(key, ""));
        }
    }
}

